#!/bin/bash

# Test package that computes default database settings

TMP_DIR="${TMPDIR}"

test -z "${LIB_DIR}" && LIB_DIR=lib

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

BASENAME=$(basename $0 .pm)

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${LIB_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

TMP_DB_MAIN="${TMP_DIR}/test.db"
TMP_DB_META="${TMP_DIR}/restful.db"

sqlite3 ${TMP_DB_MAIN} <<END
    create table has_extkey (id text, SolsaID text);
END

sqlite3 ${TMP_DB_META} < sql/metatables.sql
sqlite3 ${TMP_DB_META} <<END
    insert into validation_regex values (1, '\d+(-\d+){3}');
    insert into validation_regex values (2, '\d+(-\d+){2}');
    insert into description (id, dbname, dbtable, dbcolumn, coltype,
                             validation_regex_id) values
        (1, 'test.db', 'has_extkey', 'id', 'id', 1),
        (2, 'test.db', 'has_extkey', 'SolsaID', 'extkey', 2);
END

export TMP_DB_MAIN

perl <<'END'
#! /usr/bin/env perl

use strict;
use warnings;
use utf8;

use lib 'lib';
use Database;

binmode( STDOUT, "utf8" );

$Data::Dumper::Sortkeys = 1;
$Data::Dumper::Indent   = 1;

my $db_settings = {
    content_db => {
        DB => $ENV{TMP_DB_MAIN},
        engine => 'SQLite',
    }
};

my $db = Database->new( $db_settings );
$db->connect();

local $\ = "\n";
print $db->get_unique_key_column( 'has_extkey', '51-43-4-1' );
print $db->get_unique_key_column( 'has_extkey', '51-43-4' );
END

# Temporary directory will be deleted by the trap.
