% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MixedSpeciesSample.R
\name{classifyCellsAndDoublets}
\alias{classifyCellsAndDoublets}
\title{Classify cells to species}
\usage{
classifyCellsAndDoublets(object, threshold = 0.9, min.trans = 500)
}
\arguments{
\item{object}{A \code{MixedSpeciesSample} object.}

\item{threshold}{The threshold which the ratio of transcripts of one species
over the other has to surpass in order to succesfully assign a cell to a species.
Below that threshold the cell is characterized as a doublet.}

\item{min.trans}{The minimum number of transcripts (UMIs) required for a cell.}
}
\value{
A \code{data.frame} containing the cell barcodes, the number of transcripts
per species and the characterization of the cell.
}
\description{
Classify the cells to species according to the transcripts they express.
The differentiation of species is performed internally and according to
the \code{species1} and \code{species2} labels of the sample. If the
classificiation is not confident enough, the cell is characterized as doublet.
}
