% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_along.R
\name{gen_along}
\alias{gen_along}
\title{Generator for tweening along a variable}
\usage{
gen_along(
  .data,
  ease,
  along,
  id = NULL,
  range = NULL,
  history = TRUE,
  keep_last = FALSE
)
}
\arguments{
\item{.data}{A data.frame with components at different stages}

\item{ease}{The easing function to use. Either a single string or one for
each column in the data set.}

\item{along}{The "time" point for each row}

\item{id}{An unquoted expression giving the component id for each row. Will
be evaluated in the context of \code{.data} so can refer to a column from that}

\item{range}{The range of time points to include in the tween. If \code{NULL} it
will use the range of \code{time}}

\item{history}{Should earlier datapoints be kept in subsequent frames}

\item{keep_last}{Should the last point of each id be kept beyond its time}
}
\value{
An \code{along_generator} object
}
\description{
This is a generator version of \code{\link[=tween_along]{tween_along()}}. It returns a generator that
can be used with \code{\link[=get_frame]{get_frame()}} and \code{\link[=get_raw_frames]{get_raw_frames()}} to extract frames for
a specific time point scaled between 0 and 1.
}
\examples{
# Default behaviour
gen <- gen_along(airquality, ease = "linear", along = Day, id = Month)
get_frame(gen, 0.22)

# Overwrite keep_last or history in get_frame
get_frame(gen, 0.67, history = FALSE)
}
\seealso{
Other Other generators: 
\code{\link{gen_at}()},
\code{\link{gen_components}()},
\code{\link{gen_events}()},
\code{\link{gen_keyframe}()}
}
\concept{Other generators}
