% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_keyframe.R
\name{gen_keyframe}
\alias{gen_keyframe}
\alias{add_pause}
\alias{add_keyframe}
\title{Generator for keyframe based tweening}
\usage{
gen_keyframe(keyframe = NULL, pause = 0)

add_pause(.data, pause = 0)

add_keyframe(
  .data,
  keyframe,
  ease,
  length,
  id = NULL,
  enter = NULL,
  exit = NULL
)
}
\arguments{
\item{keyframe}{A data frame to use as a keyframe state}

\item{pause}{The length of the pause at the current keyframe}

\item{.data}{A data.frame to start from. If \code{.data} is the result of a prior
tween, only the last frame will be used for the tween. The new tween will
then be added to the prior tween}

\item{ease}{The easing function to use. Either a single string or one for
each column in the data set.}

\item{length}{The length of the transition}

\item{id}{The column to match observations on. If \code{NULL} observations will be
matched by position. See the \emph{Match, Enter, and Exit} section for more
information.}

\item{enter, exit}{functions that calculate a start state for new observations
that appear in \code{to} or an end state for observations that are not present in
\code{to}. If \code{NULL} the new/old observations will not be part of the tween. The
function gets a data.frame with either the start state of the exiting
observations, or the end state of the entering observations and must return
a modified version of that data.frame. See the \emph{Match, Enter, and Exit}
section for more information.}
}
\value{
A \code{keyframe_generator} object
}
\description{
This is a generator version of \code{\link[=tween_state]{tween_state()}} and its utility functions. It
returns a generator that can be used with \code{\link[=get_frame]{get_frame()}} and
\code{\link[=get_raw_frames]{get_raw_frames()}} to extract frames for a specific time point scaled between
0 and 1.
}
\examples{
df1 <- data.frame(
  country = c('Denmark', 'Sweden', 'Norway'),
  population = c(5e6, 10e6, 3.5e6)
)
df2 <- data.frame(
  country = c('Denmark', 'Sweden', 'Norway', 'Finland'),
  population = c(6e6, 10.5e6, 4e6, 3e6)
)
df3 <- data.frame(
  country = c('Denmark', 'Norway'),
  population = c(10e6, 6e6)
)
to_zero <- function(x) {
  x$population <- 0
  x
}
gen <- gen_keyframe(df1, 10) \%>\%
  add_keyframe(df2, 'cubic-in-out', 35, id = country, enter = to_zero) \%>\%
  add_pause(10) \%>\%
  add_keyframe(df3, 'cubic-in-out', 35, id = country, enter = to_zero,
               exit = to_zero) \%>\%
  add_pause(10)

get_frame(gen, 0.25)
}
\seealso{
Other Other generators: 
\code{\link{gen_along}()},
\code{\link{gen_at}()},
\code{\link{gen_components}()},
\code{\link{gen_events}()}
}
\concept{Other generators}
