% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TMB.R
\name{compile}
\alias{compile}
\title{Compile a C++ template to DLL suitable for MakeADFun.}
\usage{
compile(file, flags = "", safebounds = TRUE, safeunload = TRUE,
  openmp = isParallelTemplate(file[1]), libtmb = TRUE, libinit = TRUE,
  tracesweep = FALSE, framework = getOption("tmb.ad.framework"),
  supernodal = FALSE, longint = FALSE, eigen.disable.warnings = TRUE,
  max.order = NULL, ...)
}
\arguments{
\item{file}{C++ file.}

\item{flags}{Character with compile flags.}

\item{safebounds}{Turn on preprocessor flag for bound checking?}

\item{safeunload}{Turn on preprocessor flag for safe DLL unloading?}

\item{openmp}{Turn on openmp flag? Auto detected for parallel templates.}

\item{libtmb}{Use precompiled TMB library if available (to speed up compilation)?}

\item{libinit}{Turn on preprocessor flag to register native routines?}

\item{tracesweep}{Turn on preprocessor flag to trace AD sweeps? (Silently disables \code{libtmb})}

\item{framework}{Which AD framework to use ('TMBad' or 'CppAD')}

\item{supernodal}{Turn on preprocessor flag to use supernodal sparse Cholesky/Inverse from system wide suitesparse library}

\item{longint}{Turn on preprocessor flag to use long integers for Eigen's SparseMatrix StorageIndex}

\item{eigen.disable.warnings}{Turn on preprocessor flag to disable nuisance warnings. Note that this is not allowed for code to be compiled on CRAN.}

\item{max.order}{Maximum derivative order of compiler generated atomic special functions - see details.}

\item{...}{Passed as Makeconf variables.}
}
\description{
Compile a C++ template into a shared object file. OpenMP flag is set if the template is detected to be parallel.
}
\details{
TMB relies on R's built in functionality to create shared libraries independent of the platform.
A template is compiled by \code{compile("template.cpp")}, which will call R's makefile with appropriate
preprocessor flags.
Compiler and compiler flags can be stored in a configuration file. In order of precedence either via
the file pointed at by R_MAKEVARS_USER or the file ~/.R/Makevars if it exists.
Additional configuration variables can be set with the \code{flags} and \code{...} arguments, which will override any
previous selections.
}
\section{Using a custom SuiteSparse installation}{

Sparse matrix calculations play an important role in TMB. By default TMB uses a small subset of \code{SuiteSparse} available through the R package \code{Matrix}. This is sufficient for most use cases, however for some very large models the following extra features are worth considering:

\itemize{
  \item Some large models benefit from an extended set of graph reordering algorithms (especially METIS) not part of \code{Matrix}. It is common that these orderings can provide quite big speedups.
  \item Some large models need sparse matrices with number of nonzeros exceeding the current 32 bit limitation of \code{Matrix}. Normally such cases will result in the cholmod error 'problem too large'. \code{SuiteSparse} includes 64 bit integer routines to address this problem.
}

Experimental support for linking to a \emph{custom} \code{SuiteSparse} installation is available through two arguments to the \code{\link{compile}} function. The first argument \code{supernodal=TRUE} tells TMB to use the supernodal Cholesky factorization from the system wide \code{SuiteSparse} on the C++ side. This will affect the speed of the Laplace approximation when run internally (using arguments \code{intern} or \code{integrate} to \code{\link{MakeADFun}}).

The second argument \code{longint=TRUE} tells TMB to use 64 bit integers for sparse matrices on the C++ side. This works in combination with \code{supernodal=TRUE} from Eigen version 3.4.

On Windows a \code{SuiteSparse} installation can be obtained using the \code{Rtools} package manager. Start 'Rtools Bash' terminal and run:
\preformatted{
  pacman -Sy
  pacman -S mingw-w64-{i686,x86_64}-suitesparse
}

On Linux one should look for the package \code{libsuitesparse-dev}.
}

\section{Selecting the AD framework}{

TMB supports two different AD libraries 'CppAD' and 'TMBad' selected via the argument \code{framework} which works as a switch to set one of two C++ preprocessor flags: 'CPPAD_FRAMEWORK' or 'TMBAD_FRAMEWORK'. The default value of \code{framework} can be set from R by \code{options("tmb.ad.framework")} or alternatively from the shell via the environment variable 'TMB_AD_FRAMEWORK'. Packages linking to TMB should set one of the two C++ preprocessor flags in Makevars.
}

\section{Order of compiler generated atomic functions}{

The argument \code{max.order} controls the maximum derivative order of special functions (e.g. \code{pbeta}) generated by the compiler. By default the value is set to 3 which is sufficient to obtain the Laplace approximation (order 2) and its derivatives (order 3). However, sometimes a higher value may be needed. For example \code{framework='TMBad'} allows one to calculate the Hessian of the Laplace approximation, but that requires 4th order derivatives of special functions in use. A too small value will cause the runtime error 'increase TMB_MAX_ORDER'. Note that compilation time and binary size increases with \code{max.order}.
}

\seealso{
\code{\link{precompile}}
}
