% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/section.R
\name{section}
\alias{section}
\alias{print.section}
\alias{str.section}
\alias{get_section}
\title{Create a section in a list (collection of functions and other objects).}
\usage{
section(obj, title)

\method{print}{section}(x, ...)

\method{str}{section}(object, ...)

get_section(x, title)
}
\arguments{
\item{obj}{A list object.}

\item{title}{The title of the section. It must match the name of the list
item. For a title "My section title", the name must be "0__MY_SECTION_NAME__"
that is both a syntactically correct name and something that emphasizes the
entry as a title.}

\item{x}{A list containing the section}

\item{...}{Further arguments (not used yet)}

\item{object}{A list to use for section extraction}
}
\value{
A function that is able to extract the corresponding section from the
list.
}
\description{
A section tags a list to sort its items. It is particularly
useful when you create a collection of function (or other objects) to ease
the access to these functions. Sections are displayed in printed and "str"ed
versions of the list and are also functions that cut the list to the section
content only. \code{get_section()} is the workhorse function that does the section
extraction.
}
\examples{
#TODO...
}
