% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locate.R
\name{str_locate}
\alias{str_locate}
\alias{str_locate_all}
\title{Find location of match}
\usage{
str_locate(string, pattern)

str_locate_all(string, pattern)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{pattern}{Pattern to look for.

The default interpretation is a regular expression, as described in
\code{vignette("regular-expressions")}. Use \code{\link[=regex]{regex()}} for finer control of the
matching behaviour.

Match a fixed string (i.e. by comparing only bytes), using
\code{\link[=fixed]{fixed()}}. This is fast, but approximate. Generally,
for matching human text, you'll want \code{\link[=coll]{coll()}} which
respects character matching rules for the specified locale.

Match character, word, line and sentence boundaries with
\code{\link[=boundary]{boundary()}}. An empty pattern, "", is equivalent to
\code{boundary("character")}.}
}
\value{
\itemize{
\item \code{str_locate()} returns an integer matrix with two columns and
one row for each element of \code{string}. The first column, \code{start},
gives the position at the start of the match, and the second column, \code{end},
gives the position of the end.
\item \code{str_locate_all()} returns a list of integer matrices with the same
length as \code{string}/\code{pattern}. The matrices have columns \code{start} and \code{end}
as above, and one row for each match.
}
}
\description{
\code{str_locate()} returns the \code{start} and \code{end} position of the first match;
\code{str_locate_all()} returns the \code{start} and \code{end} position of each match.

Because the \code{start} and \code{end} values are inclusive, zero-length matches
(e.g. \code{$}, \code{^}, \verb{\\\\b}) will have an \code{end} that is smaller than \code{start}.
}
\examples{
fruit <- c("apple", "banana", "pear", "pineapple")
str_locate(fruit, "$")
str_locate(fruit, "a")
str_locate(fruit, "e")
str_locate(fruit, c("a", "b", "p", "p"))

str_locate_all(fruit, "a")
str_locate_all(fruit, "e")
str_locate_all(fruit, c("a", "b", "p", "p"))

# Find location of every character
str_locate_all(fruit, "")
}
\seealso{
\code{\link[=str_extract]{str_extract()}} for a convenient way of extracting matches,
\code{\link[stringi:stri_locate]{stringi::stri_locate()}} for the underlying implementation.
}
