% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/updateButton.R
\name{updateButton}
\alias{updateButton}
\title{updateButton}
\usage{
updateButton(session, inputId, label = NULL, icon = NULL, value = NULL,
  style = NULL, size = NULL, block = NULL, disabled = NULL)
}
\arguments{
\item{session}{The session object passed to function given to shinyServer.}

\item{inputId}{Specifies the input slot that will be used to access the
value.}

\item{label}{The contents of the button or link--usually a text label, but
you could also use any other HTML, like an image.}

\item{icon}{An optional \code{\link{icon}} to appear on the button.}

\item{value}{\bold{logical} If \code{type = "toggle"}, the initial value of the button.}

\item{style}{A Bootstrap style to apply to the button. (\code{default}, \code{primary},
\code{success}, \code{info}, \code{warning}, or \code{danger})}

\item{size}{The size of the button (\code{extra-small}, \code{small},
\code{default}, or \code{large})}

\item{block}{\bold{logical} Should the button take the full width of the parent element?}

\item{disabled}{\bold{logical} Should the button be disabled (un-clickable)?}
}
\description{
\code{updateButton} is used in your Server logic to update the style or state
of a button.
}
\details{
Because of the way it is coded, \code{updateButton} may work on buttons not
created by \code{\link{bsButton}} such as \code{\link{submitButton}}.

See \code{\link{Buttons}} for more information about how to use \code{updateButton} with the rest of the Buttons family.
}
\note{
Run \code{bsExample("Buttons")} for an example
of \code{updateButton} functionality.
}
\seealso{
\href{http://getbootstrap.com}{Twitter Bootstrap 3}

Other Buttons: \code{\link{Buttons}};
  \code{\link{bsButton}}
}

