% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{as.Seurat.CellDataSet}
\alias{as.Seurat.CellDataSet}
\alias{as.Seurat.SingleCellExperiment}
\title{Convert objects to \code{Seurat} objects}
\usage{
\method{as.Seurat}{CellDataSet}(x, slot = "counts", assay = "RNA", verbose = TRUE, ...)

\method{as.Seurat}{SingleCellExperiment}(
  x,
  counts = "counts",
  data = "logcounts",
  assay = "RNA",
  project = "SingleCellExperiment",
  ...
)
}
\arguments{
\item{x}{An object to convert to class \code{Seurat}}

\item{slot}{Slot to store expression data as}

\item{assay}{Name to store expression matrices as}

\item{verbose}{Show progress updates}

\item{...}{Arguments passed to other methods}

\item{counts}{name of the SingleCellExperiment assay to store as \code{counts};
set to \code{NULL} if only normalized data are present}

\item{data}{name of the SingleCellExperiment assay to slot as \code{data}.
Set to NULL if only counts are present}

\item{project}{Project name for new Seurat object}
}
\value{
A \code{Seurat} object generated from \code{x}
}
\description{
Convert objects to \code{Seurat} objects
}
\seealso{
\code{\link[SeuratObject:as.Seurat]{SeuratObject::as.Seurat}}
}
\concept{objects}
