% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mixscape.R
\name{RunLDA}
\alias{RunLDA}
\alias{RunLDA.default}
\alias{RunLDA.Assay}
\alias{RunLDA.Seurat}
\title{Run Linear Discriminant Analysis}
\usage{
RunLDA(object, ...)

\method{RunLDA}{default}(
  object,
  labels,
  assay = NULL,
  verbose = TRUE,
  ndims.print = 1:5,
  nfeatures.print = 30,
  reduction.key = "LDA_",
  seed = 42,
  ...
)

\method{RunLDA}{Assay}(
  object,
  assay,
  labels,
  features = NULL,
  verbose = TRUE,
  ndims.print = 1:5,
  nfeatures.print = 30,
  reduction.key = "LDA_",
  seed = 42,
  ...
)

\method{RunLDA}{Seurat}(
  object,
  assay = NULL,
  labels,
  features = NULL,
  reduction.name = "lda",
  reduction.key = "LDA_",
  seed = 42,
  verbose = TRUE,
  ndims.print = 1:5,
  nfeatures.print = 30,
  ...
)
}
\arguments{
\item{object}{An object of class Seurat.}

\item{...}{Arguments passed to other methods}

\item{labels}{Meta data column with target gene class labels.}

\item{assay}{Assay to use for performing Linear Discriminant Analysis (LDA).}

\item{verbose}{Print the top genes associated with high/low loadings for
the PCs}

\item{ndims.print}{Number of LDA dimensions to print.}

\item{nfeatures.print}{Number of features to print for each LDA component.}

\item{reduction.key}{Reduction key name.}

\item{seed}{Value for random seed}

\item{features}{Features to compute LDA on}

\item{reduction.name}{dimensional reduction name, lda by default}
}
\description{
Run Linear Discriminant Analysis

Function to perform Linear Discriminant Analysis.
}
\concept{mixscape}
