% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{FeatureScatter}
\alias{FeatureScatter}
\alias{GenePlot}
\title{Scatter plot of single cell data}
\usage{
FeatureScatter(
  object,
  feature1,
  feature2,
  cells = NULL,
  group.by = NULL,
  cols = NULL,
  pt.size = 1,
  shape.by = NULL,
  span = NULL,
  smooth = FALSE,
  combine = TRUE,
  slot = "data",
  plot.cor = TRUE,
  raster = NULL
)
}
\arguments{
\item{object}{Seurat object}

\item{feature1}{First feature to plot. Typically feature expression but can also
be metrics, PC scores, etc. - anything that can be retreived with FetchData}

\item{feature2}{Second feature to plot.}

\item{cells}{Cells to include on the scatter plot.}

\item{group.by}{Name of one or more metadata columns to group (color) cells by
(for example, orig.ident); pass 'ident' to group by identity class}

\item{cols}{Colors to use for identity class plotting.}

\item{pt.size}{Size of the points on the plot}

\item{shape.by}{Ignored for now}

\item{span}{Spline span in loess function call, if \code{NULL}, no spline added}

\item{smooth}{Smooth the graph (similar to smoothScatter)}

\item{combine}{Combine plots into a single \code{\link[patchwork]{patchwork}ed}}

\item{slot}{Slot to pull data from, should be one of 'counts', 'data', or 'scale.data'}

\item{plot.cor}{Display correlation in plot title}

\item{raster}{Convert points to raster format, default is \code{NULL}
which will automatically use raster if the number of points plotted is greater than
100,000}
}
\value{
A ggplot object
}
\description{
Creates a scatter plot of two features (typically feature expression), across a
set of single cells. Cells are colored by their identity class. Pearson
correlation between the two features is displayed above the plot.
}
\examples{
data("pbmc_small")
FeatureScatter(object = pbmc_small, feature1 = 'CD9', feature2 = 'CD3E')

}
\concept{visualization}
