% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.R
\name{df_label_both}
\alias{df_label_both}
\alias{df_label_value}
\title{Functions to Label Data Frames by Grouping Variables}
\usage{
df_label_both(data, ..., vars = NULL, label_col = "label", sep = c(", ", ":"))

df_label_value(data, ..., vars = NULL, label_col = "label", sep = ", ")
}
\arguments{
\item{data}{a data frame}

\item{...}{One or more unquoted expressions (or variable names) separated by
commas. Used as grouping variables.}

\item{vars}{a character vector containing the grouping variables of interest.}

\item{label_col}{column to hold the label of the data subsets. Default column
name is "label".}

\item{sep}{String separating labelling variables and values. Should be of
length 2 in the function \code{df_label_both()}. 1) One sep is used to
separate groups, for example ','; 2) The other sep between group name and
levels; for example ':'.}
}
\value{
a modified data frame with a column containing row labels.
}
\description{
Functions to label data frame rows by one or multiple grouping
  variables.
}
\section{Functions}{
\itemize{
\item \code{df_label_both}: Displays both the variable name and the factor value.

\item \code{df_label_value}: Displays only the value of a factor.
}}

\examples{
# Data preparation
df <- head(ToothGrowth)

# Labelling: Non standard evaluation
df \%>\%
  df_label_both(dose, supp)

# Standard evaluation
df \%>\%
  df_label_both(dose, supp)

# Nesting the data then label each subset by groups
ToothGrowth \%>\%
  df_nest_by(dose, supp) \%>\%
  df_label_both(supp, dose)

}
