% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regularExpressions.R
\name{initRegExp}
\alias{initRegExp}
\title{Add regular expression operator}
\usage{
initRegExp(db)
}
\arguments{
\item{db}{A \code{\linkS4class{SQLiteConnection}} object to add the
regular expression operator into the connection.}
}
\value{
Always \code{TRUE}, invisibly.
}
\description{
This loads a regular-expression matcher for posix extended regular
expressions, as available through the SQLite source code repository
(\url{https://sqlite.org/src/raw?filename=ext/misc/regexp.c}).
}
\details{
SQLite will then implement the "A regexp B" operator,
where A is the string to be matched and B is the regular expression.

Note this only affects the specified connection.
}
\examples{
library(DBI)
db <- RSQLite::datasetsDb()
RSQLite::initRegExp(db)

dbGetQuery(db, "SELECT * FROM mtcars WHERE carb REGEXP '[12]'")
dbDisconnect(db)
}
