% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{load_options}
\alias{load_options}
\alias{roxy_meta_get}
\title{Load roxygen2 options}
\usage{
load_options(base_path = ".")

roxy_meta_get(key = NULL, default = NULL)
}
\arguments{
\item{base_path}{Path to package.}
}
\description{
Options can be stored in the \code{Roxygen} field of the \code{DESCRIPTION}, or
in \code{man/roxygen/meta.R}. In either case, the code is parsed and evaluated
in a child of the base environment. Call \code{roxy_meta_get()} to access
current option values from within tag and roclet methods.

Options in \code{man/roxygen/meta.R} override those present in \code{DESCRIPTION}.
}
\section{Possible options}{

\itemize{
\item \code{roclets} \verb{<character>}: giving names of roclets to run. See
\code{\link[=roclet_find]{roclet_find()}} for details.
\item \code{packages} \verb{<character>}: packages to load that implement new tags.
\item \code{load} \verb{<string>}: how to load R code. See \link{load} for details.
\item \code{old_usage} \verb{<flag>}: use old style usage formatting?
\item \code{markdown} \verb{<flag>}: translate markdown syntax to Rd?
\item \code{r6} \verb{<flag>}: document R6 classes?
\item \code{current_package} \verb{<string>} (read only): name of package being documented.
\item \code{rd_family_title} \verb{<list>}: overrides for \verb{@family} titles. See the
\emph{rd} vignette for details: \code{vignette("rd", package = "roxygen2")}
\item \code{knitr_chunk_options} \verb{<list>}: default chunk options used for knitr.
\item \code{restrict_image_formats} \verb{<flag>}: if \code{TRUE} then PDF images are only
included in the PDF manual, and SVG images are only included in the HTML
manual. (This only applies to images supplied via markdown.)
}
}

\section{How to set}{

Either set in \code{DESCRIPTION}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{Roxygen: list(markdown = TRUE, load = "installed")
}\if{html}{\out{</div>}}

Or if longer, you can put in \verb{/man/roxygen/meta.R}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(
  markdown = TRUE,
  load = "installed"
)
}\if{html}{\out{</div>}}
}

\keyword{internal}
