% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/melt.r
\name{melt.array}
\alias{melt.array}
\alias{melt.table}
\alias{melt.matrix}
\title{Melt an array.}
\usage{
\method{melt}{array}(
  data,
  varnames = names(dimnames(data)),
  ...,
  na.rm = FALSE,
  as.is = FALSE,
  value.name = "value"
)

\method{melt}{table}(
  data,
  varnames = names(dimnames(data)),
  ...,
  na.rm = FALSE,
  as.is = FALSE,
  value.name = "value"
)

\method{melt}{matrix}(
  data,
  varnames = names(dimnames(data)),
  ...,
  na.rm = FALSE,
  as.is = FALSE,
  value.name = "value"
)
}
\arguments{
\item{data}{array to melt}

\item{varnames}{variable names to use in molten data.frame}

\item{...}{further arguments passed to or from other methods.}

\item{na.rm}{Should NA values be removed from the data set? This will
convert explicit missings to implicit missings.}

\item{as.is}{if \code{FALSE}, the default, dimnames will be converted
using \code{\link{type.convert}}. If \code{TRUE}, they will be left
as strings.}

\item{value.name}{name of variable used to store values}
}
\description{
This code is conceptually similar to \code{\link{as.data.frame.table}}
}
\examples{
a <- array(c(1:23, NA), c(2,3,4))
melt(a)
melt(a, na.rm = TRUE)
melt(a, varnames=c("X","Y","Z"))
dimnames(a) <- lapply(dim(a), function(x) LETTERS[1:x])
melt(a)
melt(a, varnames=c("X","Y","Z"))
dimnames(a)[1] <- list(NULL)
melt(a)
}
\seealso{
\code{\link{cast}}

Other melt methods: 
\code{\link{melt.data.frame}()},
\code{\link{melt.default}()},
\code{\link{melt.list}()}
}
\concept{melt methods}
\keyword{manip}
