% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xsizes-docs.R
\name{pretty_bytes}
\alias{pretty_bytes}
\alias{compute_bytes}
\title{Bytes in a human readable string}
\usage{
pretty_bytes(bytes, style = c("default", "nopad", "6"))

compute_bytes(bytes, smallest_unit = "B")
}
\arguments{
\item{bytes}{Numeric vector, number of bytes.}

\item{style}{Formatting style:
\itemize{
\item \code{"default"} is the original \code{pretty_bytes} formatting, and it always
pads the output, so that all vector elements are of the same width,
\item \code{"nopad"} is similar, but does not pad the output,
\item \code{"6"} always uses 6 characters,
The \code{"6"} style is useful if it is important that the output always
has the same width (number of characters), e.g. in progress bars.
See some examples below.
}}

\item{smallest_unit}{A character scalar, the smallest unit to use.}
}
\value{
Character vector, the formatted sizes.
For \code{compute_bytes}, a data frame with columns \code{amount}, \code{unit},
\code{negative}.
}
\description{
Use \code{pretty_bytes()} to format bytes. \code{compute_bytes()} is the underlying
engine that may be useful for custom formatting.
}
\examples{
bytes <- c(1337, 133337, 13333337, 1333333337, 133333333337)
pretty_bytes(bytes)
pretty_bytes(bytes, style = "nopad")
pretty_bytes(bytes, style = "6")
}
