% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_nakagawa.R
\name{r2_nakagawa}
\alias{r2_nakagawa}
\title{Nakagawa's R2 for mixed models}
\usage{
r2_nakagawa(model, by_group = FALSE, tolerance = 1e-05)
}
\arguments{
\item{model}{A mixed effects model.}

\item{by_group}{Logical, if \code{TRUE}, returns the explained variance
at different levels (if there are multiple levels). This is essentially
similar to the variance reduction approach by \cite{Hox (2010), pp. 69-78}.}

\item{tolerance}{Tolerance for singularity check of random effects, to decide
whether to compute random effect variances for the conditional r-squared
or not. Indicates up to which value the convergence result is accepted. When
\code{r2_nakagawa()} returns a warning, stating that random effect variances
can't be computed (and thus, the conditional r-squared is \code{NA}),
decrease the tolerance-level. See also \code{\link{check_singularity}}.}
}
\value{
A list with the conditional and marginal R2 values.
}
\description{
Compute the marginal and conditional r-squared value for
 mixed effects models with complex random effects structures.
}
\details{
Marginal and conditional r-squared values for mixed models are calculated
 based on \cite{Nakagawa et al. 2017}. For more details on the computation
 of the variances, see \code{?insight::get_variance}.
 \cr \cr
 The marginal r-squared considers only the variance of the fixed effects, while the
 conditional r-squared takes both the fixed and random effects into account.
 The random effect variances are actually the mean random effect variances,
 thus the r-squared value is also appropriate for mixed models with random
 slopes or nested random effects (see \cite{Johnson 2014}).
}
\examples{
if (require("lme4")) {
  model <- lmer(Sepal.Length ~ Petal.Length + (1 | Species), data = iris)
  r2_nakagawa(model)
  r2_nakagawa(model, by_group = TRUE)
}
}
\references{
\itemize{
 \item Hox, J. J. (2010). Multilevel analysis: techniques and applications (2nd ed). New York: Routledge.
 \item Johnson, P. C. D. (2014). Extension of Nakagawa & Schielzeth’s R2 GLMM to random slopes models. Methods in Ecology and Evolution, 5(9), 944–946. \doi{10.1111/2041-210X.12225}
 \item Nakagawa, S., & Schielzeth, H. (2013). A general and simple method for obtaining R2 from generalized linear mixed-effects models. Methods in Ecology and Evolution, 4(2), 133–142. \doi{10.1111/j.2041-210x.2012.00261.x}
 \item Nakagawa, S., Johnson, P. C. D., & Schielzeth, H. (2017). The coefficient of determination R2 and intra-class correlation coefficient from generalized linear mixed-effects models revisited and expanded. Journal of The Royal Society Interface, 14(134), 20170213. \doi{10.1098/rsif.2017.0213}
 }
}
