% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictSurvProb.R
\name{predictSurvProb}
\alias{predictSurvProb}
\alias{predictSurvProb.aalen}
\alias{predictSurvProb.riskRegression}
\alias{predictSurvProb.cox.aalen}
\alias{predictSurvProb.coxph}
\alias{predictSurvProb.cph}
\alias{predictSurvProb.default}
\alias{predictSurvProb.rfsrc}
\alias{predictSurvProb.matrix}
\alias{predictSurvProb.pecCtree}
\alias{predictSurvProb.pecCforest}
\alias{predictSurvProb.prodlim}
\alias{predictSurvProb.psm}
\alias{predictSurvProb.selectCox}
\alias{predictSurvProb.survfit}
\alias{predictSurvProb.pecRpart}
\title{Predicting survival probabilities}
\usage{
\method{predictSurvProb}{aalen}(object,newdata,times,...)
\method{predictSurvProb}{riskRegression}(object,newdata,times,...)
\method{predictSurvProb}{cox.aalen}(object,newdata,times,...)
\method{predictSurvProb}{cph}(object,newdata,times,...)
\method{predictSurvProb}{coxph}(object,newdata,times,...)
\method{predictSurvProb}{matrix}(object,newdata,times,...)
\method{predictSurvProb}{selectCox}(object,newdata,times,...)
\method{predictSurvProb}{pecCforest}(object,newdata,times,...)
\method{predictSurvProb}{prodlim}(object,newdata,times,...)
\method{predictSurvProb}{psm}(object,newdata,times,...)
\method{predictSurvProb}{survfit}(object,newdata,times,...)
\method{predictSurvProb}{pecRpart}(object,newdata,times,...)
#' \method{predictSurvProb}{pecCtree}(object,newdata,times,...)
}
\arguments{
\item{object}{A fitted model from which to extract predicted survival
probabilities}

\item{newdata}{A data frame containing predictor variable combinations for
which to compute predicted survival probabilities.}

\item{times}{A vector of times in the range of the response variable, e.g.
times when the response is a survival object, at which to return the
survival probabilities.}

\item{\dots}{Additional arguments that are passed on to the current method.}
}
\value{
A matrix with as many rows as \code{NROW(newdata)} and as many
columns as \code{length(times)}. Each entry should be a probability and in
rows the values should be decreasing.
}
\description{
Function to extract survival probability predictions from various modeling
approaches. The most prominent one is the Cox regression model which can be
fitted for example with `coxph' and with `cph'.
}
\details{
The function predictSurvProb is a generic function that means it invokes
specifically designed functions depending on the 'class' of the first
argument.

The function \code{pec} requires survival probabilities for each row in
newdata at requested times. These probabilities are extracted from a fitted
model of class \code{CLASS} with the function \code{predictSurvProb.CLASS}.

Currently there are \code{predictSurvProb} methods for objects of class cph
(library rms), coxph (library survival), aalen (library timereg), cox.aalen
(library timereg), 
rpart (library rpart), product.limit (library prodlim),
survfit (library survival), psm (library rms)
}
\note{
In order to assess the predictive performance of a new survival model
a specific \code{predictSurvProb} S3 method has to be written. For examples,
see the bodies of the existing methods.

The performance of the assessment procedure, in particular for resampling
where the model is repeatedly evaluated, will be improved by supressing in
the call to the model all the computations that are not needed for
probability prediction. For example, \code{se.fit=FALSE} can be set in the
call to \code{cph}.
}
\examples{

# generate some survival data
library(prodlim)
set.seed(100)
d <- SimSurv(100)
# then fit a Cox model
library(survival)
library(rms)
coxmodel <- cph(Surv(time,status)~X1+X2,data=d,surv=TRUE)

# Extract predicted survival probabilities 
# at selected time-points:
ttt <- quantile(d$time)
# for selected predictor values:
ndat <- data.frame(X1=c(0.25,0.25,-0.05,0.05),X2=c(0,1,0,1))
# as follows
predictSurvProb(coxmodel,newdata=ndat,times=ttt)

# stratified cox model
sfit <- coxph(Surv(time,status)~strata(X1)+X2,data=d,,x=TRUE,y=TRUE)
predictSurvProb(sfit,newdata=d[1:3,],times=c(1,3,5,10))

## simulate some learning and some validation data
learndat <- SimSurv(100)
valdat <- SimSurv(100)
## use the learning data to fit a Cox model
library(survival)
fitCox <- coxph(Surv(time,status)~X1+X2,data=learndat,x=TRUE,y=TRUE)
## suppose we want to predict the survival probabilities for all patients
## in the validation data at the following time points:
## 0, 12, 24, 36, 48, 60
psurv <- predictSurvProb(fitCox,newdata=valdat,times=seq(0,60,12))
## This is a matrix with survival probabilities
## one column for each of the 5 time points
## one row for each validation set individual

## Cox with ridge option
f1 <- coxph(Surv(time,status)~X1+X2,data=learndat,x=TRUE,y=TRUE)
f2 <- coxph(Surv(time,status)~ridge(X1)+ridge(X2),data=learndat,x=TRUE,y=TRUE)
plot(predictSurvProb(f1,newdata=valdat,times=10),
     pec:::predictSurvProb.coxph(f2,newdata=valdat,times=10),
     xlim=c(0,1),
     ylim=c(0,1),
     xlab="Unpenalized predicted survival chance at 10",
     ylab="Ridge predicted survival chance at 10")


}
\references{
Ulla B. Mogensen, Hemant Ishwaran, Thomas A. Gerds (2012).
Evaluating Random Forests for Survival Analysis Using Prediction Error
Curves. Journal of Statistical Software, 50(11), 1-23. DOI
10.18637/jss.v050.i11
}
\seealso{
\code{\link{predict}},\code{\link{survfit}}
}
\author{
Thomas A. Gerds \email{tag@biostat.ku.dk}
}
\keyword{survival}
