% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/length_levels_linter.R
\name{length_levels_linter}
\alias{length_levels_linter}
\title{Require usage of nlevels over length(levels(.))}
\usage{
length_levels_linter()
}
\description{
\code{length(levels(x))} is the same as \code{nlevels(x)}, but harder to read.
}
\examples{
# will produce lints
lint(
  text = "length(levels(x))",
  linters = length_levels_linter()
)

# okay
lint(
  text = "length(c(levels(x), levels(y)))",
  linters = length_levels_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=consistency_linters]{consistency}, \link[=readability_linters]{readability}
}
