Sys.setlocale("LC_CTYPE", "en_US.UTF-8")

make_ISO_3166_1_table <-
function()
{
    x <- jsonlite::read_json("/usr/share/iso-codes/json/iso_3166-1.json",
                             TRUE)
    ## See <file:///usr/share/iso-codes/json/schema-3166-1.json>
    ISO_3166_1_vars <-
        c(Alpha_2 = "alpha_2",
          Alpha_3 = "alpha_3",
          Numeric = "numeric",
          Name = "name",
          Official_name = "official_name",
          Common_name = "common_name")
    ISO_3166_1 <- x[[1L]][ISO_3166_1_vars]
    names(ISO_3166_1) <- names(ISO_3166_1_vars)
    ISO_3166_1
}

make_ISO_3166_2_table <-
function()
{
    x <- jsonlite::read_json("/usr/share/iso-codes/json/iso_3166-2.json",
                             TRUE)
    ## See <file:///usr/share/iso-codes/json/schema-3166-2.json>
    ISO_3166_2_vars <-
        c(Code = "code",
          Name = "name",
          Type = "type",
          Parent = "parent")
    ISO_3166_2 <- x[[1L]][ISO_3166_2_vars]
    names(ISO_3166_2) <- names(ISO_3166_2_vars)
    ISO_3166_2
}

make_ISO_3166_3_table <-
function()
{
    x <- jsonlite::read_json("/usr/share/iso-codes/json/iso_3166-3.json",
                             TRUE)
    ## See <file:///usr/share/iso-codes/json/schema-3166-3.json>
    ISO_3166_3_vars <-
        c(Alpha_4 = "alpha_4",
          Alpha_3 = "alpha_3",
          Numeric = "numeric",
          Name = "name",
          Date_withdrawn = "withdrawal_date",
          Comment = "comment")
    ISO_3166_3 <- x[[1L]][ISO_3166_3_vars]
    names(ISO_3166_3) <- names(ISO_3166_3_vars)
    ISO_3166_3
}

if(FALSE) {
    ISO_3166_1 <- make_ISO_3166_1_table()
    save(ISO_3166_1, file = "ISO_3166_1.rda", compress = TRUE)
    ISO_3166_2 <- make_ISO_3166_2_table()
    save(ISO_3166_2, file = "ISO_3166_2.rda", compress = TRUE)
    ISO_3166_3 <- make_ISO_3166_3_table()
    save(ISO_3166_3, file = "ISO_3166_3.rda", compress = TRUE)
}
