% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motifs.R
\name{dyad_census}
\alias{dyad_census}
\title{Dyad census of a graph}
\usage{
dyad_census(graph)
}
\arguments{
\item{graph}{The input graph. A warning is given if it is not directed.}
}
\value{
A named numeric vector with three elements: \item{mut}{The number of
pairs with mutual connections.} \item{asym}{The number of pairs with
non-mutual connections.} \item{null}{The number of pairs with no connection
between them.}
}
\description{
Classify dyads in a directed graphs. The relationship between each pair of
vertices is measured. It can be in three states: mutual, asymmetric or
non-existent.
}
\examples{

g <- sample_pa(100)
dyad_census(g)
}
\references{
Holland, P.W. and Leinhardt, S. A Method for Detecting Structure
in Sociometric Data. \emph{American Journal of Sociology}, 76, 492--513.
1970.

Wasserman, S., and Faust, K. \emph{Social Network Analysis: Methods and
Applications.} Cambridge: Cambridge University Press. 1994.
}
\seealso{
\code{\link[=triad_census]{triad_census()}} for the same classification, but with
triples.

Other graph motifs: 
\code{\link{count_motifs}()},
\code{\link{motifs}()},
\code{\link{sample_motifs}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{graph motifs}
\keyword{graphs}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/latest/igraph-Motifs.html#igraph_dyad_census}{\code{igraph_dyad_census()}}.}

