% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{graph_from_graphnel}
\alias{graph_from_graphnel}
\alias{igraph.from.graphNEL}
\title{Convert graphNEL objects from the graph package to igraph}
\usage{
graph_from_graphnel(graphNEL, name = TRUE, weight = TRUE, unlist.attrs = TRUE)
}
\arguments{
\item{graphNEL}{The graphNEL graph.}

\item{name}{Logical scalar, whether to add graphNEL vertex names as an
igraph vertex attribute called \sQuote{\code{name}}.}

\item{weight}{Logical scalar, whether to add graphNEL edge weights as an
igraph edge attribute called \sQuote{\code{weight}}. (graphNEL graphs are
always weighted.)}

\item{unlist.attrs}{Logical scalar. graphNEL attribute query functions
return the values of the attributes in R lists, if this argument is
\code{TRUE} (the default) these will be converted to atomic vectors,
whenever possible, before adding them to the igraph graph.}
}
\value{
\code{graph_from_graphnel} returns an igraph graph object.
}
\description{
The graphNEL class is defined in the \code{graph} package, it is another
way to represent graphs. \code{graph_from_graphnel} takes a graphNEL
graph and converts it to an igraph graph. It handles all
graph/vertex/edge attributes. If the graphNEL graph has a vertex
attribute called \sQuote{\code{name}} it will be used as igraph vertex
attribute \sQuote{\code{name}} and the graphNEL vertex names will be
ignored.
}
\details{
Because graphNEL graphs poorly support multiple edges, the edge
attributes of the multiple edges are lost: they are all replaced by the
attributes of the first of the multiple edges.
}
\examples{
\dontrun{
## Undirected
g <- make_ring(10)
V(g)$name <- letters[1:10]
GNEL <- as_graphnel(g)
g2 <- graph_from_graphnel(GNEL)
g2

## Directed
g3 <- make_star(10, mode="in")
V(g3)$name <- letters[1:10]
GNEL2 <- as_graphnel(g3)
g4 <- graph_from_graphnel(GNEL2)
g4
}
}
\seealso{
\code{\link{as_graphnel}} for the other direction,
\code{\link{as_adj}}, \code{\link{graph_from_adjacency_matrix}},
\code{\link{as_adj_list}} and \code{\link{graph.adjlist}} for other
graph representations.
}
