% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bspline_closed.R
\name{geom_bspline_closed}
\alias{geom_bspline_closed}
\alias{stat_bspline_closed}
\alias{geom_bspline_closed0}
\title{Create closed b-spline shapes}
\usage{
stat_bspline_closed(
  mapping = NULL,
  data = NULL,
  geom = "shape",
  position = "identity",
  na.rm = FALSE,
  n = 100,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

geom_bspline_closed(
  mapping = NULL,
  data = NULL,
  stat = "bspline",
  position = "identity",
  n = 100,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

geom_bspline_closed0(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use to display the data, either as a
\code{ggproto} \code{Geom} subclass or as a string naming the geom stripped of the
\code{geom_} prefix (e.g. \code{"point"} rather than \code{"geom_point"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{n}{The number of points generated for each spline}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}
}
\description{
This geom creates closed b-spline curves and draws them as shapes. The
closed b-spline is achieved by wrapping the control points rather than the
knots. The *0 version uses the \code{\link[grid:grid.xspline]{grid::xsplineGrob()}} function with
\code{open = FALSE} and can thus not be manipulated as a shape geom in the same
way as the base version (expand, contract, etc).
}
\section{Aesthetics}{

geom_bspline_closed understand the following aesthetics (required aesthetics
are in bold):
\itemize{
\item \strong{x}
\item \strong{y}
\item color
\item fill
\item linewidth
\item linetype
\item alpha
}
}

\section{Computed variables}{


\describe{
\item{x, y}{The coordinates for the path describing the spline}
\item{index}{The progression along the interpolation mapped between 0 and 1}
}
}

\examples{
# Create 6 random control points
controls <- data.frame(
  x = runif(6),
  y = runif(6)
)

ggplot(controls, aes(x, y)) +
  geom_polygon(fill = NA, colour = 'grey') +
  geom_point(colour = 'red') +
  geom_bspline_closed(alpha = 0.5)

# The 0 version approximates the correct shape
ggplot(controls, aes(x, y)) +
  geom_polygon(fill = NA, colour = 'grey') +
  geom_point(colour = 'red') +
  geom_bspline_closed0(alpha = 0.5)

# But only the standard version supports geom_shape operations
# Be aware of self-intersections though
ggplot(controls, aes(x, y)) +
  geom_polygon(fill = NA, colour = 'grey') +
  geom_point(colour = 'red') +
  geom_bspline_closed(alpha = 0.5, expand = unit(2, 'cm'))
}
\author{
Thomas Lin Pedersen. The C++ code for De Boor's algorithm has been
adapted from
\href{https://chi3x10.wordpress.com/2009/10/18/de-boor-algorithm-in-c/}{Jason Yu-Tseh Chi implementation}
}
