% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htr.R
\name{htr}
\alias{htr}
\title{Haplotype trend regression}
\usage{
htr(y, x, n.sim = 0)
}
\arguments{
\item{y}{a vector of phenotype.}

\item{x}{a haplotype table.}

\item{n.sim}{the number of permutations.}
}
\value{
The returned value is a list containing:
\itemize{
\item f the F statistic for overall association.
\item p the p value for overall association.
\item fv the F statistics for individual haplotypes.
\item pi the p values for individual haplotypes.
}
}
\description{
Haplotype trend regression
}
\details{
Haplotype trend regression (with permutation)
}
\note{
adapted from emgi.cpp, a pseudorandom number seed will be added on.
}
\examples{
\dontrun{
# 26-10-03
# this is now part of demo
test2<-read.table("test2.dat")
y<-test2[,1]
x<-test2[,-1]
y<-as.matrix(y)
x<-as.matrix(x)
htr.test2<-htr(y,x)
htr.test2
htr.test2<-htr(y,x,n.sim=10)
htr.test2

# 13-11-2003
require(gap.datasets)
data(apoeapoc)
apoeapoc.gc<-gc.em(apoeapoc[,5:8])
y<-apoeapoc$y
for(i in 1:length(y)) if(y[i]==2) y[i]<-1
htr(y,apoeapoc.gc$htrtable)

# 20-8-2008
# part of the example from useR!2008 tutorial by Andrea Foulkes
# It may be used beyond the generalized linear model (GLM) framework
HaploEM <- haplo.em(Geno,locus.label=SNPnames)
HapMat <- HapDesign(HaploEM)
m1 <- lm(Trait~HapMat)
m2 <- lm(Trait~1)
anova(m2,m1)
}

}
\references{
\insertRef{zaykin02}{gap}

\insertRef{xie05}{gap}
}
\seealso{
\code{\link{hap.score}}
}
\author{
Dimitri Zaykin, Jing Hua Zhao
}
\keyword{regression}
