% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{vmap}
\alias{vmap}
\title{Vectorized map from element to case by index or string value}
\usage{
vmap(EXPR, ..., SIMPLIFY = TRUE)
}
\arguments{
\item{EXPR}{an expression evaluated to be character or numeric vector/list.}

\item{...}{The list of alternatives for each \code{switch}.}

\item{SIMPLIFY}{\code{TRUE} to simplify the resulted list to vector, matrix
or array if possible.}
}
\description{
This function is a vectorized version of \code{switch}, that is, for
each element of input vector, \code{switch} is evaluated and the results are
combined.
}
\examples{
x <- c("normal","normal","error","unknown","unknown")
vmap(x, normal = 0, error = -1, unknown = -2)

x <- c(1,1,2,1,2,2,1,1,2)
vmap(x, "type-A", "type-B")
}
\seealso{
\code{\link{switch}}
}
