% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{gglagplot}
\alias{gglagplot}
\alias{gglagchull}
\title{Time series lag ggplots}
\usage{
gglagplot(
  x,
  lags = if (frequency(x) > 9) 16 else 9,
  set.lags = 1:lags,
  diag = TRUE,
  diag.col = "gray",
  do.lines = TRUE,
  colour = TRUE,
  continuous = frequency(x) > 12,
  labels = FALSE,
  seasonal = TRUE,
  ...
)

gglagchull(
  x,
  lags = if (frequency(x) > 1) min(12, frequency(x)) else 4,
  set.lags = 1:lags,
  diag = TRUE,
  diag.col = "gray",
  ...
)
}
\arguments{
\item{x}{a time series object (type \code{ts}).}

\item{lags}{number of lag plots desired, see arg set.lags.}

\item{set.lags}{vector of positive integers specifying which lags to use.}

\item{diag}{logical indicating if the x=y diagonal should be drawn.}

\item{diag.col}{color to be used for the diagonal if(diag).}

\item{do.lines}{if \code{TRUE}, lines will be drawn, otherwise points will be
drawn.}

\item{colour}{logical indicating if lines should be coloured.}

\item{continuous}{Should the colour scheme for years be continuous or
discrete?}

\item{labels}{logical indicating if labels should be used.}

\item{seasonal}{Should the line colour be based on seasonal characteristics
(\code{TRUE}), or sequential (\code{FALSE}).}

\item{...}{Not used (for consistency with lag.plot)}
}
\value{
None.
}
\description{
Plots a lag plot using ggplot.
}
\details{
"gglagplot" will plot time series against lagged versions of
themselves. Helps visualising 'auto-dependence' even when auto-correlations
vanish.

"gglagchull" will layer convex hulls of the lags, layered on a single
plot. This helps visualise the change in 'auto-dependence' as lags increase.
}
\examples{

gglagplot(woolyrnq)
gglagplot(woolyrnq, seasonal = FALSE)

lungDeaths <- cbind(mdeaths, fdeaths)
gglagplot(lungDeaths, lags = 2)
gglagchull(lungDeaths, lags = 6)

gglagchull(woolyrnq)

}
\seealso{
\code{\link[stats:lag.plot]{stats::lag.plot()}}
}
\author{
Mitchell O'Hara-Wild
}
