% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable_sizes.R
\name{fit_to_width}
\alias{fit_to_width}
\title{fit a flextable to a maximum width}
\usage{
fit_to_width(x, max_width, inc = 1L, max_iter = 20, unit = "in")
}
\arguments{
\item{x}{flextable object}

\item{max_width}{maximum width to fit in inches}

\item{inc}{the font size decrease for each step}

\item{max_iter}{maximum iterations}

\item{unit}{unit for max_width, one of "in", "cm", "mm".}
}
\description{
decrease font size for each cell incrementally until
it fits a given max_width.
}
\section{Illustrations}{


\if{html}{\figure{fig_fit_to_width_1.png}{options: width="400"}}

\if{html}{\figure{fig_fit_to_width_2.png}{options: width="150"}}
}

\examples{
ft_1 <- qflextable(head(mtcars))
ft_1 <- width(ft_1, width = 1)
ft_1

ft_2 <- fit_to_width(ft_1, max_width = 4)
ft_2
}
\seealso{
Other flextable dimensions: 
\code{\link{autofit}()},
\code{\link{dim.flextable}()},
\code{\link{dim_pretty}()},
\code{\link{flextable_dim}()},
\code{\link{height}()},
\code{\link{hrule}()},
\code{\link{ncol_keys}()},
\code{\link{nrow_part}()},
\code{\link{set_table_properties}()},
\code{\link{width}()}
}
\concept{flextable dimensions}
