% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DHARMa.R
\docType{package}
\name{DHARMa-package}
\alias{DHARMa}
\alias{DHARMa-package}
\title{DHARMa: Residual Diagnostics for Hierarchical (Multi-Level / Mixed) Regression Models}
\description{
The 'DHARMa' package uses a simulation-based approach to create readily interpretable scaled (quantile) residuals for fitted (generalized) linear mixed models. Currently supported are linear and generalized linear (mixed) models from 'lme4' (classes 'lmerMod', 'glmerMod'), 'glmmTMB', 'GLMMadaptive', and 'spaMM'; phylogenetic linear models from 'phylolm' (classes 'phylolm' and 'phyloglm'); generalized additive models ('gam' from 'mgcv'); 'glm' (including 'negbin' from 'MASS', but excluding quasi-distributions) and 'lm' model classes. Moreover, externally created simulations, e.g. posterior predictive simulations from Bayesian software such as 'JAGS', 'STAN', or 'BUGS' can be processed as well. The resulting residuals are standardized to values between 0 and 1 and can be interpreted as intuitively as residuals from a linear regression. The package also provides a number of plot and test functions for typical model misspecification problems, such as over/underdispersion, zero-inflation, and residual spatial, phylogenetic and temporal autocorrelation.
}
\details{
To get started with the package, look at the vignette and start with \link{simulateResiduals}
}
\references{
vignette("DHARMa", package="DHARMa")
}
\seealso{
Useful links:
\itemize{
  \item \url{http://florianhartig.github.io/DHARMa/}
  \item Report bugs at \url{https://github.com/florianhartig/DHARMa/issues}
}

}
\author{
\strong{Maintainer}: Florian Hartig \email{florian.hartig@biologie.uni-regensburg.de} (\href{https://orcid.org/0000-0002-6255-9059}{ORCID})

Other contributors:
\itemize{
  \item Lukas Lohse [contributor]
  \item Melina de Souza leite [contributor]
}

}
\keyword{internal}
