% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-sql-list-objects.R
\docType{data}
\name{spec_sql_list_objects}
\alias{spec_sql_list_objects}
\title{spec_sql_list_objects}
\value{
\code{dbListObjects()}
returns a data frame
with columns
\code{table} and \code{is_prefix} (in that order),
optionally with other columns with a dot (\code{.}) prefix.
The \code{table} column is of type list.
Each object in this list is suitable for use as argument in \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}.
The \code{is_prefix} column is a logical.
This data frame contains one row for each object (schema, table
and view)
accessible from the prefix (if passed) or from the global namespace
(if prefix is omitted).
Tables added with \code{\link[=dbWriteTable]{dbWriteTable()}}
are part of the data frame,
including temporary objects if supported by the database.
As soon a table is removed from the database,
it is also removed from the data frame of database objects.

The returned names are suitable for quoting with \code{dbQuoteIdentifier()}.
An error is raised when calling this method for a closed
or invalid connection.
}
\description{
spec_sql_list_objects
}
\section{Specification}{

The \code{table} object can be quoted with \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}.
The result of quoting can be passed to \code{\link[=dbUnquoteIdentifier]{dbUnquoteIdentifier()}}.
The unquoted results are equal to the original \code{table} object.
(For backends it may be convenient to use the \link{Id} class, but this is
not required.)

The \code{prefix} column indicates if the \code{table} value refers to a table
or a prefix.
For a call with the default \code{prefix = NULL}, the \code{table}
values that have \code{is_prefix == FALSE} correspond to the tables
returned from \code{\link[=dbListTables]{dbListTables()}},

Values in \code{table} column that have \code{is_prefix == TRUE} can be
passed as the \code{prefix} argument to another call to \code{dbListObjects()}.
For the data frame returned from a \code{dbListObject()} call with the
\code{prefix} argument set, all \code{table} values where \code{is_prefix} is
\code{FALSE} can be used in a call to \code{\link[=dbExistsTable]{dbExistsTable()}} which returns
\code{TRUE}.
}

\keyword{internal}
