% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/week-year-week-day.R
\name{year-week-day-group}
\alias{year-week-day-group}
\alias{calendar_group.clock_year_week_day}
\title{Grouping: year-week-day}
\usage{
\method{calendar_group}{clock_year_week_day}(x, precision, ..., n = 1L)
}
\arguments{
\item{x}{\verb{[clock_year_week_day]}

A year-week-day vector.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
\item \code{"week"}
\item \code{"day"}
\item \code{"hour"}
\item \code{"minute"}
\item \code{"second"}
\item \code{"millisecond"}
\item \code{"microsecond"}
\item \code{"nanosecond"}
}}

\item{...}{These dots are for future extensions and must be empty.}

\item{n}{\verb{[positive integer(1)]}

A single positive integer specifying a multiple of \code{precision} to use.}
}
\value{
\code{x} grouped at the specified \code{precision}.
}
\description{
This is a year-week-day method for the \code{\link[=calendar_group]{calendar_group()}} generic.

Grouping for a year-week-day object can be done at any precision, as
long as \code{x} is at least as precise as \code{precision}.
}
\examples{
x <- year_week_day(2019, 1:52)

# Group by 3 weeks
calendar_group(x, "week", n = 3)

y <- year_week_day(2000:2020, 1, 1)

# Group by 2 years
calendar_group(y, "year", n = 2)
}
