% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso-year-week-day.R
\name{iso-year-week-day-boundary}
\alias{iso-year-week-day-boundary}
\alias{calendar_start.clock_iso_year_week_day}
\alias{calendar_end.clock_iso_year_week_day}
\title{Boundaries: iso-year-week-day}
\usage{
\method{calendar_start}{clock_iso_year_week_day}(x, precision)

\method{calendar_end}{clock_iso_year_week_day}(x, precision)
}
\arguments{
\item{x}{\verb{[clock_iso_year_week_day]}

A iso-year-week-day vector.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
\item \code{"week"}
\item \code{"day"}
\item \code{"hour"}
\item \code{"minute"}
\item \code{"second"}
\item \code{"millisecond"}
\item \code{"microsecond"}
\item \code{"nanosecond"}
}}
}
\value{
\code{x} at the same precision, but with some components altered to be
at the boundary value.
}
\description{
This is an iso-year-week-day method for the \code{\link[=calendar_start]{calendar_start()}} and
\code{\link[=calendar_end]{calendar_end()}} generics. They adjust components of a calendar to the
start or end of a specified \code{precision}.
}
\examples{
x <- iso_year_week_day(2019:2020, 5, 6, 10)
x

# Compute the last moment of the last iso week of the year
calendar_end(x, "year")

# Compare that to just setting the week to `"last"`,
# which doesn't affect the other components
set_week(x, "last")
}
