% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-month-day.R
\name{as_year_month_day}
\alias{as_year_month_day}
\title{Convert to year-month-day}
\usage{
as_year_month_day(x)
}
\arguments{
\item{x}{\verb{[vector]}

A vector to convert to year-month-day.}
}
\value{
A year-month-day vector.
}
\description{
\code{as_year_month_day()} converts a vector to the year-month-day calendar.
Time points, Dates, POSIXct, and other calendars can all be converted to
year-month-day.
}
\examples{
# From Date
as_year_month_day(as.Date("2019-01-01"))

# From POSIXct, which assumes that the naive time is what should be converted
as_year_month_day(as.POSIXct("2019-01-01 02:30:30", "America/New_York"))

# From other calendars
as_year_month_day(year_quarter_day(2019, quarter = 2, day = 50))
}
