% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bold_stats.R
\name{bold_stats}
\alias{bold_stats}
\title{Get BOLD stats}
\usage{
bold_stats(
  taxon = NULL,
  ids = NULL,
  bin = NULL,
  container = NULL,
  institutions = NULL,
  researchers = NULL,
  geo = NULL,
  dataType = "drill_down",
  response = FALSE,
  ...
)
}
\arguments{
\item{taxon}{(character) Returns all records containing matching taxa. Taxa
includes the ranks of  phylum, class, order, family, subfamily, genus,
and species.}

\item{ids}{(character) Returns all records containing matching IDs. IDs
include Sample IDs, Process IDs, Museum IDs and Field IDs.}

\item{bin}{(character) Returns all records contained in matching BINs. A
BIN is defined by a Barcode Index Number URI.}

\item{container}{(character) Returns all records contained in matching
projects or datasets. Containers include project codes and dataset codes}

\item{institutions}{(character) Returns all records stored in matching
institutions. Institutions are the Specimen Storing Site.}

\item{researchers}{(character) Returns all records containing matching
researcher names. Researchers include collectors and specimen identifiers.}

\item{geo}{(character) Returns all records collected in matching geographic
sites. Geographic sites includes countries and province/states.}

\item{dataType}{(character) one of "overview" or "drill_down" (default).
"drill_down": a detailed summary of information which provides record
counts by (BINs, Country, Storing Institution, Species). "overview":
the total counts of (BINs, Countries, Storing Institutions, Orders,
Families, Genus, Species)}

\item{response}{(logical) Note that response is the object that returns
from the Curl call, useful for debugging, and getting detailed info on
the API call.}

\item{...}{Further args passed on to
\code{\link[crul:verb-GET]{crul::verb-GET}}, main purpose being curl
debugging}
}
\description{
Get BOLD stats
}
\examples{
\dontrun{
x <- bold_stats(taxon='Osmia')
x$total_records
x$records_with_species_name
x$bins
x$countries
x$depositories
x$order
x$family
x$genus
x$species

# just get all counts
lapply(Filter(is.list, x), "[[", "count")

res <- bold_stats(taxon='Osmia', response=TRUE)
res$url
res$status_code
res$response_headers

# More than 1 can be given for all search parameters
bold_stats(taxon=c('Coelioxys','Osmia'))

## curl debugging
### These examples below take a long time, so you can set a timeout so that
### it stops by X sec
bold_stats(taxon='Osmia', verbose = TRUE)
# bold_stats(geo='Costa Rica', timeout_ms = 6)
}
}
\references{
http://v4.boldsystems.org/index.php/resources/api?type=webservices
}
