\name{predict.bma}
\alias{predict.bma}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Predict Method for bma Objects }
\description{
  Expected value of prediction based on 'bma' object
}
\usage{
 \method{predict}{bma}(object, newdata = NULL, exact = FALSE, topmodels = NULL, ...)}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{ a bma object - see \code{\link{bms}} }
  \item{newdata}{An optional data.frame, matrix or vector containing variables with which to predict. If omitted, then (the expected values of) the fitted values are returned.}
  \item{exact}{If \code{FALSE} (default), then prediction is based on all models (i.e. on their MCMC frequencies in case the \code{\link{bms}} parameter \code{mcmc} was set to an mcmc sampler.\cr
    If \code{TRUE}, then prediction is based on analytical likelihoods of the best models retained in \code{object} - cf. \code{\link{bms}} parameter \code{nmodel}.}
  \item{topmodels}{index of the models with whom to predict: for instance, \code{topmodels=1} predicts based solely on the best model, whereas \code{topmodels=1:5} predicts based on a combination of the five best models.\cr
Note that setting \code{topmodels} triggers \code{exact=TRUE}.  }
  \item{\dots}{further arguments passed to or from other methods.}
}
\value{
  A vector with (expected values of) fitted values.
}
%\references{ ~put references to the literature/web site here ~ }
\author{ Martin Feldkircher and Stefan Zeugner }
\seealso{ \code{\link{coef.bma}} for obtaining coefficients, \code{\link{bms}} for creating bma objects, \code{\link{predict.lm}} for a comparable function

Check \url{http://bms.zeugner.eu} for additional help.}
\examples{
 data(datafls)
 mm=bms(datafls,user.int=FALSE)
 
 predict(mm) #fitted values based on MCM frequencies
 predict(mm, exact=TRUE) #fitted values based on best models
 
 predict(mm, newdata=1:41) #prediction based on MCMC frequencies 
 
 predict(mm, newdata=datafls[1,], exact=TRUE) #prediction based on a data.frame
 
 # the following two are equivalent:
 predict(mm, topmodels=1:10)
 predict(mm[1:10], exact=TRUE)
 
 
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{utilities}
