% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post.column.switch.R
\name{post.column.switch}
\alias{post.column.switch}
\title{Perform column switchting on posterior MCMC sample}
\usage{
post.column.switch(mcmc)
}
\arguments{
\item{mcmc}{Object of class '\code{befa}'.}
}
\value{
Same '\code{befa}' object as the one passed to the function, where
the indicators in the matrix \code{dedic}, as well as the rows and columns of
the correlation matrix of the factors saved in \code{draws}, have been
switched appropriately to restore the identification of the factor model with
respect to column switching.
}
\description{
This function reorders the columns of the factor loading matrix for each MCMC
draw, as well as the rows and columns of the correlation matrix of the
factors, to restore the identification of the model \emph{a posteriori} with
respect to the column switching problem.
}
\details{
The reordering of the columns of the factor loading matrix is based
on the top elements of the columns (i.e., the first row containing a nonzero
factor loading in each nonzero column of \eqn{\alpha}, starting from the top
of the matrix). At each MCMC iteration, the nonzero columns of \eqn{\alpha}
are reordered such that the top elements appear in increasing order.
The rows and columns of the correlation matrix \eqn{R} of the factors are
switched accordingly. See section 4.3 of CFSHP (p.42) for more details.
}
\examples{
set.seed(6)
Y <- simul.dedic.facmod(N = 100, dedic = rep(1:3, each = 5))
mcmc <- befa(Y, Kmax = 5, iter = 1000)
mcmc <- post.column.switch(mcmc)

}
\references{
G. Conti, S. Frühwirth-Schnatter, J.J. Heckman,
R. Piatek (2014): ``Bayesian Exploratory Factor Analysis'',
\emph{Journal of Econometrics}, 183(1), pages 31-57,
\url{http://dx.doi.org/10.1016/j.jeconom.2014.06.008}.
}
\seealso{
\code{\link{post.sign.switch}} to restore identification a
posteriori with respect to the sign switching problem.
}
\author{
Rémi Piatek \email{remi.piatek@gmail.com}
}
