% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Core.R
\name{checkColumns}
\alias{checkColumns}
\title{Check data.frame for valid columns and issue message if invalid}
\usage{
checkColumns(data, columns, logic = c("all", "any"))
}
\arguments{
\item{data}{data.frame to check.}

\item{columns}{vector of column names to check.}

\item{logic}{one of \code{"all"} or \code{"any"} controlling whether all,
or at least one, of the columns must be valid, respectively.}
}
\value{
\code{TRUE} if columns are valid and a string message if not.
}
\description{
Check data.frame for valid columns and issue message if invalid
}
\examples{
df <- data.frame(A=1:3, B=4:6, C=rep(NA, 3))
checkColumns(df, c("A", "B"), logic="all")
checkColumns(df, c("A", "B"), logic="any")
checkColumns(df, c("A", "C"), logic="all")
checkColumns(df, c("A", "C"), logic="any")
checkColumns(df, c("A", "D"), logic="all")
checkColumns(df, c("A", "D"), logic="any")

}
