% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylation.R
\name{TCGAvisualize_starburst}
\alias{TCGAvisualize_starburst}
\title{Create starburst plot}
\usage{
TCGAvisualize_starburst(
  met,
  exp,
  group1 = NULL,
  group2 = NULL,
  exp.p.cut = 0.01,
  met.p.cut = 0.01,
  diffmean.cut = 0,
  logFC.cut = 0,
  met.platform,
  genome,
  names = FALSE,
  names.fill = TRUE,
  filename = "starburst.pdf",
  return.plot = FALSE,
  ylab = expression(atop("Gene Expression", paste(Log[10],
    " (FDR corrected P values)"))),
  xlab = expression(atop("DNA Methylation", paste(Log[10],
    " (FDR corrected P values)"))),
  title = "Starburst Plot",
  legend = "DNA Methylation/Expression Relation",
  color = NULL,
  label = c("Not Significant", "Up regulated & Hypo methylated",
    "Down regulated & Hypo methylated", "hypo methylated", "hyper methylated",
    "Up regulated", "Down regulated", "Up regulated & Hyper methylated",
    "Down regulated & Hyper methylated"),
  xlim = NULL,
  ylim = NULL,
  height = 10,
  width = 20,
  dpi = 600
)
}
\arguments{
\item{met}{A SummarizedExperiment with methylation data obtained from the
TCGAPrepare or Data frame from DMR_results file. Expected colData columns: diffmean,  p.value.adj  and p.value
Execute volcanoPlot function in order to obtain these values for the object.}

\item{exp}{Object obtained by DEArnaSEQ function}

\item{group1}{The name of the group 1
Obs: Column p.value.adj.group1.group2 should exist}

\item{group2}{The name of the group 2.
Obs: Column p.value.adj.group1.group2 should exist}

\item{exp.p.cut}{expression p value cut-off}

\item{met.p.cut}{methylation p value cut-off}

\item{diffmean.cut}{If set, the probes with diffmean higher
than methylation cut-off will be
 highlighted in the plot. And the data frame return will be subseted.}

\item{logFC.cut}{If set, the probes with expression fold
change higher than methylation cut-off will be
 highlighted in the plot. And the data frame return will be subseted.}

\item{met.platform}{DNA methylation platform ("27K","450K" or "EPIC")}

\item{genome}{Genome of reference ("hg38" or "hg19") used to identify nearest probes TSS}

\item{names}{Add the names of the significant genes? Default: FALSE}

\item{names.fill}{Names should be filled in a color box?  Default: TRUE}

\item{filename}{The filename of the file (it can be pdf, svg, png, etc)}

\item{return.plot}{If true only plot object will be returned (pdf will not be created)}

\item{ylab}{y axis text}

\item{xlab}{x axis text}

\item{title}{main title}

\item{legend}{legend title}

\item{color}{vector of colors to be used in graph}

\item{label}{vector of labels to be used in graph}

\item{xlim}{x limits to cut image}

\item{ylim}{y limits to cut image}

\item{height}{Figure height}

\item{width}{Figure width}

\item{dpi}{Figure dpi}
}
\value{
Save a starburst plot
}
\description{
Create Starburst plot for comparison of DNA methylation and gene expression.
   The log10 (FDR-corrected P value) is plotted for beta value for DNA
   methylation (x axis) and gene expression (y axis) for each gene.

   The black dashed line shows the FDR-adjusted P value of 0.01.

   You can set names to TRUE to get the names of the significant genes.

   Candidate biologically significant genes will be circled in the plot.

   Candidate biologically significant are the genes that respect the
   expression (logFC.cut), DNA methylation (diffmean.cut) and
   significance thresholds (exp.p.cut, met.p.cut)
}
\details{
Input: data with gene expression/methylation expression
   Output: starburst plot
}
\examples{
\dontrun{
library(SummarizedExperiment)
met <- TCGAbiolinks:::getMetPlatInfo(genome = "hg38", platform = "27K")
values(met) <- NULL
met$probeID <- names(met)
nrows <- length(met); ncols <- 20
counts <- matrix(runif(nrows * ncols, 1, 1e4), nrows)
colData <- S4Vectors::DataFrame(
  Treatment = rep(c("ChIP", "Input"), 5),
  row.names = LETTERS[1:20],
  group = rep(c("group1","group2"),c(10,10))
)
met <- SummarizedExperiment::SummarizedExperiment(
         assays = S4Vectors::SimpleList(counts=counts),
         rowRanges = met,
         colData = colData)
rowRanges(met)$diffmean.g1.g2 <- c(runif(nrows, -0.1, 0.1))
rowRanges(met)$diffmean.g2.g1 <- -1*(rowRanges(met)$diffmean.g1.g2)
rowRanges(met)$p.value.g1.g2 <- c(runif(nrows, 0, 1))
rowRanges(met)$p.value.adj.g1.g2 <- c(runif(nrows, 0, 1))
exp <- TCGAbiolinks:::get.GRCh.bioMart("hg38")
exp$logFC <- runif(nrow(exp), -5, 5)
exp$FDR <- runif(nrow(exp), 0.01, 1)

result <- TCGAvisualize_starburst(
  met,
  exp,
  exp.p.cut = 0.05,
  met.p.cut = 0.05,
  logFC.cut = 2,
  group1 = "g1",
  group2 = "g2",
  genome = "hg38",
  met.platform = "27K",
  diffmean.cut = 0.0,
  names  = TRUE
)
}
}
