% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setPermissions.R
\name{setPermissions}
\alias{setPermissions}
\title{Set project permissions}
\usage{
setPermissions(
  project,
  owners = NULL,
  uploaders = NULL,
  append = TRUE,
  url = restUrl(),
  token = accessToken()
)
}
\arguments{
\item{project}{String containing the project name.}

\item{owners}{Character vector containing the GitHub users or organizations that are owners of this project.
If \code{NULL}, no change is made to the existing owners of the project.}

\item{uploaders}{List specifying the authorized uploaders for this project.
See the \code{uploaders} field in the \code{\link{fetchPermissions}} return value for the expected format. 
If \code{NULL}, no change is made to the existing uploaders of the project.}

\item{append}{Logical scalar indicating whether \code{owners} and \code{uploaders} should be appended to the existing owners and uploaders, respectively, of the project.
If \code{FALSE}, the \code{owners} and \code{uploaders} are used to replace the existing values.}

\item{url}{String containing the URL of the gypsum REST API.}

\item{token}{String containing a GitHub access token to authenticate to the gypsum REST API.
The token must refer to an owner of the \code{project}.}
}
\value{
\code{NULL} is invisibly returned upon successful setting of the permissions.
}
\description{
Set the owner and uploader permissions for a project.
}
\examples{
if (interactive()) {
    # Creating a project for demonstration purposes.
    createProject("test-R-perms", owners="LTLA")

    # Setting extra permissions on this project.
    setPermissions("test-R-perms",
        owners="jkanche", 
        uploaders=list(list(id="lawremi", until=Sys.time() + 1000))
    )
}

}
\seealso{
\code{\link{fetchPermissions}}, to fetch the permissions.
}
\author{
Aaron Lun
}
