/////////////////////////////////////////////////////////////////////////////////////////////
// Copyright 2024 Garmin International, Inc.
// Licensed under the Flexible and Interoperable Data Transfer (FIT) Protocol License; you
// may not use this file except in compliance with the Flexible and Interoperable Data
// Transfer (FIT) Protocol License.
/////////////////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 21.158.0Release
// Tag = production/release/21.158.0-0-gc9428aa
/////////////////////////////////////////////////////////////////////////////////////////////


#if !defined(FIT_SPLIT_MESG_HPP)
#define FIT_SPLIT_MESG_HPP

#include "fit_mesg.hpp"

namespace fit
{

class SplitMesg : public Mesg
{
public:
    class FieldDefNum final
    {
    public:
       static const FIT_UINT8 MessageIndex = 254;
       static const FIT_UINT8 SplitType = 0;
       static const FIT_UINT8 TotalElapsedTime = 1;
       static const FIT_UINT8 TotalTimerTime = 2;
       static const FIT_UINT8 TotalDistance = 3;
       static const FIT_UINT8 AvgSpeed = 4;
       static const FIT_UINT8 StartTime = 9;
       static const FIT_UINT8 TotalAscent = 13;
       static const FIT_UINT8 TotalDescent = 14;
       static const FIT_UINT8 StartPositionLat = 21;
       static const FIT_UINT8 StartPositionLong = 22;
       static const FIT_UINT8 EndPositionLat = 23;
       static const FIT_UINT8 EndPositionLong = 24;
       static const FIT_UINT8 MaxSpeed = 25;
       static const FIT_UINT8 AvgVertSpeed = 26;
       static const FIT_UINT8 EndTime = 27;
       static const FIT_UINT8 TotalCalories = 28;
       static const FIT_UINT8 StartElevation = 74;
       static const FIT_UINT8 TotalMovingTime = 110;
       static const FIT_UINT8 Invalid = FIT_FIELD_NUM_INVALID;
    };

    SplitMesg(void) : Mesg(Profile::MESG_SPLIT)
    {
    }

    SplitMesg(const Mesg &mesg) : Mesg(mesg)
    {
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of message_index field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMessageIndexValid() const
    {
        const Field* field = GetField(254);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns message_index field
    ///////////////////////////////////////////////////////////////////////
    FIT_MESSAGE_INDEX GetMessageIndex(void) const
    {
        return GetFieldUINT16Value(254, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set message_index field
    ///////////////////////////////////////////////////////////////////////
    void SetMessageIndex(FIT_MESSAGE_INDEX messageIndex)
    {
        SetFieldUINT16Value(254, messageIndex, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of split_type field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSplitTypeValid() const
    {
        const Field* field = GetField(0);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns split_type field
    ///////////////////////////////////////////////////////////////////////
    FIT_SPLIT_TYPE GetSplitType(void) const
    {
        return GetFieldENUMValue(0, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set split_type field
    ///////////////////////////////////////////////////////////////////////
    void SetSplitType(FIT_SPLIT_TYPE splitType)
    {
        SetFieldENUMValue(0, splitType, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_elapsed_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalElapsedTimeValid() const
    {
        const Field* field = GetField(1);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_elapsed_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalElapsedTime(void) const
    {
        return GetFieldFLOAT32Value(1, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_elapsed_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTotalElapsedTime(FIT_FLOAT32 totalElapsedTime)
    {
        SetFieldFLOAT32Value(1, totalElapsedTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_timer_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalTimerTimeValid() const
    {
        const Field* field = GetField(2);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_timer_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalTimerTime(void) const
    {
        return GetFieldFLOAT32Value(2, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_timer_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTotalTimerTime(FIT_FLOAT32 totalTimerTime)
    {
        SetFieldFLOAT32Value(2, totalTimerTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_distance field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalDistanceValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_distance field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalDistance(void) const
    {
        return GetFieldFLOAT32Value(3, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_distance field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetTotalDistance(FIT_FLOAT32 totalDistance)
    {
        SetFieldFLOAT32Value(3, totalDistance, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgSpeedValid() const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgSpeed(void) const
    {
        return GetFieldFLOAT32Value(4, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetAvgSpeed(FIT_FLOAT32 avgSpeed)
    {
        SetFieldFLOAT32Value(4, avgSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of start_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStartTimeValid() const
    {
        const Field* field = GetField(9);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns start_time field
    ///////////////////////////////////////////////////////////////////////
    FIT_DATE_TIME GetStartTime(void) const
    {
        return GetFieldUINT32Value(9, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set start_time field
    ///////////////////////////////////////////////////////////////////////
    void SetStartTime(FIT_DATE_TIME startTime)
    {
        SetFieldUINT32Value(9, startTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_ascent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalAscentValid() const
    {
        const Field* field = GetField(13);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_ascent field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetTotalAscent(void) const
    {
        return GetFieldUINT16Value(13, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_ascent field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetTotalAscent(FIT_UINT16 totalAscent)
    {
        SetFieldUINT16Value(13, totalAscent, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_descent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalDescentValid() const
    {
        const Field* field = GetField(14);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_descent field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetTotalDescent(void) const
    {
        return GetFieldUINT16Value(14, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_descent field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetTotalDescent(FIT_UINT16 totalDescent)
    {
        SetFieldUINT16Value(14, totalDescent, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of start_position_lat field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStartPositionLatValid() const
    {
        const Field* field = GetField(21);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns start_position_lat field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetStartPositionLat(void) const
    {
        return GetFieldSINT32Value(21, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set start_position_lat field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    void SetStartPositionLat(FIT_SINT32 startPositionLat)
    {
        SetFieldSINT32Value(21, startPositionLat, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of start_position_long field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStartPositionLongValid() const
    {
        const Field* field = GetField(22);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns start_position_long field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetStartPositionLong(void) const
    {
        return GetFieldSINT32Value(22, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set start_position_long field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    void SetStartPositionLong(FIT_SINT32 startPositionLong)
    {
        SetFieldSINT32Value(22, startPositionLong, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of end_position_lat field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEndPositionLatValid() const
    {
        const Field* field = GetField(23);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns end_position_lat field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetEndPositionLat(void) const
    {
        return GetFieldSINT32Value(23, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set end_position_lat field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    void SetEndPositionLat(FIT_SINT32 endPositionLat)
    {
        SetFieldSINT32Value(23, endPositionLat, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of end_position_long field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEndPositionLongValid() const
    {
        const Field* field = GetField(24);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns end_position_long field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetEndPositionLong(void) const
    {
        return GetFieldSINT32Value(24, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set end_position_long field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    void SetEndPositionLong(FIT_SINT32 endPositionLong)
    {
        SetFieldSINT32Value(24, endPositionLong, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxSpeedValid() const
    {
        const Field* field = GetField(25);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxSpeed(void) const
    {
        return GetFieldFLOAT32Value(25, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetMaxSpeed(FIT_FLOAT32 maxSpeed)
    {
        SetFieldFLOAT32Value(25, maxSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_vert_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgVertSpeedValid() const
    {
        const Field* field = GetField(26);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_vert_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgVertSpeed(void) const
    {
        return GetFieldFLOAT32Value(26, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_vert_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetAvgVertSpeed(FIT_FLOAT32 avgVertSpeed)
    {
        SetFieldFLOAT32Value(26, avgVertSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of end_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEndTimeValid() const
    {
        const Field* field = GetField(27);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns end_time field
    ///////////////////////////////////////////////////////////////////////
    FIT_DATE_TIME GetEndTime(void) const
    {
        return GetFieldUINT32Value(27, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set end_time field
    ///////////////////////////////////////////////////////////////////////
    void SetEndTime(FIT_DATE_TIME endTime)
    {
        SetFieldUINT32Value(27, endTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_calories field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalCaloriesValid() const
    {
        const Field* field = GetField(28);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_calories field
    // Units: kcal
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetTotalCalories(void) const
    {
        return GetFieldUINT32Value(28, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_calories field
    // Units: kcal
    ///////////////////////////////////////////////////////////////////////
    void SetTotalCalories(FIT_UINT32 totalCalories)
    {
        SetFieldUINT32Value(28, totalCalories, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of start_elevation field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStartElevationValid() const
    {
        const Field* field = GetField(74);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns start_elevation field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetStartElevation(void) const
    {
        return GetFieldFLOAT32Value(74, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set start_elevation field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetStartElevation(FIT_FLOAT32 startElevation)
    {
        SetFieldFLOAT32Value(74, startElevation, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_moving_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalMovingTimeValid() const
    {
        const Field* field = GetField(110);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_moving_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalMovingTime(void) const
    {
        return GetFieldFLOAT32Value(110, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_moving_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTotalMovingTime(FIT_FLOAT32 totalMovingTime)
    {
        SetFieldFLOAT32Value(110, totalMovingTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

};

} // namespace fit

#endif // !defined(FIT_SPLIT_MESG_HPP)
