Minutes from 85th OpenVDB TSC meeting, April 06, 2021, (EDT)

Attendees: *Nick* A., *Jeff* L., *Ken* M., *Dan* B, *Andre* P.

Additional Attendees: JT Nelson (Blender), Bruce Cherniak (Intel),
Laura Lediaev (ImageWorks), Sergio Rojas, Robin Rowe (CinePaint), 
Johannes Meng (Intel)

Regrets: none

Agenda:

1) Confirm Quorum
2) Secretary
3) Forum
4) Instantiations Of Many VDB grids
5) Discussion On Cases Of Trying To Pack More Information Into Voxels
6) AX Update
7) Discussion On Grain Size
8) TBB
9) SIGGRAPH
10) NanoVDB
11) SOP Extrapolate (PR760)
12) Active Voxel Count (PR1010)
13) VDB 8.1
14) Next Meeting

1) Confirm Quorum

Quorum is present.

2) Secretary

Secretary is Andre Pradhana.

3) Forum

houdini_examples.hip opens with many errors and warnings in houdini 18.0.460. Andre will ask Jeff Budsberg who is the author of the file is he is willing to help to update the file.

Jeff Lait asks if we can add that file into the CI as a regression test. Ken asks if we can run a Houdini session in the CI. Jeff says we need a license and we can do it with Apprentice License. We do not have Houdini in the CI because Houdini itself is pretty big.

Build issue in Windows with Houdini 18.5. This has to do with OpenVDBHoudiniSetup.cmake. This is solved by Nick through PR 1023.

The Forum is no longer on the openvdb.org/forum because Google no longer supports embedded groups.

CSG Operations on a vector grid. A user wants to be able to perform a CSG operation on the first element of a Vec2d grid. Currently, there is no tool that supports this operation out-of-the-box. The user can leverage vector-split and vector-merge operations to accomplish this. Jeff mentions that if you activate the union of your topology, then you can visit all the active nodes and turn-off afterwards.

4) Instantiations Of Many VDB grids

Ken mentions that if there is a file with thousands of instantiations of VDB grids, there may be performance issues and memory leak. Ken will follow up.

5) Discussion On Cases Of Trying To Pack More Information Into Voxels

Dan mentions there are cases when a user wants to add more information to a voxel. Jeff mentions that this is related to the idea of having a Vector6 grid to store color, signed-distance-value, and uv attributes.

Ken mentions that if we have 64 bits blank-data in every leaf-node or every node of the tree. There are many times when you need to associate meta-data with a node. The way that we are currently doing it is by cannibalizing the origin. If we have 32-bit or 64-bit blind data, iit can be integer offset to another array that has more information, for example. It will increase the foot-print, but not by much. Jeff says that this will help with developing a fluid solver, e.g. by having a velocity grid and a signed-distance surface data.

Dan mentions that there is a tendency of people assuming that having multiple grids and value accessors is slow. He doesn't think that it's such a huge cost. This is related to the concept of Array of Structures (AoS) v.s. Structure of Arrays (SoA). There are use cases of both. To get a conclusive answer, we need to do actual experiments and timing.

If your leaf node has multiple data blocks, e.g. surface data block, velocity data block, and color data block, then you do the traversal only once but you still need to index into the data block at the end.

Dan mentions that if two or more grids share the same topology, it may be useful to have something in the ValueAccessor that shares the path through the tree, so you can avoid unnecessary lookup. Jeff mentions that sharing the same topology may not be the same as having the same active regions, e.g. a viscosity grid can be constant, so we can have constant tiles everywhere. 

Ken proposes the idea of supporting multiple channels, i.e. in every leaf node, you can have arbitrary buffers. Jeff brought up the concern that adding channels will assume that each one is equally-dense, e.g. an SDF channel that is dense in the exterior, but a color channel that is dense in the interior.

The best way to proceed is to do actual experiments and to do an objective performance measure.

Dan mentions that he wants to experiment with thread local storage of value accessors and assess the performance of that versus the Leaf Node approach. Nick has experimented with Dynamic Node Manager and Node Manager. The approach using Node Manager and Leaf Node is slow because it is calling the operator in batches of 1. If your operator is comparatively small, then a lot of the time is spent constructing and destructing accessors.

6) AX Update 

Nick implemented volume streaming in AX. Invoking volume kernel is twice as fast than previously. Picking the right grain size on the volume executor is really important for performance. Nick uses 32 as the grain size in non-leaf nodes in the Node Manager.

7) Discussion On Grain Size

Dan wonders if making the grain size argument in the Dynamic Manager will only affect the Leaf Node level. If you need to have a different grain size for the internal nodes, then you do the Leaf Manager approach, where  you do a Dynamic Node Manager except for the last level. The default grain size value is 1.

Ken says that there is grain size and policy for dividing. It does not always go to 1 grain size because it will try to do dynamic load balancing. When he is threading over leaf nodes, then it is useful to have a grain size that is greater than 1.

8) TBB

TBB will remove tbb::task in 2021. Nick says that there are works to be done to make OpenVDB to compile with TBB 2021. The hard one is related to tbb::task. It is used in io/Queue.

Dan mentions that we have not used Queue very much, so we may be able to fix the problem by using a typedef if it is not used that much. Ken mentions that this sounds like a collection of asynchronous tasks running, so an async in C++11 may fix the problem. Ken will take a look.

tbb::scheduler constructor has been removed. You can replace it with tbb::task_arena and tbb::global_control. Nick says we only get a few deprecation warnings from tbb::tbb_thread, tbb::task_scheduler_init, and tbb::task. One API and TBB 2021 are the same.

9) SIGGRAPH

SIGGRAPH should come at the end of the month.

10) NanoVDB

Ken finished a very big refactoring of the code. All that is missing at this point is the C99 that is broken. The primary version is C++11. There is a version of the C99 that Jeff Lait wrote. There is another C99 version written than Andrew Reidmeyer of NVIDIA. The latter will be rewritten.

The memory layout has been modified. Performance is better. There is a 20% improvement between the old version and the new version. Ken added compression. There is a run-time compression. It supports 4 bit, 8, bit, 16 bits, and variable bits. You can specify global tolerance. It currently only supports float grids, but Ken will add support for vector grids. When you convert from OpenVDB grid to NanoVDB grid, you can specify the bit-width and a tolerance. Jeff Lait suggests to test dithering.

If you have an old Nanovdb, it will not load it. There is no backward compatibility because the memory layout is different.

Once the C99 code is updated, Ken will start the review process. The viewer of Nanovdb will be included.

11) SOP Extrapolate (PR760)

Andre has addressed the comments made by Jeff and has fixed extrapolating an integer grid. He will merge the PR this week.

12) Active Voxel Count (PR1010)

Jeff has approved. Nick and Ken will take a look at it this week.

13) VDB 8.1

Nick says we need to find a time-line for the next 8.1 release.

14) Next Meeting

Next meeting is April 13th, 2021. 12pm-1pm EST (GMT-5).


