# FISH completions for OneDrive Linux Client
# License: GPLv3+ (as with the rest of the OneDrive Linux client project)

complete -c onedrive -f

complete -c onedrive -l check-for-nomount -d 'Check for the presence of .nosync in the syncdir root. If found, do not perform sync.'
complete -c onedrive -l check-for-nosync -d 'Check for the presence of .nosync in each directory. If found, skip directory from sync.'
complete -c onedrive -l create-directory -d 'Create a directory on OneDrive - no sync will be performed.'
complete -c onedrive -l debug-https -d 'Debug OneDrive HTTPS communication.'
complete -c onedrive -l disable-notifications -d 'Do not use desktop notifications in monitor mode.'
complete -c onedrive -l disable-upload-validation -d 'Disable upload validation when uploading to OneDrive.'
complete -c onedrive -l display-config -d 'Display what options the client will use as currently configured - no sync will be performed.'
complete -c onedrive -l display-sync-status -d 'Display the sync status of the client - no sync will be performed.'
complete -c onedrive -l download-only -d 'Only download remote changes.'
complete -c onedrive -l dry-run -d 'Perform a trial sync with no changes made.'
complete -c onedrive -l enable-logging -d 'Enable client activity to a separate log file.'
complete -c onedrive -l force-http-1.1 -d 'Force the use of HTTP 1.1 for all operations.'
complete -c onedrive -l force-http-2 -d 'Force the use of HTTP 2 for all operations.'
complete -c onedrive -l get-O365-drive-id -d 'Query and return the Office 365 Drive ID for a given Office 365 SharePoint Shared Library.'
complete -c onedrive -s h -l help -d 'Print help information.'
complete -c onedrive -l local-first -d 'Synchronize from the local directory source first, before downloading changes from OneDrive.'
complete -c onedrive -l logout -d 'Logout the current user.'
complete -c onedrive -n "not __fish_seen_subcommand_from --synchronize" -a "-m --monitor" -d 'Keep monitoring for local and remote changes.'
complete -c onedrive -l no-remote-delete -d 'Do not delete local file deletes from OneDrive when using --upload-only.'
complete -c onedrive -l operation-timeout -d 'Specify the maximum amount of time (in seconds) an operation is allowed to take.'
complete -c onedrive -l print-token -d 'Print the access token, useful for debugging.'
complete -c onedrive -l remote-directory -d 'Remove a directory on OneDrive - no sync will be performed.'
complete -c onedrive -l reauth -d 'Reauthenticate the client with OneDrive.'
complete -c onedrive -l resync -d 'Forget the last saved state, perform a full sync.'
complete -c onedrive -l single-directory -d 'Specify a single local directory within the OneDrive root to sync.'
complete -c onedrive -l skip-dot-files -d 'Skip dot files and folders from syncing.'
complete -c onedrive -l skip-symlinks -d 'Skip syncing of symlinks.'
complete -c onedrive -l source-directory -d 'Source directory to rename or move on OneDrive - no sync will be performed.'
complete -c onedrive -n "not __fish_seen_subcommand_from --monitor; and not __fish_seen_subcommand_from -m" -l synchronize -d 'Perform a synchronization.'
complete -c onedrive -l upload-only -d 'Only upload to OneDrive, do not sync changes from OneDrive locally'
complete -c onedrive -s v -l verbose -d 'Print more details, useful for debugging (repeat for extra debugging).'
complete -c onedrive -l version -d 'Print the version and exit.'
