/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/*
* This script compiles modules for evaluating polynomial functions. If any polynomial coefficients change, this script should be rerun to update the compiled files.
*/
'use strict';

// MODULES //

var resolve = require( 'path' ).resolve;
var writeFileSync = require( '@stdlib/fs/write-file' ).sync;
var licenseHeader = require( '@stdlib/_tools/licenses/header' );
var compile = require( './../../../../base/tools/evalrational-compile' );


// VARIABLES //

// Polynomial coefficients ordered in ascending degree...
var P1 = [
	1.0723538782003176831e+11,
	-8.3716255451260504098e+09,
	2.0422274357376619816e+08,
	-2.1287548474401797963e+06,
	1.0102532948020907590e+04,
	-1.8402381979244993524e+01
];

var Q1 = [
	5.8873865738997033405e+11,
	8.1617187777290363573e+09,
	5.5662956624278251596e+07,
	2.3889393209447253406e+05,
	6.6475986689240190091e+02,
	1.0
];

var P2 = [
	-2.2213976967566192242e+13,
	-5.5107435206722644429e+11,
	4.3600098638603061642e+10,
	-6.9590439394619619534e+08,
	4.6905288611678631510e+06,
	-1.4566865832663635920e+04,
	1.7427031242901594547e+01
];

var Q2 = [
	4.3386146580707264428e+14,
	5.4266824419412347550e+12,
	3.4015103849971240096e+10,
	1.3960202770986831075e+08,
	4.0669982352539552018e+05,
	8.3030857612070288823e+02,
	1.0
];

var P3 = [
	-8.0728726905150210443e+15,
	6.7016641869173237784e+14,
	-1.2829912364088687306e+11,
	-1.9363051266772083678e+11,
	2.1958827170518100757e+09,
	-1.0085539923498211426e+07,
	2.1363534169313901632e+04,
	-1.7439661319197499338e+01
];

var Q3 = [
	3.4563724628846457519e+17,
	3.9272425569640309819e+15,
	2.2598377924042897629e+13,
	8.6926121104209825246e+10,
	2.4727219475672302327e+08,
	5.3924739209768057030e+05,
	8.7903362168128450017e+02,
	1.0
];

var PC = [
	2.2779090197304684302e+04,
	4.1345386639580765797e+04,
	2.1170523380864944322e+04,
	3.4806486443249270347e+03,
	1.5376201909008354296e+02,
	8.8961548424210455236e-01
];

var QC = [
	2.2779090197304684318e+04,
	4.1370412495510416640e+04,
	2.1215350561880115730e+04,
	3.5028735138235608207e+03,
	1.5711159858080893649e+02,
	1.0
];

var PS = [
	-8.9226600200800094098e+01,
	-1.8591953644342993800e+02,
	-1.1183429920482737611e+02,
	-2.2300261666214198472e+01,
	-1.2441026745835638459e+00,
	-8.8033303048680751817e-03
];

var QS = [
	5.7105024128512061905e+03,
	1.1951131543434613647e+04,
	7.2642780169211018836e+03,
	1.4887231232283756582e+03,
	9.0593769594993125859e+01,
	1.0
];

// Header to add to output files:
var header = licenseHeader( 'Apache-2.0', 'js', {
	'year': ( new Date() ).getFullYear(),
	'copyright': 'The Stdlib Authors'
});
header += '\n/* This is a generated file. Do not edit directly. */\n';


// MAIN //

/**
* Main execution sequence.
*
* @private
*/
function main() {
	var fpath;
	var opts;
	var str;

	opts = {
		'encoding': 'utf8'
	};

	fpath = resolve( __dirname, '..', 'lib', 'rational_p1q1.js' );
	str = header + compile( P1, Q1 );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_p2q2.js' );
	str = header + compile( P2, Q2 );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_p3q3.js' );
	str = header + compile( P3, Q3 );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_pcqc.js' );
	str = header + compile( PC, QC );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_psqs.js' );
	str = header + compile( PS, QS );
	writeFileSync( fpath, str, opts );
}

main();
