if (typeof T === 'undefined') require('../setup');

T('modulo', function () {

  var t = function (a, b, expected, sd, rm) {
    T.assertEqual(expected, new Decimal(a).mod(b).valueOf());
  }

  Decimal.config({
    precision: 400,
    rounding: 4,
    toExpNeg: -7,
    toExpPos: 21,
    minE: -9e15,
    maxE: 9e15,
    modulo: 1
  });

  t(1, 0, 'NaN');
  t(1, -0, 'NaN');
  t(-1, 0, 'NaN');
  t(-1, -0, 'NaN');
  t(1, 'NaN', 'NaN');
  t(-1, 'NaN', 'NaN');
  t(1, 'Infinity', '1');
  t(1, '-Infinity', '1');
  t(-1, 'Infinity', '-1');
  t(-1, '-Infinity', '-1');
  t(0, 1, '0');
  t(0, -1, '0');
  t(-0, 1, '-0');
  t(-0, -1, '-0');
  t(0, 0, 'NaN');
  t(0, -0, 'NaN');
  t(-0, 0, 'NaN');
  t(-0, -0, 'NaN');
  t(0, NaN, 'NaN');
  t(-0, NaN, 'NaN');
  t(0, Infinity, '0');
  t(0, -Infinity, '0');
  t(-0, Infinity, '-0');
  t(-0, -Infinity, '-0');
  t('NaN', 1, 'NaN');
  t('NaN', -1, 'NaN');
  t('NaN', 0, 'NaN');
  t('NaN', -0, 'NaN');
  t('NaN', 'NaN', 'NaN');
  t('NaN', 'Infinity', 'NaN');
  t('NaN', '-Infinity', 'NaN');
  t('Infinity', 1, 'NaN');
  t('Infinity', -1, 'NaN');
  t('-Infinity', 1, 'NaN');
  t('-Infinity', -1, 'NaN');
  t('Infinity', 0, 'NaN');
  t('Infinity', -0, 'NaN');
  t('-Infinity', 0, 'NaN');
  t('-Infinity', -0, 'NaN');
  t('Infinity', 'NaN', 'NaN');
  t('-Infinity', 'NaN', 'NaN');
  t('Infinity', 'Infinity', 'NaN');
  t('Infinity', '-Infinity', 'NaN');
  t('-Infinity', 'Infinity', 'NaN');
  t('-Infinity', '-Infinity', 'NaN');

  t(1, '0', 'NaN');
  t(1, '1', '0');
  t(1, '-45', '1');
  t(1, '22', '1');
  t(1, 0144, '1');
  t(1, '0144', '1');
  t(1, '6.1915', '1');
  t(1, '-1.02', '1');
  t(1, '-1.02', '1');
  t(1, 2, '1');
  t(1, -2, '1');
  t(-1, 2, '-1');
  t(-1, -2, '-1');

  /*
   Due to the double precision binary floating point representation of 0.1 the next 4 results
   match BigDecimal's remainder method, but not Javascript's % operator.

   0.1.toFixed(18)                // '0.100000000000000006'
   new Decimal(1).mod('-0.100000000000000006')  // '0.099999999999999946'
   */
  t( 1, -0.1, '0');         // JS:   0.09999999999999995
  t(-1, -0.1, '0');         // JS:  -0.09999999999999995
  t( 2, -0.1, '0');         // JS:   0.0999999999999999
  t(-2, -0.1, '0');         // JS:  -0.0999999999999999

  t( 2, -0.5, '0');         // JS:   0
  t(-2, -0.5, '0');         // JS:   0
  t(999.99, -0.99, '0.09');
  t(-999.99, -0.99, '-0.09');
  t(999.99, '3.01', '0.67');
  t(-999.99, '3.01', '-0.67');

  t(1, '0.09', '0.01');
  t(1, '-0.0001', '0');
  t(-0, 1, '-0');
  t(-0, 0.1, '-0');
  t('-0', '-1', '-0');
  t('-0', Infinity, '-0');
  t(1, '1e-14', '0');

  t(1, '8e5', '1');
  t(1, '9E12', '1');
  t(1, '3.345E-9', '6.1e-10');
  t(1, '-345.43e+4', '1');
  t(1, '-94.12E+0', '1');
  t(1, Number.POSITIVE_INFINITY, '1');
  t(1, Number.NEGATIVE_INFINITY, '1');
  t('0', 0, 'NaN');
  t('0', '0', 'NaN');
  t(3, -0, 'NaN');
  t(9.654, 0, 'NaN');
  t(0, '0.001', '0');
  t(0, '111.1111111110000', '0');
  t('NaN', '0', 'NaN');
  t(-1, 1, '0');
  t(-0.01, 0.01, '0');
  t(54, -54, '0');
  t(9.99, '-9.99', '0');
  t('0.0000023432495704937', '-0.0000023432495704937', '0');
  t(NaN, NaN, 'NaN');
  t(NaN, 'NaN', 'NaN');
  t('NaN', NaN, 'NaN');
  t('NaN', 4, 'NaN');
  t('NaN', '4534534.45435435', 'NaN');
  t('NaN', 99999.999, 'NaN');
  t(Infinity, '354.345341', 'NaN');
  t(3, '-Infinity', '3');
  t(-Infinity, '-Infinity', 'NaN');
  t('-Infinity', -Infinity, 'NaN');
  t('Infinity', '-999e999', 'NaN');
  t('1.21123e43', '-Infinity', '1.21123e+43');
  t('-999.0', 'Infinity', '-999');
  t('657.342e-45', '-Infinity', '6.57342e-43');
  t('Infinity', 123, 'NaN');
  t(100, 100, '0');
  t('03.333', -4, '3.333');
  t(43534.5435, '0.054645', '0.019545');
  t('99999', '1', '0');

  t('-0.111', '21', '-0.111');
  t('0.000621', '-1', '0.000621');
  t('6.41', '11', '6.41');
  t('21', '11', '10');
  t('1531', '-11', '2');
  t('21', '-0.0161', '0.0056');
  t('-41', '-21', '-20');
  t('31', '-1', '0');
  t('31', '2.21', '0.06');
  t('-842658.56', '-19.52', '-19.2');
  t('-34.871', '-7325043345', '-34.871');
  t('78691958', '49006.018397', '37298.472815');
  t('-11618324684', '621.3', '-394.1');
  t('0', '69.07362125', '0');
  t('0.27474921216', '0.00000000002460017868', '2.224673016e-11');
  t('0', '59137483772', '0');
  t('-0.000000000000000000014634493', '-4.2', '-1.4634493e-20');
  t('-5.470', '-1.8989', '-1.6722');
  t('-95519.5319132', '4.1', '-1.8319132');
  t('43.257', '-4704608304', '43.257');
  t('-32128.403', '68263.11', '-32128.403');
  t('85.4005884', '-0.000000000000000010953667', '4.132633e-18');
  t('3197.909', '-10738864.39', '3197.909');
  t('1.03436722695', '2.6', '1.03436722695');
  t('-4', '-56.36464628', '-4');
  t('92.0618', '-454.866', '92.0618');
  t('-6.147123243', '-53259.9', '-6.147123243');
  t('-3', '-0.4911', '-0.0534');
  t('0', '-12.3', '0');
  t('-0.001713264153', '0.00000000000000000001843605', '-1.36779e-20');
  t('2', '-9325.1665961', '2');
  t('42016273.6500', '-122.861496017', '99.24210634');
  t('35.9', '3867744417', '35.9');
  t('0.000000000000000479760268839', '-209975.082', '4.79760268839e-16');
  t('0.0000000000000000000428713848', '3', '4.28713848e-20');
  t('0.000000000000000104698757876', '-15902.7654', '1.04698757876e-16');
  t('-4', '3124473.52104', '-4');
  t('-9.58', '1.00', '-0.58');
  t('79', '1', '0');
  t('0', '-0.0000000000013618', '0');
  t('1.55', '-31', '1.55');
  t('-2.6', '-13.58133', '-2.6');
  t('0', '90950', '0');
  t('-46.1', '61.8', '-46.1');
  t('-0.00000000000023461', '-0.00000000134', '-2.3461e-13');
  t('-9761.89778', '4645363921.75', '-9761.89778');
  t('0.000000000000000090372203', '0.00000322253', '9.0372203e-17');
  t('-23560577.226', '-0.5304109598', '-0.3270269352');
  t('-11752006.868', '0.003773', '-0.002016');
  t('0.000000036524', '-1.2', '3.6524e-8');
  t('4713.9562', '0.000000000000000000561', '2.23e-19');
  t('-351870798', '28.8', '-1.2');
  t('-4.6', '-0.00000000058', '-4.4e-10');
  t('-21863.82', '4214.9937962', '-788.851019');
  t('-30.221041721', '20401.1', '-30.221041721');
  t('-2.35', '3', '-2.35');
  t('64462', '90.840', '56.44');
  t('46', '433563.55477', '46');
  t('47852501568', '-147426331397', '47852501568');
  t('0', '3812504.1', '0');
  t('0.000000000000142963770', '1210345642.9', '1.4296377e-13');
  t('-0.0024002323743', '-0.000000000000000013220659', '-3.535752e-18');
  t('225.773', '66128.74787', '225.773');
  t('-158.4165', '12.78', '-5.0565');
  t('-21042099137', '10.935', '-4.565');
  t('32791.03', '411590460', '32791.03');
  t('-1984910.86246', '-153845.7', '-138762.46246');
  t('75010460639.6', '-0.00000000005103249', '2.835305e-11');
  t('-0.00000000000000025595509', '25.023', '-2.5595509e-16');
  t('-103052291', '-350.4', '-1.4');
  t('0.00000000000000015307870924', '-0.0000035499', '1.5307870924e-16');
  t('4402230', '122.112', '92.4');
  t('-3073677', '532.95653726', '-116.64962158');
  t('-0.026619162', '-0.00000000000000010', '0');
  t('0.000065666975666', '-6.558', '0.000065666975666');
  t('-3.3', '0.000000000033194405282', '-1.2721464422e-11');
  t('94101.0', '-810285.8180', '94101');
  t('229868', '9654.7078', '7809.7206');
  t('0.000000001926', '-0.00000000000000000005918', '2.562e-20');
  t('67', '0.00000006016496', '2.00248e-8');
  t('0.0000000000000000000832655', '-327907966408', '8.32655e-20');
  t('-1534', '-293318.339', '-1534');
  t('0.00000000000000000511522652', '-1145.46888006', '5.11522652e-18');
  t('0.00000000465574', '707.0', '4.65574e-9');
  t('0.230910067', '-1712.01', '0.230910067');
  t('-31874.7', '-2617976302', '-31874.7');
  t('22.8', '3819', '22.8');
  t('-0.0000015419', '329', '-0.0000015419');
  t('-9176.3441', '741523.991', '-9176.3441');
  t('-5.1103', '-25460.136', '-5.1103');
  t('15232730973', '-2.28', '1.32');
  t('0.081', '-1111.578', '0.081');
  t('3.1', '-42.207', '3.1');
  t('-0.000000000000000433', '0.00000000000000000254528412564', '-3.016986412e-19');
  t('-83943.1', '-4303134750', '-83943.1');
  t('19.825539', '4432543.44', '19.825539');
  t('-2416', '8097.16337', '-2416');
  t('-3.836', '0.00000823841385579', '-0.00000502522549283');
  t('2290356160', '-965232.20', '825381.6');
  t('1.12', '-35806.5278', '1.12');
  t('0', '-0.0000144726783', '0');
  t('-1571629111.33', '6.4736', '-3.8676');
  t('-0.0053778', '1.1', '-0.0053778');
  t('-0.0000013840', '-12.1', '-0.000001384');
  t('-22.9310218204', '-1.6843970', '-1.0338608204');
  t('-71.300', '-25.868806', '-19.562388');
  t('0.02847', '-63397392.02', '0.02847');
  t('-0.0000000000000331096', '0.00000183271', '-3.31096e-14');
  t('-27821115', '-34.83906', '-0.40734');
  t('0.000000000000436294954175', '-2261.01154', '4.36294954175e-13');
  t('45.86441', '-530611.936214', '45.86441');
  t('-1999679428', '0.00000000000000000002297558409', '-5.828173e-23');
  t('-105924.2800', '-426.10612', '-249.96224');
  t('754.9', '-1', '0.9');
  t('0.000000238266109662', '29355.83', '2.38266109662e-7');
  t('25.3', '-0.00000000000000086417416', '5.8408656e-16');
  t('-1261.3', '39.0', '-13.3');
  t('1.017', '-153', '1.017');
  t('27.690', '-21507592', '27.69');
  t('-2623.072516', '3.06', '-0.652516');
  t('91', '13034138.923', '91');
  t('-5212749.21', '-0.00000000000000000001986395', '-2.1827e-21');
  t('117.4212', '-29.978', '27.4872');
  t('-47179.732', '-77504621680', '-47179.732');
  t('0', '-3.7234', '0');
  t('443705716.830', '3024.9575', '1925.7725');
  t('-0.000000000000000000017191196518', '-14.725715414', '-1.7191196518e-20');
  t('30.4', '399719414108', '30.4');
  t('16145.97', '-48642', '16145.97');
  t('2765166', '-18.6825', '6.54');
  t('37.63', '-1284.342', '37.63');
  t('-0.0000000000000000000177845858', '0.0000005860954024', '-1.77845858e-20');
  t('-2.3', '2582.24565000', '-2.3');
  t('16.7', '-0.0000000017369', '1.362e-9');
  t('170180366706', '4626.181', '2388.659');
  t('-1404312.6', '-17000256053', '-1404312.6');
  t('-7603530366', '316.496322753', '-236.943012537');
  t('8', '1.59866', '0.0067');
  t('-4.963', '8.73', '-4.963');
  t('25644160.8', '-5842.06855', '3321.93405');
  t('-4.31384', '-220.2', '-4.31384');
  t('186.9', '-48200.85', '186.9');
  t('5', '57089.99', '5');
  t('-244278052979', '-2', '-1');
  t('8', '-5763.4', '8');
  t('29549', '-1', '0');
  t('-2.0', '-0.00000000000000446955628', '-3.76062704e-15');
  t('737330.9', '-746370915533', '737330.9');
  t('-0.000882183174', '-16.5', '-0.000882183174');
  t('-45', '0.000000001106035', '-7.5858e-10');
  t('-594.06', '-29.85802821', '-26.75746401');
  t('-27.648237', '-1047.5249', '-27.648237');
  t('2', '-739163.624', '2');
  t('544827.1330', '54848981.1', '544827.133');
  t('1', '0.00000000000076553', '2.9959e-13');
  t('-10.89', '0.000000000000000000047', '-5e-21');
  t('-3052.938', '9327.5819201', '-3052.938');
  t('-24.1', '127758.429', '-24.1');
  t('3.9', '12173.38', '3.9');
  t('0.0000000000000213926861909', '-77.4', '2.13926861909e-14');
  t('-90173804.260', '-5062619.06909', '-4109280.08547');
  t('637', '43943.2610', '637');
  t('14867.1', '894449', '14867.1');
  t('7.3', '-1.1', '0.7');
  t('2894844.4', '-1', '0.4');
  t('-0.00000000000196', '-2.6741', '-1.96e-12');
  t('0.00000000000000071433493', '5.9227', '7.1433493e-16');
  t('69', '-7204969', '69');
  t('-12468163', '-10022891.867', '-2445271.133');
  t('45469.1932906', '-3095367650', '45469.1932906');
  t('73072906.39', '-112013211', '73072906.39');
  t('1.4', '972.159255713', '1.4');
  t('66924.3855375', '19.93', '19.3755375');
  t('26.4256214076', '11.4775634275', '3.4704945526');
  t('23362.0174956', '-0.0000000001748', '1.536e-10');
  t('18276818006', '-5.74', '1.1');
  t('-8319.8', '3', '-0.8');
  t('-7.7413714358', '43763934316.0', '-7.7413714358');
  t('-688566579', '-1.83', '-0.3');
  t('29854', '-268509731.22', '29854');
  t('-194.15246', '-3.2255572', '-0.619028');
  t('2.0186177', '-326915', '2.0186177');
  t('-4', '1259', '-4');
  t('3.56', '-0.000000000000000000515993', '1.2338e-19');
  t('0.000001783', '-16426085', '0.000001783');
  t('-1766987819', '-87.259', '-49.72');
  t('-17.1', '0.00000000000000021840564', '-5.750892e-17');
  t('-8589.659', '0.000000000000000505', '-3.75e-16');
  t('-65891.7', '-38663.83', '-27227.87');
  t('-1.0', '0.00000000000000003836', '-1.78e-17');
  t('-33378.26', '-1226528.13', '-33378.26');
  t('2', '492342441', '2');
  t('1274', '-3092459411.0', '1274');
  t('0.2631770', '-493249535.4', '0.263177');
  t('-0.00000000000000000141', '4201192116', '-1.41e-18');
  t('-574.29154', '133427.3', '-574.29154');
  t('104617.3', '293188753.50', '104617.3');
  t('0', '38.96345', '0');
  t('-0.0000017289693288', '-5.4', '-0.0000017289693288');
  t('0', '4', '0');
  t('9.65', '1.2', '0.05');
  t('0.000000000017', '-50377365', '1.7e-11');
  t('137.3064', '0.0000001012', '7.04e-8');
  t('-9.89405', '29.2', '-9.89405');
  t('3.23', '-3048751.09', '3.23');
  t('87020568364', '-1', '0');
  t('-3658', '-0.4067222', '-0.3472554');
  t('0.0000000000483229749', '-508858', '4.83229749e-11');
  t('3', '-0.000000000000000006525172012', '6.0850742e-19');
  t('-52.63', '-373.710', '-52.63');
  t('-6.49915814', '352.2', '-6.49915814');
  t('0', '-44190.198', '0');
  t('0.00000000000000003763584929', '6', '3.763584929e-17');
  t('1.299983', '194.7', '1.299983');
  t('1', '9.52', '1');
  t('-86603.9', '446867516', '-86603.9');
  t('-1482885.420', '-0.0000000018878840', '-9.643e-10');
  t('-170.531717', '-633436587.6', '-170.531717');
  t('15.36378', '6540.267', '15.36378');
  t('-20570.61', '18.955913858', '-3.44346407');
  t('77', '0.000000000000027', '2.3e-14');
  t('0.000000001687849', '-0.0131699248663', '1.687849e-9');
  t('-0.000000000000026', '3291407.1', '-2.6e-14');
  t('-290.613', '0.00000000000000000008353794', '-6.386436e-20');
  t('200', '66.97', '66.06');
  t('2.2', '-43.41589', '2.2');
  t('98201.177964', '0.007000', '0.004964');
  t('35.453991547', '128.68861', '35.453991547');
  t('5.27', '1', '0.27');
  t('-1', '0.000119683476689', '-0.000044552263405');
  t('-34.0', '3', '-1');
  t('3378', '-44180', '3378');
  t('15', '-4', '3');
  t('0.0000004190944243', '37285824.4', '4.190944243e-7');
  t('-298.4', '506466', '-298.4');
  t('-0.00000010893', '-0.000426882829396', '-1.0893e-7');
  t('-1.9756065817', '941.5', '-1.9756065817');
  t('-1026297.2', '-205657.802', '-203665.992');
  t('2', '0.0000000005621541447', '3.513430991e-10');
  t('-7951901.67', '-0.0000000000055383', '-2.3814e-12');
  t('9', '0.000000000015125851830', '7.24233339e-12');
  t('72.245762', '-39.70217', '32.543592');
  t('6.62321', '-912632', '6.62321');
  t('617021', '-42.5970821', '2.2657815');
  t('1469815.28770', '537.217915', '524.290175');
  t('345897.6', '-0.00000000000108024', '9.7032e-13');
  t('0', '1.8688906295', '0');
  t('164', '-82114.2', '164');
  t('57.84537', '-1.4', '0.44537');
  t('114.340500', '6333334050', '114.3405');
  t('4.80', '-6077773.6', '4.8');
  t('162', '-37.75886044', '10.96455824');
  t('0.000000016367092', '1', '1.6367092e-8');
  t('148.2', '-46', '10.2');
  t('1.5768318844', '-7512089036.8', '1.5768318844');
  t('-0.0000000000000014460', '0.0011257005', '-1.446e-15');
  t('64.079', '-141', '64.079');
  t('-0.0582', '-13.35353476', '-0.0582');
  t('-1.0007', '63155.153933', '-1.0007');
  t('-623313173.6', '0.0000000081031', '-2.4548e-9');
  t('-36.9', '-1', '-0.9');
  t('2.0857', '0.000000000000000000205859744928', '1.887979864e-19');
  t('0.0000000494417', '492420240', '4.94417e-8');
  t('0.000000000000012194', '0.000000000000000013778591965', '1.372470294e-17');
  t('-16179.166', '16.4610327', '-14.4318886');
  t('3.24', '55986', '3.24');
  t('-61938', '47825328585', '-61938');
  t('4.36', '-1', '0.36');
  t('-9857364.3', '-1', '-0.3');
  t('9943.75', '3.5', '0.25');
  t('151.4907', '-1', '0.4907');
  t('0.000000000113985670', '-2286508', '1.1398567e-10');
  t('-1468', '-12915320.7', '-1468');
  t('46.543901', '0.00000014040913', '3.32077e-8');
  t('3', '190.34681', '3');
  t('-468.5022', '-0.00000000309208106131', '-1.13251725725e-9');
  t('-0.00000000000153707', '-112649.31435', '-1.53707e-12');
  t('-1.5', '0.000000067829063910', '-6.729086517e-8');
  t('42031.2', '-1.165644', '0.408648');
  t('-137623012.4', '-71.9609', '-21.9379');
  t('-278354', '8', '-2');
  t('5370.3', '71543859', '5370.3');
  t('-0.2469826911', '-0.0000000000008289323096', '-3.584481336e-13');
  t('338.68861185', '0.000000000000371927032', '2.00995384e-13');
  t('-0.00000000144', '115767.5757', '-1.44e-9');
  t('-3183918.6386', '-980.559', '-43.5656');
  t('-0.000000000004661097', '-0.051176618', '-4.661097e-12');
  t('-1', '948.171', '-1');
  t('1057394189', '62.751', '54.866');
  t('167.9', '0.00000000000009753', '8.45e-15');
  t('-12.172', '800.4476', '-12.172');
  t('-1.4', '-139187231194', '-1.4');
  t('359356.2', '-0.006806', '0.005734');
  t('4744567.6711', '-1.74', '0.0511');
  t('-0.0000000000234390', '-75.75283631', '-2.3439e-11');
  t('-6557078727.02', '-0.000000000000000015', '-5e-18');
  t('-1.33', '-5.111037', '-1.33');
  t('-431.277', '-1', '-0.277');
  t('0.0000000000000000000697336', '-8212.9015367', '6.97336e-20');
  t('3370.2674507', '445.572089', '251.2628277');
  t('-2.33567', '-0.0000000104784', '-8.888e-9');
  t('0.00000983659', '83423921', '0.00000983659');
  t('-51.2', '-0.0027394686', '-0.0020713346');
  t('0.000000000819617035421', '0.000000011', '8.19617035421e-10');
  t('0.00079279091535', '7', '0.00079279091535');
  t('-0.000000000095324834', '28091.00', '-9.5324834e-11');
  t('-0.00000000000000015', '23.52', '-1.5e-16');
  t('0.1438', '1035688.4', '0.1438');
  t('16693', '-1', '0');
  t('-781.09402123', '6.9', '-1.39402123');
  t('1', '20.70', '1');
  t('-3', '0.000006782445', '-0.00000249249');
  t('0.00000000000000000022', '-54710642.596', '2.2e-19');
  t('-590.69625205', '26.40', '-9.89625205');
  t('10', '-5.67', '4.33');
  t('-7', '-0.00000000000643634802', '-3.80362768e-12');
  t('-9680099.05', '-62.737684457', '-50.764391642');
  t('-1.5', '9914.9781', '-1.5');
  t('-1', '0.0000000507688288763', '-3.15199093625e-8');
  t('-0.000000000032713211391', '-0.000000046529', '-3.2713211391e-11');
  t('5.40', '1612427.39748', '5.4');
  t('0', '-0.0000000000000000000146', '0');
  t('-0.000000000000000000817527', '-52.0', '-8.17527e-19');
  t('1053329.8', '-120573.937', '88738.304');
  t('0.0000000000713', '-100743.840', '7.13e-11');
  t('8219', '-7505759130.86', '8219');
  t('16655.7', '243', '131.7');
  t('259.650', '278.73', '259.65');
  t('-284.091', '-1', '-0.091');
  t('0.1250', '-23713.35', '0.125');
  t('0.00000000490018764513', '-4.41', '4.90018764513e-9');
  t('-584.70403', '11076992', '-584.70403');
  t('-221.643', '-30.5', '-8.143');
  t('-9.69', '1177241', '-9.69');
  t('-4.97845868064', '-1.3178692059', '-1.02485106294');
  t('-1.04328912629', '-12.828540', '-1.04328912629');
  t('26', '-4.91596', '1.4202');
  t('94.686', '7.5851', '3.6648');
  t('0', '-0.000000000000000363', '0');
  t('-1.431', '65.06874', '-1.431');
  t('-878.898828', '-5.21', '-3.618828');
  t('-0.00000000000000014146660', '1.05112178985', '-1.414666e-16');
  t('0', '360.6112165', '0');
  t('4.464476', '0.00016302503', '0.00003555345');
  t('1145096', '-217.15', '64.05');
  t('29.46', '104.40', '29.46');
  t('841.82', '-2171922.59229', '841.82');
  t('46', '1', '0');
  t('22829.8889', '-1578709411', '22829.8889');
  t('-0.00374341104', '1.2', '-0.00374341104');
  t('410', '7', '4');
  t('0.076125848849', '1.103', '0.076125848849');
  t('0.000001844875808', '0.000000000000020813', '2.0037e-14');
  t('6.685', '0.003905472818', '0.002736008402');
  t('41011740.6', '908.670191', '728.869597');
  t('-152.527', '-1', '-0.527');
  t('12815.035', '-1497.81264', '832.53388');
  t('-0.000000000000004048729', '0.00000000126', '-4.048729e-15');
  t('-19949.700625', '-314.64', '-127.380625');
  t('-2.4', '569419658.2', '-2.4');
  t('0.00000000000000597954708', '4', '5.97954708e-15');
  t('-17.0', '1.58', '-1.2');
  t('22811600498', '2', '0');
  t('3.1328', '-119317.4', '3.1328');
  t('2.26039694', '1567.2', '2.26039694');
  t('-0.0004559', '-1.59', '-0.0004559');
  t('-0.000000000000165', '3', '-1.65e-13');
  t('-215.9051', '14846316.4792', '-215.9051');
  t('-1', '6004363.2', '-1');
  t('173513829480', '-117.2937046', '37.6296904');
  t('2269413223', '44.831', '39.204');
  t('-1411953.506', '0.000003338150524', '-0.000001742597716');
  t('-26.596', '-7', '-5.596');
  t('-0.00000000000010245141710', '6652789979', '-1.024514171e-13');
  t('2.042', '24673', '2.042');
  t('-2.71', '68.05392544', '-2.71');
  t('-3', '220821.80', '-3');
  t('116.073', '-0.0000000000024392780', '2.029598e-12');
  t('-0.00000006283674', '0.0000000000000079', '-5.7e-15');
  t('-3', '-7', '-3');
  t('-0.0000000000000005058', '-1.5', '-5.058e-16');
  t('-683', '1013123.5', '-683');
  t('-6', '16985130.432', '-6');

  t('2318237922853539360.167157597022570', '-9702015238687.680494235371626139504030926823802574', '9295675788919.833075194557918488338251940141560718');
  t('-3346995255.54414928936', '-19484973963827626752773520333240590885639375', '-3346995255.54414928936');
  t('-270721769', '22539228.03492196260802407744489638356810047', '-251032.58093644870371107066124339718279436');
  t('-0.00000000000000000308066481692295683548642301228852180070143433425056969292333', '206232915.762239501154732324', '-3.08066481692295683548642301228852180070143433425056969292333e-18');
  t('-0.00000000156454306292867840840689', '2635', '-1.56454306292867840840689e-9');
  t('12886035692416820.3977457533594029154555584175743', '-113496127978790341.941210015456704515', '12886035692416820.3977457533594029154555584175743');
  t('-299395547.883083669188105176893563510454667', '-3152.9580', '-115.077083669188105176893563510454667');
  t('8076327350.789696755252236317', '9', '5.789696755252236317');
  t('2241730616485747642201052100686334', '15115372376051.1433309224128', '15028644606255.6407694748928');
  t('0.000000020545442143', '910205431326260.56522101419792183224139104902865869227', '2.0545442143e-8');
  t('-299.2', '-1095069605114867345071265098807585478368438601713540771676', '-299.2');
  t('0', '-0.00000000000000000006258032721', '0');
  t('-9561792051.46130', '-0.00000037912322661422', '-3.0664875638608e-7');
  t('-4589.274150042', '5463826693798.059180748770', '-4589.274150042');
  t('-177372488891124.8209441829612234253673371', '-2184484411972.871928873110', '-429251521322.1947054610512234253673371');
  t('2840794355990579101690516447419567416103576933551526', '-225384346136689418.311568171615', '4159399848092788.810925291935');
  t('433169940324134426366793327.235', '-1918606541369710.9167801826', '369802826989779.100695574');
  t('0.00000231962990639112417450960779176176525188784519762202020426278', '11491626.8146875740651454657723913302260', '0.00000231962990639112417450960779176176525188784519762202020426278');
  t('-118317530966985340050567.3794340230', '-1290337888625470391870404816877827630953112876.297', '-1.18317530966985340050567379434023e+23');
  t('507941745866485347809651792.3258074064530387681549475622', '-78.8876', '48.5294074064530387681549475622');
  t('3280516686867.41769205935464611912132313550145186748', '-0.00000000000000125477', '5.0338132313550145186748e-16');
  t('39.99', '-196.666', '39.99');
  t('198328732837738155510399443.82996', '0.049415792708', '0.034407057628');
  t('23.9909397975464820637937485614', '0.0000000001050229258855441', '8.54924991032156614e-11');
  t('-1157214583831665284482', '1.0988344', '-0.0759048');
  t('19626.043251177620', '0.0000000034291719721621', '1.7452276531105e-9');
  t('11144329315299884830592174718286.015391668774749336449044', '-276730.619204816478', '84261.983174911066749336449044');
  t('71.3348063927327012696442274193666742024', '1.003', '0.1218063927327012696442274193666742024');
  t('2353.964728726069', '-1147885339335726766004631.4827280116227481840172642411087841', '2353.964728726069');
  t('-3.4', '99841150890712628939215423679763543630485717', '-3.4');
  t('-17423609848720294448155093008156493860946579332348817', '-407401303.1', '-39793145.5');
  t('268219889', '66408.228187594864', '63463.578491939168');
  t('-7067928231578399800943353710459167713.4021506', '-44099.172874028', '-34277.265446476');
  t('0.0000000000003143', '0.763206816948175243403280699590867', '3.143e-13');
  t('4.036744136250', '0.00971177', '0.00635958625');
  t('1793819.269108', '493646013195.8520', '1793819.269108');
  t('-15826468630.86978', '-0.000000000000000000372629410691473337097845426967193919000496413569810554360', '-3.3602620906243362074116532307435310028959396493592065148e-19');
  t('-18.7707479011363', '-0.00000000000002581603178761489486464393960475608950385662413624987', '-9.1067040799565470223405647782611453765936052898943e-15');
  t('238432236541400642177165.39210', '-5', '0.3921');
  t('-6811268416946324947973610791528879575619937612025', '0.0000000000000001069504654335424482337205845600046597647661', '-8.16882733210848477277494710610839496492589e-17');
  t('-0.0000000000000001763427790981229873712832162', '-0.00000000000000000002454861590426229238192323806393241482688272809526858064170', '-1.00710578069411919285971867734642985013640916857852506689e-20');
  t('19755770505453660565232908.50109071', '11636774869145974997.1', '6173329669666681241.40109071');
  t('-0.0000000000002209009508639970169662640887364083811', '0.000000000000000089645450775854240465099382429782771424049138745143690592', '-1.4560152292168460259210429423632311142922131965946381312e-17');
  t('563088', '-0.00000008456562014728262541201891984898', '2.11408406705846430113462806523e-8');
  t('0.000000000000014349029064561994176595511', '-185.73981699167343715247600', '1.4349029064561994176595511e-14');
  t('-0.00000000001083082172818863769543', '1190273509470734307.14840', '-1.083082172818863769543e-11');
  t('-0.0000007000816503264538441903792097551608671', '426939', '-7.000816503264538441903792097551608671e-7');
  t('-74639664.5738469080670677219615636886365697', '11681605088890876252615.81485333', '-74639664.5738469080670677219615636886365697');
  t('-17473762843659544328007830640965916', '4735599287262364762422146713625.0556784154158620151196', '-4.1370729486807194325314144030856023255308850262237956e+30');
  t('-35798372944152782907433662314743475258228956226653087.007402', '2986648933436031786673397525017144049.527376', '-2.586979851276128040119426347481949619034666e+36');
  t('594962882338997095.95600951831319665393181826', '-0.000040093460748026675395936734376802508692547860', '0.00000106629014969426833642467613848819248141182');
  t('-730572579439411951784822207340668557', '0.0000000000000028', '-4e-16');
  t('0.000000000000000001168651449131923286954932276275033439404771143330881475', '-47210255.27658777658181021168421281357', '1.168651449131923286954932276275033439404771143330881475e-18');
  t('-30769567698.202004635902421797597470637', '-2117030646075139493515312478944809325583483881105', '-30769567698.202004635902421797597470637');
  t('0.22203824107047587018951755693974277131200048220', '-136.52076', '0.2220382410704758701895175569397427713120004822');
  t('4489045408103326401151265241469016732232592556114681884438', '0.000000000000001314763381159004315842197', '6.8074495798791174068935e-16');
  t('-21348129287570112842795163717617654521736400718052510', '-1995504519697835638540568077.0196418', '-1.1402642626986948193867205135517104e+27');
  t('-14.48287435139371979106', '-278112747003022610742126629257947172194929.64536', '-14.48287435139371979106');
  t('0.0000000000000110719145581948062251355493585472867', '-7978399748.1558009430388367158631487853516499292946094', '1.10719145581948062251355493585472867e-14');
  t('119501784974', '-0.0031818401885065375156179', '0.0016290398380208417060804');
  t('-0.133707475845003705950317295850288779512882217932', '329652021145697865591302212038174941275757995054.713783674845', '-0.133707475845003705950317295850288779512882217932');
  t('-12542871568091185279.0460234294798148233', '25754.120417', '-21877.7952474294798148233');
  t('-3818054566.20841286030331762281612', '-1936.24778639274331686587963417792515204476546099', '-472.43293099041187629213445041741051174848665583');
  t('118000308055.9373727402663957624604063', '9918.67574327356', '4846.8753496034663957624604063');
  t('-11.38', '-24193758424792525116909481098205.677446', '-11.38');
  t('2.46889727437003280961289299604392122014099570', '-4644753841435365046988433379518839103541882981334804890807.8', '2.4688972743700328096128929960439212201409957');
  t('1805667164641860305883.31324', '0.00000000016618955069904640141657751519707415214669847044', '1.046133052518583849356487736801523519251586328e-11');
  t('-0.000000000000000000012169689776926610597997556555980427323944885949030949402', '-434910402113045297454505.1302573189763520', '-1.2169689776926610597997556555980427323944885949030949402e-20');
  t('-1739.4', '0.155584511367509963502532516739270411', '-0.120747422606118005188995371696075431');
  t('-569589695561180399227800563933576000706960457.3656765081522', '3483.46493456384339944984809629410413910476502', '-3467.25917700145185407850776398960809939327178');
  t('27827944878804.043096443231553973596298120', '327784539432851688676.574297', '27827944878804.04309644323155397359629812');
  t('-0.0000000000000000000273570270893076789122004877379023084477997941182649713787', '55071786762378989.632689594', '-2.73570270893076789122004877379023084477997941182649713787e-20');
  t('-1', '30698458.1545228514266', '-1');
  t('-77.6796737181065072239544734403386720988476876081692968190', '-48043379.33911367817680827247020826', '-77.679673718106507223954473440338672098847687608169296819');
  t('-0.00000000002231552048713565363805177481170756001463248', '-7745938658044151', '-2.231552048713565363805177481170756001463248e-11');
  t('4080930738001215900471542815678.870', '-259094.384407758455239', '219215.641754292988748');
  t('-65148376658415.8821831041618603950', '176.7', '-41.982183104161860395');
  t('-20649466814.805802613083057980846632715554163812995', '-0.0000000001319860149268122557211741866249364289650956', '-9.623959984992160004489809813728963916899e-11');
  t('-8637039792424460231', '1171511157428179825785002.9414399798460302750', '-8637039792424460231');
  t('170120714324740496497515610676549361259437493939036', '0.0000001984234593401508456286993357944778724317751259644793106', '1.80272091831781979821089649811533712715612789460516662e-8');
  t('3040385342.35657760274052', '-372946621956569451.93539995558371617994622295531744', '3040385342.35657760274052');
  t('234417346052636032.106833697570476435658983423056', '405728269025466785030711845788149565209977.743', '234417346052636032.106833697570476435658983423056');
  t('3003698058950457901967364.923201608', '-0.00000000000033926708389437080558726155721138587500872389823', '2.3077148260391721408496333950768060426097166773e-13');
  t('-1', '13121297327432473503324600878404', '-1');
  t('-0.00000000000086987493647337590015438704985', '1126309963348141179998313355117347492625867522.06445459173', '-8.6987493647337590015438704985e-13');
  t('0.01175883004658442799157', '-1304796615695885174911897002429657121243.096878772927435101', '0.01175883004658442799157');
  t('-4.1', '-925940.0049', '-4.1');
  t('94413979984015715031.72143', '-44956570520496128861135438942192313346223.4679844', '94413979984015715031.72143');
  t('-2084.96276512750756221737052806049261165250425', '1.5202660037865707', '-0.67807393611913251737052806049261165250425');
  t('5530042131715182582', '0.00000076755550127601384796182326285660346554068838', '4.3620483782819522891660511451578934939479584e-7');
  t('-67042.802', '-28411888994.212820705785482909844033014', '-67042.802');
  t('-5360742.0', '327368856548045.08220112714929243516', '-5360742');
  t('47117230722.16973123915245237545229011004357913004', '-47488231.617918014245187991287717374685823103416490829', '8904957.195061107925965018036654421707060540881097632');
  t('-0.000000000000151343572349948255798487186356', '42.39640064100021994629331666', '-1.51343572349948255798487186356e-13');
  t('113840373593648670861500086', '16082411799435623101958677220820405667', '1.13840373593648670861500086e+26');
  t('-8.22', '-2867798109411674.996765068247085164513407273890902397064937', '-8.22');
  t('-3.50238614', '-6860188389136636488339219859054193101069684390', '-3.50238614');
  t('107107360259917227679425620190.388983860971684', '8800479523270977282088607107997626691064406556317263323.341', '1.07107360259917227679425620190388983860971684e+29');
  t('-175822.1223383477', '-88621983013742415713.67926832', '-175822.1223383477');
  t('-0.0000000001165498478337125015371156469966957212161218123244751', '-62550285299530518719359714148367546793907', '-1.165498478337125015371156469966957212161218123244751e-10');
  t('0.0000000000000000320110187403311537074296810233047925148', '-60407506473103.897451724471', '3.20110187403311537074296810233047925148e-17');
  t('-0.000000000000000338282064563114', '-96190376454071434357.783403611375151575341982065544942431', '-3.38282064563114e-16');
  t('-0.000000000000446753711341', '-9.4', '-4.46753711341e-13');
  t('369078971611659797359596697169091.7394557', '4390355307871218680185944', '3.2920328769890124360129157394557e+24');
  t('0.00167752355829931578551694576878658836500507142636702529088528', '3276066309050', '0.00167752355829931578551694576878658836500507142636702529088528');
  t('-40341913269616270298908054352.555424105652', '-76.6805753', '-22.343535105652');
  t('0.000000000000000234899796181467417005659941', '-0.00000000000000002455754630676905247611', '1.3881879420545944720669941e-17');
  t('-2288200091016313974155687089998490026813781889257797', '173612435224249143072698340434416969557762958', '-4.06305517399251906560023908396396030698941e+41');
  t('-119.570203264189', '0.00000000000000000270873280446606560343105459296495864', '-3.0654086667132932857371380394960016e-19');
  t('9636003428434421863325355207384758', '27189148267469.7985900247652', '763104629651.47867591268');
  t('336.422676596', '45198935114500.3922307046', '336.422676596');
  t('-14.0627943158485824648781649958871436175344604029182482603314', '514937038588634.2538384203447', '-14.0627943158485824648781649958871436175344604029182482603314');
  t('0.00000023418399644897328432613203542773200097298268', '150.05994', '2.3418399644897328432613203542773200097298268e-7');
  t('-7549019185595.78985813486261693520665842030485693423', '0.00000107047', '-3.7760261693520665842030485693423e-7');
  t('2084', '-4702062390.892', '2084');
  t('-0.000000000000004338', '23.449915', '-4.338e-15');
  t('355378988141704324089218417352212802.4373051939435896809', '-410089.6820', '397574.1193051939435896809');
  t('-0.00000001989462540690061730462809985539649615779', '-38.286442069994941913718432', '-1.989462540690061730462809985539649615779e-8');
  t('18131048627056749262739468342.355859006591', '-1199.6142723004281428', '211.04880824112304');
  t('-7485271015053088795456302791998022618551521.6832', '0.0000000000000000000469320709938399196323702081094328803321', '-2.69710660151015687863998038860418026399e-20');
  t('0.000000000951589985684289940380019704065655070039753', '-26373114201649323963859575.5038618827163', '9.51589985684289940380019704065655070039753e-10');
  t('29612852829840055823.4234313598', '-0.000000000000000000390000839472495342007727670085919905954881', '1.00427280201824924510562417012541840544546e-19');

  t('-0.0000000000000001612847241392420250768267369', '17433478642639304.4236073577621811634134', '-1.612847241392420250768267369e-16');
  t('-1883174595828380403709352050091085026369077660279268.9', '-0.0012895', '-0.001097');
  t('-125549014214.7375819121786172926612698843039792917253281', '-101.5885766453', '-100.8153792133786172926612698843039792917253281');
  t('1065766474589037077293252213448', '104.84555', '81.7216');
  t('-0.0047533898584759553535897361825760775807323217889394835', '-18213101567414468503998329412491692494599546949.8', '-0.0047533898584759553535897361825760775807323217889394835');
  t('1270005291407.8881300436', '4138621074845956468.09769209', '1270005291407.8881300436');
  t('-260441856275307932803222450437995247080731478', '704992903069127.4325788', '-431855187882906.333326');
  t('-0.00000000000000000009754763692467059466885260432113614665268499743', '-1095452837.106034703346392429672156', '-9.754763692467059466885260432113614665268499743e-20');
  t('15.2', '-9898.141488362', '15.2');
  t('-4.642097816103323517795932640', '2320173035769155029864.2360071417144711754883993503027', '-4.64209781610332351779593264');
  t('27232043073441728507866158240.138995261078', '-215290045818292170941580969748443497', '2.7232043073441728507866158240138995261078e+28');
  t('-7820551181460133788154158506805766936661586187217825438.43', '9043807302.81268', '-8827979159.46068');
  t('40454701041551859098452066940764312196468.06490346453770', '1.43336157528769251880838', '0.053020665769834197966');
  t('0', '6893071800513.175', '0');
  t('-23294105221282442798534198559904763230604376248570', '1108006854160532581.643019501', '-634324850398077026.428796591');
  t('-70.48', '425148951767015.661297750583259821000170', '-70.48');
  t('-40097263.65021696329198038628255519578725029828361985869', '8008783649.929271', '-40097263.65021696329198038628255519578725029828361985869');
  t('-3744957147569480041094559658.8985734744', '-1.39589737574796529539305515486016767152', '-0.007414375129527604087594017204876948');
  t('1', '12243765348634238072286305372976115524601373993259986307', '1');
  t('1133226250873003731000285272922.678821486883559776563400259', '-48449121713.05851357863749277194726', '46399517902.028653911554106994622540259');
  t('-1110.00985672050392625354008504049692', '0.000000000000000144467905969585159040405525015114077352752345766119586', '-5.0667226393916955793430389451065661055080904169044368e-17');
  t('9977', '793339.568052455522323049704543732060826', '9977');
  t('3044797849984420605285366.474651143157', '25186260049851668345583291614301619318511974775753812002050.8326735955299366787084106211969141751506', '3.044797849984420605285366474651143157e+24');
  t('639737463904283952640443433078141655542321388667481890755297474427803997023609757112922145297681502347448794470168805201764741986941', '-14552442514714892538227035420.61249278214225741', '3.07716512012830819205367001585789874568359778e+27');
  t('0.0000009480666812553237528290117310639076036954221787358487462393246935364400792376', '1.0', '9.480666812553237528290117310639076036954221787358487462393246935364400792376e-7');
  t('16673429143256557896853574875292172327063389650998117777668136985538005.9156698099892691658894660539763873869793114863329930039146096813387028', '-107478408440617999633969729.9071529239187240331642550654002067338975836414285167506215860', '8.20260811545606661396908107304136068380872993912615354808000919495595106968750582594596813387028e+25');
  t('-2433298586307081.77465641473337660801763802817481653388429397435772288734383710955919905923279924807', '8945608818026652762135420517379.424606537007', '-2433298586307081.77465641473337660801763802817481653388429397435772288734383710955919905923279924807');
  t('-70843295832985633806095066724872543838444364150876355516508644344503020757888058408332911592444048015580157647', '159194370214483300881159411658565511338185028333524386712582766324718381977826309423371642975467856662959008464353958219661', '-7.0843295832985633806095066724872543838444364150876355516508644344503020757888058408332911592444048015580157647e+109');
  t('3.2263', '71756256022538928427069542438.00966178692388729446382444038774751007836179716329976575691385315023922435789196791754653262230986812059146', '3.2263');
  t('108061134.3910585273259047952072200021695505338334592792817809710438', '1260951025714501457005284501987116458944716243549637898428510181316826466436575714044748818353924236900363398289', '108061134.3910585273259047952072200021695505338334592792817809710438');
  t('43607983963968869595947769368216107706521387015680146006305613629433990860442947600228456010092', '121385730326389922895424600532542775257956396540395781939587936260842487516174244325430.384295616198856908112758', '1.1504925896106825966642741273863721105609952802207648727165046290817382897631508088378461034727326937297965944e+86');
  t('-2.6480956814', '2148671523057716670055099537649941488566244507589768590863804139800870729193528442.071130969310679730958621114', '-2.6480956814');
  t('-470479333263.84377245126007813562135983915023544360010239389244912214130585392185699431847364158901094167357758815083446794565320814454973581796', '27849448232164647723510637195798019946766053448137414448566670989993.67717797401551478004030639298176072944', '-470479333263.84377245126007813562135983915023544360010239389244912214130585392185699431847364158901094167357758815083446794565320814454973581796');
  t('0', '-6993020667326513594.01598727239030644128692238032346465300777782504759087255641592855556786881965341488969418534051814789', '0');
  t('-10372286284244779022048585', '-0.0000001930730138191035178741471788596965420386122185118633654121349245216394001018297980054707996074710125164147', '-8.47592995170001700266169749815180334434465081954780254569435821161404742961756995939834569063835498482552e-8');
  t('274897009856813.734380955979520483734957204601027214931003941720546146487845256149072527968056465339318846303131569226913408938616354923540700172412', '7', '1.734380955979520483734957204601027214931003941720546146487845256149072527968056465339318846303131569226913408938616354923540700172412');
  t('738408012842109785457164849764507323379297.79095792233769102310198027453532813226348191188862586945019214410536832', '15306177324248047715406533.5158700026', '1.506634005344982055089315836033881173769102310198027453532813226348191188862586945019214410536832e+25');
  t('0.000000001307002813605936443383593439823579112009200431906135937099617451361199016339230482184530115838223218189460633917243083200', '-156347131201.0667716470724866', '1.3070028136059364433835934398235791120092004319061359370996174513611990163392304821845301158382232181894606339172430832e-9');
  t('-4792567274869561212802263.9162146352653952716695372928501404982289832583166534206544945624150460220976057951121526613072397239125750526383369389', '-2571615359217819081745372380499521952091705406387642084116393860754896982150026573094709965566690085424189906211974018648786870967996877095142', '-4.7925672748695612128022639162146352653952716695372928501404982289832583166534206544945624150460220976057951121526613072397239125750526383369389e+24');
  t('-40.05748869168454725527441481953494139473673991070979113635160468475219376406826789262579745739976', '-41875468662578995790027634863433077814557063632577215827031.031982081918392876105825240291071725658144212578666', '-40.05748869168454725527441481953494139473673991070979113635160468475219376406826789262579745739976');
  t('-0.0000022907766811721016183225617138609000543876574860984718810338550238748128247445010491861049613', '-3279074504656188611648707.4983942082641992057679531912380705659521798322669577604617597486447068188912830230847051445600458515668443081070949175', '-0.0000022907766811721016183225617138609000543876574860984718810338550238748128247445010491861049613');
  t('-0.000000000340313277', '-0.000000001255112168870655023338247473949331250106676281883642901353991', '-3.40313277e-10');
  t('-50225365.1475566438998761801442412', '284028617245837000189928101232939099744527904229835535.835746075', '-50225365.1475566438998761801442412');
  t('63.344721423304857459331086841825237874925064097', '57155073593666.40553442288889921516416834083269742567707391607', '63.344721423304857459331086841825237874925064097');
  t('-405919933.1066287819696386581647229483641869199888974504501408794124002251348919063696581146156799005', '2647178729438306865645909642983752549443679075960964976334982663855617.77', '-405919933.1066287819696386581647229483641869199888974504501408794124002251348919063696581146156799005');
  t('-0.000000000000130754174234156809102364575558', '1512769765054847098913787446631276445464675564737758845532029029227218416561642292270741819169983956650914922547871552583245517440681359875', '-1.30754174234156809102364575558e-13');
  t('-42805325218726498366672740080295203192725414965527973209314316749.7120445518644682586008052614425260815242140724520046592053081', '0.000123298332335657505901061098051881119196170384724006568439947745355121025753230625359269654114501774394590171609541470588517', '-0.000032325304000891296915093212441483965264186154572168660357953720611674306961720593830907904561258705086770592138813164224068');
  t('-75210406056668422373802918016368260769067586508935441638493539318778550326.50528533489988415483952', '440622997.6355053630471029', '-340429684.42458949795004585483952');
  t('-1222922824327546500522220970819290434122898473371530650066004876062845284114.47721875136651190', '-1379027454245733767586', '-881180208974102493198.4772187513665119');
  t('-30656582150188875494703614722772772221409126232115063256882064964663663147033209144753246762464712.948730003091026599897432459556025696', '-2913934951186033025005819092772439514996587951119743767357433798109195725658300879072952407504422194931477368634077', '-3.0656582150188875494703614722772772221409126232115063256882064964663663147033209144753246762464712948730003091026599897432459556025696e+97');
  t('-6460522065030402275014019.2874194931729240210323452441436174892', '-84550416554285528170014238135907266547165974999578715609084038263.46129840157771271779704084743623515311185778729738812', '-6.4605220650304022750140192874194931729240210323452441436174892e+24');
  t('-0.016364386296444405533757351682555346465502820950062088651150128675773350177464733695707386307349689534592475248473689442', '-662351516465.9032743599806965674027961010966377214913163', '-0.016364386296444405533757351682555346465502820950062088651150128675773350177464733695707386307349689534592475248473689442');
  t('1103343525164099798605597537113983882179727144422100669678631936027042820706120285756898888893404677995338896062374110057717750895679', '91748792242920404655427917872546031638524.76204683127448751123961871264830271567888066463998429231705219642715054074868199195373673227635494751953719', '3.076328553647557636193208401331029365654020485144903415117912662361833098755573989373555529561896396760648323565651091850507799771898789127729144278e+40');
  t('-0.0894652716283348818337684886989151280762017763427032659791509101256464820297', '-12966.6884', '-0.0894652716283348818337684886989151280762017763427032659791509101256464820297');
  t('13114418006467273871814114136828793244459258873580991741468083458844936', '4759000553255960840361168620.3774494470837273198', '4.2761722071204063036259345611428685193209688534e+27');
  t('-28951495771059579052038784935583719855135835316878812739160571275658593082655402834569052032878823395641241968136.92574783376902191547024436698530', '-3031768663774740737176934765360849728180780437211886327623459816735182479695223019269147895285170079834032202516966937529989903070284157092473214668.7', '-2.89514957710595790520387849355837198551358353168788127391605712756585930826554028345690520328788233956412419681369257478337690219154702443669853e+112');
  t('2393723882767965821294763322394195744548891304060902', '-140981135960273230.0025778', '86668711566444988.9814302');
  t('-3224488416109581472101333552995382215707383396998952009319985210337309105631785072396803.91964338865842816515912815197781787', '102818159313377657005579111128189067224885718.140628085554012525428767372817189722551478405035418445112060974169840360487565259217', '-8.1595634025043932590241822413741540317627232887069206304733728507469999734166316619875329520357299837254473649437591096347440866e+43');
  t('0.000000000000000162614535957335504400161243268689702722565890737357214918357356590168738846464706769774484467251167640135858015634083627803179977581109102', '0.00000106803134832455205844954340150714254354766339175870844951355513521917239107042458407307482848507498559', '1.62614535957335504400161243268689702722565890737357214918357356590168738846464706769774484467251167640135858015634083627803179977581109102e-16');
  t('-3927.4031809', '-0.0000000035029583866611658486269733571456482523405154883369032001554318344330512146832289592781514675456658500756286236294841624823979375753461327906', '-2.6932691679676130460056959057199199083055272525449126446015947490329456323969370838199750438158748550553789684640297326857241719276712355958e-9');
  t('2592701578783037181466698143885146669128411307594485136303860886846006143235135122817836647040961317262173311873893155', '-2476735053659095937599211826013828027536167714634610749923083443278572078026871812469079060633677096037053974280521689349022693979242065', '2.592701578783037181466698143885146669128411307594485136303860886846006143235135122817836647040961317262173311873893155e+117');
  t('96.04335877730532081621787788158383111099350287030581038188446699532128180774027960706578', '19731419380883276630592147059117156462461951865864609673166.4479371059569659447212290002838890816175493435199181043231716596224989574671224595362826', '96.04335877730532081621787788158383111099350287030581038188446699532128180774027960706578');
  t('325023114939529014657978169628372760601480839073817238211782426113558723164836055970989007713696933704', '106223840476390782472173917090144170488887005908229635819404889799358852135763.040387492', '1.05150216674283695595324235267625323135707751092953285615150305395692443496735212656796e+77');
  t('-0.00000000000000033647992217979179179186957', '-0.00000000000000000003156150266634952697310752', '-2.74225383948473157029928e-21');
  t('67711097909563003399071203293654909244735459519561246144664768566612029202546308760389038038790661412078936611567061527752843866673871533', '0.0000000250914595238219383127319568059987481594970145735261435136883603429568', '1.1931039593784471503157310210681907892950978516052505236994695043296e-8');
  t('942307044555108835920493820461160734540503253601173239.92559776036964181595894387449189836528222244015903442453788542293705358104537', '-341315427404722210577937787468731.95', '4.792118403841194654638154768215812559776036964181595894387449189836528222244015903442453788542293705358104537e+31');
  t('-94130661760152187286400649382778774100247360104073487553172289492592909079685814047724040987.545360', '582.270609307311781203990506333968732999092917722', '-429.29359293653441023844377749905124203115916886');
  t('3313638785820621590180176562638.00992668522579291400041235393589181972606810182197653338554677836315505146', '90527335216395767852035210539.14', '5.465471803037394750690898322896992668522579291400041235393589181972606810182197653338554677836315505146e+28');
  t('-0.306955389372676043580907106603221153651127238512560719', '66.904579801977727781298', '-0.306955389372676043580907106603221153651127238512560719');
  t('141390900187450346.4446228025914244', '-255850256279441962530367023331027625163686895444551579538905939296353570502455036176395785785059148507467346341628419844281564795408561', '141390900187450346.4446228025914244');
  t('-31281694978574998092.32325767151', '-1542462855.73276869937293894166028800355184049470473', '-519767223.60416992161136296357867627633975428783569');
  t('0.00000000465065764192519767209223768411174160970559048882576195807880851927339930867660413363177803', '695983282190820825900286910552083743912340874031142607911981006600892487992712378.27501435873441215408642204715421306049', '4.65065764192519767209223768411174160970559048882576195807880851927339930867660413363177803e-9');
  t('0.000002299699', '105', '0.000002299699');
  t('-751157538.56375056723760379542086174039490718435868835658852', '-0.000000281235130627575144572363209737439923', '-2.4952865744315606513538295859410866335658852e-7');
  t('-1492151820229229.7080972636031810741838557504286290118227845200639080208767965213313891261997405771908981', '518534900915966328248424169467.8926376495890764066267652', '-1492151820229229.7080972636031810741838557504286290118227845200639080208767965213313891261997405771908981');
  t('477573736732380117689005270695410306243996300502014352674644518059825662478485969426161545468188704450446835856', '-44107433160804154887771872206618010747863690779283512394813143542934429409262133052168377457307.7801829320544', '4.26587795612760356325706643922768450442822164299827765862986444105362242670998534111196655345782505509351168e+94');
  t('-1708419546267714621908304198526.86627770247445328880', '-6561936.23828726436959004970934079513865615878124751998092886724055429258975571944079950471550813589210381712752008129366876', '-3255473.411304257056507423459569857877329230063250469248244750150261213529383645499126139366386431281819493395691345793149');
  t('0.0000000000000004527321152996104608068898547927166509996670208320178171898523653701667544358478578289218730097763063669131852', '0.000000000000011707656496202100248575019665652640050450842478555351860415163190039866', '4.527321152996104608068898547927166509996670208320178171898523653701667544358478578289218730097763063669131852e-16');

  t('-4.785068183e+1', '4.100602340813778290214569907944153985840287e+41', '-47.85068183');
  t('2.80464647349124269012895506839600253935327310965e+18', '-9.5524432014496391100798143628e+26', '2804646473491242690.12895506839600253935327310965');
  t('-2.8475390576301982648821864330615e+1', '2.699279786373606e-17', '-2.6651296488681e-17');
  t('-2.9148775309735883444412038961e+12', '-3.7791910283459953859509024618806015827414491747e-14', '-1.2484519780688810034904273898769796515468689534e-14');
  t('4.75952e+1', '-9.2480596298788483952588449013e+15', '47.5952');
  t('-1.059098439e-6', '-2.61519835738114698145e+4', '-0.000001059098439');
  t('2.0737545782540501468649951383811505929864648e-11', '8.001141125055718003273562341771790690597363615833e+48', '2.0737545782540501468649951383811505929864648e-11');
  t('-1.22658750490728083398e+13', '1.8753238083480045539938865768259755398e+8', '-132148191.84975394758545561202438438412');
  t('3.0610455075185277682819215983121128590345078192561e+45', '-7.2132877592078603887799551646099823518259e+16', '61373855855082630.483565489609741494295639');
  t('9.0188012787220251521914339e+21', '7.34972521506799782052e+20', '199131020640427767567.4339');
  t('2.732276e+6', '-2.155e+2', '167');
  t('1.81970803337505025123814446711e+19', '1.552273391587321102352777093263e+8', '121079294.0355602541613892510099');
  t('5.29521849750516603814171596807e-3', '-1.186023062792866863315593132074754530817309278318e-16', '9.65458477943067357182194529851732179008303939488e-17');
  t('4.17590665394570316906941267960925070278431e-5', '9.049524633791428612160450019368774628e+0', '0.0000417590665394570316906941267960925070278431');
  t('-3.349078310428002e+5', '-1.6540638667696404135343644190345e+18', '-334907.8310428002');
  t('3.1992755000743044238501551275241732747e+28', '6.7694639443884902632801069e+19', '58012283694485729642.404216747');
  t('7.824216663065598374539197703051941e+7', '2.8264285749437427237554422632944775049521496e+41', '78242166.63065598374539197703051941');
  t('-1.67058990412026696591650976e+2', '4.22502522584451063700771426002353559984275436807335e+7', '-167.058990412026696591650976');
  t('-2.45635416234991644154081e+10', '1.6511720053714564535061012818217797956053950352564e+3', '-169.9750792296892367202705840388216243464507038608');
  t('-1.234302917437106938892e+6', '-4.66222869142052358935242282170391162075612576838441480514e-11', '-1.16831454856809476137891894092632703280451615639647891166e-11');
  t('1.839710778457895734645309275939324e+23', '-1.16318585777868797619955e+17', '90437897170854441.0401789324');
  t('4.31278525467628823588407602838382746643207760247774704277223e+9', '2.23171038985847514593e+20', '4312785254.67628823588407602838382746643207760247774704277223');
  t('3.0774747e+7', '-1.292178569466e+6', '1054639.902282');
  t('7.1986256721501851444121681387782246892728127232221676165644e+45', '-1.13782811077947907584409056830168328555517006340535538318684e+28', '2.4664369028970742315721904655905118416446174179007597618692e+27');
  t('-5e+0', '1.8187074446258529890089548133661805568989582581e+46', '-5');
  t('2.90713213183891582843410750914399986513758162e-3', '-2.63153627e+1', '0.00290713213183891582843410750914399986513758162');
  t('-1.1994289233986543701822561078984450080807572663172692845e+26', '1.3308098373134e+12', '-1101301973800.58984450080807572663172692845');
  t('3.80222940163e+10', '-1.86439621006147e+8', '175050952.052159');
  t('-1.0589771547255325020757865564001533466983148718e+46', '-4.66653476326811630302573645173380627372e+30', '-1.34743461530630312563356791528734704544e+30');
  t('0e+0', '-5.8555382904168e+10', '0');
  t('-3.877410561846137535676828506580217538851e+39', '1.8546585782329946703671500695022434e+25', '-8.304732800863368666145000987852196e+24');
  t('-1.163627582049e+10', '-1.190310616961783801595291761751e+7', '-6941092.77337225841399948769273');
  t('5.50922178592853292e+8', '2.7726691028626755345614e+1', '9.067016077612284334026');
  t('4.585813032273175774206281699078636679246584e+2', '-1e+0', '0.5813032273175774206281699078636679246584');
  t('2.143209743784799995437859351e+27', '7.89686033593298254046863395059167e-18', '6.81868949928986360863748711628261e-18');
  t('-2.2928677299898057914670255997347455786e+11', '1.43685706448112139571439918598028632e+6', '-306934.405632425577309870670368346');
  t('4.354911010988471845818170482045217459828e-19', '-3.4255381103210061953947764102346444839325208e+5', '4.354911010988471845818170482045217459828e-19');
  t('7.6205756951722652979726396821744395258e-11', '-2.469701682300246385132843673488255945931294e+23', '7.6205756951722652979726396821744395258e-11');
  t('-3.0414336636936289483194714509757754918625515721268383983891e+22', '4.536514951e+9', '-2390201439.714509757754918625515721268383983891');
  t('6.1950756263395220720928988581672084e+12', '5.50299097228515217025542686233486e+6', '994424.9277391452982364908047321');
  t('1.5592703628193685590607028031257876838163995140476313e+52', '4.644158636847e+12', '1438695302628');
  t('-8.321953e-20', '3.425924048971005175376011737e-6', '-8.321953e-20');
  t('2.50545873839057298343115607524742030919655663396773e-12', '-3.81e-9', '2.50545873839057298343115607524742030919655663396773e-12');
  t('-6.626563801610720283429069e+24', '-7.318668911456127669428074219e+27', '-6.626563801610720283429069e+24');
  t('6.579221387782276980734304828884120337616419799251099653496e-1', '-3.8969000319182257446208467342247396396093882352e-15', '1.9767722676183043776377919004479568382127247136e-15');
  t('3.1401513e+2', '1.237032386460703e+15', '314.01513');
  t('4.232794809535764324617667621124324483982653495945584e+6', '7.3809184815598732203484798105535965548268885342e+0', '0.4405677713499586621163276690389136391131296364');
  t('-2.54046333929067768396256156730192176704492639570003e+1', '-1.43509613727037812846035760529266475517733244287446e+5', '-25.4046333929067768396256156730192176704492639570003');
  t('-1.7784812894976825e+5', '1.348176239051319766183648668812555533668836074076e+47', '-177848.12894976825');
  t('-1.34525103103779e+8', '-2.1e+0', '-1.903779');
  t('-7.5e+0', '1.1485396369968399088809663888589e-8', '-2.897466364518558819119797833239e-9');
  t('1.02502826667e+1', '9.3481096028282686300763053917132870455928e-15', '7.7634911550320902212280587730161073680336e-15');
  t('9.56858647594739448303715711e+11', '-4.2315e+2', '168.239448303715711');
  t('-1.121662781899762e+3', '-1.153e+3', '-1121.662781899762');
  t('-1.1987521321e+0', '3.3717546189279471902193720771211135e-6', '-0.0000023276964037193028773035373618806855');
  t('-3.96409663517864928212668914312890035732488673186557035e+16', '-3.503768915124379422490579250903005526551657e+9', '-1073469883.0404370184683678233259100444904567035');
  t('-9.780642443954005196506214589e+15', '-9.0202154557465647565999764323022181914347547218716e+44', '-9780642443954005.196506214589');
  t('6.22723611860453496632948443539098691396413e-10', '-2.77824094902753769648885834726391520861911e+5', '6.22723611860453496632948443539098691396413e-10');
  t('-4.7319718694e+5', '6.8346446241247783161447574947601984306026821486383635e+33', '-473197.18694');
  t('-6.1933379823501920314298624358203814e+30', '-8.089868231074264910103113854481018685411838271163628e+0', '-8.004699925089141256941499632457605509538837084388632');
  t('1.5e-3', '7.82546748299781600669e+20', '0.0015');
  t('-6.7242596508788e-7', '1.3806352e+7', '-6.7242596508788e-7');
  t('1.9762609860647814575863656621674468865989380864741e+45', '6.51277646556899014436272323991705259786529655e-5', '0.000014790203177222374955576884258500785345510175');
  t('7.004000748022736e-8', '4.736649441368895442161035451e+22', '7.004000748022736e-8');
  t('-4.29285701374473103585848390846585847338e-20', '-1.39970996245e+6', '-4.29285701374473103585848390846585847338e-20');
  t('1.44068396723397585225000633824556784092935879966094079042e+14', '-1.85739402953385383572444765551721122270675395703645487708e-6', '2.2082902769721875195705810453565730977529281295245227248e-7');
  t('-1.90763083929612502667113570129e-17', '-2.989745679222607307608195e+24', '-1.90763083929612502667113570129e-17');
  t('-1.8008915784029129140878223332849e+15', '1.2709184544773109938594286324169565032629e-8', '-8.198978038773931537165401098330611286589e-9');
  t('2.5283393571163e+11', '1.42605397244976960657e+16', '252833935711.63');
  t('-1.07482517991266460493961480563252855043997503069929863e+53', '4.0293147259356676513464190395e+2', '-327.97566262501963085789832435');
  t('-1.791459937048480305498333255301e-17', '-3.60140444532360031210882850839206992361061e+32', '-1.791459937048480305498333255301e-17');
  t('-3.7973618905e+4', '2.076660739009108092554128277835978289058948608e+27', '-37973.618905');
  t('4.296835337235213305241997742797979761241859185e+32', '1.016128323816741556885745789299051e+30', '8.773810728563935184150511955984541241859185e+29');
  t('-3.3476803669790089330287396786213536648e-19', '-1.0485228843496121655433179024642877076320529176e-16', '-3.3476803669790089330287396786213536648e-19');
  t('-9.265001828356e-19', '5.82146621596502038608123809e+5', '-9.265001828356e-19');
  t('1.6574237778185417162412521417931606051387220789593e+6', '4.3416420707553748006564234818e+29', '1657423.7778185417162412521417931606051387220789593');
  t('-9.774062277712948833378e-13', '3.080037033054419810654271948e-15', '-1.034488293043803360395792484e-15');
  t('1.0480042083686042910696085478682293620068215e+43', '-9.1636346772043682784439956904897547881091051932e+20', '711021412902451879505.0635467550321309923369716');
  t('-3.40923816647136940940085344632137226188233200061358e+20', '1.6073165168980479523827835495337e+31', '-340923816647136940940.085344632137226188233200061358');
  t('-8.7800373379e+9', '1.589967630656932636460925283862063976207125245919e-11', '-2.20858757786189096197325170019616955392212367465e-12');
  t('-1.508492483290420652523454481016576379245159230227181384539e+43', '9.65407339051e-1', '-0.95207917271339');
  t('1.70797882e-17', '-1.221287649130143636399302725332474299568133811751e+13', '1.70797882e-17');
  t('2.25e+0', '7.2018713275608502122703864334941124435400603003965e+49', '2.25');
  t('3.66e+3', '-2.00125759501079698887197092755e+20', '3660');
  t('1.074410572430091406447031457374002693e+8', '1.14072231468921335177378921904e+16', '107441057.2430091406447031457374002693');
  t('-3.8968391781145045605e+7', '3.823518283e-1', '-0.379345773205');
  t('3.8807293359084454309373e-14', '-6.54951383e-4', '3.8807293359084454309373e-14');
  t('8.3790348726489133341557987289125627922491641304972332e+10', '1.88761931097750519978e+9', '735099043.478904551237987289125627922491641304972332');

  /*
    modulo mode.

    Tests cases taken from:

    Division and Modulus for Computer Scientists, DAAN LEIJEN
    http://research.microsoft.com/en-us/um/people/daan/download/papers/divmodnote-letter.pdf

    On the Definition of Integer Division and Modulus in Programming Languages, BOYKO B. BANTCHEV
    http://www.math.bas.bg/bantchev/articles/divmod.pdf

    MSDN Math.IEEERemainder Method
    http://msdn.microsoft.com/en-us/library/system.math.ieeeremainder.aspx
  */

  // Truncated division (ROUND_DOWN)
  Decimal.modulo = 1;

  t( 8, 3, '2');
  t( 8, -3, '2');
  t( -8, 3, '-2');
  t( -8, -3, '-2');
  t( 1, 2, '1');
  t( 1, -2, '1');
  t( -1, 2, '-1');
  t( -1, -2, '-1');
  t( 34, 5, '4');
  t( 34, -5, '4');
  t( -34, 5, '-4');
  t( -34, -5, '-4');

  // Floored division (ROUND_FLOOR).
  Decimal.modulo = 3;

  t( 8, 3, '2');
  t( 8, -3, '-1');
  t( -8, 3, '1');
  t( -8, -3, '-2');
  t( 1, 2, '1');
  t( 1, -2, '-1');
  t( -1, 2, '1');
  t( -1, -2, '-1');
  t( 34, 5, '4');
  t( 34, -5, '-1');
  t( -34, 5, '1');
  t( -34, -5, '-4');

  // Euclidean division (ROUND_EUCLID).
  Decimal.modulo = 9;

  t( 8, 3, '2');
  t( 8, -3, '2');
  t( -8, 3, '1');
  t( -8, -3, '1');
  t( 1, 2, '1');
  t( 1, -2, '1');
  t( -1, 2, '1');
  t( -1, -2, '1');
  t( 34, 5, '4');
  t( 34, -5, '4');
  t( -34, 5, '1');
  t( -34, -5, '1');

  // IEEE 754 Remainder division (ROUND_HALF_EVEN).
  Decimal.modulo = 6;

  t( 3, 2, '-1');
  t( 4, 2, '0');
  t( 10, 3, '1');
  t( 11, 3, '-1');
  t( 27, 4, '-1');
  t( 28, 5, '-2');
  t( 17.8, 4, '1.8');
  t( 17.8, 4.1, '1.4');
  t( -16.3, 4.1, '0.1');
  t( 17.8, -4.1, '1.4');
  t( -17.8, -4.1, '-1.4');

  t = function (a, b, expected, sd, rm) {
    Decimal.precision = sd;
    Decimal.rounding = rm;
    T.assertEqual(expected, new Decimal(a).mod(b).valueOf());
  }

  Decimal.toExpNeg = Decimal.toExpPos = 0;
  Decimal.modulo = 1;

  t('-8.943550875826899174004147098160947209117401e+112', '8795986955015178649130170399228023.855728306', '-8.254602310669191899712579731892356266536504e+33', 57, 3);
  t('-2.736538371967866031325075682600169801042080643176906e+67', '-798.10121', '-5.1093943e+2', 15, 6);
  t('8.89244411964474967575e+995', '-1.22396282949406136970691396606e+143', '2.1076810292497291230174828448e+142', 37, 5);
  t('-4.133853260833105676637834626304395288e+331', '-4151623665.00637323381006132759572375', '-1.953e+9', 4, 0);
  t('-4.98716329433101e+63', '5.2324163e+989', '-4.98716329433101e+63', 42, 3);
  t('-1.21401788871257659e+26', '7606.68304751112951636636391962372647031362684321', '-3.8282851383973410080190582059122127821019964721e+3', 47, 4);
  t('5.098420853880029521477e+9004', '7.160182680398e+769', '6.109129834846e+769', 93, 4);
  t('38972.7', '8.884699481786844829e+413', '3.89727e+4', 31, 3);
  t('6114.6135258543884127880811426762677209603105075061581615', '3.0606472374614422625444168825327291936017622710500e+275', '6.1146135258543884127880811426762677209603105075061581615e+3', 98, 4);
  t('9.44899733642716929280554042413664887e+67', '3365420322.33466499588376037066560633919203780807168', '3.14018804773158888457522038228739693507536858699776e+9', 54, 4);
  t('4.649378943629298120865999754037420765850004956622433023174e+987', '-8.06433839e+21', '7.10669696e+21', 44, 4);
  t('-6.99689242488633036641737497911e+337', '-8.62087725552e+511', '-6.99689242488633036641737497911e+337', 39, 6);
  t('2.68888209327808354367202351104495e+405', '-8819404.2382061121909378683556', '1.1144088192608904221647532924e+6', 34, 0);
  t('95.999733394918432190664281885062439232831974613845764432', '260016173581199901254971273211250760375409527201652153.674', '9.5999733394918432190664281885062439232831974613845764432e+1', 79, 2);
  t('-65183.1712462898879902640839124139318475', '6.256224403276153e+18', '-6.518317124628988799026408391241393185e+4', 37, 3);
  t('6.73109e+5632', '6.2e+5', '5.4e+5', 62, 4);
  t('5.02028141167363618090367152620443275143849821e+65', '-5.1423741815608532540616250447301058274773391073e+397', '5.020281411673636180903672e+65', 25, 0);
  t('-5.92043551e+148', '-4.28952447049490303828404027555378e+6513', '-5.92043551e+148', 52, 3);
  t('-7.776298593803313194202564e+91', '-8.65584352736057897977696414850809690748461947332009869e+121', '-7.776298593803313194202564e+91', 58, 5);
  t('6.0468446816579233067128095e+47', '-9.25703241665044447133e+232', '6.0468446816579233067128095e+47', 61, 6);
  t('-2.8596931954822549177171791e+65', '-2842388394.3157048684464', '-2.23925487e+9', 9, 5);
  t('6.049098770167682103e+61', '6.62504441855149114634843111447292655983275898565177681129e+549', '6.049098770167682103e+61', 77, 5);
  t('-3.1766317506888756886345e+6581', '-1.02395581038358273020004954944197227e+8632', '-3e+6581', 1, 5);
  t('-6.494537598665515278622730e+407', '-3.693271952093896608738805402952058e+593', '-6.49453759866551527862273e+407', 55, 4);
  t('-54570662.9152087959960116', '3628345183.695935530586261340756849', '-5.4570662915209e+7', 14, 5);
  t('4.0937805605767803276628345776693834523568082109865317580e+7653', '4129.795194087170', '9.9197199795059e+2', 78, 0);
  t('19716777.12985866079587414603535351339087353731317', '4.15268790332934991803928616e+612', '1.971677713e+7', 10, 5);
  t('-653510.8843942609262130842269762944441504401', '-2.027688666442884256244726305622087828395505875189979280284e+936', '-6.535108843943e+5', 13, 3);
  t('-5.1464720662639698186031461962218221108584708551990576e+426', '-3.753738703787238056897308105489740e+5947', '-5.1464720662639698186031461962218221108584708551990576e+426', 77, 0);
  t('-185083.95424764097664278043736816641562291', '6.88483981698920539e+549', '-1.8508395424764097664278043736816641562291e+5', 52, 3);
  t('-8.4526212586667859362683394505144580845548023e+92', '8.56475540823390109934430835325058371670270846338329e+93', '-8.4526212586667859362683394505144580845548023e+92', 90, 5);
  t('-945636271.5759891', '-2.17432808397e+594', '-9.456362715759891e+8', 89, 0);
  t('3.548871234875504632967049284731417963316430094e+938', '8.58647841598924619155917147408449004293104046547183e+8404', '3.548871234875504632967049284731417963316430094e+938', 56, 6);
  t('-1.1430431170771599354075836985722188465803720293752e+2890', '8.77e+542', '-5.33e+542', 27, 3);
  t('-9.04312894420050284873550010294637483269334834464174461210e+871', '-4.224918240e+77', '-1.03574112e+77', 25, 6);
  t('1.3894699e+3042', '-2.31875507700977838117805540505980140857029476462714e+91', '1.9357052749968517239204685249164188278642182342502e+91', 61, 0);
  t('79.235', '4.4827898048205433701866299445e+255', '7.9235e+1', 75, 0);
  t('4.476999920584999735690940e+2947', '431.4007436129918618300842573436992667279830088', '2.177092162465684682859259261336151290563486416e+2', 73, 0);
  t('1.951106229235660612010096898495653211543461145647637e+61', '-3.3477064e+141', '1.951106229235660612010096898495653211543461145647637e+61', 89, 6);
  t('-9.916630e+84', '-66.064342', '-1.3177302e+1', 37, 4);
  t('-860.1444052695', '825080074792355962132959107719531393891221', '-8.601444052695e+2', 32, 3);
  t('6.1352951126363381185748747422972468541675591991781e+9278', '4.1560786995244e+1527', '2.651534168388e+1527', 34, 6);
  t('4.944978e+764', '5323614045.2252161212631613035133757836906706', '5.1535379640553098968737518932745870816240816e+9', 97, 1);
  t('9.09144e+6306', '3.50201226950969565080636878120146612e+55', '2.69469845381791678871664408741658344e+55', 96, 5);
  t('32172841276723723017320184344985646175887112.47790381', '5.58951e+9', '2.42307711247790381e+9', 20, 1);
  t('7.00620e+9706', '-8.08968082636983139609501341360433350633079179648541620232683e+9707', '7.0062e+9706', 42, 1);
  t('4.264042494837184947927734754557762536643709070327e+540', '9.95e+15', '3.95e+15', 45, 4);
  t('5.6105940856889306e+8254', '-7e+2', '6e+2', 93, 4);
  t('2526.4723101095362366485683598497883', '8.77812650378806065221188793462677511675764948870478079267e+94', '2.526472310109536236648569e+3', 25, 2);
  t('-4659.75203988732274192476946401', '6.060e+79', '-4.65975203988732274192476946401e+3', 72, 5);
  t('9.139217102709553745990883488575994294713541e+500', '-418253.135835407934425294007034135260164397764', '3.58109993522251265587238475937111423227918172e+5', 95, 0);
  t('-8.1086318916990298755700481699299539037472013444974422e+5755', '-1.5661587555799104561758191e+87', '-1.0074281153436182858841239e+87', 99, 5);
  t('-416737.42745', '-77173894789158506974126571178514075283378413478233.00755', '-4.1673742745e+5', 16, 6);
  t('8.333306239514058871243415468295297607303726047354266e+684', '3.502702752540721094141e+59', '1.367728644750058669789e+59', 61, 4);
  t('-6.25787639e+479', '9.9197660713292e+55', '-4.5153786834196e+55', 60, 0);
  t('3.72001563869117563677e+76', '-66669138.417849525425581002528394724049111419621217', '6.2279859967071260303160475364250607980294928950909e+7', 55, 2);
  t('-1.5482390020990842932e+1127', '-1.527299849113353346489254e+726', '-1.057674615874692739663148e+726', 63, 5);
  t('-1.81968692707021067164405981e+1010', '-8.0e+4383', '-1.819e+1010', 4, 1);
  t('-3053673848.9365372689017115785293', '-7.0224310e+2372', '-3.053673848936537268901711579e+9', 28, 3);
  t('54183.632867779042905454844274458562747', '-83662541.555738139789607530938580336298367634', '5.41836328678e+4', 12, 5);
  t('-4.22473209309078364216473134517737205060872591792014964962722e+9967', '-269720069.2925602198855004698047', '-1.596172726513e+7', 14, 5);
  t('-5.75017431522121151911584268476607397041271245184126e+6110', '3.1316103139139653e+59', '-1.8603166122551754e+59', 33, 3);
  t('-53.3032029466169433002012740687580043518816717487', '31641.6419229957', '-5.33032029466169433002012740687580043518816717487e+1', 70, 3);
  t('72217.81124137174718066449515357955447849981408895', '-8.7683588909862633417120718073873e+49', '7.221781124137174718066449515357955447849981408895e+4', 53, 1);
  t('4692222630612536029410534310094035996228840113566296.8', '1228263.06453688667212142398916324', '5.4696289351779412826381928353116e+5', 67, 0);
  t('-7.9540186730450607380161429790e+6430', '-4639.1111967549704803866386', '-1.07e+3', 3, 5);
  t('5.22e+7656', '-8.500204601289537368439368068473e+64', '1.31145091818334943531353566321e+64', 34, 5);
  t('9.87886266656141131566931816173489290346252900698068e+66', '-9.537278383404716745059580002e+195', '9.87886266656141131566931816173489290346252900698068e+66', 98, 4);
  t('-9031367.14748312394', '9.8676925037570147928180472738580628944445e+112', '-9.03136714748312394e+6', 93, 3);
  t('-3.237780151586765403233992546861473219e+103', '-4.213698590019308332103708310931502e+86', '-3.715913030258199339756353959945608e+86', 100, 5);
  t('-2e+624', '3.0630010e+754', '-2e+624', 24, 3);
  t('-26267210542733.60053963718272912688751521576671166112045188', '8.920557499910098814348531734605286864e+7549', '-2.62672105e+13', 9, 6);
  t('5.884563e+86', '5.544271814073647469677715398389e+68', '1.656897857425690453539776341638e+68', 49, 6);
  t('-2.9501e+1031', '-5.705094676024e+32', '-3.086833450968e+32', 38, 0);
  t('2190203683.01784039790649953183427044501728975229622892', '-129341.6581527620814546235644263675042036956912', '6.1385517120072635e+4', 17, 4);
  t('374.465410986072628695747577414265711313', '5.2879747143440196018217433252932138284305606201435437e+952', '3.7446541098607e+2', 14, 1);
  t('8.4784750153107531506270037576e+327', '6.4828775998173475131160558410831475175e+2971', '8.4784750153107531506270037576e+327', 34, 0);
  t('9.62707270e+501', '-6.342341847592514387089599362701767676614396026825953485e+539', '9.6270727e+501', 84, 1);
  t('7145500474663735829770809398299303175.875800464970535410224', '90828572.5113415651186621228687335129152209', '5.6290732076087447357393897802e+7', 29, 1);
  t('-6.05845881219948340925618875938e+91', '6.61836246027891675911003e+7034', '-6.0584588121994e+91', 14, 1);
  t('-7.43e+833', '-3.1891516544348227127456801051019337878811793572460629e+1748', '-7.43e+833', 39, 4);
  t('-586487137896561.9', '-7e+720', '-5.864871378965619e+14', 32, 3);
  t('-7004720099355232745.58685968254503', '464534361433180', '-6.46330431152558685968254503e+12', 83, 4);
  t('7376349279.6789964', '8.13158102169523546706061074913188868474536498e+1244', '7.3763492796789964e+9', 83, 1);
  t('-2.66694516312127080093289225754644e+5649', '-8.2788550315689695e+274', '-6.58461978336281e+273', 91, 3);
  t('-26377480.2334276377485822339988800328191768957719819966', '97339239938767981386925617.88982454562567822091088', '-2.6377480233427637748582233e+7', 26, 1);
  t('2.3644616729891784263411140e+3430', '-981855.982985359583764068205579338555912870110328229714', '5.192582575653964788593134550979615774147e+5', 40, 2);
  t('-2567.301939196367215654841', '-4.7110984724522e+20', '-2.567301939196367215654841e+3', 48, 3);
  t('-6.887177370604424697705428668658450e+36', '-7.67098e+3101', '-6.88717737060442469770542866865845e+36', 73, 1);
  t('2.3477568659602166267356708374e+758', '260693.9220345082421249094573691967212817853512', '2.359424256311595263045483114847279155538568672e+5', 55, 6);
  t('-5.033571988963017652865943270154512156255697111231944e+1306', '-1.04835155898865079e+703', '-9.344544833551976e+702', 72, 1);
  t('8.214139451354306802429236611686779e+5690', '-1.1263730322555479536183521284e+67', '3.74429518435572840395289768e+66', 50, 5);
  t('-8.1488000628720211739998282062206736158332e+75', '-2.001705e+6119', '-8.148800062872021173999828206220673615833e+75', 40, 1);
  t('-1080.0089303345457', '-2.70053959411289137357067400343848e+7462', '-1.0800089303345457e+3', 47, 3);
  t('-951.8120833154', '-4601803.9053077601346104732884149542122', '-9.518120833154e+2', 85, 1);
  t('623427944.6738997303017990', '8.80254156992034229e+39', '6.23427944673899730301799e+8', 67, 5);
  t('2.35391833099492200539685512e+541', '6.54579350680846293549701724417257e+6501', '2.35391833099492200539685512e+541', 78, 3);
  t('-5.802871745569351746236032657404971772902653184e+166', '-569601127769.9071963300149221373', '-3.942765500842812255133287266114e+11', 95, 2);
  t('58251.5299394592584913418694544936952', '9.922305336838175628353279413320037919974386628e+529', '5.82515299394592584913418694544936952e+4', 38, 0);
  t('178.810791', '5.9730850405607582e+127', '1.78810791e+2', 84, 5);
  t('-7.213282126127679116801393251769456078498115487567582164e+771', '9.6205166181505588836203473075832010219834163e+54', '-2.5117368798393502824500490159742596742822416e+54', 68, 2);
  t('4.4e+1415', '-1791.169782612342099849155398906941466798405915791267', '4.653087683667797453179502356881392981661075348818e+2', 49, 6);
  t('3.34143206113154599754e+6694', '-7.26959684903106538055444862542e+55', '3.3407965043731368445510652696e+54', 72, 6);
  t('7.01029485594801768569517050720798941155721968259835932500e+9422', '-7.0642669512907646431409065185107769129961433230267e+65', '2.2427484434740226146829404720536384416432051622105e+65', 95, 1);
  t('-4.33801305787072916172388791e+80', '5.22122485473591837565234669915e+391', '-4.33801305787072916172388791e+80', 27, 2);
  t('7.8492581941996654096258841e+325', '8.9130586564498055969723193446e+77', '6.957386304461095271086697014e+77', 33, 6);
  t('7.23792299537795282764181e+89', '84967.13729986244128821297358194722156577559385', '6.7621143544859443748328006466947263422e+4', 38, 0);
  t('5033998704.17776924377988587279152844', '8.08401900237472415884868065688485795856720872615446e+8410', '5.03399870417776924377988587279152e+9', 33, 3);
  t('-5.94302899773211952133552303e+187', '2.9972e+7', '-2.9248e+7', 64, 5);
  t('-9.708e+685', '9.19085856796459395e+9531', '-9.708e+685', 68, 0);
  t('-1.5465036868358516166872219595', '-6.6120784612856e+68', '-1.5465036868358516166872219595e+0', 35, 3);
  t('-3.3053551448370844845756700300850e+3913', '-8.3467925553134e+50', '-4.1896819159544e+50', 96, 1);
  t('9.09456645650818213193831463546071024679434471379e+666', '7.38724213405152e+6026', '9.09456645650818213193831463546071024679434471379e+666', 67, 5);
  t('4.58641736178041090644887341275999994080950314188e+1696', '42578392.4318675275571079327730844188901162369235804917550975', '1.23791564353744632853300363493236151396949910992682155531775e+7', 65, 5);
  t('7.9961e+998', '-1.1820804651008895509998463408241199118086e+9578', '7.9961e+998', 63, 2);
  t('-6.072e+5252', '-7.18009312791883624836138815068459810882308438794417e+8712', '-6.072e+5252', 47, 4);
  t('-4.5600994941281230126894362369720165703108388452e+2403', '-622038.4747064194717182782274608403027399105469860723330', '-5.4141438904500328e+5', 17, 6);
  t('-3.25278868174882601881e+2959', '7.8431549098046872891828825565737588458734074284671853699539e+633', '-2.3794416114981559662e+633', 20, 1);
  t('3.6343105960435681326882097841415419173146739156748857909293e+163', '-21', '1.5e+1', 34, 0);
  t('-8.518623612127699770931777976e+45', '2646604900335022323292722367397273217264.57291', '-1.71262916408899413908e+39', 21, 3);
  t('4174055292995644.9880231577567977226789530659873674', '8.360559715199137928831459829758326270411708783897324911671e+6398', '4.174055293e+15', 12, 6);
  t('61974599899119.9534242842171966733601323', '-5.453e+1783', '6.197e+13', 4, 3);
  t('6543503.0162949178948038773968906145153443230268592', '-7125491.922', '6.5435030162949178948038773968906145153443e+6', 41, 6);
  t('-29924.33147502565764364098940606', '-1592929.777384719554672688705249208524154144674784435883721', '-2.99243314750256576e+4', 18, 1);
  t('-4311819637633458353446934226481969087340.175', '3e+888', '-4.311819637633458353446934226481969087340175e+39', 69, 6);
  t('-701325358.8507151963018486', '5.02485985784225975e+2516', '-7.013253588507151963018486e+8', 69, 1);
  t('-6.3336349419868999600556396454550393580710353e+559', '30.032145617405641584200167823777472745177252592857', '-1.804780266424170907995664538747e+1', 31, 5);
  t('8208171.29438957568235282192379149634710643516674459', '5.526518296200919451845144699586071213e+56', '8.20817129438957568235282192379149634710643516674459e+6', 74, 6);
  t('-7026771.991488141635713537245992635089330556307', '-5.78495686345608787896765252e+87', '-7.026771991488141635713537245992635089330556307e+6', 78, 3);
  t('-682825', '-9.58106140947497715953494e+7650', '-6.82825e+5', 53, 1);
  t('1.0432667917954743913105334020914075684681873553141e+53', '-363639573.56541900063559754', '8.8041122284741437367e+6', 20, 2);
  t('9.294092190225380807622716e+554', '82510153.549550000881266062462945', '5.7307479561359672028887521773435e+7', 37, 0);
  t('-8.61826021489505921628320081423912946310238785369120278845e+4535', '4413386685.26795493710228068839622996984174618', '-3.38270650710585646963860751526981526607567182e+9', 85, 3);
  t('-2.672585214604e+621', '-9.578201948955624059202e+62', '-5.08879650726473396428e+61', 35, 4);
  t('6.9128357540377177371762216197787022755536508992068094e+523', '-3.2577610725568034259555913702314301e+502', '3.2025889458822105348276677851579185e+502', 94, 4);
  t('-5.441086784380795770829212', '671.1382228580292151191915154358159424235725030704', '-5.4410867843808e+0', 14, 6);
  t('8.151289172051252728e+49', '-288.51320484667811368085314331', '2e+2', 1, 5);
  t('8.075e+8', '-2.3439742423603951162113459', '1.5484257243982081068293252e+0', 98, 6);
  t('-5.8040872885301e+27', '-756632.178760425828115651424792498655635088327', '-6.7838751e+5', 8, 5);
  t('-6.30185023912358362453739e+43', '-5.8291686913947145494292529837761538164089993367780968996309e+182', '-6.301e+43', 4, 2);
  t('-2.3168408598819483038286410534187220e+54', '5.76821013360839181791090764e+895', '-2.316840859881948303828641053418722e+54', 64, 5);
  t('4.73433879920597402830e+517', '7.19935223140121316154319557870953e+83', '6.276715240828e+83', 13, 4);
  t('-2.81509e+6', '1.812e+246', '-2.81509e+6', 83, 3);
  t('-3.7125440302535164287920458084935906', '9.4056833e+407', '-3.7125440302535164287920458084935906e+0', 100, 0);
  t('3.8089600875379985918666854598970946009387586848198798601e+64', '-9.842428987583196816730893684990759478255192322e+172', '3.808960087537998592e+64', 19, 2);
  t('-6.49308611559837353028439424226724e+681', '-6.9279627338450039699162972e+5038', '-6.49308611559837353028439424226724e+681', 52, 1);
  t('-3.283e+8', '1.59267743467980e+46', '-3.283e+8', 74, 5);
  t('8.69757929965438373165362773612974e+192', '-73.79436307426341549232457077000482745011', '5.145179803297395e+1', 16, 0);
  t('-8.2373007776535315311267037638881860091e+40', '-5.757730498009786912193794e+37', '-3.7461654995362466895783438881860091e+37', 89, 1);
  t('8.2753743577733496649229415e+370', '-88797.16162', '5.492178204e+4', 93, 4);
  t('1.48581817545381241776887741933992917284785358529', '5903622466634088045894004.22718934', '1.48581817545381241776887741933992917284785358529e+0', 71, 6);
  t('5.129086074208008222351499810040746978958761126e+293', '496793381949653476385416592315281192971751225.09020825', '4e+44', 1, 1);
  t('-2.80845381738689415933627794871721050391716565400744493348202e+159', '4042022.949118089592', '-5.1205e+5', 5, 5);
  t('-7.608461933481403715443327118274378005025e+6785', '73027440923359159570.9274647515324850715', '-4.0233559318242465845769751200091461814e+19', 100, 0);
  t('5.3656679337854155278424098140145779577342655431342620134014e+7681', '-9.34344633539969e+136', '3.2266e+135', 5, 0);
  t('-8.76e+15', '7.884013646400282186823118749015404657404866922926e+5546', '-9e+15', 1, 0);
  t('3.08613897206936240922007217437132e+9939', '5.60781020e+9', '4.424842e+9', 17, 2);
  t('17.347072298067804168620815', '9.6146989823337249222122068576315652901e+59', '1.7347072298067804168620815e+1', 81, 2);
  t('-3.3610512896674974771860856952304666e+76', '9.82609790457683994410', '-5.4089915183757222993e+0', 91, 3);
  t('-5.075266107871695934621156287679557190e+225', '-8950634354.102096867', '-3.320100822028796139e+9', 64, 4);
  t('1.80906977550635553008735110130154444563675928517e+222', '-2.3641653094828594182991e+850', '1.809069775506355530087351e+222', 25, 5);
  t('2.10724292529592973714942968646730881946629591268819155763e+96', '8.7469186241449712430e+308', '2.1072429252959297371494297e+96', 26, 5);
  t('2.511951653e+3360', '-62704201442675201961255868610.62', '2.566182839527647e+28', 16, 3);
  t('-243025.9013822376723836745951444', '-2.6675104229981642056765726341862e+9212', '-2.430259013822376723836745951444e+5', 91, 1);
  t('5.9150440852e+129', '1756386.26758530048962177340289455990042113', '1.51990747887335793925678558668139806689985e+6', 53, 5);
  t('-94252.40812498886857383293649', '-3.8032732751134162575094809941651e+621', '-9.425240812498886857383293649e+4', 96, 4);
  t('-6.00559063113006083268308811806162403396832594e+7303', '-526206391770735839309548148095066062264265607373.735063960260', '-2.5090125586506678664e+47', 20, 6);
  t('-2.2567835144492993286994200e+573', '3.86e+19', '-2.72e+19', 56, 0);
  t('45.40437334953326105840633843242', '8.165685418205048453423994094023522482e+91', '4.540437334953326105840633843242e+1', 55, 6);
});
