# Jasmine Core 3.6 Release Notes

## Summary

This is a maintenance release of Jasmine with a number of new features and fixes.

## Highlights

* Added support for custom object formatters
    * Allows customizing how an object is stringified in matcher failure messages
    * [Tutorial](https://jasmine.github.io/tutorials/custom_object_formatter)
    * [API reference](https://jasmine.github.io/api/3.6/jasmine.html#.addCustomObjectFormatter)

* Don't require matchers and asymmetric equality testers to pass custom object formatters back to Jasmine
    - Supports custom object formatters.
    - Makes it easier to write high quality matchers and asymmetric equality testers.
    - The old API will still work until 4.0.

* Properly import jasmineRequire object before using
    - Improves compatibility with Webpack
    - Merges [#1766](https://github.com/jasmine/jasmine/pull/1766) from @amilligan

* Added a toHaveBeenCalledOnceWith matcher
    - Merges [#1801](https://github.com/jasmine/jasmine/pull/1801) from @Maximaximum
    - Fixes [#1717](https://github.com/jasmine/jasmine/issues/1717)
    
* Added a toHaveSize matcher
    - Merges [#1796](https://github.com/jasmine/jasmine/pull/1796) from @wokier

* Added a toBePending async matcher
    - Merges [#1808](https://github.com/jasmine/jasmine/pull/1808) from @DCtheTall
    - Fixes [#1803](https://github.com/jasmine/jasmine/issues/1803)
    
* Added support for user-defined spec/suite properties
    - Allows specs/suites to pass data to custom reporters
    - Merges [#1763](https://github.com/jasmine/jasmine/pull/1763) from @johnjbarton

* Route unhandled promise rejections to onerror
    - Merges [#1778](https://github.com/jasmine/jasmine/pull/1778) from @johnjbarton
    - Fixes [#1777](https://github.com/jasmine/jasmine/issues/1777)


## Internal notes

* Use a version of eslint that works on Node 8

* Check for syntax and standard library objects that don't work in IE

* Run eslint against all files

* Add Additional Test for equals Matcher
    - Merges [#1829](https://github.com/jasmine/jasmine/pull/1829) from @tobiasschweizer
    - Fixes [#1821](https://github.com/jasmine/jasmine/issues/1821)

* Depend on head of jasmine-browser to fix IE failures in CI

* Fixed test failure in Firefox 74

* Added test for resolveTo/rejectWith with empty parameters
    - Merges [#1802](https://github.com/jasmine/jasmine/pull/1802) from @chivesrs
    
* Removed unnecessary uses of new in tests

* Realigned the browser testing matrix to match current reality
    - Use Windows instead of Linux so we can get current browsers from Sauce.
    - Test against the version of Firefox that corresponds to ESR as well as
  latest.
    - Test the latest Edge rather than a specific older version.
    - Test Safari 8 and 13 instead of 8, 9 and 10. What works in those versions
  is likely to work in the ones in between.

* Don't leak global error handlers between Jasmine's own tests

* Added basic property tests for matchersUtil.equals

* Added integration tests for existing matcher interfaces

* Added integration tests for asymmetric equality testers

* Test IE before other browsers on Travis


## Other Changes

* Show diffs involving root-level asymmetric equality testers
    - Fixes [#1831](https://github.com/jasmine/jasmine/issues/1831)

* Fixed references to master in docs

* Allow spy throwError to throw an Object
    - Merges [#1822](https://github.com/jasmine/jasmine/pull/1822) from @terencehonles

* Added missing periods to README
    - Merges [#1828](https://github.com/jasmine/jasmine/pull/1828) from @dirkpuge


* Expose setSpec/SuiteProperty on interface
    - Merges [#1820](https://github.com/jasmine/jasmine/pull/1820) from @johnjbarton

* Prevent undesired reloads when karma-jasmine-html-reporter is used
    - Merges [#1807](https://github.com/jasmine/jasmine/pull/1807) from @parloti
    - Fixes [#1775](https://github.com/jasmine/jasmine/issues/1775)

* Correctly report spec and suite duration
    - Fixes [#1676](https://github.com/jasmine/jasmine/issues/1676).

* Added jsdocs for MatchersUtil

* Allow the .callThrough spy strategy to call constructor functions without errors
    - Merges [#1782](https://github.com/jasmine/jasmine/pull/1782) from @enelson
    - Fixes [#1760](https://github.com/jasmine/jasmine/issues/1760)
    
* Inject a per-runable pretty printer into MatchersUtil
    - Supports custom object formatters

* Include stack traces in unhandled promise rejection messages

* Describe the naming for the function it
    - Merges [#1772](https://github.com/jasmine/jasmine/pull/1772) from @johnlinp

* Correctly extract error messages from stack traces that don't start with `Error`
    - Merges [#1776](https://github.com/jasmine/jasmine/pull/1776) from @vhermannitk
    - Fixes [#1771](https://github.com/jasmine/jasmine/issues/1771)

* Fixed objectContaining to not match when the expected is the empty object and the actual is a non-object

* Fixed toEqual(0, Number.MIN_VALUE) to fail instead of passing 
    - Merges [#1764](https://github.com/jasmine/jasmine/pull/1764) from @dubzzz

* Fixed comparison between ObjectContaining and non-objects on IE

* Provide better diffs for object graphs that include `objectContaining`

* Indent multiline failure messages in the output of `withContext`
    * This makes it easier to see where each failure message begins and ends.

* Report async expectations that complete after the runable completes
    - See [#1752](https://github.com/jasmine/jasmine/issues/1752).

* Treat NodeJS assertion failures as expectation failures
    - Merges [#1678](https://github.com/jasmine/jasmine/pull/1678) from @apla


------

_Release Notes generated with _[Anchorman](http://github.com/infews/anchorman)_
