#include "config.h"

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "math_expression.h"
#include "math_equation.h"
#include "math_function.h"

struct funcs {
  char *name;
  struct math_function_parameter prm;
};

static struct funcs FuncAry[] = {
  {"ARRAY_MOVING_AVERAGE", {4, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_array_moving_average, NULL, NULL, NULL, NULL}},
  {"STRING_FLOAT_ARRAY", {2, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_string_float_array, NULL, NULL, NULL, NULL}},
  {"STRING_SPLIT_FLOAT", {4, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_string_split_float, NULL, NULL, NULL, NULL}},
  {"STRING_SUBSTRING", {4, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_string_substring, NULL, NULL, NULL, NULL}},
  {"EACH_WITH_INDEX", {4, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_each_with_index, NULL, NULL, NULL, NULL}},
  {"STRING_TRUNCATE", {2, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_string_truncate, NULL, NULL, NULL, NULL}},
  {"STRING_PREPEND", {2, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_string_prepend, NULL, NULL, NULL, NULL}},
  {"STRING_REVERSE", {2, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_string_reverse, NULL, NULL, NULL, NULL}},
  {"STRING_COMPARE", {3, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_string_compare, NULL, NULL, NULL, NULL}},
  {"STRING_REPLACE", {5, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_string_replace, NULL, NULL, NULL, NULL}},
  {"ARRAY_AVERAGE", {1, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_array_average, NULL, NULL, NULL, NULL}},
  {"ARRAY_COMPACT", {1, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_array_compact, NULL, NULL, NULL, NULL}},
  {"STRING_LENGTH", {1, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_string_length, NULL, NULL, NULL, NULL}},
  {"STRING_APPEND", {2, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_string_append, NULL, NULL, NULL, NULL}},
  {"STRING_INSERT", {3, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_string_insert, NULL, NULL, NULL, NULL}},
  {"GETOBJ_STRING", {4, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_getobj_string, NULL, NULL, NULL, NULL}},
  {"ARRAY_STDEVP", {1, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_array_stdevp, NULL, NULL, NULL, NULL}},
  {"STRING_FLOAT", {1, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_string_float, NULL, NULL, NULL, NULL}},
  {"STRING_STRIP", {1, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_string_strip, NULL, NULL, NULL, NULL}},
  {"STRING_MATCH", {3, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_string_match, NULL, NULL, NULL, NULL}},
  {"STRING_ERASE", {3, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_string_erase, NULL, NULL, NULL, NULL}},
  {"STRING_SPLIT", {4, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_string_split, NULL, NULL, NULL, NULL}},
  {"GETOBJ_ARRAY", {4, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_getobj_array, NULL, NULL, NULL, NULL}},
  {"ARRAY_CLEAR", {1, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_array_clear, NULL, NULL, NULL, NULL}},
  {"ARRAY_SUMSQ", {1, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_array_sumsq, NULL, NULL, NULL, NULL}},
  {"ARRAY_STDEV", {1, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_array_stdev, NULL, NULL, NULL, NULL}},
  {"STRING_DOWN", {2, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_string_down, NULL, NULL, NULL, NULL}},
  {"STRING_JOIN", {3, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_string_join, NULL, NULL, NULL, NULL}},
  {"ARRAY_COPY", {2, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_array_copy, NULL, NULL, NULL, NULL}},
#ifdef HAVE_LIBGSL
  {"ZETAM1_INT", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_zetam1_int, NULL, NULL, NULL, NULL}},
#else
  {NULL, {0, 0, 0, NULL, NULL, NULL, NULL, NULL}},
#endif
  {"MJD2MONTH", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_mjd2month, NULL, NULL, NULL, NULL}},
  {"ARRAY_SUM", {1, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_array_sum, NULL, NULL, NULL, NULL}},
  {"ARRAY_MIN", {1, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_array_min, NULL, NULL, NULL, NULL}},
  {"ARRAY_MAX", {1, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_array_max, NULL, NULL, NULL, NULL}},
  {"PARAMETER", {1, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_parameter, NULL, NULL, NULL, NULL}},
  {"STRING_UP", {2, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_string_up, NULL, NULL, NULL, NULL}},
  {"UNIX2MJD", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_unix2mjd, NULL, NULL, NULL, NULL}},
  {"MJD2YEAR", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_mjd2year, NULL, NULL, NULL, NULL}},
  {"MJD2WDAY", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_mjd2wday, NULL, NULL, NULL, NULL}},
  {"MJD2YDAY", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_mjd2yday, NULL, NULL, NULL, NULL}},
  {"ISNORMAL", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_isnormal, NULL, NULL, NULL, NULL}},
#ifdef HAVE_LIBGSL
  {"ZETA_INT", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_zeta_int, NULL, NULL, NULL, NULL}},
#else
  {NULL, {0, 0, 0, NULL, NULL, NULL, NULL, NULL}},
#endif
  {"MJD2UNIX", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_mjd2unix, NULL, NULL, NULL, NULL}},
  {"STRFTIME", {4, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_strftime, NULL, NULL, NULL, NULL}},
  {"MJD2DAY", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_mjd2day, NULL, NULL, NULL, NULL}},
  {"ZIP_MAP", {6, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_zip_map, NULL, NULL, NULL, NULL}},
  {"ISUNDEF", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_isundef, NULL, NULL, NULL, NULL}},
  {"ISBREAK", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_isbreak, NULL, NULL, NULL, NULL}},
  {"UNSHIFT", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_unshift, NULL, NULL, NULL, NULL}},
  {"SPRINTF", {-3, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_sprintf, NULL, NULL, NULL, NULL}},
#ifdef HAVE_LIBGSL
  {"ICBETA", {3, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_icbeta, NULL, NULL, NULL, NULL}},
#else
  {NULL, {0, 0, 0, NULL, NULL, NULL, NULL, NULL}},
#endif
  {"UNLESS", {3, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_unless, NULL, NULL, NULL, NULL}},
  {"FILTER", {4, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_filter, NULL, NULL, NULL, NULL}},
  {"REDUCE", {4, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_reduce, NULL, NULL, NULL, NULL}},
  {"ISCONT", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_iscont, NULL, NULL, NULL, NULL}},
#ifdef HAVE_LIBGSL
  {"ZETAM1", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_zetam1, NULL, NULL, NULL, NULL}},
#else
  {NULL, {0, 0, 0, NULL, NULL, NULL, NULL, NULL}},
#endif
#ifdef HAVE_LIBGSL
  {"CHOOSE", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_choose, NULL, NULL, NULL, NULL}},
#else
  {NULL, {0, 0, 0, NULL, NULL, NULL, NULL, NULL}},
#endif
  {"STRING", {2, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_string, NULL, NULL, NULL, NULL}},
  {"PRINTF", {-2, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_printf, NULL, NULL, NULL, NULL}},
  {"GETOBJ", {3, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_getobj, NULL, NULL, NULL, NULL}},
  {"GAUSS", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_gauss, NULL, NULL, NULL, NULL}},
  {"ROUND", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_round, NULL, NULL, NULL, NULL}},
  {"EXPM1", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_expm1, NULL, NULL, NULL, NULL}},
  {"LOG1P", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_log1p, NULL, NULL, NULL, NULL}},
  {"ASINH", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_asinh, NULL, NULL, NULL, NULL}},
  {"ACOSH", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_acosh, NULL, NULL, NULL, NULL}},
  {"ATANH", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_atanh, NULL, NULL, NULL, NULL}},
  {"SRAND", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_srand, NULL, NULL, NULL, NULL}},
  {"THETA", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_theta, NULL, NULL, NULL, NULL}},
  {"DELTA", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_delta, NULL, NULL, NULL, NULL}},
  {"GAMMA", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_gamma, NULL, NULL, NULL, NULL}},
  {"ICGAM", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_icgam, NULL, NULL, NULL, NULL}},
  {"TIMES", {3, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_times, NULL, NULL, NULL, NULL}},
  {"RSORT", {2, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_rsort, NULL, NULL, NULL, NULL}},
  {"INDEX", {3, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_index, NULL, NULL, NULL, NULL}},
  {"ARRAY", {-2, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_array, NULL, NULL, NULL, NULL}},
  {"ISNAN", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_isnan, NULL, NULL, NULL, NULL}},
  {"PROGN", {-1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_progn, NULL, NULL, NULL, NULL}},
  {"PROG1", {-1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_prog1, NULL, NULL, NULL, NULL}},
  {"PROG2", {-1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_prog2, NULL, NULL, NULL, NULL}},
  {"SHIFT", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_shift, NULL, NULL, NULL, NULL}},
  {"SUMSQ", {-1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_sumsq, NULL, NULL, NULL, NULL}},
  {"SIGN", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_sign, NULL, NULL, NULL, NULL}},
  {"FRAC", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_frac, NULL, NULL, NULL, NULL}},
  {"SQRT", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_sqrt, NULL, NULL, NULL, NULL}},
  {"LN1P", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_ln1p, NULL, NULL, NULL, NULL}},
  {"ASIN", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_asin, NULL, NULL, NULL, NULL}},
  {"ACOS", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_acos, NULL, NULL, NULL, NULL}},
  {"ATAN", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_atan, NULL, NULL, NULL, NULL}},
  {"SINH", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_sinh, NULL, NULL, NULL, NULL}},
  {"COSH", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_cosh, NULL, NULL, NULL, NULL}},
  {"TANH", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_tanh, NULL, NULL, NULL, NULL}},
  {"RAND", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_rand, NULL, NULL, NULL, NULL}},
  {"ERFC", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_erfc, NULL, NULL, NULL, NULL}},
  {"QINV", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_qinv, NULL, NULL, NULL, NULL}},
  {"BETA", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_beta, NULL, NULL, NULL, NULL}},
  {"SORT", {2, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_sort, NULL, NULL, NULL, NULL}},
  {"SIZE", {1, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_size, NULL, NULL, NULL, NULL}},
  {"FIND", {3, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_find, NULL, NULL, NULL, NULL}},
  {"EACH", {3, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_each, NULL, NULL, NULL, NULL}},
#ifdef HAVE_LIBGSL
  {"ZETA", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_zeta, NULL, NULL, NULL, NULL}},
#else
  {NULL, {0, 0, 0, NULL, NULL, NULL, NULL, NULL}},
#endif
  {"PUSH", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_push, NULL, NULL, NULL, NULL}},
  {"TIME", {0, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_time, NULL, NULL, NULL, NULL}},
  {"FMOD", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_fmod, NULL, NULL, NULL, NULL}},
  {"PUTS", {1, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_puts, NULL, NULL, NULL, NULL}},
  {"ABS", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_abs, NULL, NULL, NULL, NULL}},
  {"INT", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_int, NULL, NULL, NULL, NULL}},
  {"MIN", {-1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_min, NULL, NULL, NULL, NULL}},
  {"MAX", {-1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_max, NULL, NULL, NULL, NULL}},
  {"SQR", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_sqr, NULL, NULL, NULL, NULL}},
  {"EXP", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_exp, NULL, NULL, NULL, NULL}},
  {"LOG", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_log, NULL, NULL, NULL, NULL}},
  {"SIN", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_sin, NULL, NULL, NULL, NULL}},
  {"COS", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_cos, NULL, NULL, NULL, NULL}},
  {"TAN", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_tan, NULL, NULL, NULL, NULL}},
#ifdef HAVE_LIBGSL
  {"ERF", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_erf, NULL, NULL, NULL, NULL}},
#else
  {NULL, {0, 0, 0, NULL, NULL, NULL, NULL, NULL}},
#endif
  {"LGN", {3, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_lgn, NULL, NULL, NULL, NULL}},
  {"MJD", {6, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_mjd, NULL, NULL, NULL, NULL}},
  {"NEQ", {3, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_neq, NULL, NULL, NULL, NULL}},
  {"NOT", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_not, NULL, NULL, NULL, NULL}},
  {"AND", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_and, NULL, NULL, NULL, NULL}},
  {"XOR", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_xor, NULL, NULL, NULL, NULL}},
  {"FOR", {5, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_for, NULL, NULL, NULL, NULL}},
  {"DIF", {1, 1, MATH_FUNCTION_TYPE_POSITIONAL, math_func_dif, NULL, NULL, NULL, NULL}},
  {"SUM", {1, 1, MATH_FUNCTION_TYPE_POSITIONAL, math_func_sum, NULL, NULL, NULL, NULL}},
  {"MAP", {4, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_map, NULL, NULL, NULL, NULL}},
  {"ZIP", {5, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_zip, NULL, NULL, NULL, NULL}},
#ifdef HAVE_LIBGSL
  {"JNU", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_jnu, NULL, NULL, NULL, NULL}},
#else
  {NULL, {0, 0, 0, NULL, NULL, NULL, NULL, NULL}},
#endif
#ifdef HAVE_LIBGSL
  {"YNU", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_ynu, NULL, NULL, NULL, NULL}},
#else
  {NULL, {0, 0, 0, NULL, NULL, NULL, NULL, NULL}},
#endif
#ifdef HAVE_LIBGSL
  {"INU", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_inu, NULL, NULL, NULL, NULL}},
#else
  {NULL, {0, 0, 0, NULL, NULL, NULL, NULL, NULL}},
#endif
#ifdef HAVE_LIBGSL
  {"KNU", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_knu, NULL, NULL, NULL, NULL}},
#else
  {NULL, {0, 0, 0, NULL, NULL, NULL, NULL, NULL}},
#endif
  {"POP", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_pop, NULL, NULL, NULL, NULL}},
  {"LN", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_ln, NULL, NULL, NULL, NULL}},
  {"EI", {1, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_ei, NULL, NULL, NULL, NULL}},
  {"JN", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_jn, NULL, NULL, NULL, NULL}},
  {"YN", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_yn, NULL, NULL, NULL, NULL}},
  {"PN", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_pn, NULL, NULL, NULL, NULL}},
  {"HN", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_hn, NULL, NULL, NULL, NULL}},
  {"TN", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_tn, NULL, NULL, NULL, NULL}},
  {"EQ", {3, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_eq, NULL, NULL, NULL, NULL}},
  {"GE", {3, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_ge, NULL, NULL, NULL, NULL}},
  {"GT", {3, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_gt, NULL, NULL, NULL, NULL}},
  {"LE", {3, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_le, NULL, NULL, NULL, NULL}},
  {"LT", {3, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_lt, NULL, NULL, NULL, NULL}},
  {"OR", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_or, NULL, NULL, NULL, NULL}},
  {"RM", {1, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_rm, NULL, NULL, NULL, NULL}},
  {"CM", {2, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_cm, NULL, NULL, NULL, NULL}},
  {"AM", {1, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_am, NULL, NULL, NULL, NULL}},
  {"IF", {3, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_if, NULL, NULL, NULL, NULL}},
#ifdef HAVE_LIBGSL
  {"IN", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_in, NULL, NULL, NULL, NULL}},
#else
  {NULL, {0, 0, 0, NULL, NULL, NULL, NULL, NULL}},
#endif
#ifdef HAVE_LIBGSL
  {"KN", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_kn, NULL, NULL, NULL, NULL}},
#else
  {NULL, {0, 0, 0, NULL, NULL, NULL, NULL, NULL}},
#endif
#ifdef HAVE_LIBGSL
  {"YL", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_yl, NULL, NULL, NULL, NULL}},
#else
  {NULL, {0, 0, 0, NULL, NULL, NULL, NULL, NULL}},
#endif
#ifdef HAVE_LIBGSL
  {"JL", {2, 0, MATH_FUNCTION_TYPE_NORMAL, math_func_jl, NULL, NULL, NULL, NULL}},
#else
  {NULL, {0, 0, 0, NULL, NULL, NULL, NULL, NULL}},
#endif
  {"M", {2, 1, MATH_FUNCTION_TYPE_NORMAL, math_func_m, NULL, NULL, NULL, NULL}},
};


int
math_add_basic_function(MathEquation *eq) {
  unsigned int i;
  enum MATH_FUNCTION_ARG_TYPE *ptr;

  for (i = 0; i < sizeof(FuncAry) / sizeof(*FuncAry); i++) {
    if (FuncAry[i].name == NULL) {
      continue;
    }
    switch (i) {
    case 0:  /*  ARRAY_MOVING_AVERAGE  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 4);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_ARRAY;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      ptr[3] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 1:  /*  STRING_FLOAT_ARRAY  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 2);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_STRING_ARRAY;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 2:  /*  STRING_SPLIT_FLOAT  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 4);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_STRING;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_STRING;
      ptr[3] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 3:  /*  STRING_SUBSTRING  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 4);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING_VARIABLE;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_STRING;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      ptr[3] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 4:  /*  EACH_WITH_INDEX  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 4);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_VARIABLE_COMMON;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_VARIABLE;
      ptr[3] = MATH_FUNCTION_ARG_TYPE_PROC;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 5:  /*  STRING_TRUNCATE  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 2);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING_VARIABLE;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 6:  /*  STRING_PREPEND  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 2);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING_VARIABLE;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_STRING;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 7:  /*  STRING_REVERSE  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 2);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING_VARIABLE;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_STRING;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 8:  /*  STRING_COMPARE  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 3);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_STRING;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 9:  /*  STRING_REPLACE  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 5);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING_VARIABLE;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_STRING;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_STRING;
      ptr[3] = MATH_FUNCTION_ARG_TYPE_STRING;
      ptr[4] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 10:  /*  ARRAY_AVERAGE  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 1);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 11:  /*  ARRAY_COMPACT  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 1);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 12:  /*  STRING_LENGTH  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 1);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 13:  /*  STRING_APPEND  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 2);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING_VARIABLE;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_STRING;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 14:  /*  STRING_INSERT  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 3);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING_VARIABLE;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_STRING;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 15:  /*  GETOBJ_STRING  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 4);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING_VARIABLE;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_STRING;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_STRING;
      ptr[3] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 16:  /*  ARRAY_STDEVP  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 1);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 17:  /*  STRING_FLOAT  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 1);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 18:  /*  STRING_STRIP  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 1);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING_VARIABLE;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 19:  /*  STRING_MATCH  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 3);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_STRING;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 20:  /*  STRING_ERASE  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 3);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING_VARIABLE;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 21:  /*  STRING_SPLIT  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 4);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_STRING;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_STRING;
      ptr[3] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 22:  /*  GETOBJ_ARRAY  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 4);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_STRING;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_STRING;
      ptr[3] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 23:  /*  ARRAY_CLEAR  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 1);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 24:  /*  ARRAY_SUMSQ  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 1);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 25:  /*  ARRAY_STDEV  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 1);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 26:  /*  STRING_DOWN  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 2);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING_VARIABLE;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_STRING;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 27:  /*  STRING_JOIN  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 3);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING_VARIABLE;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_STRING;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_STRING_ARRAY;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 28:  /*  ARRAY_COPY  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 2);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 31:  /*  ARRAY_SUM  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 1);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 32:  /*  ARRAY_MIN  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 1);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 33:  /*  ARRAY_MAX  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 1);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 35:  /*  STRING_UP  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 2);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING_VARIABLE;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_STRING;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 43:  /*  STRFTIME  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 4);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING_VARIABLE;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_STRING;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      ptr[3] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 45:  /*  ZIP_MAP  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 6);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      ptr[3] = MATH_FUNCTION_ARG_TYPE_VARIABLE_COMMON;
      ptr[4] = MATH_FUNCTION_ARG_TYPE_VARIABLE_COMMON;
      ptr[5] = MATH_FUNCTION_ARG_TYPE_PROC;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 48:  /*  UNSHIFT  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 2);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_PROC;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 49:  /*  SPRINTF  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 2);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING_VARIABLE;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_STRING;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 51:  /*  UNLESS  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 3);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_PROC;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_PROC;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 52:  /*  FILTER  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 4);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_VARIABLE_COMMON;
      ptr[3] = MATH_FUNCTION_ARG_TYPE_PROC;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 53:  /*  REDUCE  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 4);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_VARIABLE_COMMON;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_VARIABLE;
      ptr[3] = MATH_FUNCTION_ARG_TYPE_PROC;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 57:  /*  STRING  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 2);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING_VARIABLE;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 58:  /*  PRINTF  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 1);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 59:  /*  GETOBJ  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 3);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_STRING;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 72:  /*  TIMES  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 3);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_VARIABLE;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_PROC;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 73:  /*  RSORT  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 2);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 74:  /*  INDEX  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 3);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_VARIABLE_COMMON;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_PROC;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 75:  /*  ARRAY  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 1);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 80:  /*  SHIFT  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 2);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 96:  /*  SORT  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 2);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 97:  /*  SIZE  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 1);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 98:  /*  FIND  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 3);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_VARIABLE;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_PROC;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 99:  /*  EACH  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 3);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_VARIABLE_COMMON;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_PROC;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 101:  /*  PUSH  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 2);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_PROC;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 104:  /*  PUTS  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 1);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_STRING;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 122:  /*  FOR  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 5);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      ptr[3] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      ptr[4] = MATH_FUNCTION_ARG_TYPE_PROC;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 125:  /*  MAP  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 4);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_VARIABLE_COMMON;
      ptr[3] = MATH_FUNCTION_ARG_TYPE_PROC;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 126:  /*  ZIP  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 5);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_VARIABLE_COMMON;
      ptr[3] = MATH_FUNCTION_ARG_TYPE_VARIABLE_COMMON;
      ptr[4] = MATH_FUNCTION_ARG_TYPE_PROC;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 131:  /*  POP  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 2);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY_COMMON;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 147:  /*  AM  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 1);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_ARRAY;
      FuncAry[i].prm.arg_type = ptr;
      break;
    case 148:  /*  IF  */
      if (FuncAry[i].prm.arg_type) {
        break;
      }
      ptr = g_malloc(sizeof(enum MATH_FUNCTION_ARG_TYPE) * 3);
      if (ptr == NULL) {
        return 1;
      }
      ptr[0] = MATH_FUNCTION_ARG_TYPE_DOUBLE;
      ptr[1] = MATH_FUNCTION_ARG_TYPE_PROC;
      ptr[2] = MATH_FUNCTION_ARG_TYPE_PROC;
      FuncAry[i].prm.arg_type = ptr;
      break;
    }
    if (math_equation_add_func(eq, FuncAry[i].name, &FuncAry[i].prm) == NULL)
      return 1;
  }
  return 0;
}
