#include "config.h"

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>

#include <time.h>
#include INC_SYS_TIME
#include <pwd.h>
#include "version.h"
#include "patchlevel.h"

/*****************************************************************************/
/*                                                                           */
/*  This program generates cflags.c  tm is not identical across arches, date */
/*  is a poor way of getting the compilation time.  A simple program (just   */
/*  like this one) is the answer.                                            */
/*                                                                           */
/*  Oh yea, better have an ANSI compiler. --oh well. HP, you suck!           */
/*  ANSI C defines the tm structure in time.h so better learn ANSI C         */
/*                                                                           */
/*****************************************************************************/

int
main (argc, argv)
     int argc;
     char *argv[];
{
  time_t seconds;
  struct tm *tm_date;
  char tbuff1[100], tbuff2[100];
  char pigcall[120];
  char *pigcallresp ();

  if (argc != 3)
    {
      fprintf (stderr, "This program takes 2 argument, why are you running it anyway?\n");
      exit (1);
    }
  seconds = time(0);
  tm_date = localtime (&seconds);
  strftime (tbuff1, sizeof (tbuff1), "%a %b %d, %Y %r", tm_date);
  strftime (tbuff2, sizeof (tbuff2), "%D", tm_date);
  printf ("/*****************************************************************************/\n");
  printf ("/*   Cflags.c: generated by mkcflags on %s         */\n", tbuff1);
  printf ("/*****************************************************************************/\n");
  printf ("#include \"config.h\"\n");
  printf ("#include <time.h>\n");
  printf ("#include INC_SYS_TIME\n\n");
  printf ("char cflags[]=\"%s\";\n", argv[1]);
  printf ("char arch[]=\"%s\";\n", argv[2]);
  printf ("char cdate[]=\"%s\";\n", tbuff2);
  printf ("struct timeval tv_ctime={%u,0};\n", (int) seconds);
  printf ("char cbugs[]=\"feedback to: quozl@us.netrek.org\";\n");
  printf ("char cowid[]=\"%s\";\n", pigcallresp (pigcall, tbuff2, argv[2]));
  exit (0);
}

/* slightly modified pigcallresp */
char *
pigcallresp (pigcall, cdate, arch)
     char *pigcall;
     char *cdate;
     char *arch;
{
  sprintf (pigcall, "%s.%d, %s, %s, ", version, PATCHLEVEL, arch, cdate);
  /* ack .... gross short hand fomulas for compile options!!! */

#ifdef RSA
  strcat (pigcall, "R");
#endif

#ifdef NBT
  strcat (pigcall, "M");
#endif

#ifdef DEBUG
  strcat (pigcall, "D");
#endif

#ifdef CORRUPTED_PACKETS
  strcat (pigcall, "C");
#endif

#ifdef SHORT_PACKETS
  strcat (pigcall, "S");
#endif

#ifdef EXPIRE
  sprintf (buf, "E%d", EXPIRE);
  strcat (pigcall, buf);
#endif

#ifdef ARMY_SLIDER
  strcat (pigcall, "A");
#endif

#ifdef META
  strcat (pigcall, "m");
#endif

#ifdef TOOLS
  strcat (pigcall, "T");
#endif

#ifdef SOUND
  strcat (pigcall, "s");
#endif

#ifdef RCD
  strcat (pigcall, "r");
#endif

  strcat (pigcall, "P");

  return (pigcall);
}
