/* This is part of the netCDF package. Copyright 2005-2018 University
   Corporation for Atmospheric Research/Unidata See COPYRIGHT file for
   conditions of use.

   This program creates some files with lots of metadata, and then
   times the opening and closing of the files. The files used are
   real-world examples provided by users. The code used to generate
   the files comes from ncgen.

   Ed Hartnett

*/

#include <nc_tests.h>
#include "err_macros.h"
#include <time.h>
#include <sys/time.h>
#include <unistd.h>

#define FILE_NAME "tst_wrf_reads.nc"

/* Prototype from tst_utils.c. */
int nc4_timeval_subtract(struct timeval *result, struct timeval *x,
                         struct timeval *y);

extern const char* nc_strerror(int ncerr);

void
check_err(const int stat, const int line, const char *file) {
   if (stat != NC_NOERR) {
      (void)fprintf(stderr,"line %d of %s: %s\n", line, file, nc_strerror(stat));
      fflush(stderr);
      exit(1);
   }
}

int
create_wrf_chem_file(char *file_name, int cmode)
{
    int  stat;  /* return status */
    int  ncid;  /* netCDF id */

    /* group ids */
    int wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp;

    /* dimension ids */
    int Time_dim;
    int DateStrLen_dim;
    int west_east_dim;
    int south_north_dim;
    int bottom_top_dim;
    int bottom_top_stag_dim;
    int soil_layers_stag_dim;
    int west_east_stag_dim;
    int south_north_stag_dim;
    int dust_erosion_dimension_dim;
    int klevs_for_dust_dim;
    int bio_emissions_dimension_stag_dim;
    int klevs_for_dvel_dim;

    /* dimension lengths */
    size_t Time_len = NC_UNLIMITED;
    size_t DateStrLen_len = 19;
    size_t west_east_len = 648;
    size_t south_north_len = 647;
    size_t bottom_top_len = 50;
    size_t bottom_top_stag_len = 51;
    size_t soil_layers_stag_len = 4;
    size_t west_east_stag_len = 649;
    size_t south_north_stag_len = 648;
    size_t dust_erosion_dimension_len = 3;
    size_t klevs_for_dust_len = 1;
    size_t bio_emissions_dimension_stag_len = 110;
    size_t klevs_for_dvel_len = 1;

    /* variable ids */
    int Times_id;
    int XLAT_id;
    int XLONG_id;
    int LU_INDEX_id;
    int ZNU_id;
    int ZNW_id;
    int ZS_id;
    int DZS_id;
    int VAR_SSO_id;
    int U_id;
    int V_id;
    int W_id;
    int PH_id;
    int PHB_id;
    int T_id;
    int HFX_FORCE_id;
    int LH_FORCE_id;
    int TSK_FORCE_id;
    int HFX_FORCE_TEND_id;
    int LH_FORCE_TEND_id;
    int TSK_FORCE_TEND_id;
    int MU_id;
    int MUB_id;
    int NEST_POS_id;
    int P_id;
    int PB_id;
    int FNM_id;
    int FNP_id;
    int RDNW_id;
    int RDN_id;
    int DNW_id;
    int DN_id;
    int CFN_id;
    int CFN1_id;
    int THIS_IS_AN_IDEAL_RUN_id;
    int P_HYD_id;
    int Q2_id;
    int T2_id;
    int TH2_id;
    int PSFC_id;
    int U10_id;
    int V10_id;
    int RDX_id;
    int RDY_id;
    int RESM_id;
    int ZETATOP_id;
    int CF1_id;
    int CF2_id;
    int CF3_id;
    int ITIMESTEP_id;
    int XTIME_id;
    int QVAPOR_id;
    int QCLOUD_id;
    int QRAIN_id;
    int QICE_id;
    int QSNOW_id;
    int QGRAUP_id;
    int QNWFA2D_id;
    int QNICE_id;
    int QNRAIN_id;
    int QNCLOUD_id;
    int QNWFA_id;
    int QNIFA_id;
    int SHDMAX_id;
    int SHDMIN_id;
    int SNOALB_id;
    int TSLB_id;
    int SMOIS_id;
    int SH2O_id;
    int SMCREL_id;
    int SEAICE_id;
    int XICEM_id;
    int SFROFF_id;
    int UDROFF_id;
    int IVGTYP_id;
    int ISLTYP_id;
    int VEGFRA_id;
    int GRDFLX_id;
    int ACGRDFLX_id;
    int ACSNOM_id;
    int SNOW_id;
    int SNOWH_id;
    int CANWAT_id;
    int SSTSK_id;
    int COSZEN_id;
    int LAI_id;
    int EDMF_A_id;
    int EDMF_W_id;
    int EDMF_THL_id;
    int EDMF_QT_id;
    int EDMF_ENT_id;
    int EDMF_QC_id;
    int VAR_id;
    int O3RAD_id;
    int MAPFAC_M_id;
    int MAPFAC_U_id;
    int MAPFAC_V_id;
    int MAPFAC_MX_id;
    int MAPFAC_MY_id;
    int MAPFAC_UX_id;
    int MAPFAC_UY_id;
    int MAPFAC_VX_id;
    int MF_VX_INV_id;
    int MAPFAC_VY_id;
    int F_id;
    int E_id;
    int SINALPHA_id;
    int COSALPHA_id;
    int HGT_id;
    int TSK_id;
    int P_TOP_id;
    int T00_id;
    int P00_id;
    int TLP_id;
    int TISO_id;
    int TLP_STRAT_id;
    int P_STRAT_id;
    int MAX_MSTFX_id;
    int MAX_MSTFY_id;
    int RAINC_id;
    int RAINSH_id;
    int RAINNC_id;
    int SNOWNC_id;
    int GRAUPELNC_id;
    int HAILNC_id;
    int CLDFRA_id;
    int SWDOWN_id;
    int GLW_id;
    int SWNORM_id;
    int TAOD5502D_id;
    int ACSWUPT_id;
    int ACSWUPTC_id;
    int ACSWDNT_id;
    int ACSWDNTC_id;
    int ACSWUPB_id;
    int ACSWUPBC_id;
    int ACSWDNB_id;
    int ACSWDNBC_id;
    int ACLWUPT_id;
    int ACLWUPTC_id;
    int ACLWDNT_id;
    int ACLWDNTC_id;
    int ACLWUPB_id;
    int ACLWUPBC_id;
    int ACLWDNB_id;
    int ACLWDNBC_id;
    int SWUPT_id;
    int SWUPTC_id;
    int SWDNT_id;
    int SWDNTC_id;
    int SWUPB_id;
    int SWUPBC_id;
    int SWDNB_id;
    int SWDNBC_id;
    int LWUPT_id;
    int LWUPTC_id;
    int LWDNT_id;
    int LWDNTC_id;
    int LWUPB_id;
    int LWUPBC_id;
    int LWDNB_id;
    int LWDNBC_id;
    int OLR_id;
    int XLAT_U_id;
    int XLONG_U_id;
    int XLAT_V_id;
    int XLONG_V_id;
    int ALBEDO_id;
    int CLAT_id;
    int ALBBCK_id;
    int EMISS_id;
    int NOAHRES_id;
    int TMN_id;
    int XLAND_id;
    int UST_id;
    int PBLH_id;
    int HFX_id;
    int QFX_id;
    int LH_id;
    int ACHFX_id;
    int ACLHF_id;
    int SNOWC_id;
    int SR_id;
    int SAVE_TOPO_FROM_REAL_id;
    int PREC_ACC_C_id;
    int PREC_ACC_NC_id;
    int SNOW_ACC_NC_id;
    int EROD_id;
    int CLDFRA2_id;
    int RAINPROD_id;
    int EVAPPROD_id;
    int UST_T_id;
    int ROUGH_COR_id;
    int SMOIS_COR_id;
    int DUSTLOAD_1_id;
    int DUSTLOAD_2_id;
    int DUSTLOAD_3_id;
    int DUSTLOAD_4_id;
    int DUSTLOAD_5_id;
    int DRYDEPVEL_id;
    int GRASET_1_id;
    int GRASET_2_id;
    int GRASET_3_id;
    int GRASET_4_id;
    int GRASET_5_id;
    int DRYDEP_1_id;
    int DRYDEP_2_id;
    int DRYDEP_3_id;
    int DRYDEP_4_id;
    int DRYDEP_5_id;
    int EDUST1_id;
    int EDUST2_id;
    int EDUST3_id;
    int EDUST4_id;
    int EDUST5_id;
    int ebu_oc_id;
    int MEAN_FCT_AGTF_id;
    int MEAN_FCT_AGEF_id;
    int MEAN_FCT_AGSV_id;
    int MEAN_FCT_AGGR_id;
    int FIRESIZE_AGTF_id;
    int FIRESIZE_AGEF_id;
    int FIRESIZE_AGSV_id;
    int FIRESIZE_AGGR_id;
    int EXTCOF55_id;
    int DRY_DEP_LEN_id;
    int DRY_DEP_FLUX_id;
    int WET_DEP_FLUX_id;
    int EBIO_ISO_id;
    int EBIO_API_id;
    int LAI_VEGMASK_id;
    int dvel_o3_id;
    int PM2_5_DRY_id;
    int PM10_id;
    int DMS_0_id;
    int PHOTR201_id;
    int PHOTR202_id;
    int PHOTR203_id;
    int so2_id;
    int sulf_id;
    int no2_id;
    int no_id;
    int o3_id;
    int hno3_id;
    int h2o2_id;
    int ald_id;
    int hcho_id;
    int op1_id;
    int op2_id;
    int paa_id;
    int ora1_id;
    int ora2_id;
    int nh3_id;
    int n2o5_id;
    int no3_id;
    int pan_id;
    int hc3_id;
    int hc5_id;
    int hc8_id;
    int eth_id;
    int co_id;
    int ete_id;
    int olt_id;
    int oli_id;
    int tol_id;
    int xyl_id;
    int aco3_id;
    int tpan_id;
    int hono_id;
    int hno4_id;
    int ket_id;
    int gly_id;
    int mgly_id;
    int dcb_id;
    int onit_id;
    int csl_id;
    int iso_id;
    int co2_id;
    int ch4_id;
    int udd_id;
    int hket_id;
    int api_id;
    int lim_id;
    int dien_id;
    int macr_id;
    int hace_id;
    int ishp_id;
    int ison_id;
    int mahp_id;
    int mpan_id;
    int nald_id;
    int sesq_id;
    int mbo_id;
    int cvasoa1_id;
    int cvasoa2_id;
    int cvasoa3_id;
    int cvasoa4_id;
    int cvbsoa1_id;
    int cvbsoa2_id;
    int cvbsoa3_id;
    int cvbsoa4_id;
    int ho_id;
    int ho2_id;
    int so4aj_id;
    int so4ai_id;
    int nh4aj_id;
    int nh4ai_id;
    int no3aj_id;
    int no3ai_id;
    int naaj_id;
    int naai_id;
    int claj_id;
    int clai_id;
    int asoa1j_id;
    int asoa1i_id;
    int asoa2j_id;
    int asoa2i_id;
    int asoa3j_id;
    int asoa3i_id;
    int asoa4j_id;
    int asoa4i_id;
    int bsoa1j_id;
    int bsoa1i_id;
    int bsoa2j_id;
    int bsoa2i_id;
    int bsoa3j_id;
    int bsoa3i_id;
    int bsoa4j_id;
    int bsoa4i_id;
    int orgpaj_id;
    int orgpai_id;
    int ecj_id;
    int eci_id;
    int p25j_id;
    int p25i_id;
    int antha_id;
    int seas_id;
    int soila_id;
    int nu0_id;
    int ac0_id;
    int corn_id;
    int ISEEDARR_SPPT_id;
    int ISEEDARR_SKEBS_id;
    int ISEEDARR_RAND_PERTURB_id;
    int ISEEDARRAY_SPP_CONV_id;
    int ISEEDARRAY_SPP_PBL_id;
    int ISEEDARRAY_SPP_LSM_id;
    int BF_id;
    int C1H_id;
    int C2H_id;
    int BH_id;
    int C1F_id;
    int C2F_id;
    int C3H_id;
    int C4H_id;
    int C3F_id;
    int C4F_id;
    int PCB_id;
    int PC_id;
    int LANDMASK_id;
    int LAKEMASK_id;
    int SST_id;
    int SST_INPUT_id;

    /* rank (number of dimensions) for each variable */
#   define RANK_Times 2
#   define RANK_XLAT 3
#   define RANK_XLONG 3
#   define RANK_LU_INDEX 3
#   define RANK_ZNU 2
#   define RANK_ZNW 2
#   define RANK_ZS 2
#   define RANK_DZS 2
#   define RANK_VAR_SSO 3
#   define RANK_U 4
#   define RANK_V 4
#   define RANK_W 4
#   define RANK_PH 4
#   define RANK_PHB 4
#   define RANK_T 4
#   define RANK_HFX_FORCE 1
#   define RANK_LH_FORCE 1
#   define RANK_TSK_FORCE 1
#   define RANK_HFX_FORCE_TEND 1
#   define RANK_LH_FORCE_TEND 1
#   define RANK_TSK_FORCE_TEND 1
#   define RANK_MU 3
#   define RANK_MUB 3
#   define RANK_NEST_POS 3
#   define RANK_P 4
#   define RANK_PB 4
#   define RANK_FNM 2
#   define RANK_FNP 2
#   define RANK_RDNW 2
#   define RANK_RDN 2
#   define RANK_DNW 2
#   define RANK_DN 2
#   define RANK_CFN 1
#   define RANK_CFN1 1
#   define RANK_THIS_IS_AN_IDEAL_RUN 1
#   define RANK_P_HYD 4
#   define RANK_Q2 3
#   define RANK_T2 3
#   define RANK_TH2 3
#   define RANK_PSFC 3
#   define RANK_U10 3
#   define RANK_V10 3
#   define RANK_RDX 1
#   define RANK_RDY 1
#   define RANK_RESM 1
#   define RANK_ZETATOP 1
#   define RANK_CF1 1
#   define RANK_CF2 1
#   define RANK_CF3 1
#   define RANK_ITIMESTEP 1
#   define RANK_XTIME 1
#   define RANK_QVAPOR 4
#   define RANK_QCLOUD 4
#   define RANK_QRAIN 4
#   define RANK_QICE 4
#   define RANK_QSNOW 4
#   define RANK_QGRAUP 4
#   define RANK_QNWFA2D 3
#   define RANK_QNICE 4
#   define RANK_QNRAIN 4
#   define RANK_QNCLOUD 4
#   define RANK_QNWFA 4
#   define RANK_QNIFA 4
#   define RANK_SHDMAX 3
#   define RANK_SHDMIN 3
#   define RANK_SNOALB 3
#   define RANK_TSLB 4
#   define RANK_SMOIS 4
#   define RANK_SH2O 4
#   define RANK_SMCREL 4
#   define RANK_SEAICE 3
#   define RANK_XICEM 3
#   define RANK_SFROFF 3
#   define RANK_UDROFF 3
#   define RANK_IVGTYP 3
#   define RANK_ISLTYP 3
#   define RANK_VEGFRA 3
#   define RANK_GRDFLX 3
#   define RANK_ACGRDFLX 3
#   define RANK_ACSNOM 3
#   define RANK_SNOW 3
#   define RANK_SNOWH 3
#   define RANK_CANWAT 3
#   define RANK_SSTSK 3
#   define RANK_COSZEN 3
#   define RANK_LAI 3
#   define RANK_EDMF_A 4
#   define RANK_EDMF_W 4
#   define RANK_EDMF_THL 4
#   define RANK_EDMF_QT 4
#   define RANK_EDMF_ENT 4
#   define RANK_EDMF_QC 4
#   define RANK_VAR 3
#   define RANK_O3RAD 4
#   define RANK_MAPFAC_M 3
#   define RANK_MAPFAC_U 3
#   define RANK_MAPFAC_V 3
#   define RANK_MAPFAC_MX 3
#   define RANK_MAPFAC_MY 3
#   define RANK_MAPFAC_UX 3
#   define RANK_MAPFAC_UY 3
#   define RANK_MAPFAC_VX 3
#   define RANK_MF_VX_INV 3
#   define RANK_MAPFAC_VY 3
#   define RANK_F 3
#   define RANK_E 3
#   define RANK_SINALPHA 3
#   define RANK_COSALPHA 3
#   define RANK_HGT 3
#   define RANK_TSK 3
#   define RANK_P_TOP 1
#   define RANK_T00 1
#   define RANK_P00 1
#   define RANK_TLP 1
#   define RANK_TISO 1
#   define RANK_TLP_STRAT 1
#   define RANK_P_STRAT 1
#   define RANK_MAX_MSTFX 1
#   define RANK_MAX_MSTFY 1
#   define RANK_RAINC 3
#   define RANK_RAINSH 3
#   define RANK_RAINNC 3
#   define RANK_SNOWNC 3
#   define RANK_GRAUPELNC 3
#   define RANK_HAILNC 3
#   define RANK_CLDFRA 4
#   define RANK_SWDOWN 3
#   define RANK_GLW 3
#   define RANK_SWNORM 3
#   define RANK_TAOD5502D 3
#   define RANK_ACSWUPT 3
#   define RANK_ACSWUPTC 3
#   define RANK_ACSWDNT 3
#   define RANK_ACSWDNTC 3
#   define RANK_ACSWUPB 3
#   define RANK_ACSWUPBC 3
#   define RANK_ACSWDNB 3
#   define RANK_ACSWDNBC 3
#   define RANK_ACLWUPT 3
#   define RANK_ACLWUPTC 3
#   define RANK_ACLWDNT 3
#   define RANK_ACLWDNTC 3
#   define RANK_ACLWUPB 3
#   define RANK_ACLWUPBC 3
#   define RANK_ACLWDNB 3
#   define RANK_ACLWDNBC 3
#   define RANK_SWUPT 3
#   define RANK_SWUPTC 3
#   define RANK_SWDNT 3
#   define RANK_SWDNTC 3
#   define RANK_SWUPB 3
#   define RANK_SWUPBC 3
#   define RANK_SWDNB 3
#   define RANK_SWDNBC 3
#   define RANK_LWUPT 3
#   define RANK_LWUPTC 3
#   define RANK_LWDNT 3
#   define RANK_LWDNTC 3
#   define RANK_LWUPB 3
#   define RANK_LWUPBC 3
#   define RANK_LWDNB 3
#   define RANK_LWDNBC 3
#   define RANK_OLR 3
#   define RANK_XLAT_U 3
#   define RANK_XLONG_U 3
#   define RANK_XLAT_V 3
#   define RANK_XLONG_V 3
#   define RANK_ALBEDO 3
#   define RANK_CLAT 3
#   define RANK_ALBBCK 3
#   define RANK_EMISS 3
#   define RANK_NOAHRES 3
#   define RANK_TMN 3
#   define RANK_XLAND 3
#   define RANK_UST 3
#   define RANK_PBLH 3
#   define RANK_HFX 3
#   define RANK_QFX 3
#   define RANK_LH 3
#   define RANK_ACHFX 3
#   define RANK_ACLHF 3
#   define RANK_SNOWC 3
#   define RANK_SR 3
#   define RANK_SAVE_TOPO_FROM_REAL 1
#   define RANK_PREC_ACC_C 3
#   define RANK_PREC_ACC_NC 3
#   define RANK_SNOW_ACC_NC 3
#   define RANK_EROD 4
#   define RANK_CLDFRA2 4
#   define RANK_RAINPROD 4
#   define RANK_EVAPPROD 4
#   define RANK_UST_T 3
#   define RANK_ROUGH_COR 3
#   define RANK_SMOIS_COR 3
#   define RANK_DUSTLOAD_1 3
#   define RANK_DUSTLOAD_2 3
#   define RANK_DUSTLOAD_3 3
#   define RANK_DUSTLOAD_4 3
#   define RANK_DUSTLOAD_5 3
#   define RANK_DRYDEPVEL 3
#   define RANK_GRASET_1 3
#   define RANK_GRASET_2 3
#   define RANK_GRASET_3 3
#   define RANK_GRASET_4 3
#   define RANK_GRASET_5 3
#   define RANK_DRYDEP_1 3
#   define RANK_DRYDEP_2 3
#   define RANK_DRYDEP_3 3
#   define RANK_DRYDEP_4 3
#   define RANK_DRYDEP_5 3
#   define RANK_EDUST1 4
#   define RANK_EDUST2 4
#   define RANK_EDUST3 4
#   define RANK_EDUST4 4
#   define RANK_EDUST5 4
#   define RANK_ebu_oc 4
#   define RANK_MEAN_FCT_AGTF 3
#   define RANK_MEAN_FCT_AGEF 3
#   define RANK_MEAN_FCT_AGSV 3
#   define RANK_MEAN_FCT_AGGR 3
#   define RANK_FIRESIZE_AGTF 3
#   define RANK_FIRESIZE_AGEF 3
#   define RANK_FIRESIZE_AGSV 3
#   define RANK_FIRESIZE_AGGR 3
#   define RANK_EXTCOF55 4
#   define RANK_DRY_DEP_LEN 4
#   define RANK_DRY_DEP_FLUX 4
#   define RANK_WET_DEP_FLUX 4
#   define RANK_EBIO_ISO 3
#   define RANK_EBIO_API 3
#   define RANK_LAI_VEGMASK 3
#   define RANK_dvel_o3 4
#   define RANK_PM2_5_DRY 4
#   define RANK_PM10 4
#   define RANK_DMS_0 3
#   define RANK_PHOTR201 4
#   define RANK_PHOTR202 4
#   define RANK_PHOTR203 4
#   define RANK_so2 4
#   define RANK_sulf 4
#   define RANK_no2 4
#   define RANK_no 4
#   define RANK_o3 4
#   define RANK_hno3 4
#   define RANK_h2o2 4
#   define RANK_ald 4
#   define RANK_hcho 4
#   define RANK_op1 4
#   define RANK_op2 4
#   define RANK_paa 4
#   define RANK_ora1 4
#   define RANK_ora2 4
#   define RANK_nh3 4
#   define RANK_n2o5 4
#   define RANK_no3 4
#   define RANK_pan 4
#   define RANK_hc3 4
#   define RANK_hc5 4
#   define RANK_hc8 4
#   define RANK_eth 4
#   define RANK_co 4
#   define RANK_ete 4
#   define RANK_olt 4
#   define RANK_oli 4
#   define RANK_tol 4
#   define RANK_xyl 4
#   define RANK_aco3 4
#   define RANK_tpan 4
#   define RANK_hono 4
#   define RANK_hno4 4
#   define RANK_ket 4
#   define RANK_gly 4
#   define RANK_mgly 4
#   define RANK_dcb 4
#   define RANK_onit 4
#   define RANK_csl 4
#   define RANK_iso 4
#   define RANK_co2 4
#   define RANK_ch4 4
#   define RANK_udd 4
#   define RANK_hket 4
#   define RANK_api 4
#   define RANK_lim 4
#   define RANK_dien 4
#   define RANK_macr 4
#   define RANK_hace 4
#   define RANK_ishp 4
#   define RANK_ison 4
#   define RANK_mahp 4
#   define RANK_mpan 4
#   define RANK_nald 4
#   define RANK_sesq 4
#   define RANK_mbo 4
#   define RANK_cvasoa1 4
#   define RANK_cvasoa2 4
#   define RANK_cvasoa3 4
#   define RANK_cvasoa4 4
#   define RANK_cvbsoa1 4
#   define RANK_cvbsoa2 4
#   define RANK_cvbsoa3 4
#   define RANK_cvbsoa4 4
#   define RANK_ho 4
#   define RANK_ho2 4
#   define RANK_so4aj 4
#   define RANK_so4ai 4
#   define RANK_nh4aj 4
#   define RANK_nh4ai 4
#   define RANK_no3aj 4
#   define RANK_no3ai 4
#   define RANK_naaj 4
#   define RANK_naai 4
#   define RANK_claj 4
#   define RANK_clai 4
#   define RANK_asoa1j 4
#   define RANK_asoa1i 4
#   define RANK_asoa2j 4
#   define RANK_asoa2i 4
#   define RANK_asoa3j 4
#   define RANK_asoa3i 4
#   define RANK_asoa4j 4
#   define RANK_asoa4i 4
#   define RANK_bsoa1j 4
#   define RANK_bsoa1i 4
#   define RANK_bsoa2j 4
#   define RANK_bsoa2i 4
#   define RANK_bsoa3j 4
#   define RANK_bsoa3i 4
#   define RANK_bsoa4j 4
#   define RANK_bsoa4i 4
#   define RANK_orgpaj 4
#   define RANK_orgpai 4
#   define RANK_ecj 4
#   define RANK_eci 4
#   define RANK_p25j 4
#   define RANK_p25i 4
#   define RANK_antha 4
#   define RANK_seas 4
#   define RANK_soila 4
#   define RANK_nu0 4
#   define RANK_ac0 4
#   define RANK_corn 4
#   define RANK_ISEEDARR_SPPT 2
#   define RANK_ISEEDARR_SKEBS 2
#   define RANK_ISEEDARR_RAND_PERTURB 2
#   define RANK_ISEEDARRAY_SPP_CONV 2
#   define RANK_ISEEDARRAY_SPP_PBL 2
#   define RANK_ISEEDARRAY_SPP_LSM 2
#   define RANK_BF 2
#   define RANK_C1H 2
#   define RANK_C2H 2
#   define RANK_BH 2
#   define RANK_C1F 2
#   define RANK_C2F 2
#   define RANK_C3H 2
#   define RANK_C4H 2
#   define RANK_C3F 2
#   define RANK_C4F 2
#   define RANK_PCB 3
#   define RANK_PC 3
#   define RANK_LANDMASK 3
#   define RANK_LAKEMASK 3
#   define RANK_SST 3
#   define RANK_SST_INPUT 3

    /* variable shapes */
    int Times_dims[RANK_Times];
    int XLAT_dims[RANK_XLAT];
    int XLONG_dims[RANK_XLONG];
    int LU_INDEX_dims[RANK_LU_INDEX];
    int ZNU_dims[RANK_ZNU];
    int ZNW_dims[RANK_ZNW];
    int ZS_dims[RANK_ZS];
    int DZS_dims[RANK_DZS];
    int VAR_SSO_dims[RANK_VAR_SSO];
    int U_dims[RANK_U];
    int V_dims[RANK_V];
    int W_dims[RANK_W];
    int PH_dims[RANK_PH];
    int PHB_dims[RANK_PHB];
    int T_dims[RANK_T];
    int HFX_FORCE_dims[RANK_HFX_FORCE];
    int LH_FORCE_dims[RANK_LH_FORCE];
    int TSK_FORCE_dims[RANK_TSK_FORCE];
    int HFX_FORCE_TEND_dims[RANK_HFX_FORCE_TEND];
    int LH_FORCE_TEND_dims[RANK_LH_FORCE_TEND];
    int TSK_FORCE_TEND_dims[RANK_TSK_FORCE_TEND];
    int MU_dims[RANK_MU];
    int MUB_dims[RANK_MUB];
    int NEST_POS_dims[RANK_NEST_POS];
    int P_dims[RANK_P];
    int PB_dims[RANK_PB];
    int FNM_dims[RANK_FNM];
    int FNP_dims[RANK_FNP];
    int RDNW_dims[RANK_RDNW];
    int RDN_dims[RANK_RDN];
    int DNW_dims[RANK_DNW];
    int DN_dims[RANK_DN];
    int CFN_dims[RANK_CFN];
    int CFN1_dims[RANK_CFN1];
    int THIS_IS_AN_IDEAL_RUN_dims[RANK_THIS_IS_AN_IDEAL_RUN];
    int P_HYD_dims[RANK_P_HYD];
    int Q2_dims[RANK_Q2];
    int T2_dims[RANK_T2];
    int TH2_dims[RANK_TH2];
    int PSFC_dims[RANK_PSFC];
    int U10_dims[RANK_U10];
    int V10_dims[RANK_V10];
    int RDX_dims[RANK_RDX];
    int RDY_dims[RANK_RDY];
    int RESM_dims[RANK_RESM];
    int ZETATOP_dims[RANK_ZETATOP];
    int CF1_dims[RANK_CF1];
    int CF2_dims[RANK_CF2];
    int CF3_dims[RANK_CF3];
    int ITIMESTEP_dims[RANK_ITIMESTEP];
    int XTIME_dims[RANK_XTIME];
    int QVAPOR_dims[RANK_QVAPOR];
    int QCLOUD_dims[RANK_QCLOUD];
    int QRAIN_dims[RANK_QRAIN];
    int QICE_dims[RANK_QICE];
    int QSNOW_dims[RANK_QSNOW];
    int QGRAUP_dims[RANK_QGRAUP];
    int QNWFA2D_dims[RANK_QNWFA2D];
    int QNICE_dims[RANK_QNICE];
    int QNRAIN_dims[RANK_QNRAIN];
    int QNCLOUD_dims[RANK_QNCLOUD];
    int QNWFA_dims[RANK_QNWFA];
    int QNIFA_dims[RANK_QNIFA];
    int SHDMAX_dims[RANK_SHDMAX];
    int SHDMIN_dims[RANK_SHDMIN];
    int SNOALB_dims[RANK_SNOALB];
    int TSLB_dims[RANK_TSLB];
    int SMOIS_dims[RANK_SMOIS];
    int SH2O_dims[RANK_SH2O];
    int SMCREL_dims[RANK_SMCREL];
    int SEAICE_dims[RANK_SEAICE];
    int XICEM_dims[RANK_XICEM];
    int SFROFF_dims[RANK_SFROFF];
    int UDROFF_dims[RANK_UDROFF];
    int IVGTYP_dims[RANK_IVGTYP];
    int ISLTYP_dims[RANK_ISLTYP];
    int VEGFRA_dims[RANK_VEGFRA];
    int GRDFLX_dims[RANK_GRDFLX];
    int ACGRDFLX_dims[RANK_ACGRDFLX];
    int ACSNOM_dims[RANK_ACSNOM];
    int SNOW_dims[RANK_SNOW];
    int SNOWH_dims[RANK_SNOWH];
    int CANWAT_dims[RANK_CANWAT];
    int SSTSK_dims[RANK_SSTSK];
    int COSZEN_dims[RANK_COSZEN];
    int LAI_dims[RANK_LAI];
    int EDMF_A_dims[RANK_EDMF_A];
    int EDMF_W_dims[RANK_EDMF_W];
    int EDMF_THL_dims[RANK_EDMF_THL];
    int EDMF_QT_dims[RANK_EDMF_QT];
    int EDMF_ENT_dims[RANK_EDMF_ENT];
    int EDMF_QC_dims[RANK_EDMF_QC];
    int VAR_dims[RANK_VAR];
    int O3RAD_dims[RANK_O3RAD];
    int MAPFAC_M_dims[RANK_MAPFAC_M];
    int MAPFAC_U_dims[RANK_MAPFAC_U];
    int MAPFAC_V_dims[RANK_MAPFAC_V];
    int MAPFAC_MX_dims[RANK_MAPFAC_MX];
    int MAPFAC_MY_dims[RANK_MAPFAC_MY];
    int MAPFAC_UX_dims[RANK_MAPFAC_UX];
    int MAPFAC_UY_dims[RANK_MAPFAC_UY];
    int MAPFAC_VX_dims[RANK_MAPFAC_VX];
    int MF_VX_INV_dims[RANK_MF_VX_INV];
    int MAPFAC_VY_dims[RANK_MAPFAC_VY];
    int F_dims[RANK_F];
    int E_dims[RANK_E];
    int SINALPHA_dims[RANK_SINALPHA];
    int COSALPHA_dims[RANK_COSALPHA];
    int HGT_dims[RANK_HGT];
    int TSK_dims[RANK_TSK];
    int P_TOP_dims[RANK_P_TOP];
    int T00_dims[RANK_T00];
    int P00_dims[RANK_P00];
    int TLP_dims[RANK_TLP];
    int TISO_dims[RANK_TISO];
    int TLP_STRAT_dims[RANK_TLP_STRAT];
    int P_STRAT_dims[RANK_P_STRAT];
    int MAX_MSTFX_dims[RANK_MAX_MSTFX];
    int MAX_MSTFY_dims[RANK_MAX_MSTFY];
    int RAINC_dims[RANK_RAINC];
    int RAINSH_dims[RANK_RAINSH];
    int RAINNC_dims[RANK_RAINNC];
    int SNOWNC_dims[RANK_SNOWNC];
    int GRAUPELNC_dims[RANK_GRAUPELNC];
    int HAILNC_dims[RANK_HAILNC];
    int CLDFRA_dims[RANK_CLDFRA];
    int SWDOWN_dims[RANK_SWDOWN];
    int GLW_dims[RANK_GLW];
    int SWNORM_dims[RANK_SWNORM];
    int TAOD5502D_dims[RANK_TAOD5502D];
    int ACSWUPT_dims[RANK_ACSWUPT];
    int ACSWUPTC_dims[RANK_ACSWUPTC];
    int ACSWDNT_dims[RANK_ACSWDNT];
    int ACSWDNTC_dims[RANK_ACSWDNTC];
    int ACSWUPB_dims[RANK_ACSWUPB];
    int ACSWUPBC_dims[RANK_ACSWUPBC];
    int ACSWDNB_dims[RANK_ACSWDNB];
    int ACSWDNBC_dims[RANK_ACSWDNBC];
    int ACLWUPT_dims[RANK_ACLWUPT];
    int ACLWUPTC_dims[RANK_ACLWUPTC];
    int ACLWDNT_dims[RANK_ACLWDNT];
    int ACLWDNTC_dims[RANK_ACLWDNTC];
    int ACLWUPB_dims[RANK_ACLWUPB];
    int ACLWUPBC_dims[RANK_ACLWUPBC];
    int ACLWDNB_dims[RANK_ACLWDNB];
    int ACLWDNBC_dims[RANK_ACLWDNBC];
    int SWUPT_dims[RANK_SWUPT];
    int SWUPTC_dims[RANK_SWUPTC];
    int SWDNT_dims[RANK_SWDNT];
    int SWDNTC_dims[RANK_SWDNTC];
    int SWUPB_dims[RANK_SWUPB];
    int SWUPBC_dims[RANK_SWUPBC];
    int SWDNB_dims[RANK_SWDNB];
    int SWDNBC_dims[RANK_SWDNBC];
    int LWUPT_dims[RANK_LWUPT];
    int LWUPTC_dims[RANK_LWUPTC];
    int LWDNT_dims[RANK_LWDNT];
    int LWDNTC_dims[RANK_LWDNTC];
    int LWUPB_dims[RANK_LWUPB];
    int LWUPBC_dims[RANK_LWUPBC];
    int LWDNB_dims[RANK_LWDNB];
    int LWDNBC_dims[RANK_LWDNBC];
    int OLR_dims[RANK_OLR];
    int XLAT_U_dims[RANK_XLAT_U];
    int XLONG_U_dims[RANK_XLONG_U];
    int XLAT_V_dims[RANK_XLAT_V];
    int XLONG_V_dims[RANK_XLONG_V];
    int ALBEDO_dims[RANK_ALBEDO];
    int CLAT_dims[RANK_CLAT];
    int ALBBCK_dims[RANK_ALBBCK];
    int EMISS_dims[RANK_EMISS];
    int NOAHRES_dims[RANK_NOAHRES];
    int TMN_dims[RANK_TMN];
    int XLAND_dims[RANK_XLAND];
    int UST_dims[RANK_UST];
    int PBLH_dims[RANK_PBLH];
    int HFX_dims[RANK_HFX];
    int QFX_dims[RANK_QFX];
    int LH_dims[RANK_LH];
    int ACHFX_dims[RANK_ACHFX];
    int ACLHF_dims[RANK_ACLHF];
    int SNOWC_dims[RANK_SNOWC];
    int SR_dims[RANK_SR];
    int SAVE_TOPO_FROM_REAL_dims[RANK_SAVE_TOPO_FROM_REAL];
    int PREC_ACC_C_dims[RANK_PREC_ACC_C];
    int PREC_ACC_NC_dims[RANK_PREC_ACC_NC];
    int SNOW_ACC_NC_dims[RANK_SNOW_ACC_NC];
    int EROD_dims[RANK_EROD];
    int CLDFRA2_dims[RANK_CLDFRA2];
    int RAINPROD_dims[RANK_RAINPROD];
    int EVAPPROD_dims[RANK_EVAPPROD];
    int UST_T_dims[RANK_UST_T];
    int ROUGH_COR_dims[RANK_ROUGH_COR];
    int SMOIS_COR_dims[RANK_SMOIS_COR];
    int DUSTLOAD_1_dims[RANK_DUSTLOAD_1];
    int DUSTLOAD_2_dims[RANK_DUSTLOAD_2];
    int DUSTLOAD_3_dims[RANK_DUSTLOAD_3];
    int DUSTLOAD_4_dims[RANK_DUSTLOAD_4];
    int DUSTLOAD_5_dims[RANK_DUSTLOAD_5];
    int DRYDEPVEL_dims[RANK_DRYDEPVEL];
    int GRASET_1_dims[RANK_GRASET_1];
    int GRASET_2_dims[RANK_GRASET_2];
    int GRASET_3_dims[RANK_GRASET_3];
    int GRASET_4_dims[RANK_GRASET_4];
    int GRASET_5_dims[RANK_GRASET_5];
    int DRYDEP_1_dims[RANK_DRYDEP_1];
    int DRYDEP_2_dims[RANK_DRYDEP_2];
    int DRYDEP_3_dims[RANK_DRYDEP_3];
    int DRYDEP_4_dims[RANK_DRYDEP_4];
    int DRYDEP_5_dims[RANK_DRYDEP_5];
    int EDUST1_dims[RANK_EDUST1];
    int EDUST2_dims[RANK_EDUST2];
    int EDUST3_dims[RANK_EDUST3];
    int EDUST4_dims[RANK_EDUST4];
    int EDUST5_dims[RANK_EDUST5];
    int ebu_oc_dims[RANK_ebu_oc];
    int MEAN_FCT_AGTF_dims[RANK_MEAN_FCT_AGTF];
    int MEAN_FCT_AGEF_dims[RANK_MEAN_FCT_AGEF];
    int MEAN_FCT_AGSV_dims[RANK_MEAN_FCT_AGSV];
    int MEAN_FCT_AGGR_dims[RANK_MEAN_FCT_AGGR];
    int FIRESIZE_AGTF_dims[RANK_FIRESIZE_AGTF];
    int FIRESIZE_AGEF_dims[RANK_FIRESIZE_AGEF];
    int FIRESIZE_AGSV_dims[RANK_FIRESIZE_AGSV];
    int FIRESIZE_AGGR_dims[RANK_FIRESIZE_AGGR];
    int EXTCOF55_dims[RANK_EXTCOF55];
    int DRY_DEP_LEN_dims[RANK_DRY_DEP_LEN];
    int DRY_DEP_FLUX_dims[RANK_DRY_DEP_FLUX];
    int WET_DEP_FLUX_dims[RANK_WET_DEP_FLUX];
    int EBIO_ISO_dims[RANK_EBIO_ISO];
    int EBIO_API_dims[RANK_EBIO_API];
    int LAI_VEGMASK_dims[RANK_LAI_VEGMASK];
    int dvel_o3_dims[RANK_dvel_o3];
    int PM2_5_DRY_dims[RANK_PM2_5_DRY];
    int PM10_dims[RANK_PM10];
    int DMS_0_dims[RANK_DMS_0];
    int PHOTR201_dims[RANK_PHOTR201];
    int PHOTR202_dims[RANK_PHOTR202];
    int PHOTR203_dims[RANK_PHOTR203];
    int so2_dims[RANK_so2];
    int sulf_dims[RANK_sulf];
    int no2_dims[RANK_no2];
    int no_dims[RANK_no];
    int o3_dims[RANK_o3];
    int hno3_dims[RANK_hno3];
    int h2o2_dims[RANK_h2o2];
    int ald_dims[RANK_ald];
    int hcho_dims[RANK_hcho];
    int op1_dims[RANK_op1];
    int op2_dims[RANK_op2];
    int paa_dims[RANK_paa];
    int ora1_dims[RANK_ora1];
    int ora2_dims[RANK_ora2];
    int nh3_dims[RANK_nh3];
    int n2o5_dims[RANK_n2o5];
    int no3_dims[RANK_no3];
    int pan_dims[RANK_pan];
    int hc3_dims[RANK_hc3];
    int hc5_dims[RANK_hc5];
    int hc8_dims[RANK_hc8];
    int eth_dims[RANK_eth];
    int co_dims[RANK_co];
    int ete_dims[RANK_ete];
    int olt_dims[RANK_olt];
    int oli_dims[RANK_oli];
    int tol_dims[RANK_tol];
    int xyl_dims[RANK_xyl];
    int aco3_dims[RANK_aco3];
    int tpan_dims[RANK_tpan];
    int hono_dims[RANK_hono];
    int hno4_dims[RANK_hno4];
    int ket_dims[RANK_ket];
    int gly_dims[RANK_gly];
    int mgly_dims[RANK_mgly];
    int dcb_dims[RANK_dcb];
    int onit_dims[RANK_onit];
    int csl_dims[RANK_csl];
    int iso_dims[RANK_iso];
    int co2_dims[RANK_co2];
    int ch4_dims[RANK_ch4];
    int udd_dims[RANK_udd];
    int hket_dims[RANK_hket];
    int api_dims[RANK_api];
    int lim_dims[RANK_lim];
    int dien_dims[RANK_dien];
    int macr_dims[RANK_macr];
    int hace_dims[RANK_hace];
    int ishp_dims[RANK_ishp];
    int ison_dims[RANK_ison];
    int mahp_dims[RANK_mahp];
    int mpan_dims[RANK_mpan];
    int nald_dims[RANK_nald];
    int sesq_dims[RANK_sesq];
    int mbo_dims[RANK_mbo];
    int cvasoa1_dims[RANK_cvasoa1];
    int cvasoa2_dims[RANK_cvasoa2];
    int cvasoa3_dims[RANK_cvasoa3];
    int cvasoa4_dims[RANK_cvasoa4];
    int cvbsoa1_dims[RANK_cvbsoa1];
    int cvbsoa2_dims[RANK_cvbsoa2];
    int cvbsoa3_dims[RANK_cvbsoa3];
    int cvbsoa4_dims[RANK_cvbsoa4];
    int ho_dims[RANK_ho];
    int ho2_dims[RANK_ho2];
    int so4aj_dims[RANK_so4aj];
    int so4ai_dims[RANK_so4ai];
    int nh4aj_dims[RANK_nh4aj];
    int nh4ai_dims[RANK_nh4ai];
    int no3aj_dims[RANK_no3aj];
    int no3ai_dims[RANK_no3ai];
    int naaj_dims[RANK_naaj];
    int naai_dims[RANK_naai];
    int claj_dims[RANK_claj];
    int clai_dims[RANK_clai];
    int asoa1j_dims[RANK_asoa1j];
    int asoa1i_dims[RANK_asoa1i];
    int asoa2j_dims[RANK_asoa2j];
    int asoa2i_dims[RANK_asoa2i];
    int asoa3j_dims[RANK_asoa3j];
    int asoa3i_dims[RANK_asoa3i];
    int asoa4j_dims[RANK_asoa4j];
    int asoa4i_dims[RANK_asoa4i];
    int bsoa1j_dims[RANK_bsoa1j];
    int bsoa1i_dims[RANK_bsoa1i];
    int bsoa2j_dims[RANK_bsoa2j];
    int bsoa2i_dims[RANK_bsoa2i];
    int bsoa3j_dims[RANK_bsoa3j];
    int bsoa3i_dims[RANK_bsoa3i];
    int bsoa4j_dims[RANK_bsoa4j];
    int bsoa4i_dims[RANK_bsoa4i];
    int orgpaj_dims[RANK_orgpaj];
    int orgpai_dims[RANK_orgpai];
    int ecj_dims[RANK_ecj];
    int eci_dims[RANK_eci];
    int p25j_dims[RANK_p25j];
    int p25i_dims[RANK_p25i];
    int antha_dims[RANK_antha];
    int seas_dims[RANK_seas];
    int soila_dims[RANK_soila];
    int nu0_dims[RANK_nu0];
    int ac0_dims[RANK_ac0];
    int corn_dims[RANK_corn];
    int ISEEDARR_SPPT_dims[RANK_ISEEDARR_SPPT];
    int ISEEDARR_SKEBS_dims[RANK_ISEEDARR_SKEBS];
    int ISEEDARR_RAND_PERTURB_dims[RANK_ISEEDARR_RAND_PERTURB];
    int ISEEDARRAY_SPP_CONV_dims[RANK_ISEEDARRAY_SPP_CONV];
    int ISEEDARRAY_SPP_PBL_dims[RANK_ISEEDARRAY_SPP_PBL];
    int ISEEDARRAY_SPP_LSM_dims[RANK_ISEEDARRAY_SPP_LSM];
    int BF_dims[RANK_BF];
    int C1H_dims[RANK_C1H];
    int C2H_dims[RANK_C2H];
    int BH_dims[RANK_BH];
    int C1F_dims[RANK_C1F];
    int C2F_dims[RANK_C2F];
    int C3H_dims[RANK_C3H];
    int C4H_dims[RANK_C4H];
    int C3F_dims[RANK_C3F];
    int C4F_dims[RANK_C4F];
    int PCB_dims[RANK_PCB];
    int PC_dims[RANK_PC];
    int LANDMASK_dims[RANK_LANDMASK];
    int LAKEMASK_dims[RANK_LAKEMASK];
    int SST_dims[RANK_SST];
    int SST_INPUT_dims[RANK_SST_INPUT];

    /* enter define mode */
    stat = nc_create(file_name, NC_CLOBBER|cmode, &ncid);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_put_att_text(ncid, NC_GLOBAL, "_Format", 1, "netCDF-4"); */
    /* check_err(stat,__LINE__,__FILE__); */
    wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp = ncid;

    /* define dimensions */
    stat = nc_def_dim(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "Time", Time_len, &Time_dim);
    check_err(stat,__LINE__,__FILE__);
    stat = nc_def_dim(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "DateStrLen", DateStrLen_len, &DateStrLen_dim);
    check_err(stat,__LINE__,__FILE__);
    stat = nc_def_dim(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "west_east", west_east_len, &west_east_dim);
    check_err(stat,__LINE__,__FILE__);
    stat = nc_def_dim(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "south_north", south_north_len, &south_north_dim);
    check_err(stat,__LINE__,__FILE__);
    stat = nc_def_dim(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "bottom_top", bottom_top_len, &bottom_top_dim);
    check_err(stat,__LINE__,__FILE__);
    stat = nc_def_dim(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "bottom_top_stag", bottom_top_stag_len, &bottom_top_stag_dim);
    check_err(stat,__LINE__,__FILE__);
    stat = nc_def_dim(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "soil_layers_stag", soil_layers_stag_len, &soil_layers_stag_dim);
    check_err(stat,__LINE__,__FILE__);
    stat = nc_def_dim(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "west_east_stag", west_east_stag_len, &west_east_stag_dim);
    check_err(stat,__LINE__,__FILE__);
    stat = nc_def_dim(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "south_north_stag", south_north_stag_len, &south_north_stag_dim);
    check_err(stat,__LINE__,__FILE__);
    stat = nc_def_dim(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "dust_erosion_dimension", dust_erosion_dimension_len, &dust_erosion_dimension_dim);
    check_err(stat,__LINE__,__FILE__);
    stat = nc_def_dim(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "klevs_for_dust", klevs_for_dust_len, &klevs_for_dust_dim);
    check_err(stat,__LINE__,__FILE__);
    stat = nc_def_dim(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "bio_emissions_dimension_stag", bio_emissions_dimension_stag_len, &bio_emissions_dimension_stag_dim);
    check_err(stat,__LINE__,__FILE__);
    stat = nc_def_dim(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "klevs_for_dvel", klevs_for_dvel_len, &klevs_for_dvel_dim);
    check_err(stat,__LINE__,__FILE__);

    /* define variables */

    Times_dims[0] = Time_dim;
    Times_dims[1] = DateStrLen_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "Times", NC_CHAR, RANK_Times, Times_dims, &Times_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, Times_id, NC_CHUNKED, Times_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    XLAT_dims[0] = Time_dim;
    XLAT_dims[1] = south_north_dim;
    XLAT_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "XLAT", NC_FLOAT, RANK_XLAT, XLAT_dims, &XLAT_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_id, NC_CHUNKED, XLAT_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    XLONG_dims[0] = Time_dim;
    XLONG_dims[1] = south_north_dim;
    XLONG_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "XLONG", NC_FLOAT, RANK_XLONG, XLONG_dims, &XLONG_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_id, NC_CHUNKED, XLONG_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    LU_INDEX_dims[0] = Time_dim;
    LU_INDEX_dims[1] = south_north_dim;
    LU_INDEX_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "LU_INDEX", NC_FLOAT, RANK_LU_INDEX, LU_INDEX_dims, &LU_INDEX_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LU_INDEX_id, NC_CHUNKED, LU_INDEX_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LU_INDEX_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ZNU_dims[0] = Time_dim;
    ZNU_dims[1] = bottom_top_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ZNU", NC_FLOAT, RANK_ZNU, ZNU_dims, &ZNU_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZNU_id, NC_CHUNKED, ZNU_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    ZNW_dims[0] = Time_dim;
    ZNW_dims[1] = bottom_top_stag_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ZNW", NC_FLOAT, RANK_ZNW, ZNW_dims, &ZNW_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZNW_id, NC_CHUNKED, ZNW_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    ZS_dims[0] = Time_dim;
    ZS_dims[1] = soil_layers_stag_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ZS", NC_FLOAT, RANK_ZS, ZS_dims, &ZS_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZS_id, NC_CHUNKED, ZS_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    DZS_dims[0] = Time_dim;
    DZS_dims[1] = soil_layers_stag_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "DZS", NC_FLOAT, RANK_DZS, DZS_dims, &DZS_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DZS_id, NC_CHUNKED, DZS_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    VAR_SSO_dims[0] = Time_dim;
    VAR_SSO_dims[1] = south_north_dim;
    VAR_SSO_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "VAR_SSO", NC_FLOAT, RANK_VAR_SSO, VAR_SSO_dims, &VAR_SSO_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VAR_SSO_id, NC_CHUNKED, VAR_SSO_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VAR_SSO_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    U_dims[0] = Time_dim;
    U_dims[1] = bottom_top_dim;
    U_dims[2] = south_north_dim;
    U_dims[3] = west_east_stag_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "U", NC_FLOAT, RANK_U, U_dims, &U_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, U_id, NC_CHUNKED, U_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, U_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    V_dims[0] = Time_dim;
    V_dims[1] = bottom_top_dim;
    V_dims[2] = south_north_stag_dim;
    V_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "V", NC_FLOAT, RANK_V, V_dims, &V_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, V_id, NC_CHUNKED, V_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, V_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    W_dims[0] = Time_dim;
    W_dims[1] = bottom_top_stag_dim;
    W_dims[2] = south_north_dim;
    W_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "W", NC_FLOAT, RANK_W, W_dims, &W_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, W_id, NC_CHUNKED, W_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, W_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    PH_dims[0] = Time_dim;
    PH_dims[1] = bottom_top_stag_dim;
    PH_dims[2] = south_north_dim;
    PH_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "PH", NC_FLOAT, RANK_PH, PH_dims, &PH_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PH_id, NC_CHUNKED, PH_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PH_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    PHB_dims[0] = Time_dim;
    PHB_dims[1] = bottom_top_stag_dim;
    PHB_dims[2] = south_north_dim;
    PHB_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "PHB", NC_FLOAT, RANK_PHB, PHB_dims, &PHB_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHB_id, NC_CHUNKED, PHB_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHB_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    T_dims[0] = Time_dim;
    T_dims[1] = bottom_top_dim;
    T_dims[2] = south_north_dim;
    T_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "T", NC_FLOAT, RANK_T, T_dims, &T_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, T_id, NC_CHUNKED, T_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, T_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    HFX_FORCE_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "HFX_FORCE", NC_FLOAT, RANK_HFX_FORCE, HFX_FORCE_dims, &HFX_FORCE_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HFX_FORCE_id, NC_CHUNKED, HFX_FORCE_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    LH_FORCE_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "LH_FORCE", NC_FLOAT, RANK_LH_FORCE, LH_FORCE_dims, &LH_FORCE_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LH_FORCE_id, NC_CHUNKED, LH_FORCE_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    TSK_FORCE_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "TSK_FORCE", NC_FLOAT, RANK_TSK_FORCE, TSK_FORCE_dims, &TSK_FORCE_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSK_FORCE_id, NC_CHUNKED, TSK_FORCE_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    HFX_FORCE_TEND_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "HFX_FORCE_TEND", NC_FLOAT, RANK_HFX_FORCE_TEND, HFX_FORCE_TEND_dims, &HFX_FORCE_TEND_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HFX_FORCE_TEND_id, NC_CHUNKED, HFX_FORCE_TEND_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    LH_FORCE_TEND_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "LH_FORCE_TEND", NC_FLOAT, RANK_LH_FORCE_TEND, LH_FORCE_TEND_dims, &LH_FORCE_TEND_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LH_FORCE_TEND_id, NC_CHUNKED, LH_FORCE_TEND_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    TSK_FORCE_TEND_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "TSK_FORCE_TEND", NC_FLOAT, RANK_TSK_FORCE_TEND, TSK_FORCE_TEND_dims, &TSK_FORCE_TEND_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSK_FORCE_TEND_id, NC_CHUNKED, TSK_FORCE_TEND_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    MU_dims[0] = Time_dim;
    MU_dims[1] = south_north_dim;
    MU_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "MU", NC_FLOAT, RANK_MU, MU_dims, &MU_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MU_id, NC_CHUNKED, MU_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MU_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    MUB_dims[0] = Time_dim;
    MUB_dims[1] = south_north_dim;
    MUB_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "MUB", NC_FLOAT, RANK_MUB, MUB_dims, &MUB_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MUB_id, NC_CHUNKED, MUB_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MUB_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    NEST_POS_dims[0] = Time_dim;
    NEST_POS_dims[1] = south_north_dim;
    NEST_POS_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "NEST_POS", NC_FLOAT, RANK_NEST_POS, NEST_POS_dims, &NEST_POS_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NEST_POS_id, NC_CHUNKED, NEST_POS_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NEST_POS_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    P_dims[0] = Time_dim;
    P_dims[1] = bottom_top_dim;
    P_dims[2] = south_north_dim;
    P_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "P", NC_FLOAT, RANK_P, P_dims, &P_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_id, NC_CHUNKED, P_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    PB_dims[0] = Time_dim;
    PB_dims[1] = bottom_top_dim;
    PB_dims[2] = south_north_dim;
    PB_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "PB", NC_FLOAT, RANK_PB, PB_dims, &PB_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PB_id, NC_CHUNKED, PB_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PB_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    FNM_dims[0] = Time_dim;
    FNM_dims[1] = bottom_top_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "FNM", NC_FLOAT, RANK_FNM, FNM_dims, &FNM_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FNM_id, NC_CHUNKED, FNM_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    FNP_dims[0] = Time_dim;
    FNP_dims[1] = bottom_top_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "FNP", NC_FLOAT, RANK_FNP, FNP_dims, &FNP_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FNP_id, NC_CHUNKED, FNP_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    RDNW_dims[0] = Time_dim;
    RDNW_dims[1] = bottom_top_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "RDNW", NC_FLOAT, RANK_RDNW, RDNW_dims, &RDNW_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDNW_id, NC_CHUNKED, RDNW_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    RDN_dims[0] = Time_dim;
    RDN_dims[1] = bottom_top_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "RDN", NC_FLOAT, RANK_RDN, RDN_dims, &RDN_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDN_id, NC_CHUNKED, RDN_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    DNW_dims[0] = Time_dim;
    DNW_dims[1] = bottom_top_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "DNW", NC_FLOAT, RANK_DNW, DNW_dims, &DNW_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DNW_id, NC_CHUNKED, DNW_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    DN_dims[0] = Time_dim;
    DN_dims[1] = bottom_top_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "DN", NC_FLOAT, RANK_DN, DN_dims, &DN_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DN_id, NC_CHUNKED, DN_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    CFN_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "CFN", NC_FLOAT, RANK_CFN, CFN_dims, &CFN_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CFN_id, NC_CHUNKED, CFN_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    CFN1_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "CFN1", NC_FLOAT, RANK_CFN1, CFN1_dims, &CFN1_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CFN1_id, NC_CHUNKED, CFN1_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    THIS_IS_AN_IDEAL_RUN_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "THIS_IS_AN_IDEAL_RUN", NC_INT, RANK_THIS_IS_AN_IDEAL_RUN, THIS_IS_AN_IDEAL_RUN_dims, &THIS_IS_AN_IDEAL_RUN_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, THIS_IS_AN_IDEAL_RUN_id, NC_CHUNKED, THIS_IS_AN_IDEAL_RUN_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_endian(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, THIS_IS_AN_IDEAL_RUN_id, NC_ENDIAN_LITTLE); */
    /* check_err(stat,__LINE__,__FILE__); */

    P_HYD_dims[0] = Time_dim;
    P_HYD_dims[1] = bottom_top_dim;
    P_HYD_dims[2] = south_north_dim;
    P_HYD_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "P_HYD", NC_FLOAT, RANK_P_HYD, P_HYD_dims, &P_HYD_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_HYD_id, NC_CHUNKED, P_HYD_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_HYD_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    Q2_dims[0] = Time_dim;
    Q2_dims[1] = south_north_dim;
    Q2_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "Q2", NC_FLOAT, RANK_Q2, Q2_dims, &Q2_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, Q2_id, NC_CHUNKED, Q2_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, Q2_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    T2_dims[0] = Time_dim;
    T2_dims[1] = south_north_dim;
    T2_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "T2", NC_FLOAT, RANK_T2, T2_dims, &T2_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, T2_id, NC_CHUNKED, T2_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, T2_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    TH2_dims[0] = Time_dim;
    TH2_dims[1] = south_north_dim;
    TH2_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "TH2", NC_FLOAT, RANK_TH2, TH2_dims, &TH2_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TH2_id, NC_CHUNKED, TH2_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TH2_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    PSFC_dims[0] = Time_dim;
    PSFC_dims[1] = south_north_dim;
    PSFC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "PSFC", NC_FLOAT, RANK_PSFC, PSFC_dims, &PSFC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PSFC_id, NC_CHUNKED, PSFC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PSFC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    U10_dims[0] = Time_dim;
    U10_dims[1] = south_north_dim;
    U10_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "U10", NC_FLOAT, RANK_U10, U10_dims, &U10_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, U10_id, NC_CHUNKED, U10_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, U10_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    V10_dims[0] = Time_dim;
    V10_dims[1] = south_north_dim;
    V10_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "V10", NC_FLOAT, RANK_V10, V10_dims, &V10_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, V10_id, NC_CHUNKED, V10_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, V10_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    RDX_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "RDX", NC_FLOAT, RANK_RDX, RDX_dims, &RDX_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDX_id, NC_CHUNKED, RDX_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    RDY_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "RDY", NC_FLOAT, RANK_RDY, RDY_dims, &RDY_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDY_id, NC_CHUNKED, RDY_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    RESM_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "RESM", NC_FLOAT, RANK_RESM, RESM_dims, &RESM_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RESM_id, NC_CHUNKED, RESM_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    ZETATOP_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ZETATOP", NC_FLOAT, RANK_ZETATOP, ZETATOP_dims, &ZETATOP_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZETATOP_id, NC_CHUNKED, ZETATOP_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    CF1_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "CF1", NC_FLOAT, RANK_CF1, CF1_dims, &CF1_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CF1_id, NC_CHUNKED, CF1_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    CF2_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "CF2", NC_FLOAT, RANK_CF2, CF2_dims, &CF2_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CF2_id, NC_CHUNKED, CF2_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    CF3_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "CF3", NC_FLOAT, RANK_CF3, CF3_dims, &CF3_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CF3_id, NC_CHUNKED, CF3_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    ITIMESTEP_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ITIMESTEP", NC_INT, RANK_ITIMESTEP, ITIMESTEP_dims, &ITIMESTEP_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ITIMESTEP_id, NC_CHUNKED, ITIMESTEP_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_endian(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ITIMESTEP_id, NC_ENDIAN_LITTLE); */
    /* check_err(stat,__LINE__,__FILE__); */

    XTIME_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "XTIME", NC_FLOAT, RANK_XTIME, XTIME_dims, &XTIME_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XTIME_id, NC_CHUNKED, XTIME_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    QVAPOR_dims[0] = Time_dim;
    QVAPOR_dims[1] = bottom_top_dim;
    QVAPOR_dims[2] = south_north_dim;
    QVAPOR_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "QVAPOR", NC_FLOAT, RANK_QVAPOR, QVAPOR_dims, &QVAPOR_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QVAPOR_id, NC_CHUNKED, QVAPOR_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QVAPOR_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    QCLOUD_dims[0] = Time_dim;
    QCLOUD_dims[1] = bottom_top_dim;
    QCLOUD_dims[2] = south_north_dim;
    QCLOUD_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "QCLOUD", NC_FLOAT, RANK_QCLOUD, QCLOUD_dims, &QCLOUD_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QCLOUD_id, NC_CHUNKED, QCLOUD_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QCLOUD_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    QRAIN_dims[0] = Time_dim;
    QRAIN_dims[1] = bottom_top_dim;
    QRAIN_dims[2] = south_north_dim;
    QRAIN_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "QRAIN", NC_FLOAT, RANK_QRAIN, QRAIN_dims, &QRAIN_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QRAIN_id, NC_CHUNKED, QRAIN_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QRAIN_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    QICE_dims[0] = Time_dim;
    QICE_dims[1] = bottom_top_dim;
    QICE_dims[2] = south_north_dim;
    QICE_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "QICE", NC_FLOAT, RANK_QICE, QICE_dims, &QICE_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QICE_id, NC_CHUNKED, QICE_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QICE_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    QSNOW_dims[0] = Time_dim;
    QSNOW_dims[1] = bottom_top_dim;
    QSNOW_dims[2] = south_north_dim;
    QSNOW_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "QSNOW", NC_FLOAT, RANK_QSNOW, QSNOW_dims, &QSNOW_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QSNOW_id, NC_CHUNKED, QSNOW_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QSNOW_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    QGRAUP_dims[0] = Time_dim;
    QGRAUP_dims[1] = bottom_top_dim;
    QGRAUP_dims[2] = south_north_dim;
    QGRAUP_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "QGRAUP", NC_FLOAT, RANK_QGRAUP, QGRAUP_dims, &QGRAUP_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QGRAUP_id, NC_CHUNKED, QGRAUP_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QGRAUP_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    QNWFA2D_dims[0] = Time_dim;
    QNWFA2D_dims[1] = south_north_dim;
    QNWFA2D_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "QNWFA2D", NC_FLOAT, RANK_QNWFA2D, QNWFA2D_dims, &QNWFA2D_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNWFA2D_id, NC_CHUNKED, QNWFA2D_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNWFA2D_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    QNICE_dims[0] = Time_dim;
    QNICE_dims[1] = bottom_top_dim;
    QNICE_dims[2] = south_north_dim;
    QNICE_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "QNICE", NC_FLOAT, RANK_QNICE, QNICE_dims, &QNICE_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNICE_id, NC_CHUNKED, QNICE_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNICE_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    QNRAIN_dims[0] = Time_dim;
    QNRAIN_dims[1] = bottom_top_dim;
    QNRAIN_dims[2] = south_north_dim;
    QNRAIN_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "QNRAIN", NC_FLOAT, RANK_QNRAIN, QNRAIN_dims, &QNRAIN_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNRAIN_id, NC_CHUNKED, QNRAIN_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNRAIN_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    QNCLOUD_dims[0] = Time_dim;
    QNCLOUD_dims[1] = bottom_top_dim;
    QNCLOUD_dims[2] = south_north_dim;
    QNCLOUD_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "QNCLOUD", NC_FLOAT, RANK_QNCLOUD, QNCLOUD_dims, &QNCLOUD_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNCLOUD_id, NC_CHUNKED, QNCLOUD_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNCLOUD_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    QNWFA_dims[0] = Time_dim;
    QNWFA_dims[1] = bottom_top_dim;
    QNWFA_dims[2] = south_north_dim;
    QNWFA_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "QNWFA", NC_FLOAT, RANK_QNWFA, QNWFA_dims, &QNWFA_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNWFA_id, NC_CHUNKED, QNWFA_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNWFA_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    QNIFA_dims[0] = Time_dim;
    QNIFA_dims[1] = bottom_top_dim;
    QNIFA_dims[2] = south_north_dim;
    QNIFA_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "QNIFA", NC_FLOAT, RANK_QNIFA, QNIFA_dims, &QNIFA_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNIFA_id, NC_CHUNKED, QNIFA_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNIFA_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SHDMAX_dims[0] = Time_dim;
    SHDMAX_dims[1] = south_north_dim;
    SHDMAX_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SHDMAX", NC_FLOAT, RANK_SHDMAX, SHDMAX_dims, &SHDMAX_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SHDMAX_id, NC_CHUNKED, SHDMAX_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SHDMAX_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SHDMIN_dims[0] = Time_dim;
    SHDMIN_dims[1] = south_north_dim;
    SHDMIN_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SHDMIN", NC_FLOAT, RANK_SHDMIN, SHDMIN_dims, &SHDMIN_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SHDMIN_id, NC_CHUNKED, SHDMIN_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SHDMIN_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SNOALB_dims[0] = Time_dim;
    SNOALB_dims[1] = south_north_dim;
    SNOALB_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SNOALB", NC_FLOAT, RANK_SNOALB, SNOALB_dims, &SNOALB_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOALB_id, NC_CHUNKED, SNOALB_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOALB_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    TSLB_dims[0] = Time_dim;
    TSLB_dims[1] = soil_layers_stag_dim;
    TSLB_dims[2] = south_north_dim;
    TSLB_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "TSLB", NC_FLOAT, RANK_TSLB, TSLB_dims, &TSLB_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSLB_id, NC_CHUNKED, TSLB_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSLB_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SMOIS_dims[0] = Time_dim;
    SMOIS_dims[1] = soil_layers_stag_dim;
    SMOIS_dims[2] = south_north_dim;
    SMOIS_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SMOIS", NC_FLOAT, RANK_SMOIS, SMOIS_dims, &SMOIS_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMOIS_id, NC_CHUNKED, SMOIS_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMOIS_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SH2O_dims[0] = Time_dim;
    SH2O_dims[1] = soil_layers_stag_dim;
    SH2O_dims[2] = south_north_dim;
    SH2O_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SH2O", NC_FLOAT, RANK_SH2O, SH2O_dims, &SH2O_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SH2O_id, NC_CHUNKED, SH2O_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SH2O_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SMCREL_dims[0] = Time_dim;
    SMCREL_dims[1] = soil_layers_stag_dim;
    SMCREL_dims[2] = south_north_dim;
    SMCREL_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SMCREL", NC_FLOAT, RANK_SMCREL, SMCREL_dims, &SMCREL_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMCREL_id, NC_CHUNKED, SMCREL_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMCREL_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SEAICE_dims[0] = Time_dim;
    SEAICE_dims[1] = south_north_dim;
    SEAICE_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SEAICE", NC_FLOAT, RANK_SEAICE, SEAICE_dims, &SEAICE_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SEAICE_id, NC_CHUNKED, SEAICE_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SEAICE_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    XICEM_dims[0] = Time_dim;
    XICEM_dims[1] = south_north_dim;
    XICEM_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "XICEM", NC_FLOAT, RANK_XICEM, XICEM_dims, &XICEM_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XICEM_id, NC_CHUNKED, XICEM_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XICEM_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SFROFF_dims[0] = Time_dim;
    SFROFF_dims[1] = south_north_dim;
    SFROFF_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SFROFF", NC_FLOAT, RANK_SFROFF, SFROFF_dims, &SFROFF_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SFROFF_id, NC_CHUNKED, SFROFF_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SFROFF_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    UDROFF_dims[0] = Time_dim;
    UDROFF_dims[1] = south_north_dim;
    UDROFF_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "UDROFF", NC_FLOAT, RANK_UDROFF, UDROFF_dims, &UDROFF_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UDROFF_id, NC_CHUNKED, UDROFF_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UDROFF_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    IVGTYP_dims[0] = Time_dim;
    IVGTYP_dims[1] = south_north_dim;
    IVGTYP_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "IVGTYP", NC_INT, RANK_IVGTYP, IVGTYP_dims, &IVGTYP_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, IVGTYP_id, NC_CHUNKED, IVGTYP_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, IVGTYP_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_endian(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, IVGTYP_id, NC_ENDIAN_LITTLE); */
    /* check_err(stat,__LINE__,__FILE__); */

    ISLTYP_dims[0] = Time_dim;
    ISLTYP_dims[1] = south_north_dim;
    ISLTYP_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ISLTYP", NC_INT, RANK_ISLTYP, ISLTYP_dims, &ISLTYP_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISLTYP_id, NC_CHUNKED, ISLTYP_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISLTYP_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_endian(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISLTYP_id, NC_ENDIAN_LITTLE); */
    /* check_err(stat,__LINE__,__FILE__); */

    VEGFRA_dims[0] = Time_dim;
    VEGFRA_dims[1] = south_north_dim;
    VEGFRA_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "VEGFRA", NC_FLOAT, RANK_VEGFRA, VEGFRA_dims, &VEGFRA_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VEGFRA_id, NC_CHUNKED, VEGFRA_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VEGFRA_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    GRDFLX_dims[0] = Time_dim;
    GRDFLX_dims[1] = south_north_dim;
    GRDFLX_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "GRDFLX", NC_FLOAT, RANK_GRDFLX, GRDFLX_dims, &GRDFLX_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRDFLX_id, NC_CHUNKED, GRDFLX_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRDFLX_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ACGRDFLX_dims[0] = Time_dim;
    ACGRDFLX_dims[1] = south_north_dim;
    ACGRDFLX_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ACGRDFLX", NC_FLOAT, RANK_ACGRDFLX, ACGRDFLX_dims, &ACGRDFLX_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACGRDFLX_id, NC_CHUNKED, ACGRDFLX_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACGRDFLX_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ACSNOM_dims[0] = Time_dim;
    ACSNOM_dims[1] = south_north_dim;
    ACSNOM_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ACSNOM", NC_FLOAT, RANK_ACSNOM, ACSNOM_dims, &ACSNOM_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSNOM_id, NC_CHUNKED, ACSNOM_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSNOM_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SNOW_dims[0] = Time_dim;
    SNOW_dims[1] = south_north_dim;
    SNOW_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SNOW", NC_FLOAT, RANK_SNOW, SNOW_dims, &SNOW_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOW_id, NC_CHUNKED, SNOW_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOW_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SNOWH_dims[0] = Time_dim;
    SNOWH_dims[1] = south_north_dim;
    SNOWH_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SNOWH", NC_FLOAT, RANK_SNOWH, SNOWH_dims, &SNOWH_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWH_id, NC_CHUNKED, SNOWH_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWH_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    CANWAT_dims[0] = Time_dim;
    CANWAT_dims[1] = south_north_dim;
    CANWAT_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "CANWAT", NC_FLOAT, RANK_CANWAT, CANWAT_dims, &CANWAT_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CANWAT_id, NC_CHUNKED, CANWAT_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CANWAT_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SSTSK_dims[0] = Time_dim;
    SSTSK_dims[1] = south_north_dim;
    SSTSK_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SSTSK", NC_FLOAT, RANK_SSTSK, SSTSK_dims, &SSTSK_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SSTSK_id, NC_CHUNKED, SSTSK_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SSTSK_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    COSZEN_dims[0] = Time_dim;
    COSZEN_dims[1] = south_north_dim;
    COSZEN_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "COSZEN", NC_FLOAT, RANK_COSZEN, COSZEN_dims, &COSZEN_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, COSZEN_id, NC_CHUNKED, COSZEN_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, COSZEN_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    LAI_dims[0] = Time_dim;
    LAI_dims[1] = south_north_dim;
    LAI_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "LAI", NC_FLOAT, RANK_LAI, LAI_dims, &LAI_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAI_id, NC_CHUNKED, LAI_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAI_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    EDMF_A_dims[0] = Time_dim;
    EDMF_A_dims[1] = bottom_top_dim;
    EDMF_A_dims[2] = south_north_dim;
    EDMF_A_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "EDMF_A", NC_FLOAT, RANK_EDMF_A, EDMF_A_dims, &EDMF_A_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_A_id, NC_CHUNKED, EDMF_A_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_A_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    EDMF_W_dims[0] = Time_dim;
    EDMF_W_dims[1] = bottom_top_dim;
    EDMF_W_dims[2] = south_north_dim;
    EDMF_W_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "EDMF_W", NC_FLOAT, RANK_EDMF_W, EDMF_W_dims, &EDMF_W_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_W_id, NC_CHUNKED, EDMF_W_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_W_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    EDMF_THL_dims[0] = Time_dim;
    EDMF_THL_dims[1] = bottom_top_dim;
    EDMF_THL_dims[2] = south_north_dim;
    EDMF_THL_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "EDMF_THL", NC_FLOAT, RANK_EDMF_THL, EDMF_THL_dims, &EDMF_THL_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_THL_id, NC_CHUNKED, EDMF_THL_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_THL_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    EDMF_QT_dims[0] = Time_dim;
    EDMF_QT_dims[1] = bottom_top_dim;
    EDMF_QT_dims[2] = south_north_dim;
    EDMF_QT_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "EDMF_QT", NC_FLOAT, RANK_EDMF_QT, EDMF_QT_dims, &EDMF_QT_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_QT_id, NC_CHUNKED, EDMF_QT_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_QT_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    EDMF_ENT_dims[0] = Time_dim;
    EDMF_ENT_dims[1] = bottom_top_dim;
    EDMF_ENT_dims[2] = south_north_dim;
    EDMF_ENT_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "EDMF_ENT", NC_FLOAT, RANK_EDMF_ENT, EDMF_ENT_dims, &EDMF_ENT_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_ENT_id, NC_CHUNKED, EDMF_ENT_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_ENT_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    EDMF_QC_dims[0] = Time_dim;
    EDMF_QC_dims[1] = bottom_top_dim;
    EDMF_QC_dims[2] = south_north_dim;
    EDMF_QC_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "EDMF_QC", NC_FLOAT, RANK_EDMF_QC, EDMF_QC_dims, &EDMF_QC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_QC_id, NC_CHUNKED, EDMF_QC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_QC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    VAR_dims[0] = Time_dim;
    VAR_dims[1] = south_north_dim;
    VAR_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "VAR", NC_FLOAT, RANK_VAR, VAR_dims, &VAR_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VAR_id, NC_CHUNKED, VAR_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VAR_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    O3RAD_dims[0] = Time_dim;
    O3RAD_dims[1] = bottom_top_dim;
    O3RAD_dims[2] = south_north_dim;
    O3RAD_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "O3RAD", NC_FLOAT, RANK_O3RAD, O3RAD_dims, &O3RAD_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, O3RAD_id, NC_CHUNKED, O3RAD_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, O3RAD_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    MAPFAC_M_dims[0] = Time_dim;
    MAPFAC_M_dims[1] = south_north_dim;
    MAPFAC_M_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "MAPFAC_M", NC_FLOAT, RANK_MAPFAC_M, MAPFAC_M_dims, &MAPFAC_M_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_M_id, NC_CHUNKED, MAPFAC_M_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_M_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    MAPFAC_U_dims[0] = Time_dim;
    MAPFAC_U_dims[1] = south_north_dim;
    MAPFAC_U_dims[2] = west_east_stag_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "MAPFAC_U", NC_FLOAT, RANK_MAPFAC_U, MAPFAC_U_dims, &MAPFAC_U_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_U_id, NC_CHUNKED, MAPFAC_U_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_U_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    MAPFAC_V_dims[0] = Time_dim;
    MAPFAC_V_dims[1] = south_north_stag_dim;
    MAPFAC_V_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "MAPFAC_V", NC_FLOAT, RANK_MAPFAC_V, MAPFAC_V_dims, &MAPFAC_V_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_V_id, NC_CHUNKED, MAPFAC_V_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_V_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    MAPFAC_MX_dims[0] = Time_dim;
    MAPFAC_MX_dims[1] = south_north_dim;
    MAPFAC_MX_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "MAPFAC_MX", NC_FLOAT, RANK_MAPFAC_MX, MAPFAC_MX_dims, &MAPFAC_MX_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_MX_id, NC_CHUNKED, MAPFAC_MX_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_MX_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    MAPFAC_MY_dims[0] = Time_dim;
    MAPFAC_MY_dims[1] = south_north_dim;
    MAPFAC_MY_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "MAPFAC_MY", NC_FLOAT, RANK_MAPFAC_MY, MAPFAC_MY_dims, &MAPFAC_MY_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_MY_id, NC_CHUNKED, MAPFAC_MY_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_MY_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    MAPFAC_UX_dims[0] = Time_dim;
    MAPFAC_UX_dims[1] = south_north_dim;
    MAPFAC_UX_dims[2] = west_east_stag_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "MAPFAC_UX", NC_FLOAT, RANK_MAPFAC_UX, MAPFAC_UX_dims, &MAPFAC_UX_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_UX_id, NC_CHUNKED, MAPFAC_UX_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_UX_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    MAPFAC_UY_dims[0] = Time_dim;
    MAPFAC_UY_dims[1] = south_north_dim;
    MAPFAC_UY_dims[2] = west_east_stag_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "MAPFAC_UY", NC_FLOAT, RANK_MAPFAC_UY, MAPFAC_UY_dims, &MAPFAC_UY_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_UY_id, NC_CHUNKED, MAPFAC_UY_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_UY_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    MAPFAC_VX_dims[0] = Time_dim;
    MAPFAC_VX_dims[1] = south_north_stag_dim;
    MAPFAC_VX_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "MAPFAC_VX", NC_FLOAT, RANK_MAPFAC_VX, MAPFAC_VX_dims, &MAPFAC_VX_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_VX_id, NC_CHUNKED, MAPFAC_VX_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_VX_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    MF_VX_INV_dims[0] = Time_dim;
    MF_VX_INV_dims[1] = south_north_stag_dim;
    MF_VX_INV_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "MF_VX_INV", NC_FLOAT, RANK_MF_VX_INV, MF_VX_INV_dims, &MF_VX_INV_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MF_VX_INV_id, NC_CHUNKED, MF_VX_INV_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MF_VX_INV_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    MAPFAC_VY_dims[0] = Time_dim;
    MAPFAC_VY_dims[1] = south_north_stag_dim;
    MAPFAC_VY_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "MAPFAC_VY", NC_FLOAT, RANK_MAPFAC_VY, MAPFAC_VY_dims, &MAPFAC_VY_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_VY_id, NC_CHUNKED, MAPFAC_VY_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_VY_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    F_dims[0] = Time_dim;
    F_dims[1] = south_north_dim;
    F_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "F", NC_FLOAT, RANK_F, F_dims, &F_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, F_id, NC_CHUNKED, F_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, F_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    E_dims[0] = Time_dim;
    E_dims[1] = south_north_dim;
    E_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "E", NC_FLOAT, RANK_E, E_dims, &E_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, E_id, NC_CHUNKED, E_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, E_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SINALPHA_dims[0] = Time_dim;
    SINALPHA_dims[1] = south_north_dim;
    SINALPHA_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SINALPHA", NC_FLOAT, RANK_SINALPHA, SINALPHA_dims, &SINALPHA_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SINALPHA_id, NC_CHUNKED, SINALPHA_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SINALPHA_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    COSALPHA_dims[0] = Time_dim;
    COSALPHA_dims[1] = south_north_dim;
    COSALPHA_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "COSALPHA", NC_FLOAT, RANK_COSALPHA, COSALPHA_dims, &COSALPHA_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, COSALPHA_id, NC_CHUNKED, COSALPHA_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, COSALPHA_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    HGT_dims[0] = Time_dim;
    HGT_dims[1] = south_north_dim;
    HGT_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "HGT", NC_FLOAT, RANK_HGT, HGT_dims, &HGT_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HGT_id, NC_CHUNKED, HGT_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HGT_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    TSK_dims[0] = Time_dim;
    TSK_dims[1] = south_north_dim;
    TSK_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "TSK", NC_FLOAT, RANK_TSK, TSK_dims, &TSK_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSK_id, NC_CHUNKED, TSK_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSK_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    P_TOP_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "P_TOP", NC_FLOAT, RANK_P_TOP, P_TOP_dims, &P_TOP_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_TOP_id, NC_CHUNKED, P_TOP_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    T00_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "T00", NC_FLOAT, RANK_T00, T00_dims, &T00_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, T00_id, NC_CHUNKED, T00_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    P00_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "P00", NC_FLOAT, RANK_P00, P00_dims, &P00_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P00_id, NC_CHUNKED, P00_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    TLP_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "TLP", NC_FLOAT, RANK_TLP, TLP_dims, &TLP_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TLP_id, NC_CHUNKED, TLP_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    TISO_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "TISO", NC_FLOAT, RANK_TISO, TISO_dims, &TISO_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TISO_id, NC_CHUNKED, TISO_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    TLP_STRAT_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "TLP_STRAT", NC_FLOAT, RANK_TLP_STRAT, TLP_STRAT_dims, &TLP_STRAT_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TLP_STRAT_id, NC_CHUNKED, TLP_STRAT_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    P_STRAT_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "P_STRAT", NC_FLOAT, RANK_P_STRAT, P_STRAT_dims, &P_STRAT_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_STRAT_id, NC_CHUNKED, P_STRAT_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    MAX_MSTFX_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "MAX_MSTFX", NC_FLOAT, RANK_MAX_MSTFX, MAX_MSTFX_dims, &MAX_MSTFX_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAX_MSTFX_id, NC_CHUNKED, MAX_MSTFX_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    MAX_MSTFY_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "MAX_MSTFY", NC_FLOAT, RANK_MAX_MSTFY, MAX_MSTFY_dims, &MAX_MSTFY_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAX_MSTFY_id, NC_CHUNKED, MAX_MSTFY_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    RAINC_dims[0] = Time_dim;
    RAINC_dims[1] = south_north_dim;
    RAINC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "RAINC", NC_FLOAT, RANK_RAINC, RAINC_dims, &RAINC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINC_id, NC_CHUNKED, RAINC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    RAINSH_dims[0] = Time_dim;
    RAINSH_dims[1] = south_north_dim;
    RAINSH_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "RAINSH", NC_FLOAT, RANK_RAINSH, RAINSH_dims, &RAINSH_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINSH_id, NC_CHUNKED, RAINSH_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINSH_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    RAINNC_dims[0] = Time_dim;
    RAINNC_dims[1] = south_north_dim;
    RAINNC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "RAINNC", NC_FLOAT, RANK_RAINNC, RAINNC_dims, &RAINNC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINNC_id, NC_CHUNKED, RAINNC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINNC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SNOWNC_dims[0] = Time_dim;
    SNOWNC_dims[1] = south_north_dim;
    SNOWNC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SNOWNC", NC_FLOAT, RANK_SNOWNC, SNOWNC_dims, &SNOWNC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWNC_id, NC_CHUNKED, SNOWNC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWNC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    GRAUPELNC_dims[0] = Time_dim;
    GRAUPELNC_dims[1] = south_north_dim;
    GRAUPELNC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "GRAUPELNC", NC_FLOAT, RANK_GRAUPELNC, GRAUPELNC_dims, &GRAUPELNC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRAUPELNC_id, NC_CHUNKED, GRAUPELNC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRAUPELNC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    HAILNC_dims[0] = Time_dim;
    HAILNC_dims[1] = south_north_dim;
    HAILNC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "HAILNC", NC_FLOAT, RANK_HAILNC, HAILNC_dims, &HAILNC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HAILNC_id, NC_CHUNKED, HAILNC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HAILNC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    CLDFRA_dims[0] = Time_dim;
    CLDFRA_dims[1] = bottom_top_dim;
    CLDFRA_dims[2] = south_north_dim;
    CLDFRA_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "CLDFRA", NC_FLOAT, RANK_CLDFRA, CLDFRA_dims, &CLDFRA_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLDFRA_id, NC_CHUNKED, CLDFRA_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLDFRA_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SWDOWN_dims[0] = Time_dim;
    SWDOWN_dims[1] = south_north_dim;
    SWDOWN_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SWDOWN", NC_FLOAT, RANK_SWDOWN, SWDOWN_dims, &SWDOWN_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDOWN_id, NC_CHUNKED, SWDOWN_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDOWN_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    GLW_dims[0] = Time_dim;
    GLW_dims[1] = south_north_dim;
    GLW_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "GLW", NC_FLOAT, RANK_GLW, GLW_dims, &GLW_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GLW_id, NC_CHUNKED, GLW_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GLW_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SWNORM_dims[0] = Time_dim;
    SWNORM_dims[1] = south_north_dim;
    SWNORM_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SWNORM", NC_FLOAT, RANK_SWNORM, SWNORM_dims, &SWNORM_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWNORM_id, NC_CHUNKED, SWNORM_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWNORM_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    TAOD5502D_dims[0] = Time_dim;
    TAOD5502D_dims[1] = south_north_dim;
    TAOD5502D_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "TAOD5502D", NC_FLOAT, RANK_TAOD5502D, TAOD5502D_dims, &TAOD5502D_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TAOD5502D_id, NC_CHUNKED, TAOD5502D_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TAOD5502D_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ACSWUPT_dims[0] = Time_dim;
    ACSWUPT_dims[1] = south_north_dim;
    ACSWUPT_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ACSWUPT", NC_FLOAT, RANK_ACSWUPT, ACSWUPT_dims, &ACSWUPT_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPT_id, NC_CHUNKED, ACSWUPT_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPT_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ACSWUPTC_dims[0] = Time_dim;
    ACSWUPTC_dims[1] = south_north_dim;
    ACSWUPTC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ACSWUPTC", NC_FLOAT, RANK_ACSWUPTC, ACSWUPTC_dims, &ACSWUPTC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPTC_id, NC_CHUNKED, ACSWUPTC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPTC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ACSWDNT_dims[0] = Time_dim;
    ACSWDNT_dims[1] = south_north_dim;
    ACSWDNT_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ACSWDNT", NC_FLOAT, RANK_ACSWDNT, ACSWDNT_dims, &ACSWDNT_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNT_id, NC_CHUNKED, ACSWDNT_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNT_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ACSWDNTC_dims[0] = Time_dim;
    ACSWDNTC_dims[1] = south_north_dim;
    ACSWDNTC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ACSWDNTC", NC_FLOAT, RANK_ACSWDNTC, ACSWDNTC_dims, &ACSWDNTC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNTC_id, NC_CHUNKED, ACSWDNTC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNTC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ACSWUPB_dims[0] = Time_dim;
    ACSWUPB_dims[1] = south_north_dim;
    ACSWUPB_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ACSWUPB", NC_FLOAT, RANK_ACSWUPB, ACSWUPB_dims, &ACSWUPB_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPB_id, NC_CHUNKED, ACSWUPB_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPB_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ACSWUPBC_dims[0] = Time_dim;
    ACSWUPBC_dims[1] = south_north_dim;
    ACSWUPBC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ACSWUPBC", NC_FLOAT, RANK_ACSWUPBC, ACSWUPBC_dims, &ACSWUPBC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPBC_id, NC_CHUNKED, ACSWUPBC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPBC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ACSWDNB_dims[0] = Time_dim;
    ACSWDNB_dims[1] = south_north_dim;
    ACSWDNB_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ACSWDNB", NC_FLOAT, RANK_ACSWDNB, ACSWDNB_dims, &ACSWDNB_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNB_id, NC_CHUNKED, ACSWDNB_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNB_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ACSWDNBC_dims[0] = Time_dim;
    ACSWDNBC_dims[1] = south_north_dim;
    ACSWDNBC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ACSWDNBC", NC_FLOAT, RANK_ACSWDNBC, ACSWDNBC_dims, &ACSWDNBC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNBC_id, NC_CHUNKED, ACSWDNBC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNBC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ACLWUPT_dims[0] = Time_dim;
    ACLWUPT_dims[1] = south_north_dim;
    ACLWUPT_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ACLWUPT", NC_FLOAT, RANK_ACLWUPT, ACLWUPT_dims, &ACLWUPT_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPT_id, NC_CHUNKED, ACLWUPT_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPT_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ACLWUPTC_dims[0] = Time_dim;
    ACLWUPTC_dims[1] = south_north_dim;
    ACLWUPTC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ACLWUPTC", NC_FLOAT, RANK_ACLWUPTC, ACLWUPTC_dims, &ACLWUPTC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPTC_id, NC_CHUNKED, ACLWUPTC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPTC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ACLWDNT_dims[0] = Time_dim;
    ACLWDNT_dims[1] = south_north_dim;
    ACLWDNT_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ACLWDNT", NC_FLOAT, RANK_ACLWDNT, ACLWDNT_dims, &ACLWDNT_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNT_id, NC_CHUNKED, ACLWDNT_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNT_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ACLWDNTC_dims[0] = Time_dim;
    ACLWDNTC_dims[1] = south_north_dim;
    ACLWDNTC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ACLWDNTC", NC_FLOAT, RANK_ACLWDNTC, ACLWDNTC_dims, &ACLWDNTC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNTC_id, NC_CHUNKED, ACLWDNTC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNTC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ACLWUPB_dims[0] = Time_dim;
    ACLWUPB_dims[1] = south_north_dim;
    ACLWUPB_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ACLWUPB", NC_FLOAT, RANK_ACLWUPB, ACLWUPB_dims, &ACLWUPB_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPB_id, NC_CHUNKED, ACLWUPB_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPB_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ACLWUPBC_dims[0] = Time_dim;
    ACLWUPBC_dims[1] = south_north_dim;
    ACLWUPBC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ACLWUPBC", NC_FLOAT, RANK_ACLWUPBC, ACLWUPBC_dims, &ACLWUPBC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPBC_id, NC_CHUNKED, ACLWUPBC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPBC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ACLWDNB_dims[0] = Time_dim;
    ACLWDNB_dims[1] = south_north_dim;
    ACLWDNB_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ACLWDNB", NC_FLOAT, RANK_ACLWDNB, ACLWDNB_dims, &ACLWDNB_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNB_id, NC_CHUNKED, ACLWDNB_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNB_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ACLWDNBC_dims[0] = Time_dim;
    ACLWDNBC_dims[1] = south_north_dim;
    ACLWDNBC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ACLWDNBC", NC_FLOAT, RANK_ACLWDNBC, ACLWDNBC_dims, &ACLWDNBC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNBC_id, NC_CHUNKED, ACLWDNBC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNBC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SWUPT_dims[0] = Time_dim;
    SWUPT_dims[1] = south_north_dim;
    SWUPT_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SWUPT", NC_FLOAT, RANK_SWUPT, SWUPT_dims, &SWUPT_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPT_id, NC_CHUNKED, SWUPT_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPT_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SWUPTC_dims[0] = Time_dim;
    SWUPTC_dims[1] = south_north_dim;
    SWUPTC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SWUPTC", NC_FLOAT, RANK_SWUPTC, SWUPTC_dims, &SWUPTC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPTC_id, NC_CHUNKED, SWUPTC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPTC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SWDNT_dims[0] = Time_dim;
    SWDNT_dims[1] = south_north_dim;
    SWDNT_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SWDNT", NC_FLOAT, RANK_SWDNT, SWDNT_dims, &SWDNT_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNT_id, NC_CHUNKED, SWDNT_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNT_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SWDNTC_dims[0] = Time_dim;
    SWDNTC_dims[1] = south_north_dim;
    SWDNTC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SWDNTC", NC_FLOAT, RANK_SWDNTC, SWDNTC_dims, &SWDNTC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNTC_id, NC_CHUNKED, SWDNTC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNTC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SWUPB_dims[0] = Time_dim;
    SWUPB_dims[1] = south_north_dim;
    SWUPB_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SWUPB", NC_FLOAT, RANK_SWUPB, SWUPB_dims, &SWUPB_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPB_id, NC_CHUNKED, SWUPB_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPB_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SWUPBC_dims[0] = Time_dim;
    SWUPBC_dims[1] = south_north_dim;
    SWUPBC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SWUPBC", NC_FLOAT, RANK_SWUPBC, SWUPBC_dims, &SWUPBC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPBC_id, NC_CHUNKED, SWUPBC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPBC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SWDNB_dims[0] = Time_dim;
    SWDNB_dims[1] = south_north_dim;
    SWDNB_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SWDNB", NC_FLOAT, RANK_SWDNB, SWDNB_dims, &SWDNB_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNB_id, NC_CHUNKED, SWDNB_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNB_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SWDNBC_dims[0] = Time_dim;
    SWDNBC_dims[1] = south_north_dim;
    SWDNBC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SWDNBC", NC_FLOAT, RANK_SWDNBC, SWDNBC_dims, &SWDNBC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNBC_id, NC_CHUNKED, SWDNBC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNBC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    LWUPT_dims[0] = Time_dim;
    LWUPT_dims[1] = south_north_dim;
    LWUPT_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "LWUPT", NC_FLOAT, RANK_LWUPT, LWUPT_dims, &LWUPT_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPT_id, NC_CHUNKED, LWUPT_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPT_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    LWUPTC_dims[0] = Time_dim;
    LWUPTC_dims[1] = south_north_dim;
    LWUPTC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "LWUPTC", NC_FLOAT, RANK_LWUPTC, LWUPTC_dims, &LWUPTC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPTC_id, NC_CHUNKED, LWUPTC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPTC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    LWDNT_dims[0] = Time_dim;
    LWDNT_dims[1] = south_north_dim;
    LWDNT_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "LWDNT", NC_FLOAT, RANK_LWDNT, LWDNT_dims, &LWDNT_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNT_id, NC_CHUNKED, LWDNT_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNT_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    LWDNTC_dims[0] = Time_dim;
    LWDNTC_dims[1] = south_north_dim;
    LWDNTC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "LWDNTC", NC_FLOAT, RANK_LWDNTC, LWDNTC_dims, &LWDNTC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNTC_id, NC_CHUNKED, LWDNTC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNTC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    LWUPB_dims[0] = Time_dim;
    LWUPB_dims[1] = south_north_dim;
    LWUPB_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "LWUPB", NC_FLOAT, RANK_LWUPB, LWUPB_dims, &LWUPB_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPB_id, NC_CHUNKED, LWUPB_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPB_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    LWUPBC_dims[0] = Time_dim;
    LWUPBC_dims[1] = south_north_dim;
    LWUPBC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "LWUPBC", NC_FLOAT, RANK_LWUPBC, LWUPBC_dims, &LWUPBC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPBC_id, NC_CHUNKED, LWUPBC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPBC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    LWDNB_dims[0] = Time_dim;
    LWDNB_dims[1] = south_north_dim;
    LWDNB_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "LWDNB", NC_FLOAT, RANK_LWDNB, LWDNB_dims, &LWDNB_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNB_id, NC_CHUNKED, LWDNB_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNB_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    LWDNBC_dims[0] = Time_dim;
    LWDNBC_dims[1] = south_north_dim;
    LWDNBC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "LWDNBC", NC_FLOAT, RANK_LWDNBC, LWDNBC_dims, &LWDNBC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNBC_id, NC_CHUNKED, LWDNBC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNBC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    OLR_dims[0] = Time_dim;
    OLR_dims[1] = south_north_dim;
    OLR_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "OLR", NC_FLOAT, RANK_OLR, OLR_dims, &OLR_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, OLR_id, NC_CHUNKED, OLR_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, OLR_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    XLAT_U_dims[0] = Time_dim;
    XLAT_U_dims[1] = south_north_dim;
    XLAT_U_dims[2] = west_east_stag_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "XLAT_U", NC_FLOAT, RANK_XLAT_U, XLAT_U_dims, &XLAT_U_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_U_id, NC_CHUNKED, XLAT_U_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_U_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    XLONG_U_dims[0] = Time_dim;
    XLONG_U_dims[1] = south_north_dim;
    XLONG_U_dims[2] = west_east_stag_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "XLONG_U", NC_FLOAT, RANK_XLONG_U, XLONG_U_dims, &XLONG_U_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_U_id, NC_CHUNKED, XLONG_U_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_U_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    XLAT_V_dims[0] = Time_dim;
    XLAT_V_dims[1] = south_north_stag_dim;
    XLAT_V_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "XLAT_V", NC_FLOAT, RANK_XLAT_V, XLAT_V_dims, &XLAT_V_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_V_id, NC_CHUNKED, XLAT_V_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_V_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    XLONG_V_dims[0] = Time_dim;
    XLONG_V_dims[1] = south_north_stag_dim;
    XLONG_V_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "XLONG_V", NC_FLOAT, RANK_XLONG_V, XLONG_V_dims, &XLONG_V_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_V_id, NC_CHUNKED, XLONG_V_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_V_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ALBEDO_dims[0] = Time_dim;
    ALBEDO_dims[1] = south_north_dim;
    ALBEDO_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ALBEDO", NC_FLOAT, RANK_ALBEDO, ALBEDO_dims, &ALBEDO_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ALBEDO_id, NC_CHUNKED, ALBEDO_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ALBEDO_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    CLAT_dims[0] = Time_dim;
    CLAT_dims[1] = south_north_dim;
    CLAT_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "CLAT", NC_FLOAT, RANK_CLAT, CLAT_dims, &CLAT_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLAT_id, NC_CHUNKED, CLAT_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLAT_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ALBBCK_dims[0] = Time_dim;
    ALBBCK_dims[1] = south_north_dim;
    ALBBCK_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ALBBCK", NC_FLOAT, RANK_ALBBCK, ALBBCK_dims, &ALBBCK_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ALBBCK_id, NC_CHUNKED, ALBBCK_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ALBBCK_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    EMISS_dims[0] = Time_dim;
    EMISS_dims[1] = south_north_dim;
    EMISS_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "EMISS", NC_FLOAT, RANK_EMISS, EMISS_dims, &EMISS_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EMISS_id, NC_CHUNKED, EMISS_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EMISS_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    NOAHRES_dims[0] = Time_dim;
    NOAHRES_dims[1] = south_north_dim;
    NOAHRES_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "NOAHRES", NC_FLOAT, RANK_NOAHRES, NOAHRES_dims, &NOAHRES_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NOAHRES_id, NC_CHUNKED, NOAHRES_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NOAHRES_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    TMN_dims[0] = Time_dim;
    TMN_dims[1] = south_north_dim;
    TMN_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "TMN", NC_FLOAT, RANK_TMN, TMN_dims, &TMN_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TMN_id, NC_CHUNKED, TMN_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TMN_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    XLAND_dims[0] = Time_dim;
    XLAND_dims[1] = south_north_dim;
    XLAND_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "XLAND", NC_FLOAT, RANK_XLAND, XLAND_dims, &XLAND_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAND_id, NC_CHUNKED, XLAND_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAND_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    UST_dims[0] = Time_dim;
    UST_dims[1] = south_north_dim;
    UST_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "UST", NC_FLOAT, RANK_UST, UST_dims, &UST_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UST_id, NC_CHUNKED, UST_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UST_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    PBLH_dims[0] = Time_dim;
    PBLH_dims[1] = south_north_dim;
    PBLH_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "PBLH", NC_FLOAT, RANK_PBLH, PBLH_dims, &PBLH_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PBLH_id, NC_CHUNKED, PBLH_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PBLH_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    HFX_dims[0] = Time_dim;
    HFX_dims[1] = south_north_dim;
    HFX_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "HFX", NC_FLOAT, RANK_HFX, HFX_dims, &HFX_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HFX_id, NC_CHUNKED, HFX_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HFX_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    QFX_dims[0] = Time_dim;
    QFX_dims[1] = south_north_dim;
    QFX_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "QFX", NC_FLOAT, RANK_QFX, QFX_dims, &QFX_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QFX_id, NC_CHUNKED, QFX_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QFX_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    LH_dims[0] = Time_dim;
    LH_dims[1] = south_north_dim;
    LH_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "LH", NC_FLOAT, RANK_LH, LH_dims, &LH_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LH_id, NC_CHUNKED, LH_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LH_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ACHFX_dims[0] = Time_dim;
    ACHFX_dims[1] = south_north_dim;
    ACHFX_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ACHFX", NC_FLOAT, RANK_ACHFX, ACHFX_dims, &ACHFX_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACHFX_id, NC_CHUNKED, ACHFX_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACHFX_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ACLHF_dims[0] = Time_dim;
    ACLHF_dims[1] = south_north_dim;
    ACLHF_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ACLHF", NC_FLOAT, RANK_ACLHF, ACLHF_dims, &ACLHF_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLHF_id, NC_CHUNKED, ACLHF_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLHF_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SNOWC_dims[0] = Time_dim;
    SNOWC_dims[1] = south_north_dim;
    SNOWC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SNOWC", NC_FLOAT, RANK_SNOWC, SNOWC_dims, &SNOWC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWC_id, NC_CHUNKED, SNOWC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SR_dims[0] = Time_dim;
    SR_dims[1] = south_north_dim;
    SR_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SR", NC_FLOAT, RANK_SR, SR_dims, &SR_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SR_id, NC_CHUNKED, SR_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SR_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SAVE_TOPO_FROM_REAL_dims[0] = Time_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SAVE_TOPO_FROM_REAL", NC_INT, RANK_SAVE_TOPO_FROM_REAL, SAVE_TOPO_FROM_REAL_dims, &SAVE_TOPO_FROM_REAL_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SAVE_TOPO_FROM_REAL_id, NC_CHUNKED, SAVE_TOPO_FROM_REAL_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_endian(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SAVE_TOPO_FROM_REAL_id, NC_ENDIAN_LITTLE); */
    /* check_err(stat,__LINE__,__FILE__); */

    PREC_ACC_C_dims[0] = Time_dim;
    PREC_ACC_C_dims[1] = south_north_dim;
    PREC_ACC_C_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "PREC_ACC_C", NC_FLOAT, RANK_PREC_ACC_C, PREC_ACC_C_dims, &PREC_ACC_C_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PREC_ACC_C_id, NC_CHUNKED, PREC_ACC_C_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PREC_ACC_C_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    PREC_ACC_NC_dims[0] = Time_dim;
    PREC_ACC_NC_dims[1] = south_north_dim;
    PREC_ACC_NC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "PREC_ACC_NC", NC_FLOAT, RANK_PREC_ACC_NC, PREC_ACC_NC_dims, &PREC_ACC_NC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PREC_ACC_NC_id, NC_CHUNKED, PREC_ACC_NC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PREC_ACC_NC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SNOW_ACC_NC_dims[0] = Time_dim;
    SNOW_ACC_NC_dims[1] = south_north_dim;
    SNOW_ACC_NC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SNOW_ACC_NC", NC_FLOAT, RANK_SNOW_ACC_NC, SNOW_ACC_NC_dims, &SNOW_ACC_NC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOW_ACC_NC_id, NC_CHUNKED, SNOW_ACC_NC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOW_ACC_NC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    EROD_dims[0] = Time_dim;
    EROD_dims[1] = dust_erosion_dimension_dim;
    EROD_dims[2] = south_north_dim;
    EROD_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "EROD", NC_FLOAT, RANK_EROD, EROD_dims, &EROD_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EROD_id, NC_CHUNKED, EROD_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EROD_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    CLDFRA2_dims[0] = Time_dim;
    CLDFRA2_dims[1] = bottom_top_dim;
    CLDFRA2_dims[2] = south_north_dim;
    CLDFRA2_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "CLDFRA2", NC_FLOAT, RANK_CLDFRA2, CLDFRA2_dims, &CLDFRA2_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLDFRA2_id, NC_CHUNKED, CLDFRA2_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLDFRA2_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    RAINPROD_dims[0] = Time_dim;
    RAINPROD_dims[1] = bottom_top_dim;
    RAINPROD_dims[2] = south_north_dim;
    RAINPROD_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "RAINPROD", NC_FLOAT, RANK_RAINPROD, RAINPROD_dims, &RAINPROD_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINPROD_id, NC_CHUNKED, RAINPROD_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINPROD_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    EVAPPROD_dims[0] = Time_dim;
    EVAPPROD_dims[1] = bottom_top_dim;
    EVAPPROD_dims[2] = south_north_dim;
    EVAPPROD_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "EVAPPROD", NC_FLOAT, RANK_EVAPPROD, EVAPPROD_dims, &EVAPPROD_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EVAPPROD_id, NC_CHUNKED, EVAPPROD_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EVAPPROD_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    UST_T_dims[0] = Time_dim;
    UST_T_dims[1] = south_north_dim;
    UST_T_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "UST_T", NC_FLOAT, RANK_UST_T, UST_T_dims, &UST_T_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UST_T_id, NC_CHUNKED, UST_T_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UST_T_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ROUGH_COR_dims[0] = Time_dim;
    ROUGH_COR_dims[1] = south_north_dim;
    ROUGH_COR_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ROUGH_COR", NC_FLOAT, RANK_ROUGH_COR, ROUGH_COR_dims, &ROUGH_COR_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ROUGH_COR_id, NC_CHUNKED, ROUGH_COR_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ROUGH_COR_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SMOIS_COR_dims[0] = Time_dim;
    SMOIS_COR_dims[1] = south_north_dim;
    SMOIS_COR_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SMOIS_COR", NC_FLOAT, RANK_SMOIS_COR, SMOIS_COR_dims, &SMOIS_COR_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMOIS_COR_id, NC_CHUNKED, SMOIS_COR_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMOIS_COR_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    DUSTLOAD_1_dims[0] = Time_dim;
    DUSTLOAD_1_dims[1] = south_north_dim;
    DUSTLOAD_1_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "DUSTLOAD_1", NC_FLOAT, RANK_DUSTLOAD_1, DUSTLOAD_1_dims, &DUSTLOAD_1_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_1_id, NC_CHUNKED, DUSTLOAD_1_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_1_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    DUSTLOAD_2_dims[0] = Time_dim;
    DUSTLOAD_2_dims[1] = south_north_dim;
    DUSTLOAD_2_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "DUSTLOAD_2", NC_FLOAT, RANK_DUSTLOAD_2, DUSTLOAD_2_dims, &DUSTLOAD_2_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_2_id, NC_CHUNKED, DUSTLOAD_2_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_2_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    DUSTLOAD_3_dims[0] = Time_dim;
    DUSTLOAD_3_dims[1] = south_north_dim;
    DUSTLOAD_3_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "DUSTLOAD_3", NC_FLOAT, RANK_DUSTLOAD_3, DUSTLOAD_3_dims, &DUSTLOAD_3_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_3_id, NC_CHUNKED, DUSTLOAD_3_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_3_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    DUSTLOAD_4_dims[0] = Time_dim;
    DUSTLOAD_4_dims[1] = south_north_dim;
    DUSTLOAD_4_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "DUSTLOAD_4", NC_FLOAT, RANK_DUSTLOAD_4, DUSTLOAD_4_dims, &DUSTLOAD_4_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_4_id, NC_CHUNKED, DUSTLOAD_4_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_4_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    DUSTLOAD_5_dims[0] = Time_dim;
    DUSTLOAD_5_dims[1] = south_north_dim;
    DUSTLOAD_5_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "DUSTLOAD_5", NC_FLOAT, RANK_DUSTLOAD_5, DUSTLOAD_5_dims, &DUSTLOAD_5_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_5_id, NC_CHUNKED, DUSTLOAD_5_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_5_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    DRYDEPVEL_dims[0] = Time_dim;
    DRYDEPVEL_dims[1] = south_north_dim;
    DRYDEPVEL_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "DRYDEPVEL", NC_FLOAT, RANK_DRYDEPVEL, DRYDEPVEL_dims, &DRYDEPVEL_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEPVEL_id, NC_CHUNKED, DRYDEPVEL_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEPVEL_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    GRASET_1_dims[0] = Time_dim;
    GRASET_1_dims[1] = south_north_dim;
    GRASET_1_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "GRASET_1", NC_FLOAT, RANK_GRASET_1, GRASET_1_dims, &GRASET_1_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_1_id, NC_CHUNKED, GRASET_1_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_1_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    GRASET_2_dims[0] = Time_dim;
    GRASET_2_dims[1] = south_north_dim;
    GRASET_2_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "GRASET_2", NC_FLOAT, RANK_GRASET_2, GRASET_2_dims, &GRASET_2_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_2_id, NC_CHUNKED, GRASET_2_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_2_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    GRASET_3_dims[0] = Time_dim;
    GRASET_3_dims[1] = south_north_dim;
    GRASET_3_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "GRASET_3", NC_FLOAT, RANK_GRASET_3, GRASET_3_dims, &GRASET_3_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_3_id, NC_CHUNKED, GRASET_3_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_3_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    GRASET_4_dims[0] = Time_dim;
    GRASET_4_dims[1] = south_north_dim;
    GRASET_4_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "GRASET_4", NC_FLOAT, RANK_GRASET_4, GRASET_4_dims, &GRASET_4_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_4_id, NC_CHUNKED, GRASET_4_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_4_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    GRASET_5_dims[0] = Time_dim;
    GRASET_5_dims[1] = south_north_dim;
    GRASET_5_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "GRASET_5", NC_FLOAT, RANK_GRASET_5, GRASET_5_dims, &GRASET_5_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_5_id, NC_CHUNKED, GRASET_5_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_5_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    DRYDEP_1_dims[0] = Time_dim;
    DRYDEP_1_dims[1] = south_north_dim;
    DRYDEP_1_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "DRYDEP_1", NC_FLOAT, RANK_DRYDEP_1, DRYDEP_1_dims, &DRYDEP_1_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_1_id, NC_CHUNKED, DRYDEP_1_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_1_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    DRYDEP_2_dims[0] = Time_dim;
    DRYDEP_2_dims[1] = south_north_dim;
    DRYDEP_2_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "DRYDEP_2", NC_FLOAT, RANK_DRYDEP_2, DRYDEP_2_dims, &DRYDEP_2_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_2_id, NC_CHUNKED, DRYDEP_2_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_2_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    DRYDEP_3_dims[0] = Time_dim;
    DRYDEP_3_dims[1] = south_north_dim;
    DRYDEP_3_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "DRYDEP_3", NC_FLOAT, RANK_DRYDEP_3, DRYDEP_3_dims, &DRYDEP_3_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_3_id, NC_CHUNKED, DRYDEP_3_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_3_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    DRYDEP_4_dims[0] = Time_dim;
    DRYDEP_4_dims[1] = south_north_dim;
    DRYDEP_4_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "DRYDEP_4", NC_FLOAT, RANK_DRYDEP_4, DRYDEP_4_dims, &DRYDEP_4_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_4_id, NC_CHUNKED, DRYDEP_4_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_4_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    DRYDEP_5_dims[0] = Time_dim;
    DRYDEP_5_dims[1] = south_north_dim;
    DRYDEP_5_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "DRYDEP_5", NC_FLOAT, RANK_DRYDEP_5, DRYDEP_5_dims, &DRYDEP_5_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_5_id, NC_CHUNKED, DRYDEP_5_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_5_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    EDUST1_dims[0] = Time_dim;
    EDUST1_dims[1] = klevs_for_dust_dim;
    EDUST1_dims[2] = south_north_dim;
    EDUST1_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "EDUST1", NC_FLOAT, RANK_EDUST1, EDUST1_dims, &EDUST1_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST1_id, NC_CHUNKED, EDUST1_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST1_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    EDUST2_dims[0] = Time_dim;
    EDUST2_dims[1] = klevs_for_dust_dim;
    EDUST2_dims[2] = south_north_dim;
    EDUST2_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "EDUST2", NC_FLOAT, RANK_EDUST2, EDUST2_dims, &EDUST2_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST2_id, NC_CHUNKED, EDUST2_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST2_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    EDUST3_dims[0] = Time_dim;
    EDUST3_dims[1] = klevs_for_dust_dim;
    EDUST3_dims[2] = south_north_dim;
    EDUST3_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "EDUST3", NC_FLOAT, RANK_EDUST3, EDUST3_dims, &EDUST3_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST3_id, NC_CHUNKED, EDUST3_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST3_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    EDUST4_dims[0] = Time_dim;
    EDUST4_dims[1] = klevs_for_dust_dim;
    EDUST4_dims[2] = south_north_dim;
    EDUST4_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "EDUST4", NC_FLOAT, RANK_EDUST4, EDUST4_dims, &EDUST4_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST4_id, NC_CHUNKED, EDUST4_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST4_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    EDUST5_dims[0] = Time_dim;
    EDUST5_dims[1] = klevs_for_dust_dim;
    EDUST5_dims[2] = south_north_dim;
    EDUST5_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "EDUST5", NC_FLOAT, RANK_EDUST5, EDUST5_dims, &EDUST5_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST5_id, NC_CHUNKED, EDUST5_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST5_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ebu_oc_dims[0] = Time_dim;
    ebu_oc_dims[1] = bottom_top_dim;
    ebu_oc_dims[2] = south_north_dim;
    ebu_oc_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ebu_oc", NC_FLOAT, RANK_ebu_oc, ebu_oc_dims, &ebu_oc_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ebu_oc_id, NC_CHUNKED, ebu_oc_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ebu_oc_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    MEAN_FCT_AGTF_dims[0] = Time_dim;
    MEAN_FCT_AGTF_dims[1] = south_north_dim;
    MEAN_FCT_AGTF_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "MEAN_FCT_AGTF", NC_FLOAT, RANK_MEAN_FCT_AGTF, MEAN_FCT_AGTF_dims, &MEAN_FCT_AGTF_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGTF_id, NC_CHUNKED, MEAN_FCT_AGTF_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGTF_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    MEAN_FCT_AGEF_dims[0] = Time_dim;
    MEAN_FCT_AGEF_dims[1] = south_north_dim;
    MEAN_FCT_AGEF_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "MEAN_FCT_AGEF", NC_FLOAT, RANK_MEAN_FCT_AGEF, MEAN_FCT_AGEF_dims, &MEAN_FCT_AGEF_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGEF_id, NC_CHUNKED, MEAN_FCT_AGEF_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGEF_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    MEAN_FCT_AGSV_dims[0] = Time_dim;
    MEAN_FCT_AGSV_dims[1] = south_north_dim;
    MEAN_FCT_AGSV_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "MEAN_FCT_AGSV", NC_FLOAT, RANK_MEAN_FCT_AGSV, MEAN_FCT_AGSV_dims, &MEAN_FCT_AGSV_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGSV_id, NC_CHUNKED, MEAN_FCT_AGSV_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGSV_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    MEAN_FCT_AGGR_dims[0] = Time_dim;
    MEAN_FCT_AGGR_dims[1] = south_north_dim;
    MEAN_FCT_AGGR_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "MEAN_FCT_AGGR", NC_FLOAT, RANK_MEAN_FCT_AGGR, MEAN_FCT_AGGR_dims, &MEAN_FCT_AGGR_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGGR_id, NC_CHUNKED, MEAN_FCT_AGGR_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGGR_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    FIRESIZE_AGTF_dims[0] = Time_dim;
    FIRESIZE_AGTF_dims[1] = south_north_dim;
    FIRESIZE_AGTF_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "FIRESIZE_AGTF", NC_FLOAT, RANK_FIRESIZE_AGTF, FIRESIZE_AGTF_dims, &FIRESIZE_AGTF_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGTF_id, NC_CHUNKED, FIRESIZE_AGTF_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGTF_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    FIRESIZE_AGEF_dims[0] = Time_dim;
    FIRESIZE_AGEF_dims[1] = south_north_dim;
    FIRESIZE_AGEF_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "FIRESIZE_AGEF", NC_FLOAT, RANK_FIRESIZE_AGEF, FIRESIZE_AGEF_dims, &FIRESIZE_AGEF_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGEF_id, NC_CHUNKED, FIRESIZE_AGEF_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGEF_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    FIRESIZE_AGSV_dims[0] = Time_dim;
    FIRESIZE_AGSV_dims[1] = south_north_dim;
    FIRESIZE_AGSV_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "FIRESIZE_AGSV", NC_FLOAT, RANK_FIRESIZE_AGSV, FIRESIZE_AGSV_dims, &FIRESIZE_AGSV_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGSV_id, NC_CHUNKED, FIRESIZE_AGSV_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGSV_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    FIRESIZE_AGGR_dims[0] = Time_dim;
    FIRESIZE_AGGR_dims[1] = south_north_dim;
    FIRESIZE_AGGR_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "FIRESIZE_AGGR", NC_FLOAT, RANK_FIRESIZE_AGGR, FIRESIZE_AGGR_dims, &FIRESIZE_AGGR_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGGR_id, NC_CHUNKED, FIRESIZE_AGGR_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGGR_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    EXTCOF55_dims[0] = Time_dim;
    EXTCOF55_dims[1] = bottom_top_dim;
    EXTCOF55_dims[2] = south_north_dim;
    EXTCOF55_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "EXTCOF55", NC_FLOAT, RANK_EXTCOF55, EXTCOF55_dims, &EXTCOF55_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EXTCOF55_id, NC_CHUNKED, EXTCOF55_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EXTCOF55_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    DRY_DEP_LEN_dims[0] = Time_dim;
    DRY_DEP_LEN_dims[1] = bio_emissions_dimension_stag_dim;
    DRY_DEP_LEN_dims[2] = south_north_dim;
    DRY_DEP_LEN_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "DRY_DEP_LEN", NC_FLOAT, RANK_DRY_DEP_LEN, DRY_DEP_LEN_dims, &DRY_DEP_LEN_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRY_DEP_LEN_id, NC_CHUNKED, DRY_DEP_LEN_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRY_DEP_LEN_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    DRY_DEP_FLUX_dims[0] = Time_dim;
    DRY_DEP_FLUX_dims[1] = bio_emissions_dimension_stag_dim;
    DRY_DEP_FLUX_dims[2] = south_north_dim;
    DRY_DEP_FLUX_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "DRY_DEP_FLUX", NC_FLOAT, RANK_DRY_DEP_FLUX, DRY_DEP_FLUX_dims, &DRY_DEP_FLUX_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRY_DEP_FLUX_id, NC_CHUNKED, DRY_DEP_FLUX_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRY_DEP_FLUX_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    WET_DEP_FLUX_dims[0] = Time_dim;
    WET_DEP_FLUX_dims[1] = bio_emissions_dimension_stag_dim;
    WET_DEP_FLUX_dims[2] = south_north_dim;
    WET_DEP_FLUX_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "WET_DEP_FLUX", NC_FLOAT, RANK_WET_DEP_FLUX, WET_DEP_FLUX_dims, &WET_DEP_FLUX_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, WET_DEP_FLUX_id, NC_CHUNKED, WET_DEP_FLUX_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, WET_DEP_FLUX_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    EBIO_ISO_dims[0] = Time_dim;
    EBIO_ISO_dims[1] = south_north_dim;
    EBIO_ISO_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "EBIO_ISO", NC_FLOAT, RANK_EBIO_ISO, EBIO_ISO_dims, &EBIO_ISO_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EBIO_ISO_id, NC_CHUNKED, EBIO_ISO_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EBIO_ISO_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    EBIO_API_dims[0] = Time_dim;
    EBIO_API_dims[1] = south_north_dim;
    EBIO_API_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "EBIO_API", NC_FLOAT, RANK_EBIO_API, EBIO_API_dims, &EBIO_API_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EBIO_API_id, NC_CHUNKED, EBIO_API_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EBIO_API_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    LAI_VEGMASK_dims[0] = Time_dim;
    LAI_VEGMASK_dims[1] = south_north_dim;
    LAI_VEGMASK_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "LAI_VEGMASK", NC_FLOAT, RANK_LAI_VEGMASK, LAI_VEGMASK_dims, &LAI_VEGMASK_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAI_VEGMASK_id, NC_CHUNKED, LAI_VEGMASK_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAI_VEGMASK_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    dvel_o3_dims[0] = Time_dim;
    dvel_o3_dims[1] = klevs_for_dvel_dim;
    dvel_o3_dims[2] = south_north_dim;
    dvel_o3_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "dvel_o3", NC_FLOAT, RANK_dvel_o3, dvel_o3_dims, &dvel_o3_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dvel_o3_id, NC_CHUNKED, dvel_o3_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dvel_o3_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    PM2_5_DRY_dims[0] = Time_dim;
    PM2_5_DRY_dims[1] = bottom_top_dim;
    PM2_5_DRY_dims[2] = south_north_dim;
    PM2_5_DRY_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "PM2_5_DRY", NC_FLOAT, RANK_PM2_5_DRY, PM2_5_DRY_dims, &PM2_5_DRY_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PM2_5_DRY_id, NC_CHUNKED, PM2_5_DRY_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PM2_5_DRY_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    PM10_dims[0] = Time_dim;
    PM10_dims[1] = bottom_top_dim;
    PM10_dims[2] = south_north_dim;
    PM10_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "PM10", NC_FLOAT, RANK_PM10, PM10_dims, &PM10_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PM10_id, NC_CHUNKED, PM10_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PM10_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    DMS_0_dims[0] = Time_dim;
    DMS_0_dims[1] = south_north_dim;
    DMS_0_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "DMS_0", NC_FLOAT, RANK_DMS_0, DMS_0_dims, &DMS_0_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DMS_0_id, NC_CHUNKED, DMS_0_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DMS_0_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    PHOTR201_dims[0] = Time_dim;
    PHOTR201_dims[1] = bottom_top_dim;
    PHOTR201_dims[2] = south_north_dim;
    PHOTR201_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "PHOTR201", NC_FLOAT, RANK_PHOTR201, PHOTR201_dims, &PHOTR201_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR201_id, NC_CHUNKED, PHOTR201_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR201_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    PHOTR202_dims[0] = Time_dim;
    PHOTR202_dims[1] = bottom_top_dim;
    PHOTR202_dims[2] = south_north_dim;
    PHOTR202_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "PHOTR202", NC_FLOAT, RANK_PHOTR202, PHOTR202_dims, &PHOTR202_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR202_id, NC_CHUNKED, PHOTR202_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR202_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    PHOTR203_dims[0] = Time_dim;
    PHOTR203_dims[1] = bottom_top_dim;
    PHOTR203_dims[2] = south_north_dim;
    PHOTR203_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "PHOTR203", NC_FLOAT, RANK_PHOTR203, PHOTR203_dims, &PHOTR203_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR203_id, NC_CHUNKED, PHOTR203_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR203_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    so2_dims[0] = Time_dim;
    so2_dims[1] = bottom_top_dim;
    so2_dims[2] = south_north_dim;
    so2_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "so2", NC_FLOAT, RANK_so2, so2_dims, &so2_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so2_id, NC_CHUNKED, so2_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so2_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    sulf_dims[0] = Time_dim;
    sulf_dims[1] = bottom_top_dim;
    sulf_dims[2] = south_north_dim;
    sulf_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "sulf", NC_FLOAT, RANK_sulf, sulf_dims, &sulf_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, sulf_id, NC_CHUNKED, sulf_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, sulf_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    no2_dims[0] = Time_dim;
    no2_dims[1] = bottom_top_dim;
    no2_dims[2] = south_north_dim;
    no2_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "no2", NC_FLOAT, RANK_no2, no2_dims, &no2_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no2_id, NC_CHUNKED, no2_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no2_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    no_dims[0] = Time_dim;
    no_dims[1] = bottom_top_dim;
    no_dims[2] = south_north_dim;
    no_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "no", NC_FLOAT, RANK_no, no_dims, &no_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no_id, NC_CHUNKED, no_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    o3_dims[0] = Time_dim;
    o3_dims[1] = bottom_top_dim;
    o3_dims[2] = south_north_dim;
    o3_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "o3", NC_FLOAT, RANK_o3, o3_dims, &o3_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, o3_id, NC_CHUNKED, o3_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, o3_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    hno3_dims[0] = Time_dim;
    hno3_dims[1] = bottom_top_dim;
    hno3_dims[2] = south_north_dim;
    hno3_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "hno3", NC_FLOAT, RANK_hno3, hno3_dims, &hno3_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hno3_id, NC_CHUNKED, hno3_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hno3_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    h2o2_dims[0] = Time_dim;
    h2o2_dims[1] = bottom_top_dim;
    h2o2_dims[2] = south_north_dim;
    h2o2_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "h2o2", NC_FLOAT, RANK_h2o2, h2o2_dims, &h2o2_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, h2o2_id, NC_CHUNKED, h2o2_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, h2o2_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ald_dims[0] = Time_dim;
    ald_dims[1] = bottom_top_dim;
    ald_dims[2] = south_north_dim;
    ald_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ald", NC_FLOAT, RANK_ald, ald_dims, &ald_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ald_id, NC_CHUNKED, ald_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ald_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    hcho_dims[0] = Time_dim;
    hcho_dims[1] = bottom_top_dim;
    hcho_dims[2] = south_north_dim;
    hcho_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "hcho", NC_FLOAT, RANK_hcho, hcho_dims, &hcho_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hcho_id, NC_CHUNKED, hcho_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hcho_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    op1_dims[0] = Time_dim;
    op1_dims[1] = bottom_top_dim;
    op1_dims[2] = south_north_dim;
    op1_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "op1", NC_FLOAT, RANK_op1, op1_dims, &op1_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, op1_id, NC_CHUNKED, op1_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, op1_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    op2_dims[0] = Time_dim;
    op2_dims[1] = bottom_top_dim;
    op2_dims[2] = south_north_dim;
    op2_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "op2", NC_FLOAT, RANK_op2, op2_dims, &op2_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, op2_id, NC_CHUNKED, op2_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, op2_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    paa_dims[0] = Time_dim;
    paa_dims[1] = bottom_top_dim;
    paa_dims[2] = south_north_dim;
    paa_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "paa", NC_FLOAT, RANK_paa, paa_dims, &paa_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, paa_id, NC_CHUNKED, paa_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, paa_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ora1_dims[0] = Time_dim;
    ora1_dims[1] = bottom_top_dim;
    ora1_dims[2] = south_north_dim;
    ora1_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ora1", NC_FLOAT, RANK_ora1, ora1_dims, &ora1_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ora1_id, NC_CHUNKED, ora1_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ora1_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ora2_dims[0] = Time_dim;
    ora2_dims[1] = bottom_top_dim;
    ora2_dims[2] = south_north_dim;
    ora2_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ora2", NC_FLOAT, RANK_ora2, ora2_dims, &ora2_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ora2_id, NC_CHUNKED, ora2_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ora2_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    nh3_dims[0] = Time_dim;
    nh3_dims[1] = bottom_top_dim;
    nh3_dims[2] = south_north_dim;
    nh3_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "nh3", NC_FLOAT, RANK_nh3, nh3_dims, &nh3_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh3_id, NC_CHUNKED, nh3_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh3_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    n2o5_dims[0] = Time_dim;
    n2o5_dims[1] = bottom_top_dim;
    n2o5_dims[2] = south_north_dim;
    n2o5_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "n2o5", NC_FLOAT, RANK_n2o5, n2o5_dims, &n2o5_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, n2o5_id, NC_CHUNKED, n2o5_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, n2o5_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    no3_dims[0] = Time_dim;
    no3_dims[1] = bottom_top_dim;
    no3_dims[2] = south_north_dim;
    no3_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "no3", NC_FLOAT, RANK_no3, no3_dims, &no3_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3_id, NC_CHUNKED, no3_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    pan_dims[0] = Time_dim;
    pan_dims[1] = bottom_top_dim;
    pan_dims[2] = south_north_dim;
    pan_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "pan", NC_FLOAT, RANK_pan, pan_dims, &pan_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, pan_id, NC_CHUNKED, pan_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, pan_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    hc3_dims[0] = Time_dim;
    hc3_dims[1] = bottom_top_dim;
    hc3_dims[2] = south_north_dim;
    hc3_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "hc3", NC_FLOAT, RANK_hc3, hc3_dims, &hc3_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc3_id, NC_CHUNKED, hc3_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc3_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    hc5_dims[0] = Time_dim;
    hc5_dims[1] = bottom_top_dim;
    hc5_dims[2] = south_north_dim;
    hc5_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "hc5", NC_FLOAT, RANK_hc5, hc5_dims, &hc5_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc5_id, NC_CHUNKED, hc5_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc5_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    hc8_dims[0] = Time_dim;
    hc8_dims[1] = bottom_top_dim;
    hc8_dims[2] = south_north_dim;
    hc8_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "hc8", NC_FLOAT, RANK_hc8, hc8_dims, &hc8_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc8_id, NC_CHUNKED, hc8_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc8_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    eth_dims[0] = Time_dim;
    eth_dims[1] = bottom_top_dim;
    eth_dims[2] = south_north_dim;
    eth_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "eth", NC_FLOAT, RANK_eth, eth_dims, &eth_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, eth_id, NC_CHUNKED, eth_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, eth_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    co_dims[0] = Time_dim;
    co_dims[1] = bottom_top_dim;
    co_dims[2] = south_north_dim;
    co_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "co", NC_FLOAT, RANK_co, co_dims, &co_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, co_id, NC_CHUNKED, co_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, co_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ete_dims[0] = Time_dim;
    ete_dims[1] = bottom_top_dim;
    ete_dims[2] = south_north_dim;
    ete_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ete", NC_FLOAT, RANK_ete, ete_dims, &ete_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ete_id, NC_CHUNKED, ete_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ete_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    olt_dims[0] = Time_dim;
    olt_dims[1] = bottom_top_dim;
    olt_dims[2] = south_north_dim;
    olt_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "olt", NC_FLOAT, RANK_olt, olt_dims, &olt_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, olt_id, NC_CHUNKED, olt_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, olt_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    oli_dims[0] = Time_dim;
    oli_dims[1] = bottom_top_dim;
    oli_dims[2] = south_north_dim;
    oli_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "oli", NC_FLOAT, RANK_oli, oli_dims, &oli_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, oli_id, NC_CHUNKED, oli_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, oli_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    tol_dims[0] = Time_dim;
    tol_dims[1] = bottom_top_dim;
    tol_dims[2] = south_north_dim;
    tol_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "tol", NC_FLOAT, RANK_tol, tol_dims, &tol_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, tol_id, NC_CHUNKED, tol_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, tol_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    xyl_dims[0] = Time_dim;
    xyl_dims[1] = bottom_top_dim;
    xyl_dims[2] = south_north_dim;
    xyl_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "xyl", NC_FLOAT, RANK_xyl, xyl_dims, &xyl_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, xyl_id, NC_CHUNKED, xyl_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, xyl_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    aco3_dims[0] = Time_dim;
    aco3_dims[1] = bottom_top_dim;
    aco3_dims[2] = south_north_dim;
    aco3_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "aco3", NC_FLOAT, RANK_aco3, aco3_dims, &aco3_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, aco3_id, NC_CHUNKED, aco3_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, aco3_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    tpan_dims[0] = Time_dim;
    tpan_dims[1] = bottom_top_dim;
    tpan_dims[2] = south_north_dim;
    tpan_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "tpan", NC_FLOAT, RANK_tpan, tpan_dims, &tpan_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, tpan_id, NC_CHUNKED, tpan_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, tpan_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    hono_dims[0] = Time_dim;
    hono_dims[1] = bottom_top_dim;
    hono_dims[2] = south_north_dim;
    hono_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "hono", NC_FLOAT, RANK_hono, hono_dims, &hono_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hono_id, NC_CHUNKED, hono_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hono_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    hno4_dims[0] = Time_dim;
    hno4_dims[1] = bottom_top_dim;
    hno4_dims[2] = south_north_dim;
    hno4_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "hno4", NC_FLOAT, RANK_hno4, hno4_dims, &hno4_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hno4_id, NC_CHUNKED, hno4_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hno4_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ket_dims[0] = Time_dim;
    ket_dims[1] = bottom_top_dim;
    ket_dims[2] = south_north_dim;
    ket_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ket", NC_FLOAT, RANK_ket, ket_dims, &ket_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ket_id, NC_CHUNKED, ket_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ket_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    gly_dims[0] = Time_dim;
    gly_dims[1] = bottom_top_dim;
    gly_dims[2] = south_north_dim;
    gly_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "gly", NC_FLOAT, RANK_gly, gly_dims, &gly_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, gly_id, NC_CHUNKED, gly_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, gly_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    mgly_dims[0] = Time_dim;
    mgly_dims[1] = bottom_top_dim;
    mgly_dims[2] = south_north_dim;
    mgly_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "mgly", NC_FLOAT, RANK_mgly, mgly_dims, &mgly_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mgly_id, NC_CHUNKED, mgly_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mgly_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    dcb_dims[0] = Time_dim;
    dcb_dims[1] = bottom_top_dim;
    dcb_dims[2] = south_north_dim;
    dcb_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "dcb", NC_FLOAT, RANK_dcb, dcb_dims, &dcb_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dcb_id, NC_CHUNKED, dcb_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dcb_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    onit_dims[0] = Time_dim;
    onit_dims[1] = bottom_top_dim;
    onit_dims[2] = south_north_dim;
    onit_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "onit", NC_FLOAT, RANK_onit, onit_dims, &onit_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, onit_id, NC_CHUNKED, onit_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, onit_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    csl_dims[0] = Time_dim;
    csl_dims[1] = bottom_top_dim;
    csl_dims[2] = south_north_dim;
    csl_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "csl", NC_FLOAT, RANK_csl, csl_dims, &csl_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, csl_id, NC_CHUNKED, csl_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, csl_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    iso_dims[0] = Time_dim;
    iso_dims[1] = bottom_top_dim;
    iso_dims[2] = south_north_dim;
    iso_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "iso", NC_FLOAT, RANK_iso, iso_dims, &iso_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, iso_id, NC_CHUNKED, iso_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, iso_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    co2_dims[0] = Time_dim;
    co2_dims[1] = bottom_top_dim;
    co2_dims[2] = south_north_dim;
    co2_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "co2", NC_FLOAT, RANK_co2, co2_dims, &co2_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, co2_id, NC_CHUNKED, co2_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, co2_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ch4_dims[0] = Time_dim;
    ch4_dims[1] = bottom_top_dim;
    ch4_dims[2] = south_north_dim;
    ch4_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ch4", NC_FLOAT, RANK_ch4, ch4_dims, &ch4_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ch4_id, NC_CHUNKED, ch4_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ch4_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    udd_dims[0] = Time_dim;
    udd_dims[1] = bottom_top_dim;
    udd_dims[2] = south_north_dim;
    udd_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "udd", NC_FLOAT, RANK_udd, udd_dims, &udd_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, udd_id, NC_CHUNKED, udd_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, udd_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    hket_dims[0] = Time_dim;
    hket_dims[1] = bottom_top_dim;
    hket_dims[2] = south_north_dim;
    hket_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "hket", NC_FLOAT, RANK_hket, hket_dims, &hket_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hket_id, NC_CHUNKED, hket_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hket_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    api_dims[0] = Time_dim;
    api_dims[1] = bottom_top_dim;
    api_dims[2] = south_north_dim;
    api_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "api", NC_FLOAT, RANK_api, api_dims, &api_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, api_id, NC_CHUNKED, api_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, api_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    lim_dims[0] = Time_dim;
    lim_dims[1] = bottom_top_dim;
    lim_dims[2] = south_north_dim;
    lim_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "lim", NC_FLOAT, RANK_lim, lim_dims, &lim_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, lim_id, NC_CHUNKED, lim_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, lim_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    dien_dims[0] = Time_dim;
    dien_dims[1] = bottom_top_dim;
    dien_dims[2] = south_north_dim;
    dien_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "dien", NC_FLOAT, RANK_dien, dien_dims, &dien_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dien_id, NC_CHUNKED, dien_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dien_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    macr_dims[0] = Time_dim;
    macr_dims[1] = bottom_top_dim;
    macr_dims[2] = south_north_dim;
    macr_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "macr", NC_FLOAT, RANK_macr, macr_dims, &macr_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, macr_id, NC_CHUNKED, macr_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, macr_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    hace_dims[0] = Time_dim;
    hace_dims[1] = bottom_top_dim;
    hace_dims[2] = south_north_dim;
    hace_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "hace", NC_FLOAT, RANK_hace, hace_dims, &hace_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hace_id, NC_CHUNKED, hace_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hace_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ishp_dims[0] = Time_dim;
    ishp_dims[1] = bottom_top_dim;
    ishp_dims[2] = south_north_dim;
    ishp_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ishp", NC_FLOAT, RANK_ishp, ishp_dims, &ishp_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ishp_id, NC_CHUNKED, ishp_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ishp_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ison_dims[0] = Time_dim;
    ison_dims[1] = bottom_top_dim;
    ison_dims[2] = south_north_dim;
    ison_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ison", NC_FLOAT, RANK_ison, ison_dims, &ison_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ison_id, NC_CHUNKED, ison_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ison_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    mahp_dims[0] = Time_dim;
    mahp_dims[1] = bottom_top_dim;
    mahp_dims[2] = south_north_dim;
    mahp_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "mahp", NC_FLOAT, RANK_mahp, mahp_dims, &mahp_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mahp_id, NC_CHUNKED, mahp_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mahp_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    mpan_dims[0] = Time_dim;
    mpan_dims[1] = bottom_top_dim;
    mpan_dims[2] = south_north_dim;
    mpan_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "mpan", NC_FLOAT, RANK_mpan, mpan_dims, &mpan_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mpan_id, NC_CHUNKED, mpan_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mpan_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    nald_dims[0] = Time_dim;
    nald_dims[1] = bottom_top_dim;
    nald_dims[2] = south_north_dim;
    nald_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "nald", NC_FLOAT, RANK_nald, nald_dims, &nald_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nald_id, NC_CHUNKED, nald_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nald_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    sesq_dims[0] = Time_dim;
    sesq_dims[1] = bottom_top_dim;
    sesq_dims[2] = south_north_dim;
    sesq_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "sesq", NC_FLOAT, RANK_sesq, sesq_dims, &sesq_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, sesq_id, NC_CHUNKED, sesq_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, sesq_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    mbo_dims[0] = Time_dim;
    mbo_dims[1] = bottom_top_dim;
    mbo_dims[2] = south_north_dim;
    mbo_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "mbo", NC_FLOAT, RANK_mbo, mbo_dims, &mbo_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mbo_id, NC_CHUNKED, mbo_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mbo_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    cvasoa1_dims[0] = Time_dim;
    cvasoa1_dims[1] = bottom_top_dim;
    cvasoa1_dims[2] = south_north_dim;
    cvasoa1_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "cvasoa1", NC_FLOAT, RANK_cvasoa1, cvasoa1_dims, &cvasoa1_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa1_id, NC_CHUNKED, cvasoa1_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa1_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    cvasoa2_dims[0] = Time_dim;
    cvasoa2_dims[1] = bottom_top_dim;
    cvasoa2_dims[2] = south_north_dim;
    cvasoa2_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "cvasoa2", NC_FLOAT, RANK_cvasoa2, cvasoa2_dims, &cvasoa2_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa2_id, NC_CHUNKED, cvasoa2_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa2_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    cvasoa3_dims[0] = Time_dim;
    cvasoa3_dims[1] = bottom_top_dim;
    cvasoa3_dims[2] = south_north_dim;
    cvasoa3_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "cvasoa3", NC_FLOAT, RANK_cvasoa3, cvasoa3_dims, &cvasoa3_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa3_id, NC_CHUNKED, cvasoa3_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa3_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    cvasoa4_dims[0] = Time_dim;
    cvasoa4_dims[1] = bottom_top_dim;
    cvasoa4_dims[2] = south_north_dim;
    cvasoa4_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "cvasoa4", NC_FLOAT, RANK_cvasoa4, cvasoa4_dims, &cvasoa4_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa4_id, NC_CHUNKED, cvasoa4_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa4_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    cvbsoa1_dims[0] = Time_dim;
    cvbsoa1_dims[1] = bottom_top_dim;
    cvbsoa1_dims[2] = south_north_dim;
    cvbsoa1_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "cvbsoa1", NC_FLOAT, RANK_cvbsoa1, cvbsoa1_dims, &cvbsoa1_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa1_id, NC_CHUNKED, cvbsoa1_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa1_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    cvbsoa2_dims[0] = Time_dim;
    cvbsoa2_dims[1] = bottom_top_dim;
    cvbsoa2_dims[2] = south_north_dim;
    cvbsoa2_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "cvbsoa2", NC_FLOAT, RANK_cvbsoa2, cvbsoa2_dims, &cvbsoa2_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa2_id, NC_CHUNKED, cvbsoa2_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa2_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    cvbsoa3_dims[0] = Time_dim;
    cvbsoa3_dims[1] = bottom_top_dim;
    cvbsoa3_dims[2] = south_north_dim;
    cvbsoa3_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "cvbsoa3", NC_FLOAT, RANK_cvbsoa3, cvbsoa3_dims, &cvbsoa3_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa3_id, NC_CHUNKED, cvbsoa3_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa3_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    cvbsoa4_dims[0] = Time_dim;
    cvbsoa4_dims[1] = bottom_top_dim;
    cvbsoa4_dims[2] = south_north_dim;
    cvbsoa4_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "cvbsoa4", NC_FLOAT, RANK_cvbsoa4, cvbsoa4_dims, &cvbsoa4_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa4_id, NC_CHUNKED, cvbsoa4_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa4_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ho_dims[0] = Time_dim;
    ho_dims[1] = bottom_top_dim;
    ho_dims[2] = south_north_dim;
    ho_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ho", NC_FLOAT, RANK_ho, ho_dims, &ho_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ho_id, NC_CHUNKED, ho_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ho_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ho2_dims[0] = Time_dim;
    ho2_dims[1] = bottom_top_dim;
    ho2_dims[2] = south_north_dim;
    ho2_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ho2", NC_FLOAT, RANK_ho2, ho2_dims, &ho2_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ho2_id, NC_CHUNKED, ho2_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ho2_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    so4aj_dims[0] = Time_dim;
    so4aj_dims[1] = bottom_top_dim;
    so4aj_dims[2] = south_north_dim;
    so4aj_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "so4aj", NC_FLOAT, RANK_so4aj, so4aj_dims, &so4aj_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so4aj_id, NC_CHUNKED, so4aj_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so4aj_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    so4ai_dims[0] = Time_dim;
    so4ai_dims[1] = bottom_top_dim;
    so4ai_dims[2] = south_north_dim;
    so4ai_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "so4ai", NC_FLOAT, RANK_so4ai, so4ai_dims, &so4ai_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so4ai_id, NC_CHUNKED, so4ai_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so4ai_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    nh4aj_dims[0] = Time_dim;
    nh4aj_dims[1] = bottom_top_dim;
    nh4aj_dims[2] = south_north_dim;
    nh4aj_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "nh4aj", NC_FLOAT, RANK_nh4aj, nh4aj_dims, &nh4aj_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh4aj_id, NC_CHUNKED, nh4aj_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh4aj_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    nh4ai_dims[0] = Time_dim;
    nh4ai_dims[1] = bottom_top_dim;
    nh4ai_dims[2] = south_north_dim;
    nh4ai_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "nh4ai", NC_FLOAT, RANK_nh4ai, nh4ai_dims, &nh4ai_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh4ai_id, NC_CHUNKED, nh4ai_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh4ai_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    no3aj_dims[0] = Time_dim;
    no3aj_dims[1] = bottom_top_dim;
    no3aj_dims[2] = south_north_dim;
    no3aj_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "no3aj", NC_FLOAT, RANK_no3aj, no3aj_dims, &no3aj_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3aj_id, NC_CHUNKED, no3aj_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3aj_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    no3ai_dims[0] = Time_dim;
    no3ai_dims[1] = bottom_top_dim;
    no3ai_dims[2] = south_north_dim;
    no3ai_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "no3ai", NC_FLOAT, RANK_no3ai, no3ai_dims, &no3ai_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3ai_id, NC_CHUNKED, no3ai_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3ai_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    naaj_dims[0] = Time_dim;
    naaj_dims[1] = bottom_top_dim;
    naaj_dims[2] = south_north_dim;
    naaj_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "naaj", NC_FLOAT, RANK_naaj, naaj_dims, &naaj_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, naaj_id, NC_CHUNKED, naaj_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, naaj_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    naai_dims[0] = Time_dim;
    naai_dims[1] = bottom_top_dim;
    naai_dims[2] = south_north_dim;
    naai_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "naai", NC_FLOAT, RANK_naai, naai_dims, &naai_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, naai_id, NC_CHUNKED, naai_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, naai_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    claj_dims[0] = Time_dim;
    claj_dims[1] = bottom_top_dim;
    claj_dims[2] = south_north_dim;
    claj_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "claj", NC_FLOAT, RANK_claj, claj_dims, &claj_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, claj_id, NC_CHUNKED, claj_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, claj_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    clai_dims[0] = Time_dim;
    clai_dims[1] = bottom_top_dim;
    clai_dims[2] = south_north_dim;
    clai_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "clai", NC_FLOAT, RANK_clai, clai_dims, &clai_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, clai_id, NC_CHUNKED, clai_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, clai_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    asoa1j_dims[0] = Time_dim;
    asoa1j_dims[1] = bottom_top_dim;
    asoa1j_dims[2] = south_north_dim;
    asoa1j_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "asoa1j", NC_FLOAT, RANK_asoa1j, asoa1j_dims, &asoa1j_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa1j_id, NC_CHUNKED, asoa1j_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa1j_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    asoa1i_dims[0] = Time_dim;
    asoa1i_dims[1] = bottom_top_dim;
    asoa1i_dims[2] = south_north_dim;
    asoa1i_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "asoa1i", NC_FLOAT, RANK_asoa1i, asoa1i_dims, &asoa1i_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa1i_id, NC_CHUNKED, asoa1i_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa1i_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    asoa2j_dims[0] = Time_dim;
    asoa2j_dims[1] = bottom_top_dim;
    asoa2j_dims[2] = south_north_dim;
    asoa2j_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "asoa2j", NC_FLOAT, RANK_asoa2j, asoa2j_dims, &asoa2j_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa2j_id, NC_CHUNKED, asoa2j_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa2j_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    asoa2i_dims[0] = Time_dim;
    asoa2i_dims[1] = bottom_top_dim;
    asoa2i_dims[2] = south_north_dim;
    asoa2i_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "asoa2i", NC_FLOAT, RANK_asoa2i, asoa2i_dims, &asoa2i_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa2i_id, NC_CHUNKED, asoa2i_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa2i_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    asoa3j_dims[0] = Time_dim;
    asoa3j_dims[1] = bottom_top_dim;
    asoa3j_dims[2] = south_north_dim;
    asoa3j_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "asoa3j", NC_FLOAT, RANK_asoa3j, asoa3j_dims, &asoa3j_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa3j_id, NC_CHUNKED, asoa3j_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa3j_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    asoa3i_dims[0] = Time_dim;
    asoa3i_dims[1] = bottom_top_dim;
    asoa3i_dims[2] = south_north_dim;
    asoa3i_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "asoa3i", NC_FLOAT, RANK_asoa3i, asoa3i_dims, &asoa3i_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa3i_id, NC_CHUNKED, asoa3i_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa3i_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    asoa4j_dims[0] = Time_dim;
    asoa4j_dims[1] = bottom_top_dim;
    asoa4j_dims[2] = south_north_dim;
    asoa4j_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "asoa4j", NC_FLOAT, RANK_asoa4j, asoa4j_dims, &asoa4j_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa4j_id, NC_CHUNKED, asoa4j_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa4j_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    asoa4i_dims[0] = Time_dim;
    asoa4i_dims[1] = bottom_top_dim;
    asoa4i_dims[2] = south_north_dim;
    asoa4i_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "asoa4i", NC_FLOAT, RANK_asoa4i, asoa4i_dims, &asoa4i_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa4i_id, NC_CHUNKED, asoa4i_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa4i_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    bsoa1j_dims[0] = Time_dim;
    bsoa1j_dims[1] = bottom_top_dim;
    bsoa1j_dims[2] = south_north_dim;
    bsoa1j_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "bsoa1j", NC_FLOAT, RANK_bsoa1j, bsoa1j_dims, &bsoa1j_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa1j_id, NC_CHUNKED, bsoa1j_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa1j_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    bsoa1i_dims[0] = Time_dim;
    bsoa1i_dims[1] = bottom_top_dim;
    bsoa1i_dims[2] = south_north_dim;
    bsoa1i_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "bsoa1i", NC_FLOAT, RANK_bsoa1i, bsoa1i_dims, &bsoa1i_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa1i_id, NC_CHUNKED, bsoa1i_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa1i_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    bsoa2j_dims[0] = Time_dim;
    bsoa2j_dims[1] = bottom_top_dim;
    bsoa2j_dims[2] = south_north_dim;
    bsoa2j_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "bsoa2j", NC_FLOAT, RANK_bsoa2j, bsoa2j_dims, &bsoa2j_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa2j_id, NC_CHUNKED, bsoa2j_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa2j_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    bsoa2i_dims[0] = Time_dim;
    bsoa2i_dims[1] = bottom_top_dim;
    bsoa2i_dims[2] = south_north_dim;
    bsoa2i_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "bsoa2i", NC_FLOAT, RANK_bsoa2i, bsoa2i_dims, &bsoa2i_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa2i_id, NC_CHUNKED, bsoa2i_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa2i_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    bsoa3j_dims[0] = Time_dim;
    bsoa3j_dims[1] = bottom_top_dim;
    bsoa3j_dims[2] = south_north_dim;
    bsoa3j_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "bsoa3j", NC_FLOAT, RANK_bsoa3j, bsoa3j_dims, &bsoa3j_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa3j_id, NC_CHUNKED, bsoa3j_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa3j_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    bsoa3i_dims[0] = Time_dim;
    bsoa3i_dims[1] = bottom_top_dim;
    bsoa3i_dims[2] = south_north_dim;
    bsoa3i_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "bsoa3i", NC_FLOAT, RANK_bsoa3i, bsoa3i_dims, &bsoa3i_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa3i_id, NC_CHUNKED, bsoa3i_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa3i_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    bsoa4j_dims[0] = Time_dim;
    bsoa4j_dims[1] = bottom_top_dim;
    bsoa4j_dims[2] = south_north_dim;
    bsoa4j_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "bsoa4j", NC_FLOAT, RANK_bsoa4j, bsoa4j_dims, &bsoa4j_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa4j_id, NC_CHUNKED, bsoa4j_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa4j_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    bsoa4i_dims[0] = Time_dim;
    bsoa4i_dims[1] = bottom_top_dim;
    bsoa4i_dims[2] = south_north_dim;
    bsoa4i_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "bsoa4i", NC_FLOAT, RANK_bsoa4i, bsoa4i_dims, &bsoa4i_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa4i_id, NC_CHUNKED, bsoa4i_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa4i_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    orgpaj_dims[0] = Time_dim;
    orgpaj_dims[1] = bottom_top_dim;
    orgpaj_dims[2] = south_north_dim;
    orgpaj_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "orgpaj", NC_FLOAT, RANK_orgpaj, orgpaj_dims, &orgpaj_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, orgpaj_id, NC_CHUNKED, orgpaj_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, orgpaj_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    orgpai_dims[0] = Time_dim;
    orgpai_dims[1] = bottom_top_dim;
    orgpai_dims[2] = south_north_dim;
    orgpai_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "orgpai", NC_FLOAT, RANK_orgpai, orgpai_dims, &orgpai_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, orgpai_id, NC_CHUNKED, orgpai_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, orgpai_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ecj_dims[0] = Time_dim;
    ecj_dims[1] = bottom_top_dim;
    ecj_dims[2] = south_north_dim;
    ecj_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ecj", NC_FLOAT, RANK_ecj, ecj_dims, &ecj_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ecj_id, NC_CHUNKED, ecj_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ecj_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    eci_dims[0] = Time_dim;
    eci_dims[1] = bottom_top_dim;
    eci_dims[2] = south_north_dim;
    eci_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "eci", NC_FLOAT, RANK_eci, eci_dims, &eci_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, eci_id, NC_CHUNKED, eci_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, eci_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    p25j_dims[0] = Time_dim;
    p25j_dims[1] = bottom_top_dim;
    p25j_dims[2] = south_north_dim;
    p25j_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "p25j", NC_FLOAT, RANK_p25j, p25j_dims, &p25j_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, p25j_id, NC_CHUNKED, p25j_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, p25j_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    p25i_dims[0] = Time_dim;
    p25i_dims[1] = bottom_top_dim;
    p25i_dims[2] = south_north_dim;
    p25i_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "p25i", NC_FLOAT, RANK_p25i, p25i_dims, &p25i_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, p25i_id, NC_CHUNKED, p25i_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, p25i_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    antha_dims[0] = Time_dim;
    antha_dims[1] = bottom_top_dim;
    antha_dims[2] = south_north_dim;
    antha_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "antha", NC_FLOAT, RANK_antha, antha_dims, &antha_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, antha_id, NC_CHUNKED, antha_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, antha_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    seas_dims[0] = Time_dim;
    seas_dims[1] = bottom_top_dim;
    seas_dims[2] = south_north_dim;
    seas_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "seas", NC_FLOAT, RANK_seas, seas_dims, &seas_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, seas_id, NC_CHUNKED, seas_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, seas_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    soila_dims[0] = Time_dim;
    soila_dims[1] = bottom_top_dim;
    soila_dims[2] = south_north_dim;
    soila_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "soila", NC_FLOAT, RANK_soila, soila_dims, &soila_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, soila_id, NC_CHUNKED, soila_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, soila_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    nu0_dims[0] = Time_dim;
    nu0_dims[1] = bottom_top_dim;
    nu0_dims[2] = south_north_dim;
    nu0_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "nu0", NC_FLOAT, RANK_nu0, nu0_dims, &nu0_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nu0_id, NC_CHUNKED, nu0_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nu0_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ac0_dims[0] = Time_dim;
    ac0_dims[1] = bottom_top_dim;
    ac0_dims[2] = south_north_dim;
    ac0_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ac0", NC_FLOAT, RANK_ac0, ac0_dims, &ac0_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ac0_id, NC_CHUNKED, ac0_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ac0_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    corn_dims[0] = Time_dim;
    corn_dims[1] = bottom_top_dim;
    corn_dims[2] = south_north_dim;
    corn_dims[3] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "corn", NC_FLOAT, RANK_corn, corn_dims, &corn_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, corn_id, NC_CHUNKED, corn_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, corn_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    ISEEDARR_SPPT_dims[0] = Time_dim;
    ISEEDARR_SPPT_dims[1] = bottom_top_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ISEEDARR_SPPT", NC_INT, RANK_ISEEDARR_SPPT, ISEEDARR_SPPT_dims, &ISEEDARR_SPPT_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARR_SPPT_id, NC_CHUNKED, ISEEDARR_SPPT_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_endian(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARR_SPPT_id, NC_ENDIAN_LITTLE); */
    /* check_err(stat,__LINE__,__FILE__); */

    ISEEDARR_SKEBS_dims[0] = Time_dim;
    ISEEDARR_SKEBS_dims[1] = bottom_top_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ISEEDARR_SKEBS", NC_INT, RANK_ISEEDARR_SKEBS, ISEEDARR_SKEBS_dims, &ISEEDARR_SKEBS_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARR_SKEBS_id, NC_CHUNKED, ISEEDARR_SKEBS_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_endian(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARR_SKEBS_id, NC_ENDIAN_LITTLE); */
    /* check_err(stat,__LINE__,__FILE__); */

    ISEEDARR_RAND_PERTURB_dims[0] = Time_dim;
    ISEEDARR_RAND_PERTURB_dims[1] = bottom_top_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ISEEDARR_RAND_PERTURB", NC_INT, RANK_ISEEDARR_RAND_PERTURB, ISEEDARR_RAND_PERTURB_dims, &ISEEDARR_RAND_PERTURB_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARR_RAND_PERTURB_id, NC_CHUNKED, ISEEDARR_RAND_PERTURB_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_endian(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARR_RAND_PERTURB_id, NC_ENDIAN_LITTLE); */
    /* check_err(stat,__LINE__,__FILE__); */

    ISEEDARRAY_SPP_CONV_dims[0] = Time_dim;
    ISEEDARRAY_SPP_CONV_dims[1] = bottom_top_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ISEEDARRAY_SPP_CONV", NC_INT, RANK_ISEEDARRAY_SPP_CONV, ISEEDARRAY_SPP_CONV_dims, &ISEEDARRAY_SPP_CONV_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARRAY_SPP_CONV_id, NC_CHUNKED, ISEEDARRAY_SPP_CONV_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_endian(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARRAY_SPP_CONV_id, NC_ENDIAN_LITTLE); */
    /* check_err(stat,__LINE__,__FILE__); */

    ISEEDARRAY_SPP_PBL_dims[0] = Time_dim;
    ISEEDARRAY_SPP_PBL_dims[1] = bottom_top_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ISEEDARRAY_SPP_PBL", NC_INT, RANK_ISEEDARRAY_SPP_PBL, ISEEDARRAY_SPP_PBL_dims, &ISEEDARRAY_SPP_PBL_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARRAY_SPP_PBL_id, NC_CHUNKED, ISEEDARRAY_SPP_PBL_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_endian(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARRAY_SPP_PBL_id, NC_ENDIAN_LITTLE); */
    /* check_err(stat,__LINE__,__FILE__); */

    ISEEDARRAY_SPP_LSM_dims[0] = Time_dim;
    ISEEDARRAY_SPP_LSM_dims[1] = bottom_top_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "ISEEDARRAY_SPP_LSM", NC_INT, RANK_ISEEDARRAY_SPP_LSM, ISEEDARRAY_SPP_LSM_dims, &ISEEDARRAY_SPP_LSM_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARRAY_SPP_LSM_id, NC_CHUNKED, ISEEDARRAY_SPP_LSM_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_endian(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARRAY_SPP_LSM_id, NC_ENDIAN_LITTLE); */
    /* check_err(stat,__LINE__,__FILE__); */

    BF_dims[0] = Time_dim;
    BF_dims[1] = bottom_top_stag_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "BF", NC_FLOAT, RANK_BF, BF_dims, &BF_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, BF_id, NC_CHUNKED, BF_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    C1H_dims[0] = Time_dim;
    C1H_dims[1] = bottom_top_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "C1H", NC_FLOAT, RANK_C1H, C1H_dims, &C1H_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C1H_id, NC_CHUNKED, C1H_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    C2H_dims[0] = Time_dim;
    C2H_dims[1] = bottom_top_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "C2H", NC_FLOAT, RANK_C2H, C2H_dims, &C2H_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C2H_id, NC_CHUNKED, C2H_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    BH_dims[0] = Time_dim;
    BH_dims[1] = bottom_top_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "BH", NC_FLOAT, RANK_BH, BH_dims, &BH_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, BH_id, NC_CHUNKED, BH_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    C1F_dims[0] = Time_dim;
    C1F_dims[1] = bottom_top_stag_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "C1F", NC_FLOAT, RANK_C1F, C1F_dims, &C1F_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C1F_id, NC_CHUNKED, C1F_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    C2F_dims[0] = Time_dim;
    C2F_dims[1] = bottom_top_stag_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "C2F", NC_FLOAT, RANK_C2F, C2F_dims, &C2F_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C2F_id, NC_CHUNKED, C2F_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    C3H_dims[0] = Time_dim;
    C3H_dims[1] = bottom_top_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "C3H", NC_FLOAT, RANK_C3H, C3H_dims, &C3H_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C3H_id, NC_CHUNKED, C3H_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    C4H_dims[0] = Time_dim;
    C4H_dims[1] = bottom_top_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "C4H", NC_FLOAT, RANK_C4H, C4H_dims, &C4H_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C4H_id, NC_CHUNKED, C4H_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    C3F_dims[0] = Time_dim;
    C3F_dims[1] = bottom_top_stag_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "C3F", NC_FLOAT, RANK_C3F, C3F_dims, &C3F_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C3F_id, NC_CHUNKED, C3F_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    C4F_dims[0] = Time_dim;
    C4F_dims[1] = bottom_top_stag_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "C4F", NC_FLOAT, RANK_C4F, C4F_dims, &C4F_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C4F_id, NC_CHUNKED, C4F_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */

    PCB_dims[0] = Time_dim;
    PCB_dims[1] = south_north_dim;
    PCB_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "PCB", NC_FLOAT, RANK_PCB, PCB_dims, &PCB_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PCB_id, NC_CHUNKED, PCB_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PCB_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    PC_dims[0] = Time_dim;
    PC_dims[1] = south_north_dim;
    PC_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "PC", NC_FLOAT, RANK_PC, PC_dims, &PC_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PC_id, NC_CHUNKED, PC_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PC_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    LANDMASK_dims[0] = Time_dim;
    LANDMASK_dims[1] = south_north_dim;
    LANDMASK_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "LANDMASK", NC_FLOAT, RANK_LANDMASK, LANDMASK_dims, &LANDMASK_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LANDMASK_id, NC_CHUNKED, LANDMASK_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LANDMASK_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    LAKEMASK_dims[0] = Time_dim;
    LAKEMASK_dims[1] = south_north_dim;
    LAKEMASK_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "LAKEMASK", NC_FLOAT, RANK_LAKEMASK, LAKEMASK_dims, &LAKEMASK_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAKEMASK_id, NC_CHUNKED, LAKEMASK_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAKEMASK_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SST_dims[0] = Time_dim;
    SST_dims[1] = south_north_dim;
    SST_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SST", NC_FLOAT, RANK_SST, SST_dims, &SST_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SST_id, NC_CHUNKED, SST_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SST_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    SST_INPUT_dims[0] = Time_dim;
    SST_INPUT_dims[1] = south_north_dim;
    SST_INPUT_dims[2] = west_east_dim;
    stat = nc_def_var(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, "SST_INPUT", NC_FLOAT, RANK_SST_INPUT, SST_INPUT_dims, &SST_INPUT_id);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_def_var_chunking(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SST_INPUT_id, NC_CHUNKED, SST_INPUT_chunksizes); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* stat = nc_def_var_deflate(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SST_INPUT_id, NC_SHUFFLE, 1, 2); */
    /* check_err(stat,__LINE__,__FILE__); */

    /* assign global attributes */

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "TITLE", 54, " OUTPUT FROM *             PROGRAM:WRF-Chem V3.9 MODEL");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "START_DATE", 19, "2018-12-20_00:00:00");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SIMULATION_START_DATE", 19, "2018-12-20_00:00:00");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int WEST_MINUS_EAST_GRID_DIMENSION_att[1] = {649} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "WEST-EAST_GRID_DIMENSION", NC_INT, 1, WEST_MINUS_EAST_GRID_DIMENSION_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int SOUTH_MINUS_NORTH_GRID_DIMENSION_att[1] = {648} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SOUTH-NORTH_GRID_DIMENSION", NC_INT, 1, SOUTH_MINUS_NORTH_GRID_DIMENSION_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int BOTTOM_MINUS_TOP_GRID_DIMENSION_att[1] = {51} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "BOTTOM-TOP_GRID_DIMENSION", NC_INT, 1, BOTTOM_MINUS_TOP_GRID_DIMENSION_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float DX_att[1] = {((float)13545.09)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "DX", NC_FLOAT, 1, DX_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float DY_att[1] = {((float)13545.09)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "DY", NC_FLOAT, 1, DY_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int SKEBS_ON_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SKEBS_ON", NC_INT, 1, SKEBS_ON_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int SPEC_BDY_FINAL_MU_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SPEC_BDY_FINAL_MU", NC_INT, 1, SPEC_BDY_FINAL_MU_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int USE_Q_DIABATIC_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "USE_Q_DIABATIC", NC_INT, 1, USE_Q_DIABATIC_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "GRIDTYPE", 1, "C");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int DIFF_OPT_att[1] = {2} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "DIFF_OPT", NC_INT, 1, DIFF_OPT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int KM_OPT_att[1] = {4} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "KM_OPT", NC_INT, 1, KM_OPT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int DAMP_OPT_att[1] = {3} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "DAMP_OPT", NC_INT, 1, DAMP_OPT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float DAMPCOEF_att[1] = {((float)0.2)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "DAMPCOEF", NC_FLOAT, 1, DAMPCOEF_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float KHDIF_att[1] = {((float)0)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "KHDIF", NC_FLOAT, 1, KHDIF_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float KVDIF_att[1] = {((float)0)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "KVDIF", NC_FLOAT, 1, KVDIF_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int MP_PHYSICS_att[1] = {28} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "MP_PHYSICS", NC_INT, 1, MP_PHYSICS_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int RA_LW_PHYSICS_att[1] = {4} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "RA_LW_PHYSICS", NC_INT, 1, RA_LW_PHYSICS_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int RA_SW_PHYSICS_att[1] = {4} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "RA_SW_PHYSICS", NC_INT, 1, RA_SW_PHYSICS_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int SF_SFCLAY_PHYSICS_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SF_SFCLAY_PHYSICS", NC_INT, 1, SF_SFCLAY_PHYSICS_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int SF_SURFACE_PHYSICS_att[1] = {2} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SF_SURFACE_PHYSICS", NC_INT, 1, SF_SURFACE_PHYSICS_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int BL_PBL_PHYSICS_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "BL_PBL_PHYSICS", NC_INT, 1, BL_PBL_PHYSICS_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int CU_PHYSICS_att[1] = {3} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "CU_PHYSICS", NC_INT, 1, CU_PHYSICS_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int SF_LAKE_PHYSICS_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SF_LAKE_PHYSICS", NC_INT, 1, SF_LAKE_PHYSICS_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int SURFACE_INPUT_SOURCE_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SURFACE_INPUT_SOURCE", NC_INT, 1, SURFACE_INPUT_SOURCE_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int SST_UPDATE_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SST_UPDATE", NC_INT, 1, SST_UPDATE_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int GRID_FDDA_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "GRID_FDDA", NC_INT, 1, GRID_FDDA_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int GFDDA_INTERVAL_M_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "GFDDA_INTERVAL_M", NC_INT, 1, GFDDA_INTERVAL_M_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int GFDDA_END_H_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "GFDDA_END_H", NC_INT, 1, GFDDA_END_H_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int GRID_SFDDA_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "GRID_SFDDA", NC_INT, 1, GRID_SFDDA_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int SGFDDA_INTERVAL_M_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SGFDDA_INTERVAL_M", NC_INT, 1, SGFDDA_INTERVAL_M_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int SGFDDA_END_H_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SGFDDA_END_H", NC_INT, 1, SGFDDA_END_H_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int HYPSOMETRIC_OPT_att[1] = {2} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "HYPSOMETRIC_OPT", NC_INT, 1, HYPSOMETRIC_OPT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int USE_THETA_M_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "USE_THETA_M", NC_INT, 1, USE_THETA_M_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int GWD_OPT_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "GWD_OPT", NC_INT, 1, GWD_OPT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int SF_URBAN_PHYSICS_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SF_URBAN_PHYSICS", NC_INT, 1, SF_URBAN_PHYSICS_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int SF_OCEAN_PHYSICS_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SF_OCEAN_PHYSICS", NC_INT, 1, SF_OCEAN_PHYSICS_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int SHCU_PHYSICS_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SHCU_PHYSICS", NC_INT, 1, SHCU_PHYSICS_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int MFSHCONV_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "MFSHCONV", NC_INT, 1, MFSHCONV_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FEEDBACK_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "FEEDBACK", NC_INT, 1, FEEDBACK_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int SMOOTH_OPTION_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SMOOTH_OPTION", NC_INT, 1, SMOOTH_OPTION_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float SWRAD_SCAT_att[1] = {((float)1)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SWRAD_SCAT", NC_FLOAT, 1, SWRAD_SCAT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int W_DAMPING_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "W_DAMPING", NC_INT, 1, W_DAMPING_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float RADT_att[1] = {((float)20)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "RADT", NC_FLOAT, 1, RADT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float BLDT_att[1] = {((float)0)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "BLDT", NC_FLOAT, 1, BLDT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float CUDT_att[1] = {((float)0)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "CUDT", NC_FLOAT, 1, CUDT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int AER_OPT_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "AER_OPT", NC_INT, 1, AER_OPT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int SWINT_OPT_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SWINT_OPT", NC_INT, 1, SWINT_OPT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int AER_TYPE_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "AER_TYPE", NC_INT, 1, AER_TYPE_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int AER_AOD550_OPT_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "AER_AOD550_OPT", NC_INT, 1, AER_AOD550_OPT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int AER_ANGEXP_OPT_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "AER_ANGEXP_OPT", NC_INT, 1, AER_ANGEXP_OPT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int AER_SSA_OPT_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "AER_SSA_OPT", NC_INT, 1, AER_SSA_OPT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int AER_ASY_OPT_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "AER_ASY_OPT", NC_INT, 1, AER_ASY_OPT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float AER_AOD550_VAL_att[1] = {((float)0.12)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "AER_AOD550_VAL", NC_FLOAT, 1, AER_AOD550_VAL_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float AER_ANGEXP_VAL_att[1] = {((float)1.3)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "AER_ANGEXP_VAL", NC_FLOAT, 1, AER_ANGEXP_VAL_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float AER_SSA_VAL_att[1] = {((float)0.85000002)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "AER_SSA_VAL", NC_FLOAT, 1, AER_SSA_VAL_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float AER_ASY_VAL_att[1] = {((float)0.89999998)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "AER_ASY_VAL", NC_FLOAT, 1, AER_ASY_VAL_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int MOIST_ADV_OPT_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "MOIST_ADV_OPT", NC_INT, 1, MOIST_ADV_OPT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int SCALAR_ADV_OPT_att[1] = {2} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SCALAR_ADV_OPT", NC_INT, 1, SCALAR_ADV_OPT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int TKE_ADV_OPT_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "TKE_ADV_OPT", NC_INT, 1, TKE_ADV_OPT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int DIFF_6TH_OPT_att[1] = {2} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "DIFF_6TH_OPT", NC_INT, 1, DIFF_6TH_OPT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float DIFF_6TH_FACTOR_att[1] = {((float)0.12)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "DIFF_6TH_FACTOR", NC_FLOAT, 1, DIFF_6TH_FACTOR_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int OBS_NUDGE_OPT_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "OBS_NUDGE_OPT", NC_INT, 1, OBS_NUDGE_OPT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float BUCKET_MM_att[1] = {((float)-1)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "BUCKET_MM", NC_FLOAT, 1, BUCKET_MM_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float BUCKET_J_att[1] = {((float)-1)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "BUCKET_J", NC_FLOAT, 1, BUCKET_J_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float PREC_ACC_DT_att[1] = {((float)180)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "PREC_ACC_DT", NC_FLOAT, 1, PREC_ACC_DT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int ISFTCFLX_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "ISFTCFLX", NC_INT, 1, ISFTCFLX_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int ISHALLOW_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "ISHALLOW", NC_INT, 1, ISHALLOW_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int ISFFLX_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "ISFFLX", NC_INT, 1, ISFFLX_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int ICLOUD_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "ICLOUD", NC_INT, 1, ICLOUD_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int ICLOUD_CU_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "ICLOUD_CU", NC_INT, 1, ICLOUD_CU_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int TRACER_PBLMIX_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "TRACER_PBLMIX", NC_INT, 1, TRACER_PBLMIX_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int SCALAR_PBLMIX_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SCALAR_PBLMIX", NC_INT, 1, SCALAR_PBLMIX_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int YSU_TOPDOWN_PBLMIX_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "YSU_TOPDOWN_PBLMIX", NC_INT, 1, YSU_TOPDOWN_PBLMIX_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int GRAV_SETTLING_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "GRAV_SETTLING", NC_INT, 1, GRAV_SETTLING_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int DFI_OPT_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "DFI_OPT", NC_INT, 1, DFI_OPT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SIMULATION_INITIALIZATION_TYPE", 14, "REAL-DATA CASE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int WEST_MINUS_EAST_PATCH_START_UNSTAG_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "WEST-EAST_PATCH_START_UNSTAG", NC_INT, 1, WEST_MINUS_EAST_PATCH_START_UNSTAG_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int WEST_MINUS_EAST_PATCH_END_UNSTAG_att[1] = {648} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "WEST-EAST_PATCH_END_UNSTAG", NC_INT, 1, WEST_MINUS_EAST_PATCH_END_UNSTAG_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int WEST_MINUS_EAST_PATCH_START_STAG_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "WEST-EAST_PATCH_START_STAG", NC_INT, 1, WEST_MINUS_EAST_PATCH_START_STAG_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int WEST_MINUS_EAST_PATCH_END_STAG_att[1] = {649} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "WEST-EAST_PATCH_END_STAG", NC_INT, 1, WEST_MINUS_EAST_PATCH_END_STAG_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int SOUTH_MINUS_NORTH_PATCH_START_UNSTAG_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SOUTH-NORTH_PATCH_START_UNSTAG", NC_INT, 1, SOUTH_MINUS_NORTH_PATCH_START_UNSTAG_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int SOUTH_MINUS_NORTH_PATCH_END_UNSTAG_att[1] = {647} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SOUTH-NORTH_PATCH_END_UNSTAG", NC_INT, 1, SOUTH_MINUS_NORTH_PATCH_END_UNSTAG_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int SOUTH_MINUS_NORTH_PATCH_START_STAG_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SOUTH-NORTH_PATCH_START_STAG", NC_INT, 1, SOUTH_MINUS_NORTH_PATCH_START_STAG_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int SOUTH_MINUS_NORTH_PATCH_END_STAG_att[1] = {648} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "SOUTH-NORTH_PATCH_END_STAG", NC_INT, 1, SOUTH_MINUS_NORTH_PATCH_END_STAG_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int BOTTOM_MINUS_TOP_PATCH_START_UNSTAG_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "BOTTOM-TOP_PATCH_START_UNSTAG", NC_INT, 1, BOTTOM_MINUS_TOP_PATCH_START_UNSTAG_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int BOTTOM_MINUS_TOP_PATCH_END_UNSTAG_att[1] = {50} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "BOTTOM-TOP_PATCH_END_UNSTAG", NC_INT, 1, BOTTOM_MINUS_TOP_PATCH_END_UNSTAG_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int BOTTOM_MINUS_TOP_PATCH_START_STAG_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "BOTTOM-TOP_PATCH_START_STAG", NC_INT, 1, BOTTOM_MINUS_TOP_PATCH_START_STAG_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int BOTTOM_MINUS_TOP_PATCH_END_STAG_att[1] = {51} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "BOTTOM-TOP_PATCH_END_STAG", NC_INT, 1, BOTTOM_MINUS_TOP_PATCH_END_STAG_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int GRID_ID_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "GRID_ID", NC_INT, 1, GRID_ID_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int PARENT_ID_att[1] = {0} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "PARENT_ID", NC_INT, 1, PARENT_ID_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int I_PARENT_START_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "I_PARENT_START", NC_INT, 1, I_PARENT_START_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int J_PARENT_START_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "J_PARENT_START", NC_INT, 1, J_PARENT_START_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int PARENT_GRID_RATIO_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "PARENT_GRID_RATIO", NC_INT, 1, PARENT_GRID_RATIO_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float DT_att[1] = {((float)60)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "DT", NC_FLOAT, 1, DT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float CEN_LAT_att[1] = {((float)45)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "CEN_LAT", NC_FLOAT, 1, CEN_LAT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float CEN_LON_att[1] = {((float)-99.179993)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "CEN_LON", NC_FLOAT, 1, CEN_LON_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float TRUELAT1_att[1] = {((float)45)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "TRUELAT1", NC_FLOAT, 1, TRUELAT1_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float TRUELAT2_att[1] = {((float)45)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "TRUELAT2", NC_FLOAT, 1, TRUELAT2_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float MOAD_CEN_LAT_att[1] = {((float)45)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "MOAD_CEN_LAT", NC_FLOAT, 1, MOAD_CEN_LAT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float STAND_LON_att[1] = {((float)-99.18)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "STAND_LON", NC_FLOAT, 1, STAND_LON_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float POLE_LAT_att[1] = {((float)90)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "POLE_LAT", NC_FLOAT, 1, POLE_LAT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float POLE_LON_att[1] = {((float)0)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "POLE_LON", NC_FLOAT, 1, POLE_LON_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float GMT_att[1] = {((float)0)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "GMT", NC_FLOAT, 1, GMT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int JULYR_att[1] = {2018} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "JULYR", NC_INT, 1, JULYR_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int JULDAY_att[1] = {354} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "JULDAY", NC_INT, 1, JULDAY_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int MAP_PROJ_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "MAP_PROJ", NC_INT, 1, MAP_PROJ_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "MAP_PROJ_CHAR", 17, "Lambert Conformal");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "MMINLU", 4, "USGS");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int NUM_LAND_CAT_att[1] = {24} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "NUM_LAND_CAT", NC_INT, 1, NUM_LAND_CAT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int ISWATER_att[1] = {16} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "ISWATER", NC_INT, 1, ISWATER_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int ISLAKE_att[1] = {-1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "ISLAKE", NC_INT, 1, ISLAKE_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int ISICE_att[1] = {24} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "ISICE", NC_INT, 1, ISICE_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int ISURBAN_att[1] = {1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "ISURBAN", NC_INT, 1, ISURBAN_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int ISOILWATER_att[1] = {14} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "ISOILWATER", NC_INT, 1, ISOILWATER_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int HYBRID_OPT_att[1] = {-1} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "HYBRID_OPT", NC_INT, 1, HYBRID_OPT_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float ETAC_att[1] = {((float)0)} ;
    stat = nc_put_att_float(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NC_GLOBAL, "ETAC", NC_FLOAT, 1, ETAC_att);
    check_err(stat,__LINE__,__FILE__);
    }


    /* assign per-variable attributes */

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_id, "description", 27, "LATITUDE, SOUTH IS NEGATIVE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_id, "units", 12, "degree_north");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_id, "coordinates", 10, "XLONG XLAT");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_id, "description", 27, "LONGITUDE, WEST IS NEGATIVE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_id, "units", 11, "degree_east");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_id, "coordinates", 10, "XLONG XLAT");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LU_INDEX_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LU_INDEX_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LU_INDEX_id, "description", 17, "LAND USE CATEGORY");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LU_INDEX_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LU_INDEX_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LU_INDEX_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZNU_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZNU_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZNU_id, "description", 32, "eta values on half (mass) levels");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZNU_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZNU_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZNW_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZNW_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZNW_id, "description", 29, "eta values on full (w) levels");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZNW_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZNW_id, "stagger", 1, "Z");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZS_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZS_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZS_id, "description", 32, "DEPTHS OF CENTERS OF SOIL LAYERS");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZS_id, "units", 1, "m");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZS_id, "stagger", 1, "Z");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DZS_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DZS_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DZS_id, "description", 26, "THICKNESSES OF SOIL LAYERS");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DZS_id, "units", 1, "m");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DZS_id, "stagger", 1, "Z");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VAR_SSO_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VAR_SSO_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VAR_SSO_id, "description", 35, "variance of subgrid-scale orography");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VAR_SSO_id, "units", 2, "m2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VAR_SSO_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VAR_SSO_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, U_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, U_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, U_id, "description", 16, "x-wind component");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, U_id, "units", 5, "m s-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, U_id, "stagger", 1, "X");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, U_id, "coordinates", 20, "XLONG_U XLAT_U XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, V_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, V_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, V_id, "description", 16, "y-wind component");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, V_id, "units", 5, "m s-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, V_id, "stagger", 1, "Y");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, V_id, "coordinates", 20, "XLONG_V XLAT_V XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, W_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, W_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, W_id, "description", 16, "z-wind component");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, W_id, "units", 5, "m s-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, W_id, "stagger", 1, "Z");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, W_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PH_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PH_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PH_id, "description", 25, "perturbation geopotential");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PH_id, "units", 6, "m2 s-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PH_id, "stagger", 1, "Z");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PH_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHB_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHB_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHB_id, "description", 23, "base-state geopotential");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHB_id, "units", 6, "m2 s-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHB_id, "stagger", 1, "Z");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHB_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, T_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, T_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, T_id, "description", 45, "perturbation potential temperature (theta-t0)");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, T_id, "units", 1, "K");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, T_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, T_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HFX_FORCE_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HFX_FORCE_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HFX_FORCE_id, "description", 36, "SCM ideal surface sensible heat flux");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HFX_FORCE_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HFX_FORCE_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LH_FORCE_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LH_FORCE_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LH_FORCE_id, "description", 34, "SCM ideal surface latent heat flux");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LH_FORCE_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LH_FORCE_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSK_FORCE_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSK_FORCE_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSK_FORCE_id, "description", 34, "SCM ideal surface skin temperature");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSK_FORCE_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSK_FORCE_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HFX_FORCE_TEND_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HFX_FORCE_TEND_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HFX_FORCE_TEND_id, "description", 45, "SCM ideal surface sensible heat flux tendency");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HFX_FORCE_TEND_id, "units", 9, "W m-2 s-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HFX_FORCE_TEND_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LH_FORCE_TEND_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LH_FORCE_TEND_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LH_FORCE_TEND_id, "description", 43, "SCM ideal surface latent heat flux tendency");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LH_FORCE_TEND_id, "units", 9, "W m-2 s-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LH_FORCE_TEND_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSK_FORCE_TEND_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSK_FORCE_TEND_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSK_FORCE_TEND_id, "description", 43, "SCM ideal surface skin temperature tendency");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSK_FORCE_TEND_id, "units", 9, "W m-2 s-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSK_FORCE_TEND_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MU_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MU_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MU_id, "description", 35, "perturbation dry air mass in column");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MU_id, "units", 2, "Pa");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MU_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MU_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MUB_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MUB_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MUB_id, "description", 33, "base state dry air mass in column");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MUB_id, "units", 2, "Pa");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MUB_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MUB_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NEST_POS_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NEST_POS_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NEST_POS_id, "description", 1, "-");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NEST_POS_id, "units", 1, "-");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NEST_POS_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NEST_POS_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_id, "description", 21, "perturbation pressure");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_id, "units", 2, "Pa");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PB_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PB_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PB_id, "description", 19, "BASE STATE PRESSURE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PB_id, "units", 2, "Pa");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PB_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PB_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FNM_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FNM_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FNM_id, "description", 36, "upper weight for vertical stretching");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FNM_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FNM_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FNP_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FNP_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FNP_id, "description", 36, "lower weight for vertical stretching");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FNP_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FNP_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDNW_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDNW_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDNW_id, "description", 45, "inverse d(eta) values between full (w) levels");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDNW_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDNW_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDN_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDN_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDN_id, "description", 48, "inverse d(eta) values between half (mass) levels");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDN_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDN_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DNW_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DNW_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DNW_id, "description", 37, "d(eta) values between full (w) levels");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DNW_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DNW_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DN_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DN_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DN_id, "description", 40, "d(eta) values between half (mass) levels");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DN_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DN_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CFN_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CFN_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CFN_id, "description", 22, "extrapolation constant");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CFN_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CFN_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CFN1_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CFN1_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CFN1_id, "description", 22, "extrapolation constant");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CFN1_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CFN1_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {106} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, THIS_IS_AN_IDEAL_RUN_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, THIS_IS_AN_IDEAL_RUN_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, THIS_IS_AN_IDEAL_RUN_id, "description", 41, "T/F flag: this is an ARW ideal simulation");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, THIS_IS_AN_IDEAL_RUN_id, "units", 1, "-");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, THIS_IS_AN_IDEAL_RUN_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_HYD_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_HYD_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_HYD_id, "description", 20, "hydrostatic pressure");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_HYD_id, "units", 2, "Pa");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_HYD_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_HYD_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, Q2_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, Q2_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, Q2_id, "description", 9, "QV at 2 M");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, Q2_id, "units", 7, "kg kg-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, Q2_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, Q2_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, T2_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, T2_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, T2_id, "description", 11, "TEMP at 2 M");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, T2_id, "units", 1, "K");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, T2_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, T2_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TH2_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TH2_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TH2_id, "description", 15, "POT TEMP at 2 M");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TH2_id, "units", 1, "K");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TH2_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TH2_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PSFC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PSFC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PSFC_id, "description", 12, "SFC PRESSURE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PSFC_id, "units", 2, "Pa");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PSFC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PSFC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, U10_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, U10_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, U10_id, "description", 9, "U at 10 M");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, U10_id, "units", 5, "m s-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, U10_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, U10_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, V10_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, V10_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, V10_id, "description", 9, "V at 10 M");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, V10_id, "units", 5, "m s-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, V10_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, V10_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDX_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDX_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDX_id, "description", 21, "INVERSE X GRID LENGTH");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDX_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDX_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDY_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDY_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDY_id, "description", 21, "INVERSE Y GRID LENGTH");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDY_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RDY_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RESM_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RESM_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RESM_id, "description", 36, "TIME WEIGHT CONSTANT FOR SMALL STEPS");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RESM_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RESM_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZETATOP_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZETATOP_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZETATOP_id, "description", 17, "ZETA AT MODEL TOP");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZETATOP_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ZETATOP_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CF1_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CF1_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CF1_id, "description", 32, "2nd order extrapolation constant");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CF1_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CF1_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CF2_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CF2_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CF2_id, "description", 32, "2nd order extrapolation constant");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CF2_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CF2_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CF3_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CF3_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CF3_id, "description", 32, "2nd order extrapolation constant");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CF3_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CF3_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {106} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ITIMESTEP_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ITIMESTEP_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ITIMESTEP_id, "description", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ITIMESTEP_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ITIMESTEP_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XTIME_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XTIME_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XTIME_id, "description", 33, "minutes since 2018-12-20 00:00:00");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XTIME_id, "units", 33, "minutes since 2018-12-20 00:00:00");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XTIME_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QVAPOR_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QVAPOR_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QVAPOR_id, "description", 24, "Water vapor mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QVAPOR_id, "units", 7, "kg kg-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QVAPOR_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QVAPOR_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QCLOUD_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QCLOUD_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QCLOUD_id, "description", 24, "Cloud water mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QCLOUD_id, "units", 7, "kg kg-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QCLOUD_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QCLOUD_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QRAIN_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QRAIN_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QRAIN_id, "description", 23, "Rain water mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QRAIN_id, "units", 7, "kg kg-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QRAIN_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QRAIN_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QICE_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QICE_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QICE_id, "description", 16, "Ice mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QICE_id, "units", 7, "kg kg-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QICE_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QICE_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QSNOW_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QSNOW_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QSNOW_id, "description", 17, "Snow mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QSNOW_id, "units", 7, "kg kg-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QSNOW_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QSNOW_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QGRAUP_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QGRAUP_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QGRAUP_id, "description", 20, "Graupel mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QGRAUP_id, "units", 7, "kg kg-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QGRAUP_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QGRAUP_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNWFA2D_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNWFA2D_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNWFA2D_id, "description", 36, "Surface aerosol number conc emission");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNWFA2D_id, "units", 8, "kg-1 s-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNWFA2D_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNWFA2D_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNICE_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNICE_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNICE_id, "description", 24, "Ice Number concentration");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNICE_id, "units", 6, "  kg-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNICE_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNICE_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNRAIN_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNRAIN_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNRAIN_id, "description", 25, "Rain Number concentration");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNRAIN_id, "units", 8, "  kg(-1)");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNRAIN_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNRAIN_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNCLOUD_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNCLOUD_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNCLOUD_id, "description", 32, "cloud water Number concentration");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNCLOUD_id, "units", 8, "  kg(-1)");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNCLOUD_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNCLOUD_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNWFA_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNWFA_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNWFA_id, "description", 33, "water-friendly aerosol number con");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNWFA_id, "units", 8, "  kg(-1)");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNWFA_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNWFA_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNIFA_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNIFA_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNIFA_id, "description", 31, "ice-friendly aerosol number con");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNIFA_id, "units", 8, "  kg(-1)");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNIFA_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QNIFA_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SHDMAX_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SHDMAX_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SHDMAX_id, "description", 23, "ANNUAL MAX VEG FRACTION");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SHDMAX_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SHDMAX_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SHDMAX_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SHDMIN_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SHDMIN_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SHDMIN_id, "description", 23, "ANNUAL MIN VEG FRACTION");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SHDMIN_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SHDMIN_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SHDMIN_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOALB_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOALB_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOALB_id, "description", 34, "ANNUAL MAX SNOW ALBEDO IN FRACTION");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOALB_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOALB_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOALB_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSLB_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSLB_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSLB_id, "description", 16, "SOIL TEMPERATURE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSLB_id, "units", 1, "K");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSLB_id, "stagger", 1, "Z");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSLB_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMOIS_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMOIS_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMOIS_id, "description", 13, "SOIL MOISTURE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMOIS_id, "units", 6, "m3 m-3");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMOIS_id, "stagger", 1, "Z");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMOIS_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SH2O_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SH2O_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SH2O_id, "description", 17, "SOIL LIQUID WATER");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SH2O_id, "units", 6, "m3 m-3");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SH2O_id, "stagger", 1, "Z");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SH2O_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMCREL_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMCREL_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMCREL_id, "description", 22, "RELATIVE SOIL MOISTURE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMCREL_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMCREL_id, "stagger", 1, "Z");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMCREL_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SEAICE_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SEAICE_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SEAICE_id, "description", 12, "SEA ICE FLAG");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SEAICE_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SEAICE_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SEAICE_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XICEM_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XICEM_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XICEM_id, "description", 28, "SEA ICE FLAG (PREVIOUS STEP)");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XICEM_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XICEM_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XICEM_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SFROFF_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SFROFF_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SFROFF_id, "description", 14, "SURFACE RUNOFF");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SFROFF_id, "units", 2, "mm");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SFROFF_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SFROFF_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UDROFF_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UDROFF_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UDROFF_id, "description", 18, "UNDERGROUND RUNOFF");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UDROFF_id, "units", 2, "mm");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UDROFF_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UDROFF_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {106} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, IVGTYP_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, IVGTYP_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, IVGTYP_id, "description", 28, "DOMINANT VEGETATION CATEGORY");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, IVGTYP_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, IVGTYP_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, IVGTYP_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {106} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISLTYP_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISLTYP_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISLTYP_id, "description", 22, "DOMINANT SOIL CATEGORY");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISLTYP_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISLTYP_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISLTYP_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VEGFRA_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VEGFRA_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VEGFRA_id, "description", 19, "VEGETATION FRACTION");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VEGFRA_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VEGFRA_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VEGFRA_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRDFLX_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRDFLX_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRDFLX_id, "description", 16, "GROUND HEAT FLUX");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRDFLX_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRDFLX_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRDFLX_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACGRDFLX_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACGRDFLX_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACGRDFLX_id, "description", 28, "ACCUMULATED GROUND HEAT FLUX");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACGRDFLX_id, "units", 5, "J m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACGRDFLX_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACGRDFLX_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSNOM_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSNOM_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSNOM_id, "description", 23, "ACCUMULATED MELTED SNOW");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSNOM_id, "units", 6, "kg m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSNOM_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSNOM_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOW_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOW_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOW_id, "description", 21, "SNOW WATER EQUIVALENT");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOW_id, "units", 6, "kg m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOW_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOW_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWH_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWH_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWH_id, "description", 19, "PHYSICAL SNOW DEPTH");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWH_id, "units", 1, "m");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWH_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWH_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CANWAT_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CANWAT_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CANWAT_id, "description", 12, "CANOPY WATER");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CANWAT_id, "units", 6, "kg m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CANWAT_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CANWAT_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SSTSK_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SSTSK_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SSTSK_id, "description", 28, "SKIN SEA SURFACE TEMPERATURE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SSTSK_id, "units", 1, "K");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SSTSK_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SSTSK_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, COSZEN_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, COSZEN_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, COSZEN_id, "description", 25, "COS of SOLAR ZENITH ANGLE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, COSZEN_id, "units", 13, "dimensionless");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, COSZEN_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, COSZEN_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAI_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAI_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAI_id, "description", 15, "LEAF AREA INDEX");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAI_id, "units", 7, "m-2/m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAI_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAI_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_A_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_A_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_A_id, "description", 44, "EDMF relative updraft  area - moist updrafts");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_A_id, "units", 1, "-");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_A_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_A_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_W_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_W_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_W_id, "description", 45, "EDMF vertical velocity  - mean moist updrafts");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_W_id, "units", 5, "m s-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_W_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_W_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_THL_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_THL_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_THL_id, "description", 34, "EDMF thetaL  - mean moist updrafts");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_THL_id, "units", 1, "K");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_THL_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_THL_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_QT_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_QT_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_QT_id, "description", 30, "EDMF qt  - mean moist updrafts");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_QT_id, "units", 7, "kg kg-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_QT_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_QT_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_ENT_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_ENT_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_ENT_id, "description", 39, "EDMF entrainment  - mean moist updrafts");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_ENT_id, "units", 3, "m-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_ENT_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_ENT_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_QC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_QC_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_QC_id, "description", 29, "EDMF qc - mean moist updrafts");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_QC_id, "units", 7, "kg kg-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_QC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDMF_QC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VAR_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VAR_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VAR_id, "description", 19, "OROGRAPHIC VARIANCE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VAR_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VAR_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, VAR_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, O3RAD_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, O3RAD_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, O3RAD_id, "description", 18, "RADIATION 3D OZONE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, O3RAD_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, O3RAD_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, O3RAD_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_M_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_M_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_M_id, "description", 29, "Map scale factor on mass grid");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_M_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_M_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_M_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_U_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_U_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_U_id, "description", 26, "Map scale factor on u-grid");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_U_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_U_id, "stagger", 1, "X");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_U_id, "coordinates", 20, "XLONG_U XLAT_U XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_V_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_V_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_V_id, "description", 26, "Map scale factor on v-grid");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_V_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_V_id, "stagger", 1, "Y");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_V_id, "coordinates", 20, "XLONG_V XLAT_V XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_MX_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_MX_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_MX_id, "description", 42, "Map scale factor on mass grid, x direction");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_MX_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_MX_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_MX_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_MY_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_MY_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_MY_id, "description", 42, "Map scale factor on mass grid, y direction");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_MY_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_MY_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_MY_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_UX_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_UX_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_UX_id, "description", 39, "Map scale factor on u-grid, x direction");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_UX_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_UX_id, "stagger", 1, "X");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_UX_id, "coordinates", 20, "XLONG_U XLAT_U XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_UY_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_UY_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_UY_id, "description", 39, "Map scale factor on u-grid, y direction");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_UY_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_UY_id, "stagger", 1, "X");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_UY_id, "coordinates", 20, "XLONG_U XLAT_U XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_VX_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_VX_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_VX_id, "description", 39, "Map scale factor on v-grid, x direction");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_VX_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_VX_id, "stagger", 1, "Y");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_VX_id, "coordinates", 20, "XLONG_V XLAT_V XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MF_VX_INV_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MF_VX_INV_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MF_VX_INV_id, "description", 47, "Inverse map scale factor on v-grid, x direction");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MF_VX_INV_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MF_VX_INV_id, "stagger", 1, "Y");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MF_VX_INV_id, "coordinates", 20, "XLONG_V XLAT_V XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_VY_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_VY_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_VY_id, "description", 39, "Map scale factor on v-grid, y direction");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_VY_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_VY_id, "stagger", 1, "Y");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAPFAC_VY_id, "coordinates", 20, "XLONG_V XLAT_V XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, F_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, F_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, F_id, "description", 27, "Coriolis sine latitude term");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, F_id, "units", 3, "s-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, F_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, F_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, E_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, E_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, E_id, "description", 29, "Coriolis cosine latitude term");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, E_id, "units", 3, "s-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, E_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, E_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SINALPHA_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SINALPHA_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SINALPHA_id, "description", 26, "Local sine of map rotation");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SINALPHA_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SINALPHA_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SINALPHA_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, COSALPHA_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, COSALPHA_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, COSALPHA_id, "description", 28, "Local cosine of map rotation");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, COSALPHA_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, COSALPHA_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, COSALPHA_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HGT_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HGT_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HGT_id, "description", 14, "Terrain Height");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HGT_id, "units", 1, "m");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HGT_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HGT_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSK_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSK_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSK_id, "description", 24, "SURFACE SKIN TEMPERATURE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSK_id, "units", 1, "K");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSK_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TSK_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_TOP_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_TOP_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_TOP_id, "description", 25, "PRESSURE TOP OF THE MODEL");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_TOP_id, "units", 2, "Pa");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_TOP_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, T00_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, T00_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, T00_id, "description", 22, "BASE STATE TEMPERATURE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, T00_id, "units", 1, "K");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, T00_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P00_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P00_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P00_id, "description", 18, "BASE STATE PRESURE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P00_id, "units", 2, "Pa");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P00_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TLP_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TLP_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TLP_id, "description", 21, "BASE STATE LAPSE RATE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TLP_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TLP_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TISO_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TISO_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TISO_id, "description", 36, "TEMP AT WHICH THE BASE T TURNS CONST");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TISO_id, "units", 1, "K");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TISO_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TLP_STRAT_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TLP_STRAT_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TLP_STRAT_id, "description", 50, "BASE STATE LAPSE RATE (DT/D(LN(P)) IN STRATOSPHERE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TLP_STRAT_id, "units", 1, "K");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TLP_STRAT_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_STRAT_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_STRAT_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_STRAT_id, "description", 45, "BASE STATE PRESSURE AT BOTTOM OF STRATOSPHERE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_STRAT_id, "units", 2, "Pa");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, P_STRAT_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAX_MSTFX_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAX_MSTFX_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAX_MSTFX_id, "description", 24, "Max map factor in domain");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAX_MSTFX_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAX_MSTFX_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAX_MSTFY_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAX_MSTFY_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAX_MSTFY_id, "description", 24, "Max map factor in domain");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAX_MSTFY_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MAX_MSTFY_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINC_id, "description", 39, "ACCUMULATED TOTAL CUMULUS PRECIPITATION");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINC_id, "units", 2, "mm");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINSH_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINSH_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINSH_id, "description", 41, "ACCUMULATED SHALLOW CUMULUS PRECIPITATION");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINSH_id, "units", 2, "mm");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINSH_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINSH_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINNC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINNC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINNC_id, "description", 42, "ACCUMULATED TOTAL GRID SCALE PRECIPITATION");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINNC_id, "units", 2, "mm");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINNC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINNC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWNC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWNC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWNC_id, "description", 41, "ACCUMULATED TOTAL GRID SCALE SNOW AND ICE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWNC_id, "units", 2, "mm");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWNC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWNC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRAUPELNC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRAUPELNC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRAUPELNC_id, "description", 36, "ACCUMULATED TOTAL GRID SCALE GRAUPEL");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRAUPELNC_id, "units", 2, "mm");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRAUPELNC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRAUPELNC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HAILNC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HAILNC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HAILNC_id, "description", 33, "ACCUMULATED TOTAL GRID SCALE HAIL");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HAILNC_id, "units", 2, "mm");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HAILNC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HAILNC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLDFRA_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLDFRA_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLDFRA_id, "description", 14, "CLOUD FRACTION");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLDFRA_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLDFRA_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLDFRA_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDOWN_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDOWN_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDOWN_id, "description", 42, "DOWNWARD SHORT WAVE FLUX AT GROUND SURFACE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDOWN_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDOWN_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDOWN_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GLW_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GLW_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GLW_id, "description", 41, "DOWNWARD LONG WAVE FLUX AT GROUND SURFACE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GLW_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GLW_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GLW_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWNORM_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWNORM_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWNORM_id, "description", 58, "NORMAL SHORT WAVE FLUX AT GROUND SURFACE (SLOPE-DEPENDENT)");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWNORM_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWNORM_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWNORM_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TAOD5502D_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TAOD5502D_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TAOD5502D_id, "description", 42, "2D aerosol optical depth at 550 nm (MP=28)");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TAOD5502D_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TAOD5502D_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TAOD5502D_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPT_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPT_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPT_id, "description", 43, "ACCUMULATED UPWELLING SHORTWAVE FLUX AT TOP");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPT_id, "units", 5, "J m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPT_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPT_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPTC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPTC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPTC_id, "description", 53, "ACCUMULATED UPWELLING CLEAR SKY SHORTWAVE FLUX AT TOP");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPTC_id, "units", 5, "J m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPTC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPTC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNT_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNT_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNT_id, "description", 45, "ACCUMULATED DOWNWELLING SHORTWAVE FLUX AT TOP");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNT_id, "units", 5, "J m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNT_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNT_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNTC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNTC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNTC_id, "description", 55, "ACCUMULATED DOWNWELLING CLEAR SKY SHORTWAVE FLUX AT TOP");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNTC_id, "units", 5, "J m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNTC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNTC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPB_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPB_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPB_id, "description", 46, "ACCUMULATED UPWELLING SHORTWAVE FLUX AT BOTTOM");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPB_id, "units", 5, "J m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPB_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPB_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPBC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPBC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPBC_id, "description", 56, "ACCUMULATED UPWELLING CLEAR SKY SHORTWAVE FLUX AT BOTTOM");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPBC_id, "units", 5, "J m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPBC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWUPBC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNB_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNB_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNB_id, "description", 48, "ACCUMULATED DOWNWELLING SHORTWAVE FLUX AT BOTTOM");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNB_id, "units", 5, "J m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNB_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNB_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNBC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNBC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNBC_id, "description", 58, "ACCUMULATED DOWNWELLING CLEAR SKY SHORTWAVE FLUX AT BOTTOM");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNBC_id, "units", 5, "J m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNBC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACSWDNBC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPT_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPT_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPT_id, "description", 42, "ACCUMULATED UPWELLING LONGWAVE FLUX AT TOP");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPT_id, "units", 5, "J m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPT_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPT_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPTC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPTC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPTC_id, "description", 52, "ACCUMULATED UPWELLING CLEAR SKY LONGWAVE FLUX AT TOP");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPTC_id, "units", 5, "J m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPTC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPTC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNT_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNT_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNT_id, "description", 44, "ACCUMULATED DOWNWELLING LONGWAVE FLUX AT TOP");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNT_id, "units", 5, "J m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNT_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNT_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNTC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNTC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNTC_id, "description", 54, "ACCUMULATED DOWNWELLING CLEAR SKY LONGWAVE FLUX AT TOP");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNTC_id, "units", 5, "J m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNTC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNTC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPB_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPB_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPB_id, "description", 45, "ACCUMULATED UPWELLING LONGWAVE FLUX AT BOTTOM");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPB_id, "units", 5, "J m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPB_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPB_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPBC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPBC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPBC_id, "description", 55, "ACCUMULATED UPWELLING CLEAR SKY LONGWAVE FLUX AT BOTTOM");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPBC_id, "units", 5, "J m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPBC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWUPBC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNB_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNB_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNB_id, "description", 47, "ACCUMULATED DOWNWELLING LONGWAVE FLUX AT BOTTOM");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNB_id, "units", 5, "J m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNB_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNB_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNBC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNBC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNBC_id, "description", 57, "ACCUMULATED DOWNWELLING CLEAR SKY LONGWAVE FLUX AT BOTTOM");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNBC_id, "units", 5, "J m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNBC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLWDNBC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPT_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPT_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPT_id, "description", 45, "INSTANTANEOUS UPWELLING SHORTWAVE FLUX AT TOP");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPT_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPT_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPT_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPTC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPTC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPTC_id, "description", 55, "INSTANTANEOUS UPWELLING CLEAR SKY SHORTWAVE FLUX AT TOP");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPTC_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPTC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPTC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNT_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNT_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNT_id, "description", 47, "INSTANTANEOUS DOWNWELLING SHORTWAVE FLUX AT TOP");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNT_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNT_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNT_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNTC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNTC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNTC_id, "description", 57, "INSTANTANEOUS DOWNWELLING CLEAR SKY SHORTWAVE FLUX AT TOP");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNTC_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNTC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNTC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPB_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPB_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPB_id, "description", 48, "INSTANTANEOUS UPWELLING SHORTWAVE FLUX AT BOTTOM");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPB_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPB_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPB_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPBC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPBC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPBC_id, "description", 58, "INSTANTANEOUS UPWELLING CLEAR SKY SHORTWAVE FLUX AT BOTTOM");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPBC_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPBC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWUPBC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNB_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNB_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNB_id, "description", 50, "INSTANTANEOUS DOWNWELLING SHORTWAVE FLUX AT BOTTOM");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNB_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNB_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNB_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNBC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNBC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNBC_id, "description", 60, "INSTANTANEOUS DOWNWELLING CLEAR SKY SHORTWAVE FLUX AT BOTTOM");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNBC_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNBC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SWDNBC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPT_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPT_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPT_id, "description", 44, "INSTANTANEOUS UPWELLING LONGWAVE FLUX AT TOP");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPT_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPT_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPT_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPTC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPTC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPTC_id, "description", 54, "INSTANTANEOUS UPWELLING CLEAR SKY LONGWAVE FLUX AT TOP");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPTC_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPTC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPTC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNT_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNT_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNT_id, "description", 46, "INSTANTANEOUS DOWNWELLING LONGWAVE FLUX AT TOP");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNT_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNT_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNT_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNTC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNTC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNTC_id, "description", 56, "INSTANTANEOUS DOWNWELLING CLEAR SKY LONGWAVE FLUX AT TOP");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNTC_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNTC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNTC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPB_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPB_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPB_id, "description", 47, "INSTANTANEOUS UPWELLING LONGWAVE FLUX AT BOTTOM");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPB_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPB_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPB_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPBC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPBC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPBC_id, "description", 57, "INSTANTANEOUS UPWELLING CLEAR SKY LONGWAVE FLUX AT BOTTOM");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPBC_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPBC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWUPBC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNB_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNB_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNB_id, "description", 49, "INSTANTANEOUS DOWNWELLING LONGWAVE FLUX AT BOTTOM");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNB_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNB_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNB_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNBC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNBC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNBC_id, "description", 59, "INSTANTANEOUS DOWNWELLING CLEAR SKY LONGWAVE FLUX AT BOTTOM");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNBC_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNBC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LWDNBC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, OLR_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, OLR_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, OLR_id, "description", 22, "TOA OUTGOING LONG WAVE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, OLR_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, OLR_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, OLR_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_U_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_U_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_U_id, "description", 27, "LATITUDE, SOUTH IS NEGATIVE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_U_id, "units", 12, "degree_north");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_U_id, "stagger", 1, "X");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_U_id, "coordinates", 14, "XLONG_U XLAT_U");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_U_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_U_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_U_id, "description", 27, "LONGITUDE, WEST IS NEGATIVE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_U_id, "units", 11, "degree_east");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_U_id, "stagger", 1, "X");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_U_id, "coordinates", 14, "XLONG_U XLAT_U");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_V_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_V_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_V_id, "description", 27, "LATITUDE, SOUTH IS NEGATIVE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_V_id, "units", 12, "degree_north");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_V_id, "stagger", 1, "Y");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAT_V_id, "coordinates", 14, "XLONG_V XLAT_V");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_V_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_V_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_V_id, "description", 27, "LONGITUDE, WEST IS NEGATIVE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_V_id, "units", 11, "degree_east");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_V_id, "stagger", 1, "Y");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLONG_V_id, "coordinates", 14, "XLONG_V XLAT_V");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ALBEDO_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ALBEDO_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ALBEDO_id, "description", 6, "ALBEDO");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ALBEDO_id, "units", 1, "-");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ALBEDO_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ALBEDO_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLAT_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLAT_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLAT_id, "description", 46, "COMPUTATIONAL GRID LATITUDE, SOUTH IS NEGATIVE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLAT_id, "units", 12, "degree_north");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLAT_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLAT_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ALBBCK_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ALBBCK_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ALBBCK_id, "description", 17, "BACKGROUND ALBEDO");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ALBBCK_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ALBBCK_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ALBBCK_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EMISS_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EMISS_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EMISS_id, "description", 18, "SURFACE EMISSIVITY");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EMISS_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EMISS_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EMISS_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NOAHRES_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NOAHRES_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NOAHRES_id, "description", 42, "RESIDUAL OF THE NOAH SURFACE ENERGY BUDGET");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NOAHRES_id, "units", 7, "W m{-2}");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NOAHRES_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, NOAHRES_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TMN_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TMN_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TMN_id, "description", 34, "SOIL TEMPERATURE AT LOWER BOUNDARY");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TMN_id, "units", 1, "K");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TMN_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, TMN_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAND_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAND_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAND_id, "description", 35, "LAND MASK (1 FOR LAND, 2 FOR WATER)");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAND_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAND_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, XLAND_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UST_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UST_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UST_id, "description", 23, "U* IN SIMILARITY THEORY");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UST_id, "units", 5, "m s-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UST_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UST_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PBLH_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PBLH_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PBLH_id, "description", 10, "PBL HEIGHT");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PBLH_id, "units", 1, "m");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PBLH_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PBLH_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HFX_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HFX_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HFX_id, "description", 31, "UPWARD HEAT FLUX AT THE SURFACE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HFX_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HFX_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, HFX_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QFX_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QFX_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QFX_id, "description", 35, "UPWARD MOISTURE FLUX AT THE SURFACE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QFX_id, "units", 10, "kg m-2 s-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QFX_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, QFX_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LH_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LH_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LH_id, "description", 31, "LATENT HEAT FLUX AT THE SURFACE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LH_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LH_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LH_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACHFX_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACHFX_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACHFX_id, "description", 43, "ACCUMULATED UPWARD HEAT FLUX AT THE SURFACE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACHFX_id, "units", 5, "J m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACHFX_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACHFX_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLHF_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLHF_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLHF_id, "description", 50, "ACCUMULATED UPWARD LATENT HEAT FLUX AT THE SURFACE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLHF_id, "units", 5, "J m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLHF_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ACLHF_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWC_id, "description", 48, "FLAG INDICATING SNOW COVERAGE (1 FOR SNOW COVER)");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWC_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOWC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SR_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SR_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SR_id, "description", 32, "fraction of frozen precipitation");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SR_id, "units", 1, "-");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SR_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SR_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {106} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SAVE_TOPO_FROM_REAL_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SAVE_TOPO_FROM_REAL_id, "MemoryOrder", 3, "0  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SAVE_TOPO_FROM_REAL_id, "description", 48, "1=original topo from real/0=topo modified by WRF");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SAVE_TOPO_FROM_REAL_id, "units", 4, "flag");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SAVE_TOPO_FROM_REAL_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PREC_ACC_C_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PREC_ACC_C_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PREC_ACC_C_id, "description", 66, "ACCUMULATED CUMULUS PRECIPITATION OVER prec_acc_dt PERIODS OF TIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PREC_ACC_C_id, "units", 2, "mm");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PREC_ACC_C_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PREC_ACC_C_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PREC_ACC_NC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PREC_ACC_NC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PREC_ACC_NC_id, "description", 70, "ACCUMULATED GRID SCALE  PRECIPITATION OVER prec_acc_dt PERIODS OF TIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PREC_ACC_NC_id, "units", 2, "mm");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PREC_ACC_NC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PREC_ACC_NC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOW_ACC_NC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOW_ACC_NC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOW_ACC_NC_id, "description", 66, "ACCUMULATED SNOW WATER EQUIVALENT OVER prec_acc_dt PERIODS OF TIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOW_ACC_NC_id, "units", 2, "mm");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOW_ACC_NC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SNOW_ACC_NC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EROD_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EROD_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EROD_id, "description", 52, "fraction of erodible surface in each grid cell (0-1)");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EROD_id, "units", 4, "none");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EROD_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EROD_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLDFRA2_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLDFRA2_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLDFRA2_id, "description", 14, "CLOUD FRACTION");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLDFRA2_id, "units", 1, "-");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLDFRA2_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, CLDFRA2_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINPROD_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINPROD_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINPROD_id, "description", 26, "TOTAL RAIN PRODUCTION RATE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINPROD_id, "units", 3, "s-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINPROD_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, RAINPROD_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EVAPPROD_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EVAPPROD_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EVAPPROD_id, "description", 21, "RAIN EVAPORATION RATE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EVAPPROD_id, "units", 3, "s-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EVAPPROD_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EVAPPROD_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UST_T_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UST_T_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UST_T_id, "description", 27, "Threshold Friction Velocity");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UST_T_id, "units", 5, "m s-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UST_T_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, UST_T_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ROUGH_COR_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ROUGH_COR_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ROUGH_COR_id, "description", 29, "roughness elements correction");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ROUGH_COR_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ROUGH_COR_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ROUGH_COR_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMOIS_COR_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMOIS_COR_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMOIS_COR_id, "description", 24, "soil moisture correction");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMOIS_COR_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMOIS_COR_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SMOIS_COR_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_1_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_1_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_1_id, "description", 23, "dust loading for size 1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_1_id, "units", 5, "ug/m2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_1_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_1_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_2_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_2_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_2_id, "description", 23, "dust loading for size 2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_2_id, "units", 5, "ug/m2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_2_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_2_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_3_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_3_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_3_id, "description", 23, "dust loading for size 3");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_3_id, "units", 5, "ug/m2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_3_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_3_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_4_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_4_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_4_id, "description", 23, "dust loading for size 4");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_4_id, "units", 5, "ug/m2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_4_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_4_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_5_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_5_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_5_id, "description", 18, "total dust loading");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_5_id, "units", 5, "ug/m2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_5_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DUSTLOAD_5_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEPVEL_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEPVEL_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEPVEL_id, "description", 28, "dust dry deposition velocity");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEPVEL_id, "units", 3, "m/s");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEPVEL_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEPVEL_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_1_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_1_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_1_id, "description", 39, "dust gravitational settling  for size 1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_1_id, "units", 7, "ug/m2/s");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_1_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_1_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_2_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_2_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_2_id, "description", 39, "dust gravitational settling  for size 2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_2_id, "units", 7, "ug/m2/s");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_2_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_2_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_3_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_3_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_3_id, "description", 39, "dust gravitational settling  for size 3");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_3_id, "units", 7, "ug/m2/s");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_3_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_3_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_4_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_4_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_4_id, "description", 39, "dust gravitational settling  for size 4");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_4_id, "units", 7, "ug/m2/s");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_4_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_4_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_5_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_5_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_5_id, "description", 39, "dust gravitational settling  for size 5");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_5_id, "units", 7, "ug/m2/s");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_5_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, GRASET_5_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_1_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_1_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_1_id, "description", 30, "dust dry deposition for size 1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_1_id, "units", 7, "ug/m2/s");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_1_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_1_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_2_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_2_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_2_id, "description", 30, "dust dry deposition for size 2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_2_id, "units", 7, "ug/m2/s");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_2_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_2_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_3_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_3_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_3_id, "description", 30, "dust dry deposition for size 3");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_3_id, "units", 7, "ug/m2/s");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_3_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_3_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_4_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_4_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_4_id, "description", 30, "dust dry deposition for size 4");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_4_id, "units", 7, "ug/m2/s");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_4_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_4_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_5_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_5_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_5_id, "description", 30, "dust dry deposition for size 5");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_5_id, "units", 7, "ug/m2/s");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_5_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRYDEP_5_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST1_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST1_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST1_id, "description", 19, "DUST emissions bin1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST1_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST1_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST1_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST2_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST2_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST2_id, "description", 19, "DUST emissions bin2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST2_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST2_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST2_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST3_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST3_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST3_id, "description", 19, "DUST emissions bin3");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST3_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST3_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST3_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST4_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST4_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST4_id, "description", 19, "DUST emissions bin4");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST4_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST4_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST4_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST5_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST5_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST5_id, "description", 19, "DUST emissions bin5");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST5_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST5_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EDUST5_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ebu_oc_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ebu_oc_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ebu_oc_id, "description", 21, "biomass burning emiss");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ebu_oc_id, "units", 7, "ug/m2/s");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ebu_oc_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ebu_oc_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGTF_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGTF_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGTF_id, "description", 32, "mean fraction of tropical forest");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGTF_id, "units", 1, "?");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGTF_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGTF_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGEF_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGEF_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGEF_id, "description", 38, "mean fraction of extra tropical forest");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGEF_id, "units", 1, "?");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGEF_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGEF_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGSV_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGSV_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGSV_id, "description", 24, "mean fraction of savanna");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGSV_id, "units", 1, "?");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGSV_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGSV_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGGR_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGGR_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGGR_id, "description", 26, "mean fraction of grassland");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGGR_id, "units", 1, "?");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGGR_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, MEAN_FCT_AGGR_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGTF_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGTF_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGTF_id, "description", 33, "mean firesize for tropical forest");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGTF_id, "units", 1, "?");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGTF_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGTF_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGEF_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGEF_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGEF_id, "description", 38, "mean firesize for extratropical forest");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGEF_id, "units", 1, "?");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGEF_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGEF_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGSV_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGSV_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGSV_id, "description", 25, "mean firesize for savanna");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGSV_id, "units", 1, "?");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGSV_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGSV_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGGR_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGGR_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGGR_id, "description", 27, "mean firesize for grassland");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGGR_id, "units", 1, "?");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGGR_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, FIRESIZE_AGGR_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EXTCOF55_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EXTCOF55_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EXTCOF55_id, "description", 33, "Extinction coefficients for .55um");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EXTCOF55_id, "units", 5, "km^-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EXTCOF55_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EXTCOF55_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRY_DEP_LEN_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRY_DEP_LEN_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRY_DEP_LEN_id, "description", 23, "dry deposition velocity");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRY_DEP_LEN_id, "units", 4, "cm/s");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRY_DEP_LEN_id, "stagger", 1, "Z");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRY_DEP_LEN_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRY_DEP_FLUX_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRY_DEP_FLUX_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRY_DEP_FLUX_id, "description", 19, "dry deposition flux");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRY_DEP_FLUX_id, "units", 14, "mol or ug m^-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRY_DEP_FLUX_id, "stagger", 1, "Z");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DRY_DEP_FLUX_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, WET_DEP_FLUX_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, WET_DEP_FLUX_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, WET_DEP_FLUX_id, "description", 25, "column wet scavening flux");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, WET_DEP_FLUX_id, "units", 15, "mmol or ug m^-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, WET_DEP_FLUX_id, "stagger", 1, "Z");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, WET_DEP_FLUX_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EBIO_ISO_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EBIO_ISO_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EBIO_ISO_id, "description", 17, "Actual biog emiss");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EBIO_ISO_id, "units", 15, "mol km^-2 hr^-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EBIO_ISO_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EBIO_ISO_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EBIO_API_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EBIO_API_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EBIO_API_id, "description", 17, "Actual biog emiss");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EBIO_API_id, "units", 15, "mol km^-2 hr^-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EBIO_API_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, EBIO_API_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAI_VEGMASK_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAI_VEGMASK_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAI_VEGMASK_id, "description", 72, "MODIS LAI vegetation mask for this date; 0=no dust produced (vegetation)");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAI_VEGMASK_id, "units", 4, "none");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAI_VEGMASK_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAI_VEGMASK_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dvel_o3_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dvel_o3_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dvel_o3_id, "description", 22, "O3 deposition velocity");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dvel_o3_id, "units", 4, "cm/s");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dvel_o3_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dvel_o3_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PM2_5_DRY_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PM2_5_DRY_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PM2_5_DRY_id, "description", 22, "pm2.5 aerosol dry mass");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PM2_5_DRY_id, "units", 7, "ug m^-3");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PM2_5_DRY_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PM2_5_DRY_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PM10_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PM10_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PM10_id, "description", 13, "pm10 dry mass");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PM10_id, "units", 7, "ug m^-3");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PM10_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PM10_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DMS_0_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DMS_0_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DMS_0_id, "description", 26, "dms oceanic concentrations");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DMS_0_id, "units", 4, "nM/L");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DMS_0_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, DMS_0_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR201_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR201_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR201_id, "description", 19, "cl2 photolysis rate");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR201_id, "units", 7, "min{-1}");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR201_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR201_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR202_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR202_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR202_id, "description", 20, "hocl photolysis rate");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR202_id, "units", 7, "min{-1}");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR202_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR202_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR203_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR203_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR203_id, "description", 20, "fmcl photolysis rate");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR203_id, "units", 7, "min{-1}");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR203_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PHOTR203_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so2_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so2_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so2_id, "description", 16, "SO2 mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so2_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so2_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so2_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, sulf_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, sulf_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, sulf_id, "description", 17, "SULF mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, sulf_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, sulf_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, sulf_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no2_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no2_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no2_id, "description", 16, "NO2 mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no2_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no2_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no2_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no_id, "description", 15, "NO mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, o3_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, o3_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, o3_id, "description", 15, "O3 mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, o3_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, o3_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, o3_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hno3_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hno3_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hno3_id, "description", 17, "HNO3 mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hno3_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hno3_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hno3_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, h2o2_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, h2o2_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, h2o2_id, "description", 17, "H2O2 mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, h2o2_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, h2o2_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, h2o2_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ald_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ald_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ald_id, "description", 16, "ALD mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ald_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ald_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ald_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hcho_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hcho_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hcho_id, "description", 17, "HCHO mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hcho_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hcho_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hcho_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, op1_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, op1_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, op1_id, "description", 16, "OP1 mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, op1_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, op1_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, op1_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, op2_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, op2_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, op2_id, "description", 16, "OP2 mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, op2_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, op2_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, op2_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, paa_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, paa_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, paa_id, "description", 16, "PAA mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, paa_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, paa_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, paa_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ora1_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ora1_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ora1_id, "description", 17, "ORA1 mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ora1_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ora1_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ora1_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ora2_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ora2_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ora2_id, "description", 17, "ORA2 mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ora2_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ora2_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ora2_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh3_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh3_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh3_id, "description", 16, "NH3 mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh3_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh3_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh3_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, n2o5_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, n2o5_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, n2o5_id, "description", 17, "N2O5 mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, n2o5_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, n2o5_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, n2o5_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3_id, "description", 16, "NO3 mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, pan_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, pan_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, pan_id, "description", 16, "PAN mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, pan_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, pan_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, pan_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc3_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc3_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc3_id, "description", 16, "HC3 mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc3_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc3_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc3_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc5_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc5_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc5_id, "description", 16, "HC5 mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc5_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc5_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc5_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc8_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc8_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc8_id, "description", 16, "HC8 mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc8_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc8_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hc8_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, eth_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, eth_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, eth_id, "description", 16, "ETH mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, eth_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, eth_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, eth_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, co_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, co_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, co_id, "description", 15, "CO mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, co_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, co_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, co_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ete_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ete_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ete_id, "description", 16, "ETE mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ete_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ete_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ete_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, olt_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, olt_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, olt_id, "description", 16, "OLT mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, olt_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, olt_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, olt_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, oli_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, oli_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, oli_id, "description", 16, "OLI mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, oli_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, oli_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, oli_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, tol_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, tol_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, tol_id, "description", 16, "TOL mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, tol_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, tol_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, tol_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, xyl_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, xyl_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, xyl_id, "description", 16, "XYL mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, xyl_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, xyl_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, xyl_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, aco3_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, aco3_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, aco3_id, "description", 17, "ACO3 mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, aco3_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, aco3_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, aco3_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, tpan_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, tpan_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, tpan_id, "description", 17, "TPAN mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, tpan_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, tpan_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, tpan_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hono_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hono_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hono_id, "description", 17, "HONO mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hono_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hono_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hono_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hno4_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hno4_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hno4_id, "description", 17, "HNO4 mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hno4_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hno4_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hno4_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ket_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ket_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ket_id, "description", 16, "KET mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ket_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ket_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ket_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, gly_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, gly_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, gly_id, "description", 16, "GLY mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, gly_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, gly_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, gly_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mgly_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mgly_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mgly_id, "description", 17, "MGLY mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mgly_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mgly_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mgly_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dcb_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dcb_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dcb_id, "description", 16, "DCB mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dcb_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dcb_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dcb_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, onit_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, onit_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, onit_id, "description", 17, "ONIT mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, onit_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, onit_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, onit_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, csl_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, csl_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, csl_id, "description", 16, "CSL mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, csl_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, csl_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, csl_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, iso_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, iso_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, iso_id, "description", 16, "ISO mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, iso_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, iso_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, iso_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, co2_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, co2_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, co2_id, "description", 16, "CO2 mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, co2_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, co2_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, co2_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ch4_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ch4_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ch4_id, "description", 16, "CH4 mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ch4_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ch4_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ch4_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, udd_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, udd_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, udd_id, "description", 16, "UDD mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, udd_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, udd_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, udd_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hket_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hket_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hket_id, "description", 17, "HKET mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hket_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hket_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hket_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, api_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, api_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, api_id, "description", 16, "API mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, api_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, api_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, api_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, lim_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, lim_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, lim_id, "description", 16, "LIM mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, lim_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, lim_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, lim_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dien_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dien_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dien_id, "description", 17, "DIEN mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dien_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dien_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, dien_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, macr_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, macr_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, macr_id, "description", 17, "MACR mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, macr_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, macr_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, macr_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hace_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hace_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hace_id, "description", 18, "HACE concentration");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hace_id, "units", 3, "ppm");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hace_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, hace_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ishp_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ishp_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ishp_id, "description", 18, "ISHP concentration");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ishp_id, "units", 3, "ppm");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ishp_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ishp_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ison_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ison_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ison_id, "description", 18, "ISON concentration");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ison_id, "units", 3, "ppm");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ison_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ison_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mahp_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mahp_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mahp_id, "description", 18, "MAHP concentration");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mahp_id, "units", 3, "ppm");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mahp_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mahp_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mpan_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mpan_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mpan_id, "description", 18, "MPAN concentration");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mpan_id, "units", 3, "ppm");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mpan_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mpan_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nald_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nald_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nald_id, "description", 18, "NALD concentration");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nald_id, "units", 3, "ppm");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nald_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nald_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, sesq_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, sesq_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, sesq_id, "description", 17, "SESQ mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, sesq_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, sesq_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, sesq_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mbo_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mbo_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mbo_id, "description", 40, "MBO (2-Methyl-3-Buten-2-ol) mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mbo_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mbo_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, mbo_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa1_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa1_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa1_id, "description", 21, "cond.vapor from ASOA1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa1_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa1_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa1_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa2_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa2_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa2_id, "description", 21, "cond.vapor from ASOA2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa2_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa2_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa2_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa3_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa3_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa3_id, "description", 21, "cond.vapor from ASOA3");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa3_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa3_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa3_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa4_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa4_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa4_id, "description", 21, "cond.vapor from ASOA4");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa4_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa4_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvasoa4_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa1_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa1_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa1_id, "description", 21, "cond.vapor from BSOA1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa1_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa1_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa1_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa2_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa2_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa2_id, "description", 21, "cond.vapor from BSOA2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa2_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa2_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa2_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa3_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa3_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa3_id, "description", 21, "cond.vapor from BSOA3");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa3_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa3_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa3_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa4_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa4_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa4_id, "description", 21, "cond.vapor from BSOA4");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa4_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa4_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, cvbsoa4_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ho_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ho_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ho_id, "description", 15, "HO mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ho_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ho_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ho_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ho2_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ho2_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ho2_id, "description", 16, "HO2 mixing ratio");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ho2_id, "units", 4, "ppmv");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ho2_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ho2_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so4aj_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so4aj_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so4aj_id, "description", 23, "Sulfate conc. Acc. mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so4aj_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so4aj_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so4aj_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so4ai_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so4ai_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so4ai_id, "description", 25, "Sulfate conc. Aitken mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so4ai_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so4ai_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, so4ai_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh4aj_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh4aj_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh4aj_id, "description", 24, "Ammonium conc. Acc. mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh4aj_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh4aj_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh4aj_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh4ai_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh4ai_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh4ai_id, "description", 27, "Ammonium  conc. Aitken mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh4ai_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh4ai_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nh4ai_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3aj_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3aj_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3aj_id, "description", 24, "Nitrate  conc. Acc. mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3aj_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3aj_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3aj_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3ai_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3ai_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3ai_id, "description", 26, "Nitrate  conc. Aitken mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3ai_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3ai_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, no3ai_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, naaj_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, naaj_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, naaj_id, "description", 24, "Sodium   conc. Acc. mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, naaj_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, naaj_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, naaj_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, naai_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, naai_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, naai_id, "description", 26, "Sodium   conc. Aitken mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, naai_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, naai_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, naai_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, claj_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, claj_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, claj_id, "description", 24, "Chloride conc. Acc. mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, claj_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, claj_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, claj_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, clai_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, clai_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, clai_id, "description", 26, "Chloride conc. Aitken mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, clai_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, clai_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, clai_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa1j_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa1j_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa1j_id, "description", 57, "SOA Anth. org. conc. with  C* value=1    ug/m^3 Acc. mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa1j_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa1j_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa1j_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa1i_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa1i_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa1i_id, "description", 59, "SOA Anth. org. conc. with  C* value=1    ug/m^3 Aitken mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa1i_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa1i_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa1i_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa2j_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa2j_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa2j_id, "description", 57, "SOA Anth. org. conc. with  C* value=10   ug/m^3 Acc. mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa2j_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa2j_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa2j_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa2i_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa2i_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa2i_id, "description", 59, "SOA Anth. org. conc. with  C* value=10   ug/m^3 Aitken mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa2i_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa2i_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa2i_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa3j_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa3j_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa3j_id, "description", 57, "SOA Anth. org. conc. with  C* value=100  ug/m^3 Acc. mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa3j_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa3j_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa3j_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa3i_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa3i_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa3i_id, "description", 59, "SOA Anth. org. conc. with  C* value=100  ug/m^3 Aitken mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa3i_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa3i_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa3i_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa4j_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa4j_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa4j_id, "description", 57, "SOA Anth. org. conc. with  C* value=1000 ug/m^3 Acc. mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa4j_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa4j_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa4j_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa4i_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa4i_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa4i_id, "description", 59, "SOA Anth. org. conc. with  C* value=1000 ug/m^3 Aitken mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa4i_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa4i_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, asoa4i_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa1j_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa1j_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa1j_id, "description", 57, "SOA Biog. org. conc. with  C* value=1    ug/m^3 Acc. mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa1j_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa1j_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa1j_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa1i_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa1i_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa1i_id, "description", 59, "SOA Biog. org. conc. with  C* value=1    ug/m^3 Aitken mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa1i_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa1i_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa1i_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa2j_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa2j_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa2j_id, "description", 57, "SOA Biog. org. conc. with  C* value=10   ug/m^3 Acc. mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa2j_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa2j_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa2j_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa2i_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa2i_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa2i_id, "description", 59, "SOA Biog. org. conc. with  C* value=10   ug/m^3 Aitken mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa2i_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa2i_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa2i_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa3j_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa3j_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa3j_id, "description", 57, "SOA Biog. org. conc. with  C* value=100  ug/m^3 Acc. mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa3j_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa3j_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa3j_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa3i_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa3i_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa3i_id, "description", 59, "SOA Biog. org. conc. with  C* value=100  ug/m^3 Aitken mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa3i_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa3i_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa3i_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa4j_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa4j_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa4j_id, "description", 57, "SOA Biog. org. conc. with  C* value=1000 ug/m^3 Acc. mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa4j_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa4j_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa4j_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa4i_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa4i_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa4i_id, "description", 59, "SOA Biog. org. conc. with  C* value=1000 ug/m^3 Aitken mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa4i_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa4i_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, bsoa4i_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, orgpaj_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, orgpaj_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, orgpaj_id, "description", 47, "Prim. anth. org. conc. from aromatics Acc. mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, orgpaj_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, orgpaj_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, orgpaj_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, orgpai_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, orgpai_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, orgpai_id, "description", 49, "Prim. anth. org. conc. from aromatics Aitken mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, orgpai_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, orgpai_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, orgpai_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ecj_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ecj_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ecj_id, "description", 26, "Elemental carbon Acc. mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ecj_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ecj_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ecj_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, eci_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, eci_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, eci_id, "description", 28, "Elemental carbon Aitken mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, eci_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, eci_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, eci_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, p25j_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, p25j_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, p25j_id, "description", 23, "Primary PM2.5 Acc. mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, p25j_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, p25j_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, p25j_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, p25i_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, p25i_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, p25i_id, "description", 25, "Primary PM2.5 Aitken mode");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, p25i_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, p25i_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, p25i_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, antha_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, antha_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, antha_id, "description", 29, "Coarse anthropogenic aerosols");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, antha_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, antha_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, antha_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, seas_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, seas_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, seas_id, "description", 22, "Coarse marine aerosols");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, seas_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, seas_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, seas_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, soila_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, soila_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, soila_id, "description", 28, "Coarse soil-derived aerosols");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, soila_id, "units", 12, "ug/kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, soila_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, soila_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nu0_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nu0_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nu0_id, "description", 18, "Aitken mode number");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nu0_id, "units", 11, " /kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nu0_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, nu0_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ac0_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ac0_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ac0_id, "description", 24, "Accumulation mode number");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ac0_id, "units", 11, " /kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ac0_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ac0_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, corn_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, corn_id, "MemoryOrder", 3, "XYZ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, corn_id, "description", 18, "Coarse mode number");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, corn_id, "units", 11, " /kg-dryair");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, corn_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, corn_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {106} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARR_SPPT_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARR_SPPT_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARR_SPPT_id, "description", 36, "Array to hold seed for restart, SPPT");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARR_SPPT_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARR_SPPT_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {106} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARR_SKEBS_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARR_SKEBS_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARR_SKEBS_id, "description", 37, "Array to hold seed for restart, SKEBS");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARR_SKEBS_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARR_SKEBS_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {106} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARR_RAND_PERTURB_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARR_RAND_PERTURB_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARR_RAND_PERTURB_id, "description", 41, "Array to hold seed for restart, RAND_PERT");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARR_RAND_PERTURB_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARR_RAND_PERTURB_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {106} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARRAY_SPP_CONV_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARRAY_SPP_CONV_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARRAY_SPP_CONV_id, "description", 42, "Array to hold seed for restart, RAND_PERT2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARRAY_SPP_CONV_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARRAY_SPP_CONV_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {106} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARRAY_SPP_PBL_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARRAY_SPP_PBL_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARRAY_SPP_PBL_id, "description", 42, "Array to hold seed for restart, RAND_PERT3");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARRAY_SPP_PBL_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARRAY_SPP_PBL_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {106} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARRAY_SPP_LSM_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARRAY_SPP_LSM_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARRAY_SPP_LSM_id, "description", 42, "Array to hold seed for restart, RAND_PERT4");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARRAY_SPP_LSM_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, ISEEDARRAY_SPP_LSM_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, BF_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, BF_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, BF_id, "description", 46, "full levels, bf=0 => isobaric; bf=znw => sigma");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, BF_id, "units", 13, "Dimensionless");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, BF_id, "stagger", 1, "Z");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C1H_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C1H_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C1H_id, "description", 42, "half levels, c1h = d bf / d eta, using znw");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C1H_id, "units", 13, "Dimensionless");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C1H_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C2H_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C2H_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C2H_id, "description", 34, "half levels, c2h = (1-c1h)*(p0-pt)");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C2H_id, "units", 2, "Pa");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C2H_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, BH_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, BH_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, BH_id, "description", 46, "half levels, bh=0 => isobaric; bh=znu => sigma");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, BH_id, "units", 13, "Dimensionless");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, BH_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C1F_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C1F_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C1F_id, "description", 42, "full levels, c1f = d bf / d eta, using znu");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C1F_id, "units", 13, "Dimensionless");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C1F_id, "stagger", 1, "Z");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C2F_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C2F_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C2F_id, "description", 34, "full levels, c2f = (1-c1f)*(p0-pt)");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C2F_id, "units", 2, "Pa");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C2F_id, "stagger", 1, "Z");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C3H_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C3H_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C3H_id, "description", 21, "half levels, c3h = bh");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C3H_id, "units", 13, "Dimensionless");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C3H_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C4H_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C4H_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C4H_id, "description", 49, "half levels, c4h = (eta-bh)*(p0-pt)+pt, using znu");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C4H_id, "units", 2, "Pa");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C4H_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C3F_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C3F_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C3F_id, "description", 21, "full levels, c3f = bf");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C3F_id, "units", 13, "Dimensionless");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C3F_id, "stagger", 1, "Z");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C4F_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C4F_id, "MemoryOrder", 3, "Z  ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C4F_id, "description", 49, "full levels, c4f = (eta-bf)*(p0-pt)+pt, using znw");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C4F_id, "units", 2, "Pa");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, C4F_id, "stagger", 1, "Z");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PCB_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PCB_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PCB_id, "description", 33, "base state dry air mass in column");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PCB_id, "units", 2, "Pa");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PCB_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PCB_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PC_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PC_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PC_id, "description", 35, "perturbation dry air mass in column");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PC_id, "units", 2, "Pa");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PC_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, PC_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LANDMASK_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LANDMASK_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LANDMASK_id, "description", 35, "LAND MASK (1 FOR LAND, 0 FOR WATER)");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LANDMASK_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LANDMASK_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LANDMASK_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAKEMASK_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAKEMASK_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAKEMASK_id, "description", 35, "LAKE MASK (1 FOR LAND, 0 FOR WATER)");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAKEMASK_id, "units", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAKEMASK_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, LAKEMASK_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SST_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SST_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SST_id, "description", 23, "SEA SURFACE TEMPERATURE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SST_id, "units", 1, "K");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SST_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SST_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const int FieldType_att[1] = {104} ;
    stat = nc_put_att_int(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SST_INPUT_id, "FieldType", NC_INT, 1, FieldType_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SST_INPUT_id, "MemoryOrder", 3, "XY ");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SST_INPUT_id, "description", 45, "SEA SURFACE TEMPERATURE FROM WRFLOWINPUT FILE");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SST_INPUT_id, "units", 1, "K");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SST_INPUT_id, "stagger", 1, "");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp, SST_INPUT_id, "coordinates", 16, "XLONG XLAT XTIME");
    check_err(stat,__LINE__,__FILE__);
    }


    /* leave define mode */
    stat = nc_enddef (wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp);
    check_err(stat,__LINE__,__FILE__);

    /* assign variable data */

    stat = nc_close(wrfout_d01_2018_MINUS_12_MINUS_20_00_BACKSLASH__COLON_00_BACKSLASH__COLON_00_grp);
    check_err(stat,__LINE__,__FILE__);
    return 0;
}

int
create_wrfbdy_file(char *file_name, int cmode) {/* create wrfbdy.nc */

   int  stat;  /* return status */
   int  ncid;  /* netCDF id */

   /* dimension ids */
   int Time_dim;
   int DateStrLen_dim;
   int south_north_dim;
   int bottom_top_dim;
   int bdy_width_dim;
   int west_east_stag_dim;
   int south_north_stag_dim;
   int west_east_dim;
   int bottom_top_stag_dim;

   /* dimension lengths */
   size_t Time_len = NC_UNLIMITED;
   size_t DateStrLen_len = 19;
   size_t south_north_len = 60;
   size_t bottom_top_len = 32;
   size_t bdy_width_len = 5;
   size_t west_east_stag_len = 74;
   size_t south_north_stag_len = 61;
   size_t west_east_len = 73;
   size_t bottom_top_stag_len = 33;

   /* variable ids */
   int Times_id;
   int md___thisbdytimee_x_t_d_o_m_a_i_n_m_e_t_a_data__id;
   int md___nextbdytimee_x_t_d_o_m_a_i_n_m_e_t_a_data__id;
   int U_BXS_id;
   int U_BXE_id;
   int U_BYS_id;
   int U_BYE_id;
   int U_BTXS_id;
   int U_BTXE_id;
   int U_BTYS_id;
   int U_BTYE_id;
   int V_BXS_id;
   int V_BXE_id;
   int V_BYS_id;
   int V_BYE_id;
   int V_BTXS_id;
   int V_BTXE_id;
   int V_BTYS_id;
   int V_BTYE_id;
   int W_BXS_id;
   int W_BXE_id;
   int W_BYS_id;
   int W_BYE_id;
   int W_BTXS_id;
   int W_BTXE_id;
   int W_BTYS_id;
   int W_BTYE_id;
   int PH_BXS_id;
   int PH_BXE_id;
   int PH_BYS_id;
   int PH_BYE_id;
   int PH_BTXS_id;
   int PH_BTXE_id;
   int PH_BTYS_id;
   int PH_BTYE_id;
   int T_BXS_id;
   int T_BXE_id;
   int T_BYS_id;
   int T_BYE_id;
   int T_BTXS_id;
   int T_BTXE_id;
   int T_BTYS_id;
   int T_BTYE_id;
   int MU_BXS_id;
   int MU_BXE_id;
   int MU_BYS_id;
   int MU_BYE_id;
   int MU_BTXS_id;
   int MU_BTXE_id;
   int MU_BTYS_id;
   int MU_BTYE_id;
   int QVAPOR_BXS_id;
   int QVAPOR_BXE_id;
   int QVAPOR_BYS_id;
   int QVAPOR_BYE_id;
   int QCLOUD_BXS_id;
   int QCLOUD_BXE_id;
   int QCLOUD_BYS_id;
   int QCLOUD_BYE_id;
   int QRAIN_BXS_id;
   int QRAIN_BXE_id;
   int QRAIN_BYS_id;
   int QRAIN_BYE_id;
   int QICE_BXS_id;
   int QICE_BXE_id;
   int QICE_BYS_id;
   int QICE_BYE_id;
   int QSNOW_BXS_id;
   int QSNOW_BXE_id;
   int QSNOW_BYS_id;
   int QSNOW_BYE_id;
   int QGRAUP_BXS_id;
   int QGRAUP_BXE_id;
   int QGRAUP_BYS_id;
   int QGRAUP_BYE_id;
   int QVAPOR_BTXS_id;
   int QVAPOR_BTXE_id;
   int QVAPOR_BTYS_id;
   int QVAPOR_BTYE_id;
   int QCLOUD_BTXS_id;
   int QCLOUD_BTXE_id;
   int QCLOUD_BTYS_id;
   int QCLOUD_BTYE_id;
   int QRAIN_BTXS_id;
   int QRAIN_BTXE_id;
   int QRAIN_BTYS_id;
   int QRAIN_BTYE_id;
   int QICE_BTXS_id;
   int QICE_BTXE_id;
   int QICE_BTYS_id;
   int QICE_BTYE_id;
   int QSNOW_BTXS_id;
   int QSNOW_BTXE_id;
   int QSNOW_BTYS_id;
   int QSNOW_BTYE_id;
   int QGRAUP_BTXS_id;
   int QGRAUP_BTXE_id;
   int QGRAUP_BTYS_id;
   int QGRAUP_BTYE_id;
   int QNICE_BXS_id;
   int QNICE_BXE_id;
   int QNICE_BYS_id;
   int QNICE_BYE_id;
   int QNRAIN_BXS_id;
   int QNRAIN_BXE_id;
   int QNRAIN_BYS_id;
   int QNRAIN_BYE_id;
   int QNICE_BTXS_id;
   int QNICE_BTXE_id;
   int QNICE_BTYS_id;
   int QNICE_BTYE_id;
   int QNRAIN_BTXS_id;
   int QNRAIN_BTXE_id;
   int QNRAIN_BTYS_id;
   int QNRAIN_BTYE_id;
   int HT_SHAD_BXS_id;
   int HT_SHAD_BXE_id;
   int HT_SHAD_BYS_id;
   int HT_SHAD_BYE_id;
   int HT_SHAD_BTXS_id;
   int HT_SHAD_BTXE_id;
   int HT_SHAD_BTYS_id;
   int HT_SHAD_BTYE_id;
   int PC_BXS_id;
   int PC_BXE_id;
   int PC_BYS_id;
   int PC_BYE_id;
   int PC_BTXS_id;
   int PC_BTXE_id;
   int PC_BTYS_id;
   int PC_BTYE_id;

   /* rank (number of dimensions) for each variable */
#   define RANK_Times 2
#   define RANK_md___thisbdytimee_x_t_d_o_m_a_i_n_m_e_t_a_data_ 2
#   define RANK_md___nextbdytimee_x_t_d_o_m_a_i_n_m_e_t_a_data_ 2
#   define RANK_U_BXS 4
#   define RANK_U_BXE 4
#   define RANK_U_BYS 4
#   define RANK_U_BYE 4
#   define RANK_U_BTXS 4
#   define RANK_U_BTXE 4
#   define RANK_U_BTYS 4
#   define RANK_U_BTYE 4
#   define RANK_V_BXS 4
#   define RANK_V_BXE 4
#   define RANK_V_BYS 4
#   define RANK_V_BYE 4
#   define RANK_V_BTXS 4
#   define RANK_V_BTXE 4
#   define RANK_V_BTYS 4
#   define RANK_V_BTYE 4
#   define RANK_W_BXS 4
#   define RANK_W_BXE 4
#   define RANK_W_BYS 4
#   define RANK_W_BYE 4
#   define RANK_W_BTXS 4
#   define RANK_W_BTXE 4
#   define RANK_W_BTYS 4
#   define RANK_W_BTYE 4
#   define RANK_PH_BXS 4
#   define RANK_PH_BXE 4
#   define RANK_PH_BYS 4
#   define RANK_PH_BYE 4
#   define RANK_PH_BTXS 4
#   define RANK_PH_BTXE 4
#   define RANK_PH_BTYS 4
#   define RANK_PH_BTYE 4
#   define RANK_T_BXS 4
#   define RANK_T_BXE 4
#   define RANK_T_BYS 4
#   define RANK_T_BYE 4
#   define RANK_T_BTXS 4
#   define RANK_T_BTXE 4
#   define RANK_T_BTYS 4
#   define RANK_T_BTYE 4
#   define RANK_MU_BXS 3
#   define RANK_MU_BXE 3
#   define RANK_MU_BYS 3
#   define RANK_MU_BYE 3
#   define RANK_MU_BTXS 3
#   define RANK_MU_BTXE 3
#   define RANK_MU_BTYS 3
#   define RANK_MU_BTYE 3
#   define RANK_QVAPOR_BXS 4
#   define RANK_QVAPOR_BXE 4
#   define RANK_QVAPOR_BYS 4
#   define RANK_QVAPOR_BYE 4
#   define RANK_QCLOUD_BXS 4
#   define RANK_QCLOUD_BXE 4
#   define RANK_QCLOUD_BYS 4
#   define RANK_QCLOUD_BYE 4
#   define RANK_QRAIN_BXS 4
#   define RANK_QRAIN_BXE 4
#   define RANK_QRAIN_BYS 4
#   define RANK_QRAIN_BYE 4
#   define RANK_QICE_BXS 4
#   define RANK_QICE_BXE 4
#   define RANK_QICE_BYS 4
#   define RANK_QICE_BYE 4
#   define RANK_QSNOW_BXS 4
#   define RANK_QSNOW_BXE 4
#   define RANK_QSNOW_BYS 4
#   define RANK_QSNOW_BYE 4
#   define RANK_QGRAUP_BXS 4
#   define RANK_QGRAUP_BXE 4
#   define RANK_QGRAUP_BYS 4
#   define RANK_QGRAUP_BYE 4
#   define RANK_QVAPOR_BTXS 4
#   define RANK_QVAPOR_BTXE 4
#   define RANK_QVAPOR_BTYS 4
#   define RANK_QVAPOR_BTYE 4
#   define RANK_QCLOUD_BTXS 4
#   define RANK_QCLOUD_BTXE 4
#   define RANK_QCLOUD_BTYS 4
#   define RANK_QCLOUD_BTYE 4
#   define RANK_QRAIN_BTXS 4
#   define RANK_QRAIN_BTXE 4
#   define RANK_QRAIN_BTYS 4
#   define RANK_QRAIN_BTYE 4
#   define RANK_QICE_BTXS 4
#   define RANK_QICE_BTXE 4
#   define RANK_QICE_BTYS 4
#   define RANK_QICE_BTYE 4
#   define RANK_QSNOW_BTXS 4
#   define RANK_QSNOW_BTXE 4
#   define RANK_QSNOW_BTYS 4
#   define RANK_QSNOW_BTYE 4
#   define RANK_QGRAUP_BTXS 4
#   define RANK_QGRAUP_BTXE 4
#   define RANK_QGRAUP_BTYS 4
#   define RANK_QGRAUP_BTYE 4
#   define RANK_QNICE_BXS 4
#   define RANK_QNICE_BXE 4
#   define RANK_QNICE_BYS 4
#   define RANK_QNICE_BYE 4
#   define RANK_QNRAIN_BXS 4
#   define RANK_QNRAIN_BXE 4
#   define RANK_QNRAIN_BYS 4
#   define RANK_QNRAIN_BYE 4
#   define RANK_QNICE_BTXS 4
#   define RANK_QNICE_BTXE 4
#   define RANK_QNICE_BTYS 4
#   define RANK_QNICE_BTYE 4
#   define RANK_QNRAIN_BTXS 4
#   define RANK_QNRAIN_BTXE 4
#   define RANK_QNRAIN_BTYS 4
#   define RANK_QNRAIN_BTYE 4
#   define RANK_HT_SHAD_BXS 3
#   define RANK_HT_SHAD_BXE 3
#   define RANK_HT_SHAD_BYS 3
#   define RANK_HT_SHAD_BYE 3
#   define RANK_HT_SHAD_BTXS 3
#   define RANK_HT_SHAD_BTXE 3
#   define RANK_HT_SHAD_BTYS 3
#   define RANK_HT_SHAD_BTYE 3
#   define RANK_PC_BXS 3
#   define RANK_PC_BXE 3
#   define RANK_PC_BYS 3
#   define RANK_PC_BYE 3
#   define RANK_PC_BTXS 3
#   define RANK_PC_BTXE 3
#   define RANK_PC_BTYS 3
#   define RANK_PC_BTYE 3

   /* variable shapes */
   int Times_dims[RANK_Times];
   int md___thisbdytimee_x_t_d_o_m_a_i_n_m_e_t_a_data__dims[RANK_md___thisbdytimee_x_t_d_o_m_a_i_n_m_e_t_a_data_];
   int md___nextbdytimee_x_t_d_o_m_a_i_n_m_e_t_a_data__dims[RANK_md___nextbdytimee_x_t_d_o_m_a_i_n_m_e_t_a_data_];
   int U_BXS_dims[RANK_U_BXS];
   int U_BXE_dims[RANK_U_BXE];
   int U_BYS_dims[RANK_U_BYS];
   int U_BYE_dims[RANK_U_BYE];
   int U_BTXS_dims[RANK_U_BTXS];
   int U_BTXE_dims[RANK_U_BTXE];
   int U_BTYS_dims[RANK_U_BTYS];
   int U_BTYE_dims[RANK_U_BTYE];
   int V_BXS_dims[RANK_V_BXS];
   int V_BXE_dims[RANK_V_BXE];
   int V_BYS_dims[RANK_V_BYS];
   int V_BYE_dims[RANK_V_BYE];
   int V_BTXS_dims[RANK_V_BTXS];
   int V_BTXE_dims[RANK_V_BTXE];
   int V_BTYS_dims[RANK_V_BTYS];
   int V_BTYE_dims[RANK_V_BTYE];
   int W_BXS_dims[RANK_W_BXS];
   int W_BXE_dims[RANK_W_BXE];
   int W_BYS_dims[RANK_W_BYS];
   int W_BYE_dims[RANK_W_BYE];
   int W_BTXS_dims[RANK_W_BTXS];
   int W_BTXE_dims[RANK_W_BTXE];
   int W_BTYS_dims[RANK_W_BTYS];
   int W_BTYE_dims[RANK_W_BTYE];
   int PH_BXS_dims[RANK_PH_BXS];
   int PH_BXE_dims[RANK_PH_BXE];
   int PH_BYS_dims[RANK_PH_BYS];
   int PH_BYE_dims[RANK_PH_BYE];
   int PH_BTXS_dims[RANK_PH_BTXS];
   int PH_BTXE_dims[RANK_PH_BTXE];
   int PH_BTYS_dims[RANK_PH_BTYS];
   int PH_BTYE_dims[RANK_PH_BTYE];
   int T_BXS_dims[RANK_T_BXS];
   int T_BXE_dims[RANK_T_BXE];
   int T_BYS_dims[RANK_T_BYS];
   int T_BYE_dims[RANK_T_BYE];
   int T_BTXS_dims[RANK_T_BTXS];
   int T_BTXE_dims[RANK_T_BTXE];
   int T_BTYS_dims[RANK_T_BTYS];
   int T_BTYE_dims[RANK_T_BTYE];
   int MU_BXS_dims[RANK_MU_BXS];
   int MU_BXE_dims[RANK_MU_BXE];
   int MU_BYS_dims[RANK_MU_BYS];
   int MU_BYE_dims[RANK_MU_BYE];
   int MU_BTXS_dims[RANK_MU_BTXS];
   int MU_BTXE_dims[RANK_MU_BTXE];
   int MU_BTYS_dims[RANK_MU_BTYS];
   int MU_BTYE_dims[RANK_MU_BTYE];
   int QVAPOR_BXS_dims[RANK_QVAPOR_BXS];
   int QVAPOR_BXE_dims[RANK_QVAPOR_BXE];
   int QVAPOR_BYS_dims[RANK_QVAPOR_BYS];
   int QVAPOR_BYE_dims[RANK_QVAPOR_BYE];
   int QCLOUD_BXS_dims[RANK_QCLOUD_BXS];
   int QCLOUD_BXE_dims[RANK_QCLOUD_BXE];
   int QCLOUD_BYS_dims[RANK_QCLOUD_BYS];
   int QCLOUD_BYE_dims[RANK_QCLOUD_BYE];
   int QRAIN_BXS_dims[RANK_QRAIN_BXS];
   int QRAIN_BXE_dims[RANK_QRAIN_BXE];
   int QRAIN_BYS_dims[RANK_QRAIN_BYS];
   int QRAIN_BYE_dims[RANK_QRAIN_BYE];
   int QICE_BXS_dims[RANK_QICE_BXS];
   int QICE_BXE_dims[RANK_QICE_BXE];
   int QICE_BYS_dims[RANK_QICE_BYS];
   int QICE_BYE_dims[RANK_QICE_BYE];
   int QSNOW_BXS_dims[RANK_QSNOW_BXS];
   int QSNOW_BXE_dims[RANK_QSNOW_BXE];
   int QSNOW_BYS_dims[RANK_QSNOW_BYS];
   int QSNOW_BYE_dims[RANK_QSNOW_BYE];
   int QGRAUP_BXS_dims[RANK_QGRAUP_BXS];
   int QGRAUP_BXE_dims[RANK_QGRAUP_BXE];
   int QGRAUP_BYS_dims[RANK_QGRAUP_BYS];
   int QGRAUP_BYE_dims[RANK_QGRAUP_BYE];
   int QVAPOR_BTXS_dims[RANK_QVAPOR_BTXS];
   int QVAPOR_BTXE_dims[RANK_QVAPOR_BTXE];
   int QVAPOR_BTYS_dims[RANK_QVAPOR_BTYS];
   int QVAPOR_BTYE_dims[RANK_QVAPOR_BTYE];
   int QCLOUD_BTXS_dims[RANK_QCLOUD_BTXS];
   int QCLOUD_BTXE_dims[RANK_QCLOUD_BTXE];
   int QCLOUD_BTYS_dims[RANK_QCLOUD_BTYS];
   int QCLOUD_BTYE_dims[RANK_QCLOUD_BTYE];
   int QRAIN_BTXS_dims[RANK_QRAIN_BTXS];
   int QRAIN_BTXE_dims[RANK_QRAIN_BTXE];
   int QRAIN_BTYS_dims[RANK_QRAIN_BTYS];
   int QRAIN_BTYE_dims[RANK_QRAIN_BTYE];
   int QICE_BTXS_dims[RANK_QICE_BTXS];
   int QICE_BTXE_dims[RANK_QICE_BTXE];
   int QICE_BTYS_dims[RANK_QICE_BTYS];
   int QICE_BTYE_dims[RANK_QICE_BTYE];
   int QSNOW_BTXS_dims[RANK_QSNOW_BTXS];
   int QSNOW_BTXE_dims[RANK_QSNOW_BTXE];
   int QSNOW_BTYS_dims[RANK_QSNOW_BTYS];
   int QSNOW_BTYE_dims[RANK_QSNOW_BTYE];
   int QGRAUP_BTXS_dims[RANK_QGRAUP_BTXS];
   int QGRAUP_BTXE_dims[RANK_QGRAUP_BTXE];
   int QGRAUP_BTYS_dims[RANK_QGRAUP_BTYS];
   int QGRAUP_BTYE_dims[RANK_QGRAUP_BTYE];
   int QNICE_BXS_dims[RANK_QNICE_BXS];
   int QNICE_BXE_dims[RANK_QNICE_BXE];
   int QNICE_BYS_dims[RANK_QNICE_BYS];
   int QNICE_BYE_dims[RANK_QNICE_BYE];
   int QNRAIN_BXS_dims[RANK_QNRAIN_BXS];
   int QNRAIN_BXE_dims[RANK_QNRAIN_BXE];
   int QNRAIN_BYS_dims[RANK_QNRAIN_BYS];
   int QNRAIN_BYE_dims[RANK_QNRAIN_BYE];
   int QNICE_BTXS_dims[RANK_QNICE_BTXS];
   int QNICE_BTXE_dims[RANK_QNICE_BTXE];
   int QNICE_BTYS_dims[RANK_QNICE_BTYS];
   int QNICE_BTYE_dims[RANK_QNICE_BTYE];
   int QNRAIN_BTXS_dims[RANK_QNRAIN_BTXS];
   int QNRAIN_BTXE_dims[RANK_QNRAIN_BTXE];
   int QNRAIN_BTYS_dims[RANK_QNRAIN_BTYS];
   int QNRAIN_BTYE_dims[RANK_QNRAIN_BTYE];
   int HT_SHAD_BXS_dims[RANK_HT_SHAD_BXS];
   int HT_SHAD_BXE_dims[RANK_HT_SHAD_BXE];
   int HT_SHAD_BYS_dims[RANK_HT_SHAD_BYS];
   int HT_SHAD_BYE_dims[RANK_HT_SHAD_BYE];
   int HT_SHAD_BTXS_dims[RANK_HT_SHAD_BTXS];
   int HT_SHAD_BTXE_dims[RANK_HT_SHAD_BTXE];
   int HT_SHAD_BTYS_dims[RANK_HT_SHAD_BTYS];
   int HT_SHAD_BTYE_dims[RANK_HT_SHAD_BTYE];
   int PC_BXS_dims[RANK_PC_BXS];
   int PC_BXE_dims[RANK_PC_BXE];
   int PC_BYS_dims[RANK_PC_BYS];
   int PC_BYE_dims[RANK_PC_BYE];
   int PC_BTXS_dims[RANK_PC_BTXS];
   int PC_BTXE_dims[RANK_PC_BTXE];
   int PC_BTYS_dims[RANK_PC_BTYS];
   int PC_BTYE_dims[RANK_PC_BTYE];

   /* enter define mode */
   stat = nc_create(file_name, cmode|NC_CLOBBER, &ncid);
   check_err(stat,__LINE__,__FILE__);

   /* define dimensions */
   stat = nc_def_dim(ncid, "Time", Time_len, &Time_dim);
   check_err(stat,__LINE__,__FILE__);
   stat = nc_def_dim(ncid, "DateStrLen", DateStrLen_len, &DateStrLen_dim);
   check_err(stat,__LINE__,__FILE__);
   stat = nc_def_dim(ncid, "south_north", south_north_len, &south_north_dim);
   check_err(stat,__LINE__,__FILE__);
   stat = nc_def_dim(ncid, "bottom_top", bottom_top_len, &bottom_top_dim);
   check_err(stat,__LINE__,__FILE__);
   stat = nc_def_dim(ncid, "bdy_width", bdy_width_len, &bdy_width_dim);
   check_err(stat,__LINE__,__FILE__);
   stat = nc_def_dim(ncid, "west_east_stag", west_east_stag_len, &west_east_stag_dim);
   check_err(stat,__LINE__,__FILE__);
   stat = nc_def_dim(ncid, "south_north_stag", south_north_stag_len, &south_north_stag_dim);
   check_err(stat,__LINE__,__FILE__);
   stat = nc_def_dim(ncid, "west_east", west_east_len, &west_east_dim);
   check_err(stat,__LINE__,__FILE__);
   stat = nc_def_dim(ncid, "bottom_top_stag", bottom_top_stag_len, &bottom_top_stag_dim);
   check_err(stat,__LINE__,__FILE__);

   /* define variables */

   Times_dims[0] = Time_dim;
   Times_dims[1] = DateStrLen_dim;
   stat = nc_def_var(ncid, "Times", NC_CHAR, RANK_Times, Times_dims, &Times_id);
   check_err(stat,__LINE__,__FILE__);

   md___thisbdytimee_x_t_d_o_m_a_i_n_m_e_t_a_data__dims[0] = Time_dim;
   md___thisbdytimee_x_t_d_o_m_a_i_n_m_e_t_a_data__dims[1] = DateStrLen_dim;
   stat = nc_def_var(ncid, "md___thisbdytimee_x_t_d_o_m_a_i_n_m_e_t_a_data_", NC_CHAR, RANK_md___thisbdytimee_x_t_d_o_m_a_i_n_m_e_t_a_data_, md___thisbdytimee_x_t_d_o_m_a_i_n_m_e_t_a_data__dims, &md___thisbdytimee_x_t_d_o_m_a_i_n_m_e_t_a_data__id);
   check_err(stat,__LINE__,__FILE__);

   md___nextbdytimee_x_t_d_o_m_a_i_n_m_e_t_a_data__dims[0] = Time_dim;
   md___nextbdytimee_x_t_d_o_m_a_i_n_m_e_t_a_data__dims[1] = DateStrLen_dim;
   stat = nc_def_var(ncid, "md___nextbdytimee_x_t_d_o_m_a_i_n_m_e_t_a_data_", NC_CHAR, RANK_md___nextbdytimee_x_t_d_o_m_a_i_n_m_e_t_a_data_, md___nextbdytimee_x_t_d_o_m_a_i_n_m_e_t_a_data__dims, &md___nextbdytimee_x_t_d_o_m_a_i_n_m_e_t_a_data__id);
   check_err(stat,__LINE__,__FILE__);

   U_BXS_dims[0] = Time_dim;
   U_BXS_dims[1] = bdy_width_dim;
   U_BXS_dims[2] = bottom_top_dim;
   U_BXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "U_BXS", NC_FLOAT, RANK_U_BXS, U_BXS_dims, &U_BXS_id);
   check_err(stat,__LINE__,__FILE__);

   U_BXE_dims[0] = Time_dim;
   U_BXE_dims[1] = bdy_width_dim;
   U_BXE_dims[2] = bottom_top_dim;
   U_BXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "U_BXE", NC_FLOAT, RANK_U_BXE, U_BXE_dims, &U_BXE_id);
   check_err(stat,__LINE__,__FILE__);

   U_BYS_dims[0] = Time_dim;
   U_BYS_dims[1] = bdy_width_dim;
   U_BYS_dims[2] = bottom_top_dim;
   U_BYS_dims[3] = west_east_stag_dim;
   stat = nc_def_var(ncid, "U_BYS", NC_FLOAT, RANK_U_BYS, U_BYS_dims, &U_BYS_id);
   check_err(stat,__LINE__,__FILE__);

   U_BYE_dims[0] = Time_dim;
   U_BYE_dims[1] = bdy_width_dim;
   U_BYE_dims[2] = bottom_top_dim;
   U_BYE_dims[3] = west_east_stag_dim;
   stat = nc_def_var(ncid, "U_BYE", NC_FLOAT, RANK_U_BYE, U_BYE_dims, &U_BYE_id);
   check_err(stat,__LINE__,__FILE__);

   U_BTXS_dims[0] = Time_dim;
   U_BTXS_dims[1] = bdy_width_dim;
   U_BTXS_dims[2] = bottom_top_dim;
   U_BTXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "U_BTXS", NC_FLOAT, RANK_U_BTXS, U_BTXS_dims, &U_BTXS_id);
   check_err(stat,__LINE__,__FILE__);

   U_BTXE_dims[0] = Time_dim;
   U_BTXE_dims[1] = bdy_width_dim;
   U_BTXE_dims[2] = bottom_top_dim;
   U_BTXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "U_BTXE", NC_FLOAT, RANK_U_BTXE, U_BTXE_dims, &U_BTXE_id);
   check_err(stat,__LINE__,__FILE__);

   U_BTYS_dims[0] = Time_dim;
   U_BTYS_dims[1] = bdy_width_dim;
   U_BTYS_dims[2] = bottom_top_dim;
   U_BTYS_dims[3] = west_east_stag_dim;
   stat = nc_def_var(ncid, "U_BTYS", NC_FLOAT, RANK_U_BTYS, U_BTYS_dims, &U_BTYS_id);
   check_err(stat,__LINE__,__FILE__);

   U_BTYE_dims[0] = Time_dim;
   U_BTYE_dims[1] = bdy_width_dim;
   U_BTYE_dims[2] = bottom_top_dim;
   U_BTYE_dims[3] = west_east_stag_dim;
   stat = nc_def_var(ncid, "U_BTYE", NC_FLOAT, RANK_U_BTYE, U_BTYE_dims, &U_BTYE_id);
   check_err(stat,__LINE__,__FILE__);

   V_BXS_dims[0] = Time_dim;
   V_BXS_dims[1] = bdy_width_dim;
   V_BXS_dims[2] = bottom_top_dim;
   V_BXS_dims[3] = south_north_stag_dim;
   stat = nc_def_var(ncid, "V_BXS", NC_FLOAT, RANK_V_BXS, V_BXS_dims, &V_BXS_id);
   check_err(stat,__LINE__,__FILE__);

   V_BXE_dims[0] = Time_dim;
   V_BXE_dims[1] = bdy_width_dim;
   V_BXE_dims[2] = bottom_top_dim;
   V_BXE_dims[3] = south_north_stag_dim;
   stat = nc_def_var(ncid, "V_BXE", NC_FLOAT, RANK_V_BXE, V_BXE_dims, &V_BXE_id);
   check_err(stat,__LINE__,__FILE__);

   V_BYS_dims[0] = Time_dim;
   V_BYS_dims[1] = bdy_width_dim;
   V_BYS_dims[2] = bottom_top_dim;
   V_BYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "V_BYS", NC_FLOAT, RANK_V_BYS, V_BYS_dims, &V_BYS_id);
   check_err(stat,__LINE__,__FILE__);

   V_BYE_dims[0] = Time_dim;
   V_BYE_dims[1] = bdy_width_dim;
   V_BYE_dims[2] = bottom_top_dim;
   V_BYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "V_BYE", NC_FLOAT, RANK_V_BYE, V_BYE_dims, &V_BYE_id);
   check_err(stat,__LINE__,__FILE__);

   V_BTXS_dims[0] = Time_dim;
   V_BTXS_dims[1] = bdy_width_dim;
   V_BTXS_dims[2] = bottom_top_dim;
   V_BTXS_dims[3] = south_north_stag_dim;
   stat = nc_def_var(ncid, "V_BTXS", NC_FLOAT, RANK_V_BTXS, V_BTXS_dims, &V_BTXS_id);
   check_err(stat,__LINE__,__FILE__);

   V_BTXE_dims[0] = Time_dim;
   V_BTXE_dims[1] = bdy_width_dim;
   V_BTXE_dims[2] = bottom_top_dim;
   V_BTXE_dims[3] = south_north_stag_dim;
   stat = nc_def_var(ncid, "V_BTXE", NC_FLOAT, RANK_V_BTXE, V_BTXE_dims, &V_BTXE_id);
   check_err(stat,__LINE__,__FILE__);

   V_BTYS_dims[0] = Time_dim;
   V_BTYS_dims[1] = bdy_width_dim;
   V_BTYS_dims[2] = bottom_top_dim;
   V_BTYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "V_BTYS", NC_FLOAT, RANK_V_BTYS, V_BTYS_dims, &V_BTYS_id);
   check_err(stat,__LINE__,__FILE__);

   V_BTYE_dims[0] = Time_dim;
   V_BTYE_dims[1] = bdy_width_dim;
   V_BTYE_dims[2] = bottom_top_dim;
   V_BTYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "V_BTYE", NC_FLOAT, RANK_V_BTYE, V_BTYE_dims, &V_BTYE_id);
   check_err(stat,__LINE__,__FILE__);

   W_BXS_dims[0] = Time_dim;
   W_BXS_dims[1] = bdy_width_dim;
   W_BXS_dims[2] = bottom_top_stag_dim;
   W_BXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "W_BXS", NC_FLOAT, RANK_W_BXS, W_BXS_dims, &W_BXS_id);
   check_err(stat,__LINE__,__FILE__);

   W_BXE_dims[0] = Time_dim;
   W_BXE_dims[1] = bdy_width_dim;
   W_BXE_dims[2] = bottom_top_stag_dim;
   W_BXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "W_BXE", NC_FLOAT, RANK_W_BXE, W_BXE_dims, &W_BXE_id);
   check_err(stat,__LINE__,__FILE__);

   W_BYS_dims[0] = Time_dim;
   W_BYS_dims[1] = bdy_width_dim;
   W_BYS_dims[2] = bottom_top_stag_dim;
   W_BYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "W_BYS", NC_FLOAT, RANK_W_BYS, W_BYS_dims, &W_BYS_id);
   check_err(stat,__LINE__,__FILE__);

   W_BYE_dims[0] = Time_dim;
   W_BYE_dims[1] = bdy_width_dim;
   W_BYE_dims[2] = bottom_top_stag_dim;
   W_BYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "W_BYE", NC_FLOAT, RANK_W_BYE, W_BYE_dims, &W_BYE_id);
   check_err(stat,__LINE__,__FILE__);

   W_BTXS_dims[0] = Time_dim;
   W_BTXS_dims[1] = bdy_width_dim;
   W_BTXS_dims[2] = bottom_top_stag_dim;
   W_BTXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "W_BTXS", NC_FLOAT, RANK_W_BTXS, W_BTXS_dims, &W_BTXS_id);
   check_err(stat,__LINE__,__FILE__);

   W_BTXE_dims[0] = Time_dim;
   W_BTXE_dims[1] = bdy_width_dim;
   W_BTXE_dims[2] = bottom_top_stag_dim;
   W_BTXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "W_BTXE", NC_FLOAT, RANK_W_BTXE, W_BTXE_dims, &W_BTXE_id);
   check_err(stat,__LINE__,__FILE__);

   W_BTYS_dims[0] = Time_dim;
   W_BTYS_dims[1] = bdy_width_dim;
   W_BTYS_dims[2] = bottom_top_stag_dim;
   W_BTYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "W_BTYS", NC_FLOAT, RANK_W_BTYS, W_BTYS_dims, &W_BTYS_id);
   check_err(stat,__LINE__,__FILE__);

   W_BTYE_dims[0] = Time_dim;
   W_BTYE_dims[1] = bdy_width_dim;
   W_BTYE_dims[2] = bottom_top_stag_dim;
   W_BTYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "W_BTYE", NC_FLOAT, RANK_W_BTYE, W_BTYE_dims, &W_BTYE_id);
   check_err(stat,__LINE__,__FILE__);

   PH_BXS_dims[0] = Time_dim;
   PH_BXS_dims[1] = bdy_width_dim;
   PH_BXS_dims[2] = bottom_top_stag_dim;
   PH_BXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "PH_BXS", NC_FLOAT, RANK_PH_BXS, PH_BXS_dims, &PH_BXS_id);
   check_err(stat,__LINE__,__FILE__);

   PH_BXE_dims[0] = Time_dim;
   PH_BXE_dims[1] = bdy_width_dim;
   PH_BXE_dims[2] = bottom_top_stag_dim;
   PH_BXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "PH_BXE", NC_FLOAT, RANK_PH_BXE, PH_BXE_dims, &PH_BXE_id);
   check_err(stat,__LINE__,__FILE__);

   PH_BYS_dims[0] = Time_dim;
   PH_BYS_dims[1] = bdy_width_dim;
   PH_BYS_dims[2] = bottom_top_stag_dim;
   PH_BYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "PH_BYS", NC_FLOAT, RANK_PH_BYS, PH_BYS_dims, &PH_BYS_id);
   check_err(stat,__LINE__,__FILE__);

   PH_BYE_dims[0] = Time_dim;
   PH_BYE_dims[1] = bdy_width_dim;
   PH_BYE_dims[2] = bottom_top_stag_dim;
   PH_BYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "PH_BYE", NC_FLOAT, RANK_PH_BYE, PH_BYE_dims, &PH_BYE_id);
   check_err(stat,__LINE__,__FILE__);

   PH_BTXS_dims[0] = Time_dim;
   PH_BTXS_dims[1] = bdy_width_dim;
   PH_BTXS_dims[2] = bottom_top_stag_dim;
   PH_BTXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "PH_BTXS", NC_FLOAT, RANK_PH_BTXS, PH_BTXS_dims, &PH_BTXS_id);
   check_err(stat,__LINE__,__FILE__);

   PH_BTXE_dims[0] = Time_dim;
   PH_BTXE_dims[1] = bdy_width_dim;
   PH_BTXE_dims[2] = bottom_top_stag_dim;
   PH_BTXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "PH_BTXE", NC_FLOAT, RANK_PH_BTXE, PH_BTXE_dims, &PH_BTXE_id);
   check_err(stat,__LINE__,__FILE__);

   PH_BTYS_dims[0] = Time_dim;
   PH_BTYS_dims[1] = bdy_width_dim;
   PH_BTYS_dims[2] = bottom_top_stag_dim;
   PH_BTYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "PH_BTYS", NC_FLOAT, RANK_PH_BTYS, PH_BTYS_dims, &PH_BTYS_id);
   check_err(stat,__LINE__,__FILE__);

   PH_BTYE_dims[0] = Time_dim;
   PH_BTYE_dims[1] = bdy_width_dim;
   PH_BTYE_dims[2] = bottom_top_stag_dim;
   PH_BTYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "PH_BTYE", NC_FLOAT, RANK_PH_BTYE, PH_BTYE_dims, &PH_BTYE_id);
   check_err(stat,__LINE__,__FILE__);

   T_BXS_dims[0] = Time_dim;
   T_BXS_dims[1] = bdy_width_dim;
   T_BXS_dims[2] = bottom_top_dim;
   T_BXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "T_BXS", NC_FLOAT, RANK_T_BXS, T_BXS_dims, &T_BXS_id);
   check_err(stat,__LINE__,__FILE__);

   T_BXE_dims[0] = Time_dim;
   T_BXE_dims[1] = bdy_width_dim;
   T_BXE_dims[2] = bottom_top_dim;
   T_BXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "T_BXE", NC_FLOAT, RANK_T_BXE, T_BXE_dims, &T_BXE_id);
   check_err(stat,__LINE__,__FILE__);

   T_BYS_dims[0] = Time_dim;
   T_BYS_dims[1] = bdy_width_dim;
   T_BYS_dims[2] = bottom_top_dim;
   T_BYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "T_BYS", NC_FLOAT, RANK_T_BYS, T_BYS_dims, &T_BYS_id);
   check_err(stat,__LINE__,__FILE__);

   T_BYE_dims[0] = Time_dim;
   T_BYE_dims[1] = bdy_width_dim;
   T_BYE_dims[2] = bottom_top_dim;
   T_BYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "T_BYE", NC_FLOAT, RANK_T_BYE, T_BYE_dims, &T_BYE_id);
   check_err(stat,__LINE__,__FILE__);

   T_BTXS_dims[0] = Time_dim;
   T_BTXS_dims[1] = bdy_width_dim;
   T_BTXS_dims[2] = bottom_top_dim;
   T_BTXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "T_BTXS", NC_FLOAT, RANK_T_BTXS, T_BTXS_dims, &T_BTXS_id);
   check_err(stat,__LINE__,__FILE__);

   T_BTXE_dims[0] = Time_dim;
   T_BTXE_dims[1] = bdy_width_dim;
   T_BTXE_dims[2] = bottom_top_dim;
   T_BTXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "T_BTXE", NC_FLOAT, RANK_T_BTXE, T_BTXE_dims, &T_BTXE_id);
   check_err(stat,__LINE__,__FILE__);

   T_BTYS_dims[0] = Time_dim;
   T_BTYS_dims[1] = bdy_width_dim;
   T_BTYS_dims[2] = bottom_top_dim;
   T_BTYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "T_BTYS", NC_FLOAT, RANK_T_BTYS, T_BTYS_dims, &T_BTYS_id);
   check_err(stat,__LINE__,__FILE__);

   T_BTYE_dims[0] = Time_dim;
   T_BTYE_dims[1] = bdy_width_dim;
   T_BTYE_dims[2] = bottom_top_dim;
   T_BTYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "T_BTYE", NC_FLOAT, RANK_T_BTYE, T_BTYE_dims, &T_BTYE_id);
   check_err(stat,__LINE__,__FILE__);

   MU_BXS_dims[0] = Time_dim;
   MU_BXS_dims[1] = bdy_width_dim;
   MU_BXS_dims[2] = south_north_dim;
   stat = nc_def_var(ncid, "MU_BXS", NC_FLOAT, RANK_MU_BXS, MU_BXS_dims, &MU_BXS_id);
   check_err(stat,__LINE__,__FILE__);

   MU_BXE_dims[0] = Time_dim;
   MU_BXE_dims[1] = bdy_width_dim;
   MU_BXE_dims[2] = south_north_dim;
   stat = nc_def_var(ncid, "MU_BXE", NC_FLOAT, RANK_MU_BXE, MU_BXE_dims, &MU_BXE_id);
   check_err(stat,__LINE__,__FILE__);

   MU_BYS_dims[0] = Time_dim;
   MU_BYS_dims[1] = bdy_width_dim;
   MU_BYS_dims[2] = west_east_dim;
   stat = nc_def_var(ncid, "MU_BYS", NC_FLOAT, RANK_MU_BYS, MU_BYS_dims, &MU_BYS_id);
   check_err(stat,__LINE__,__FILE__);

   MU_BYE_dims[0] = Time_dim;
   MU_BYE_dims[1] = bdy_width_dim;
   MU_BYE_dims[2] = west_east_dim;
   stat = nc_def_var(ncid, "MU_BYE", NC_FLOAT, RANK_MU_BYE, MU_BYE_dims, &MU_BYE_id);
   check_err(stat,__LINE__,__FILE__);

   MU_BTXS_dims[0] = Time_dim;
   MU_BTXS_dims[1] = bdy_width_dim;
   MU_BTXS_dims[2] = south_north_dim;
   stat = nc_def_var(ncid, "MU_BTXS", NC_FLOAT, RANK_MU_BTXS, MU_BTXS_dims, &MU_BTXS_id);
   check_err(stat,__LINE__,__FILE__);

   MU_BTXE_dims[0] = Time_dim;
   MU_BTXE_dims[1] = bdy_width_dim;
   MU_BTXE_dims[2] = south_north_dim;
   stat = nc_def_var(ncid, "MU_BTXE", NC_FLOAT, RANK_MU_BTXE, MU_BTXE_dims, &MU_BTXE_id);
   check_err(stat,__LINE__,__FILE__);

   MU_BTYS_dims[0] = Time_dim;
   MU_BTYS_dims[1] = bdy_width_dim;
   MU_BTYS_dims[2] = west_east_dim;
   stat = nc_def_var(ncid, "MU_BTYS", NC_FLOAT, RANK_MU_BTYS, MU_BTYS_dims, &MU_BTYS_id);
   check_err(stat,__LINE__,__FILE__);

   MU_BTYE_dims[0] = Time_dim;
   MU_BTYE_dims[1] = bdy_width_dim;
   MU_BTYE_dims[2] = west_east_dim;
   stat = nc_def_var(ncid, "MU_BTYE", NC_FLOAT, RANK_MU_BTYE, MU_BTYE_dims, &MU_BTYE_id);
   check_err(stat,__LINE__,__FILE__);

   QVAPOR_BXS_dims[0] = Time_dim;
   QVAPOR_BXS_dims[1] = bdy_width_dim;
   QVAPOR_BXS_dims[2] = bottom_top_dim;
   QVAPOR_BXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QVAPOR_BXS", NC_FLOAT, RANK_QVAPOR_BXS, QVAPOR_BXS_dims, &QVAPOR_BXS_id);
   check_err(stat,__LINE__,__FILE__);

   QVAPOR_BXE_dims[0] = Time_dim;
   QVAPOR_BXE_dims[1] = bdy_width_dim;
   QVAPOR_BXE_dims[2] = bottom_top_dim;
   QVAPOR_BXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QVAPOR_BXE", NC_FLOAT, RANK_QVAPOR_BXE, QVAPOR_BXE_dims, &QVAPOR_BXE_id);
   check_err(stat,__LINE__,__FILE__);

   QVAPOR_BYS_dims[0] = Time_dim;
   QVAPOR_BYS_dims[1] = bdy_width_dim;
   QVAPOR_BYS_dims[2] = bottom_top_dim;
   QVAPOR_BYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QVAPOR_BYS", NC_FLOAT, RANK_QVAPOR_BYS, QVAPOR_BYS_dims, &QVAPOR_BYS_id);
   check_err(stat,__LINE__,__FILE__);

   QVAPOR_BYE_dims[0] = Time_dim;
   QVAPOR_BYE_dims[1] = bdy_width_dim;
   QVAPOR_BYE_dims[2] = bottom_top_dim;
   QVAPOR_BYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QVAPOR_BYE", NC_FLOAT, RANK_QVAPOR_BYE, QVAPOR_BYE_dims, &QVAPOR_BYE_id);
   check_err(stat,__LINE__,__FILE__);

   QCLOUD_BXS_dims[0] = Time_dim;
   QCLOUD_BXS_dims[1] = bdy_width_dim;
   QCLOUD_BXS_dims[2] = bottom_top_dim;
   QCLOUD_BXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QCLOUD_BXS", NC_FLOAT, RANK_QCLOUD_BXS, QCLOUD_BXS_dims, &QCLOUD_BXS_id);
   check_err(stat,__LINE__,__FILE__);

   QCLOUD_BXE_dims[0] = Time_dim;
   QCLOUD_BXE_dims[1] = bdy_width_dim;
   QCLOUD_BXE_dims[2] = bottom_top_dim;
   QCLOUD_BXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QCLOUD_BXE", NC_FLOAT, RANK_QCLOUD_BXE, QCLOUD_BXE_dims, &QCLOUD_BXE_id);
   check_err(stat,__LINE__,__FILE__);

   QCLOUD_BYS_dims[0] = Time_dim;
   QCLOUD_BYS_dims[1] = bdy_width_dim;
   QCLOUD_BYS_dims[2] = bottom_top_dim;
   QCLOUD_BYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QCLOUD_BYS", NC_FLOAT, RANK_QCLOUD_BYS, QCLOUD_BYS_dims, &QCLOUD_BYS_id);
   check_err(stat,__LINE__,__FILE__);

   QCLOUD_BYE_dims[0] = Time_dim;
   QCLOUD_BYE_dims[1] = bdy_width_dim;
   QCLOUD_BYE_dims[2] = bottom_top_dim;
   QCLOUD_BYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QCLOUD_BYE", NC_FLOAT, RANK_QCLOUD_BYE, QCLOUD_BYE_dims, &QCLOUD_BYE_id);
   check_err(stat,__LINE__,__FILE__);

   QRAIN_BXS_dims[0] = Time_dim;
   QRAIN_BXS_dims[1] = bdy_width_dim;
   QRAIN_BXS_dims[2] = bottom_top_dim;
   QRAIN_BXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QRAIN_BXS", NC_FLOAT, RANK_QRAIN_BXS, QRAIN_BXS_dims, &QRAIN_BXS_id);
   check_err(stat,__LINE__,__FILE__);

   QRAIN_BXE_dims[0] = Time_dim;
   QRAIN_BXE_dims[1] = bdy_width_dim;
   QRAIN_BXE_dims[2] = bottom_top_dim;
   QRAIN_BXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QRAIN_BXE", NC_FLOAT, RANK_QRAIN_BXE, QRAIN_BXE_dims, &QRAIN_BXE_id);
   check_err(stat,__LINE__,__FILE__);

   QRAIN_BYS_dims[0] = Time_dim;
   QRAIN_BYS_dims[1] = bdy_width_dim;
   QRAIN_BYS_dims[2] = bottom_top_dim;
   QRAIN_BYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QRAIN_BYS", NC_FLOAT, RANK_QRAIN_BYS, QRAIN_BYS_dims, &QRAIN_BYS_id);
   check_err(stat,__LINE__,__FILE__);

   QRAIN_BYE_dims[0] = Time_dim;
   QRAIN_BYE_dims[1] = bdy_width_dim;
   QRAIN_BYE_dims[2] = bottom_top_dim;
   QRAIN_BYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QRAIN_BYE", NC_FLOAT, RANK_QRAIN_BYE, QRAIN_BYE_dims, &QRAIN_BYE_id);
   check_err(stat,__LINE__,__FILE__);

   QICE_BXS_dims[0] = Time_dim;
   QICE_BXS_dims[1] = bdy_width_dim;
   QICE_BXS_dims[2] = bottom_top_dim;
   QICE_BXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QICE_BXS", NC_FLOAT, RANK_QICE_BXS, QICE_BXS_dims, &QICE_BXS_id);
   check_err(stat,__LINE__,__FILE__);

   QICE_BXE_dims[0] = Time_dim;
   QICE_BXE_dims[1] = bdy_width_dim;
   QICE_BXE_dims[2] = bottom_top_dim;
   QICE_BXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QICE_BXE", NC_FLOAT, RANK_QICE_BXE, QICE_BXE_dims, &QICE_BXE_id);
   check_err(stat,__LINE__,__FILE__);

   QICE_BYS_dims[0] = Time_dim;
   QICE_BYS_dims[1] = bdy_width_dim;
   QICE_BYS_dims[2] = bottom_top_dim;
   QICE_BYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QICE_BYS", NC_FLOAT, RANK_QICE_BYS, QICE_BYS_dims, &QICE_BYS_id);
   check_err(stat,__LINE__,__FILE__);

   QICE_BYE_dims[0] = Time_dim;
   QICE_BYE_dims[1] = bdy_width_dim;
   QICE_BYE_dims[2] = bottom_top_dim;
   QICE_BYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QICE_BYE", NC_FLOAT, RANK_QICE_BYE, QICE_BYE_dims, &QICE_BYE_id);
   check_err(stat,__LINE__,__FILE__);

   QSNOW_BXS_dims[0] = Time_dim;
   QSNOW_BXS_dims[1] = bdy_width_dim;
   QSNOW_BXS_dims[2] = bottom_top_dim;
   QSNOW_BXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QSNOW_BXS", NC_FLOAT, RANK_QSNOW_BXS, QSNOW_BXS_dims, &QSNOW_BXS_id);
   check_err(stat,__LINE__,__FILE__);

   QSNOW_BXE_dims[0] = Time_dim;
   QSNOW_BXE_dims[1] = bdy_width_dim;
   QSNOW_BXE_dims[2] = bottom_top_dim;
   QSNOW_BXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QSNOW_BXE", NC_FLOAT, RANK_QSNOW_BXE, QSNOW_BXE_dims, &QSNOW_BXE_id);
   check_err(stat,__LINE__,__FILE__);

   QSNOW_BYS_dims[0] = Time_dim;
   QSNOW_BYS_dims[1] = bdy_width_dim;
   QSNOW_BYS_dims[2] = bottom_top_dim;
   QSNOW_BYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QSNOW_BYS", NC_FLOAT, RANK_QSNOW_BYS, QSNOW_BYS_dims, &QSNOW_BYS_id);
   check_err(stat,__LINE__,__FILE__);

   QSNOW_BYE_dims[0] = Time_dim;
   QSNOW_BYE_dims[1] = bdy_width_dim;
   QSNOW_BYE_dims[2] = bottom_top_dim;
   QSNOW_BYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QSNOW_BYE", NC_FLOAT, RANK_QSNOW_BYE, QSNOW_BYE_dims, &QSNOW_BYE_id);
   check_err(stat,__LINE__,__FILE__);

   QGRAUP_BXS_dims[0] = Time_dim;
   QGRAUP_BXS_dims[1] = bdy_width_dim;
   QGRAUP_BXS_dims[2] = bottom_top_dim;
   QGRAUP_BXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QGRAUP_BXS", NC_FLOAT, RANK_QGRAUP_BXS, QGRAUP_BXS_dims, &QGRAUP_BXS_id);
   check_err(stat,__LINE__,__FILE__);

   QGRAUP_BXE_dims[0] = Time_dim;
   QGRAUP_BXE_dims[1] = bdy_width_dim;
   QGRAUP_BXE_dims[2] = bottom_top_dim;
   QGRAUP_BXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QGRAUP_BXE", NC_FLOAT, RANK_QGRAUP_BXE, QGRAUP_BXE_dims, &QGRAUP_BXE_id);
   check_err(stat,__LINE__,__FILE__);

   QGRAUP_BYS_dims[0] = Time_dim;
   QGRAUP_BYS_dims[1] = bdy_width_dim;
   QGRAUP_BYS_dims[2] = bottom_top_dim;
   QGRAUP_BYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QGRAUP_BYS", NC_FLOAT, RANK_QGRAUP_BYS, QGRAUP_BYS_dims, &QGRAUP_BYS_id);
   check_err(stat,__LINE__,__FILE__);

   QGRAUP_BYE_dims[0] = Time_dim;
   QGRAUP_BYE_dims[1] = bdy_width_dim;
   QGRAUP_BYE_dims[2] = bottom_top_dim;
   QGRAUP_BYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QGRAUP_BYE", NC_FLOAT, RANK_QGRAUP_BYE, QGRAUP_BYE_dims, &QGRAUP_BYE_id);
   check_err(stat,__LINE__,__FILE__);

   QVAPOR_BTXS_dims[0] = Time_dim;
   QVAPOR_BTXS_dims[1] = bdy_width_dim;
   QVAPOR_BTXS_dims[2] = bottom_top_dim;
   QVAPOR_BTXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QVAPOR_BTXS", NC_FLOAT, RANK_QVAPOR_BTXS, QVAPOR_BTXS_dims, &QVAPOR_BTXS_id);
   check_err(stat,__LINE__,__FILE__);

   QVAPOR_BTXE_dims[0] = Time_dim;
   QVAPOR_BTXE_dims[1] = bdy_width_dim;
   QVAPOR_BTXE_dims[2] = bottom_top_dim;
   QVAPOR_BTXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QVAPOR_BTXE", NC_FLOAT, RANK_QVAPOR_BTXE, QVAPOR_BTXE_dims, &QVAPOR_BTXE_id);
   check_err(stat,__LINE__,__FILE__);

   QVAPOR_BTYS_dims[0] = Time_dim;
   QVAPOR_BTYS_dims[1] = bdy_width_dim;
   QVAPOR_BTYS_dims[2] = bottom_top_dim;
   QVAPOR_BTYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QVAPOR_BTYS", NC_FLOAT, RANK_QVAPOR_BTYS, QVAPOR_BTYS_dims, &QVAPOR_BTYS_id);
   check_err(stat,__LINE__,__FILE__);

   QVAPOR_BTYE_dims[0] = Time_dim;
   QVAPOR_BTYE_dims[1] = bdy_width_dim;
   QVAPOR_BTYE_dims[2] = bottom_top_dim;
   QVAPOR_BTYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QVAPOR_BTYE", NC_FLOAT, RANK_QVAPOR_BTYE, QVAPOR_BTYE_dims, &QVAPOR_BTYE_id);
   check_err(stat,__LINE__,__FILE__);

   QCLOUD_BTXS_dims[0] = Time_dim;
   QCLOUD_BTXS_dims[1] = bdy_width_dim;
   QCLOUD_BTXS_dims[2] = bottom_top_dim;
   QCLOUD_BTXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QCLOUD_BTXS", NC_FLOAT, RANK_QCLOUD_BTXS, QCLOUD_BTXS_dims, &QCLOUD_BTXS_id);
   check_err(stat,__LINE__,__FILE__);

   QCLOUD_BTXE_dims[0] = Time_dim;
   QCLOUD_BTXE_dims[1] = bdy_width_dim;
   QCLOUD_BTXE_dims[2] = bottom_top_dim;
   QCLOUD_BTXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QCLOUD_BTXE", NC_FLOAT, RANK_QCLOUD_BTXE, QCLOUD_BTXE_dims, &QCLOUD_BTXE_id);
   check_err(stat,__LINE__,__FILE__);

   QCLOUD_BTYS_dims[0] = Time_dim;
   QCLOUD_BTYS_dims[1] = bdy_width_dim;
   QCLOUD_BTYS_dims[2] = bottom_top_dim;
   QCLOUD_BTYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QCLOUD_BTYS", NC_FLOAT, RANK_QCLOUD_BTYS, QCLOUD_BTYS_dims, &QCLOUD_BTYS_id);
   check_err(stat,__LINE__,__FILE__);

   QCLOUD_BTYE_dims[0] = Time_dim;
   QCLOUD_BTYE_dims[1] = bdy_width_dim;
   QCLOUD_BTYE_dims[2] = bottom_top_dim;
   QCLOUD_BTYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QCLOUD_BTYE", NC_FLOAT, RANK_QCLOUD_BTYE, QCLOUD_BTYE_dims, &QCLOUD_BTYE_id);
   check_err(stat,__LINE__,__FILE__);

   QRAIN_BTXS_dims[0] = Time_dim;
   QRAIN_BTXS_dims[1] = bdy_width_dim;
   QRAIN_BTXS_dims[2] = bottom_top_dim;
   QRAIN_BTXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QRAIN_BTXS", NC_FLOAT, RANK_QRAIN_BTXS, QRAIN_BTXS_dims, &QRAIN_BTXS_id);
   check_err(stat,__LINE__,__FILE__);

   QRAIN_BTXE_dims[0] = Time_dim;
   QRAIN_BTXE_dims[1] = bdy_width_dim;
   QRAIN_BTXE_dims[2] = bottom_top_dim;
   QRAIN_BTXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QRAIN_BTXE", NC_FLOAT, RANK_QRAIN_BTXE, QRAIN_BTXE_dims, &QRAIN_BTXE_id);
   check_err(stat,__LINE__,__FILE__);

   QRAIN_BTYS_dims[0] = Time_dim;
   QRAIN_BTYS_dims[1] = bdy_width_dim;
   QRAIN_BTYS_dims[2] = bottom_top_dim;
   QRAIN_BTYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QRAIN_BTYS", NC_FLOAT, RANK_QRAIN_BTYS, QRAIN_BTYS_dims, &QRAIN_BTYS_id);
   check_err(stat,__LINE__,__FILE__);

   QRAIN_BTYE_dims[0] = Time_dim;
   QRAIN_BTYE_dims[1] = bdy_width_dim;
   QRAIN_BTYE_dims[2] = bottom_top_dim;
   QRAIN_BTYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QRAIN_BTYE", NC_FLOAT, RANK_QRAIN_BTYE, QRAIN_BTYE_dims, &QRAIN_BTYE_id);
   check_err(stat,__LINE__,__FILE__);

   QICE_BTXS_dims[0] = Time_dim;
   QICE_BTXS_dims[1] = bdy_width_dim;
   QICE_BTXS_dims[2] = bottom_top_dim;
   QICE_BTXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QICE_BTXS", NC_FLOAT, RANK_QICE_BTXS, QICE_BTXS_dims, &QICE_BTXS_id);
   check_err(stat,__LINE__,__FILE__);

   QICE_BTXE_dims[0] = Time_dim;
   QICE_BTXE_dims[1] = bdy_width_dim;
   QICE_BTXE_dims[2] = bottom_top_dim;
   QICE_BTXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QICE_BTXE", NC_FLOAT, RANK_QICE_BTXE, QICE_BTXE_dims, &QICE_BTXE_id);
   check_err(stat,__LINE__,__FILE__);

   QICE_BTYS_dims[0] = Time_dim;
   QICE_BTYS_dims[1] = bdy_width_dim;
   QICE_BTYS_dims[2] = bottom_top_dim;
   QICE_BTYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QICE_BTYS", NC_FLOAT, RANK_QICE_BTYS, QICE_BTYS_dims, &QICE_BTYS_id);
   check_err(stat,__LINE__,__FILE__);

   QICE_BTYE_dims[0] = Time_dim;
   QICE_BTYE_dims[1] = bdy_width_dim;
   QICE_BTYE_dims[2] = bottom_top_dim;
   QICE_BTYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QICE_BTYE", NC_FLOAT, RANK_QICE_BTYE, QICE_BTYE_dims, &QICE_BTYE_id);
   check_err(stat,__LINE__,__FILE__);

   QSNOW_BTXS_dims[0] = Time_dim;
   QSNOW_BTXS_dims[1] = bdy_width_dim;
   QSNOW_BTXS_dims[2] = bottom_top_dim;
   QSNOW_BTXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QSNOW_BTXS", NC_FLOAT, RANK_QSNOW_BTXS, QSNOW_BTXS_dims, &QSNOW_BTXS_id);
   check_err(stat,__LINE__,__FILE__);

   QSNOW_BTXE_dims[0] = Time_dim;
   QSNOW_BTXE_dims[1] = bdy_width_dim;
   QSNOW_BTXE_dims[2] = bottom_top_dim;
   QSNOW_BTXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QSNOW_BTXE", NC_FLOAT, RANK_QSNOW_BTXE, QSNOW_BTXE_dims, &QSNOW_BTXE_id);
   check_err(stat,__LINE__,__FILE__);

   QSNOW_BTYS_dims[0] = Time_dim;
   QSNOW_BTYS_dims[1] = bdy_width_dim;
   QSNOW_BTYS_dims[2] = bottom_top_dim;
   QSNOW_BTYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QSNOW_BTYS", NC_FLOAT, RANK_QSNOW_BTYS, QSNOW_BTYS_dims, &QSNOW_BTYS_id);
   check_err(stat,__LINE__,__FILE__);

   QSNOW_BTYE_dims[0] = Time_dim;
   QSNOW_BTYE_dims[1] = bdy_width_dim;
   QSNOW_BTYE_dims[2] = bottom_top_dim;
   QSNOW_BTYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QSNOW_BTYE", NC_FLOAT, RANK_QSNOW_BTYE, QSNOW_BTYE_dims, &QSNOW_BTYE_id);
   check_err(stat,__LINE__,__FILE__);

   QGRAUP_BTXS_dims[0] = Time_dim;
   QGRAUP_BTXS_dims[1] = bdy_width_dim;
   QGRAUP_BTXS_dims[2] = bottom_top_dim;
   QGRAUP_BTXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QGRAUP_BTXS", NC_FLOAT, RANK_QGRAUP_BTXS, QGRAUP_BTXS_dims, &QGRAUP_BTXS_id);
   check_err(stat,__LINE__,__FILE__);

   QGRAUP_BTXE_dims[0] = Time_dim;
   QGRAUP_BTXE_dims[1] = bdy_width_dim;
   QGRAUP_BTXE_dims[2] = bottom_top_dim;
   QGRAUP_BTXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QGRAUP_BTXE", NC_FLOAT, RANK_QGRAUP_BTXE, QGRAUP_BTXE_dims, &QGRAUP_BTXE_id);
   check_err(stat,__LINE__,__FILE__);

   QGRAUP_BTYS_dims[0] = Time_dim;
   QGRAUP_BTYS_dims[1] = bdy_width_dim;
   QGRAUP_BTYS_dims[2] = bottom_top_dim;
   QGRAUP_BTYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QGRAUP_BTYS", NC_FLOAT, RANK_QGRAUP_BTYS, QGRAUP_BTYS_dims, &QGRAUP_BTYS_id);
   check_err(stat,__LINE__,__FILE__);

   QGRAUP_BTYE_dims[0] = Time_dim;
   QGRAUP_BTYE_dims[1] = bdy_width_dim;
   QGRAUP_BTYE_dims[2] = bottom_top_dim;
   QGRAUP_BTYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QGRAUP_BTYE", NC_FLOAT, RANK_QGRAUP_BTYE, QGRAUP_BTYE_dims, &QGRAUP_BTYE_id);
   check_err(stat,__LINE__,__FILE__);

   QNICE_BXS_dims[0] = Time_dim;
   QNICE_BXS_dims[1] = bdy_width_dim;
   QNICE_BXS_dims[2] = bottom_top_dim;
   QNICE_BXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QNICE_BXS", NC_FLOAT, RANK_QNICE_BXS, QNICE_BXS_dims, &QNICE_BXS_id);
   check_err(stat,__LINE__,__FILE__);

   QNICE_BXE_dims[0] = Time_dim;
   QNICE_BXE_dims[1] = bdy_width_dim;
   QNICE_BXE_dims[2] = bottom_top_dim;
   QNICE_BXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QNICE_BXE", NC_FLOAT, RANK_QNICE_BXE, QNICE_BXE_dims, &QNICE_BXE_id);
   check_err(stat,__LINE__,__FILE__);

   QNICE_BYS_dims[0] = Time_dim;
   QNICE_BYS_dims[1] = bdy_width_dim;
   QNICE_BYS_dims[2] = bottom_top_dim;
   QNICE_BYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QNICE_BYS", NC_FLOAT, RANK_QNICE_BYS, QNICE_BYS_dims, &QNICE_BYS_id);
   check_err(stat,__LINE__,__FILE__);

   QNICE_BYE_dims[0] = Time_dim;
   QNICE_BYE_dims[1] = bdy_width_dim;
   QNICE_BYE_dims[2] = bottom_top_dim;
   QNICE_BYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QNICE_BYE", NC_FLOAT, RANK_QNICE_BYE, QNICE_BYE_dims, &QNICE_BYE_id);
   check_err(stat,__LINE__,__FILE__);

   QNRAIN_BXS_dims[0] = Time_dim;
   QNRAIN_BXS_dims[1] = bdy_width_dim;
   QNRAIN_BXS_dims[2] = bottom_top_dim;
   QNRAIN_BXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QNRAIN_BXS", NC_FLOAT, RANK_QNRAIN_BXS, QNRAIN_BXS_dims, &QNRAIN_BXS_id);
   check_err(stat,__LINE__,__FILE__);

   QNRAIN_BXE_dims[0] = Time_dim;
   QNRAIN_BXE_dims[1] = bdy_width_dim;
   QNRAIN_BXE_dims[2] = bottom_top_dim;
   QNRAIN_BXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QNRAIN_BXE", NC_FLOAT, RANK_QNRAIN_BXE, QNRAIN_BXE_dims, &QNRAIN_BXE_id);
   check_err(stat,__LINE__,__FILE__);

   QNRAIN_BYS_dims[0] = Time_dim;
   QNRAIN_BYS_dims[1] = bdy_width_dim;
   QNRAIN_BYS_dims[2] = bottom_top_dim;
   QNRAIN_BYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QNRAIN_BYS", NC_FLOAT, RANK_QNRAIN_BYS, QNRAIN_BYS_dims, &QNRAIN_BYS_id);
   check_err(stat,__LINE__,__FILE__);

   QNRAIN_BYE_dims[0] = Time_dim;
   QNRAIN_BYE_dims[1] = bdy_width_dim;
   QNRAIN_BYE_dims[2] = bottom_top_dim;
   QNRAIN_BYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QNRAIN_BYE", NC_FLOAT, RANK_QNRAIN_BYE, QNRAIN_BYE_dims, &QNRAIN_BYE_id);
   check_err(stat,__LINE__,__FILE__);

   QNICE_BTXS_dims[0] = Time_dim;
   QNICE_BTXS_dims[1] = bdy_width_dim;
   QNICE_BTXS_dims[2] = bottom_top_dim;
   QNICE_BTXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QNICE_BTXS", NC_FLOAT, RANK_QNICE_BTXS, QNICE_BTXS_dims, &QNICE_BTXS_id);
   check_err(stat,__LINE__,__FILE__);

   QNICE_BTXE_dims[0] = Time_dim;
   QNICE_BTXE_dims[1] = bdy_width_dim;
   QNICE_BTXE_dims[2] = bottom_top_dim;
   QNICE_BTXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QNICE_BTXE", NC_FLOAT, RANK_QNICE_BTXE, QNICE_BTXE_dims, &QNICE_BTXE_id);
   check_err(stat,__LINE__,__FILE__);

   QNICE_BTYS_dims[0] = Time_dim;
   QNICE_BTYS_dims[1] = bdy_width_dim;
   QNICE_BTYS_dims[2] = bottom_top_dim;
   QNICE_BTYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QNICE_BTYS", NC_FLOAT, RANK_QNICE_BTYS, QNICE_BTYS_dims, &QNICE_BTYS_id);
   check_err(stat,__LINE__,__FILE__);

   QNICE_BTYE_dims[0] = Time_dim;
   QNICE_BTYE_dims[1] = bdy_width_dim;
   QNICE_BTYE_dims[2] = bottom_top_dim;
   QNICE_BTYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QNICE_BTYE", NC_FLOAT, RANK_QNICE_BTYE, QNICE_BTYE_dims, &QNICE_BTYE_id);
   check_err(stat,__LINE__,__FILE__);

   QNRAIN_BTXS_dims[0] = Time_dim;
   QNRAIN_BTXS_dims[1] = bdy_width_dim;
   QNRAIN_BTXS_dims[2] = bottom_top_dim;
   QNRAIN_BTXS_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QNRAIN_BTXS", NC_FLOAT, RANK_QNRAIN_BTXS, QNRAIN_BTXS_dims, &QNRAIN_BTXS_id);
   check_err(stat,__LINE__,__FILE__);

   QNRAIN_BTXE_dims[0] = Time_dim;
   QNRAIN_BTXE_dims[1] = bdy_width_dim;
   QNRAIN_BTXE_dims[2] = bottom_top_dim;
   QNRAIN_BTXE_dims[3] = south_north_dim;
   stat = nc_def_var(ncid, "QNRAIN_BTXE", NC_FLOAT, RANK_QNRAIN_BTXE, QNRAIN_BTXE_dims, &QNRAIN_BTXE_id);
   check_err(stat,__LINE__,__FILE__);

   QNRAIN_BTYS_dims[0] = Time_dim;
   QNRAIN_BTYS_dims[1] = bdy_width_dim;
   QNRAIN_BTYS_dims[2] = bottom_top_dim;
   QNRAIN_BTYS_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QNRAIN_BTYS", NC_FLOAT, RANK_QNRAIN_BTYS, QNRAIN_BTYS_dims, &QNRAIN_BTYS_id);
   check_err(stat,__LINE__,__FILE__);

   QNRAIN_BTYE_dims[0] = Time_dim;
   QNRAIN_BTYE_dims[1] = bdy_width_dim;
   QNRAIN_BTYE_dims[2] = bottom_top_dim;
   QNRAIN_BTYE_dims[3] = west_east_dim;
   stat = nc_def_var(ncid, "QNRAIN_BTYE", NC_FLOAT, RANK_QNRAIN_BTYE, QNRAIN_BTYE_dims, &QNRAIN_BTYE_id);
   check_err(stat,__LINE__,__FILE__);

   HT_SHAD_BXS_dims[0] = Time_dim;
   HT_SHAD_BXS_dims[1] = bdy_width_dim;
   HT_SHAD_BXS_dims[2] = south_north_dim;
   stat = nc_def_var(ncid, "HT_SHAD_BXS", NC_FLOAT, RANK_HT_SHAD_BXS, HT_SHAD_BXS_dims, &HT_SHAD_BXS_id);
   check_err(stat,__LINE__,__FILE__);

   HT_SHAD_BXE_dims[0] = Time_dim;
   HT_SHAD_BXE_dims[1] = bdy_width_dim;
   HT_SHAD_BXE_dims[2] = south_north_dim;
   stat = nc_def_var(ncid, "HT_SHAD_BXE", NC_FLOAT, RANK_HT_SHAD_BXE, HT_SHAD_BXE_dims, &HT_SHAD_BXE_id);
   check_err(stat,__LINE__,__FILE__);

   HT_SHAD_BYS_dims[0] = Time_dim;
   HT_SHAD_BYS_dims[1] = bdy_width_dim;
   HT_SHAD_BYS_dims[2] = west_east_dim;
   stat = nc_def_var(ncid, "HT_SHAD_BYS", NC_FLOAT, RANK_HT_SHAD_BYS, HT_SHAD_BYS_dims, &HT_SHAD_BYS_id);
   check_err(stat,__LINE__,__FILE__);

   HT_SHAD_BYE_dims[0] = Time_dim;
   HT_SHAD_BYE_dims[1] = bdy_width_dim;
   HT_SHAD_BYE_dims[2] = west_east_dim;
   stat = nc_def_var(ncid, "HT_SHAD_BYE", NC_FLOAT, RANK_HT_SHAD_BYE, HT_SHAD_BYE_dims, &HT_SHAD_BYE_id);
   check_err(stat,__LINE__,__FILE__);

   HT_SHAD_BTXS_dims[0] = Time_dim;
   HT_SHAD_BTXS_dims[1] = bdy_width_dim;
   HT_SHAD_BTXS_dims[2] = south_north_dim;
   stat = nc_def_var(ncid, "HT_SHAD_BTXS", NC_FLOAT, RANK_HT_SHAD_BTXS, HT_SHAD_BTXS_dims, &HT_SHAD_BTXS_id);
   check_err(stat,__LINE__,__FILE__);

   HT_SHAD_BTXE_dims[0] = Time_dim;
   HT_SHAD_BTXE_dims[1] = bdy_width_dim;
   HT_SHAD_BTXE_dims[2] = south_north_dim;
   stat = nc_def_var(ncid, "HT_SHAD_BTXE", NC_FLOAT, RANK_HT_SHAD_BTXE, HT_SHAD_BTXE_dims, &HT_SHAD_BTXE_id);
   check_err(stat,__LINE__,__FILE__);

   HT_SHAD_BTYS_dims[0] = Time_dim;
   HT_SHAD_BTYS_dims[1] = bdy_width_dim;
   HT_SHAD_BTYS_dims[2] = west_east_dim;
   stat = nc_def_var(ncid, "HT_SHAD_BTYS", NC_FLOAT, RANK_HT_SHAD_BTYS, HT_SHAD_BTYS_dims, &HT_SHAD_BTYS_id);
   check_err(stat,__LINE__,__FILE__);

   HT_SHAD_BTYE_dims[0] = Time_dim;
   HT_SHAD_BTYE_dims[1] = bdy_width_dim;
   HT_SHAD_BTYE_dims[2] = west_east_dim;
   stat = nc_def_var(ncid, "HT_SHAD_BTYE", NC_FLOAT, RANK_HT_SHAD_BTYE, HT_SHAD_BTYE_dims, &HT_SHAD_BTYE_id);
   check_err(stat,__LINE__,__FILE__);

   PC_BXS_dims[0] = Time_dim;
   PC_BXS_dims[1] = bdy_width_dim;
   PC_BXS_dims[2] = south_north_dim;
   stat = nc_def_var(ncid, "PC_BXS", NC_FLOAT, RANK_PC_BXS, PC_BXS_dims, &PC_BXS_id);
   check_err(stat,__LINE__,__FILE__);

   PC_BXE_dims[0] = Time_dim;
   PC_BXE_dims[1] = bdy_width_dim;
   PC_BXE_dims[2] = south_north_dim;
   stat = nc_def_var(ncid, "PC_BXE", NC_FLOAT, RANK_PC_BXE, PC_BXE_dims, &PC_BXE_id);
   check_err(stat,__LINE__,__FILE__);

   PC_BYS_dims[0] = Time_dim;
   PC_BYS_dims[1] = bdy_width_dim;
   PC_BYS_dims[2] = west_east_dim;
   stat = nc_def_var(ncid, "PC_BYS", NC_FLOAT, RANK_PC_BYS, PC_BYS_dims, &PC_BYS_id);
   check_err(stat,__LINE__,__FILE__);

   PC_BYE_dims[0] = Time_dim;
   PC_BYE_dims[1] = bdy_width_dim;
   PC_BYE_dims[2] = west_east_dim;
   stat = nc_def_var(ncid, "PC_BYE", NC_FLOAT, RANK_PC_BYE, PC_BYE_dims, &PC_BYE_id);
   check_err(stat,__LINE__,__FILE__);

   PC_BTXS_dims[0] = Time_dim;
   PC_BTXS_dims[1] = bdy_width_dim;
   PC_BTXS_dims[2] = south_north_dim;
   stat = nc_def_var(ncid, "PC_BTXS", NC_FLOAT, RANK_PC_BTXS, PC_BTXS_dims, &PC_BTXS_id);
   check_err(stat,__LINE__,__FILE__);

   PC_BTXE_dims[0] = Time_dim;
   PC_BTXE_dims[1] = bdy_width_dim;
   PC_BTXE_dims[2] = south_north_dim;
   stat = nc_def_var(ncid, "PC_BTXE", NC_FLOAT, RANK_PC_BTXE, PC_BTXE_dims, &PC_BTXE_id);
   check_err(stat,__LINE__,__FILE__);

   PC_BTYS_dims[0] = Time_dim;
   PC_BTYS_dims[1] = bdy_width_dim;
   PC_BTYS_dims[2] = west_east_dim;
   stat = nc_def_var(ncid, "PC_BTYS", NC_FLOAT, RANK_PC_BTYS, PC_BTYS_dims, &PC_BTYS_id);
   check_err(stat,__LINE__,__FILE__);

   PC_BTYE_dims[0] = Time_dim;
   PC_BTYE_dims[1] = bdy_width_dim;
   PC_BTYE_dims[2] = west_east_dim;
   stat = nc_def_var(ncid, "PC_BTYE", NC_FLOAT, RANK_PC_BTYE, PC_BTYE_dims, &PC_BTYE_id);
   check_err(stat,__LINE__,__FILE__);

   /* assign global attributes */

   {
      stat = nc_put_att_text(ncid, NC_GLOBAL, "TITLE", 38, " OUTPUT FROM REAL_EM V4.0 PREPROCESSOR");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, NC_GLOBAL, "START_DATE", 19, "2018-01-01_00:00:00");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_WEST_MINUS_EAST_GRID_DIMENSION_att[1] = {74} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "WEST-EAST_GRID_DIMENSION", NC_INT, 1, wrfbdy_d01_WEST_MINUS_EAST_GRID_DIMENSION_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_SOUTH_MINUS_NORTH_GRID_DIMENSION_att[1] = {61} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "SOUTH-NORTH_GRID_DIMENSION", NC_INT, 1, wrfbdy_d01_SOUTH_MINUS_NORTH_GRID_DIMENSION_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_BOTTOM_MINUS_TOP_GRID_DIMENSION_att[1] = {33} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "BOTTOM-TOP_GRID_DIMENSION", NC_INT, 1, wrfbdy_d01_BOTTOM_MINUS_TOP_GRID_DIMENSION_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const float wrfbdy_d01_DX_att[1] = {((float)30000)} ;
      stat = nc_put_att_float(ncid, NC_GLOBAL, "DX", NC_FLOAT, 1, wrfbdy_d01_DX_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const float wrfbdy_d01_DY_att[1] = {((float)30000)} ;
      stat = nc_put_att_float(ncid, NC_GLOBAL, "DY", NC_FLOAT, 1, wrfbdy_d01_DY_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_AERCU_OPT_att[1] = {0} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "AERCU_OPT", NC_INT, 1, wrfbdy_d01_AERCU_OPT_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const float wrfbdy_d01_AERCU_FCT_att[1] = {((float)1)} ;
      stat = nc_put_att_float(ncid, NC_GLOBAL, "AERCU_FCT", NC_FLOAT, 1, wrfbdy_d01_AERCU_FCT_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_IDEAL_CASE_att[1] = {0} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "IDEAL_CASE", NC_INT, 1, wrfbdy_d01_IDEAL_CASE_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_DIFF_6TH_SLOPEOPT_att[1] = {0} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "DIFF_6TH_SLOPEOPT", NC_INT, 1, wrfbdy_d01_DIFF_6TH_SLOPEOPT_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_AUTO_LEVELS_OPT_att[1] = {2} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "AUTO_LEVELS_OPT", NC_INT, 1, wrfbdy_d01_AUTO_LEVELS_OPT_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const float wrfbdy_d01_DIFF_6TH_THRESH_att[1] = {((float)0.1)} ;
      stat = nc_put_att_float(ncid, NC_GLOBAL, "DIFF_6TH_THRESH", NC_FLOAT, 1, wrfbdy_d01_DIFF_6TH_THRESH_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const float wrfbdy_d01_DZBOT_att[1] = {((float)50)} ;
      stat = nc_put_att_float(ncid, NC_GLOBAL, "DZBOT", NC_FLOAT, 1, wrfbdy_d01_DZBOT_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const float wrfbdy_d01_DZSTRETCH_S_att[1] = {((float)1.3)} ;
      stat = nc_put_att_float(ncid, NC_GLOBAL, "DZSTRETCH_S", NC_FLOAT, 1, wrfbdy_d01_DZSTRETCH_S_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const float wrfbdy_d01_DZSTRETCH_U_att[1] = {((float)1.1)} ;
      stat = nc_put_att_float(ncid, NC_GLOBAL, "DZSTRETCH_U", NC_FLOAT, 1, wrfbdy_d01_DZSTRETCH_U_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, NC_GLOBAL, "GRIDTYPE", 1, "C");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_DIFF_OPT_att[1] = {1} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "DIFF_OPT", NC_INT, 1, wrfbdy_d01_DIFF_OPT_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_KM_OPT_att[1] = {4} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "KM_OPT", NC_INT, 1, wrfbdy_d01_KM_OPT_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_DAMP_OPT_att[1] = {3} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "DAMP_OPT", NC_INT, 1, wrfbdy_d01_DAMP_OPT_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const float wrfbdy_d01_DAMPCOEF_att[1] = {((float)0.2)} ;
      stat = nc_put_att_float(ncid, NC_GLOBAL, "DAMPCOEF", NC_FLOAT, 1, wrfbdy_d01_DAMPCOEF_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const float wrfbdy_d01_KHDIF_att[1] = {((float)0)} ;
      stat = nc_put_att_float(ncid, NC_GLOBAL, "KHDIF", NC_FLOAT, 1, wrfbdy_d01_KHDIF_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const float wrfbdy_d01_KVDIF_att[1] = {((float)0)} ;
      stat = nc_put_att_float(ncid, NC_GLOBAL, "KVDIF", NC_FLOAT, 1, wrfbdy_d01_KVDIF_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_MP_PHYSICS_att[1] = {8} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "MP_PHYSICS", NC_INT, 1, wrfbdy_d01_MP_PHYSICS_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_RA_LW_PHYSICS_att[1] = {4} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "RA_LW_PHYSICS", NC_INT, 1, wrfbdy_d01_RA_LW_PHYSICS_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_RA_SW_PHYSICS_att[1] = {4} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "RA_SW_PHYSICS", NC_INT, 1, wrfbdy_d01_RA_SW_PHYSICS_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_SF_SFCLAY_PHYSICS_att[1] = {2} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "SF_SFCLAY_PHYSICS", NC_INT, 1, wrfbdy_d01_SF_SFCLAY_PHYSICS_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_SF_SURFACE_PHYSICS_att[1] = {2} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "SF_SURFACE_PHYSICS", NC_INT, 1, wrfbdy_d01_SF_SURFACE_PHYSICS_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_BL_PBL_PHYSICS_att[1] = {2} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "BL_PBL_PHYSICS", NC_INT, 1, wrfbdy_d01_BL_PBL_PHYSICS_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_CU_PHYSICS_att[1] = {6} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "CU_PHYSICS", NC_INT, 1, wrfbdy_d01_CU_PHYSICS_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_SF_LAKE_PHYSICS_att[1] = {0} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "SF_LAKE_PHYSICS", NC_INT, 1, wrfbdy_d01_SF_LAKE_PHYSICS_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_SURFACE_INPUT_SOURCE_att[1] = {3} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "SURFACE_INPUT_SOURCE", NC_INT, 1, wrfbdy_d01_SURFACE_INPUT_SOURCE_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_SST_UPDATE_att[1] = {0} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "SST_UPDATE", NC_INT, 1, wrfbdy_d01_SST_UPDATE_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_GRID_FDDA_att[1] = {0} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "GRID_FDDA", NC_INT, 1, wrfbdy_d01_GRID_FDDA_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_GFDDA_INTERVAL_M_att[1] = {0} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "GFDDA_INTERVAL_M", NC_INT, 1, wrfbdy_d01_GFDDA_INTERVAL_M_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_GFDDA_END_H_att[1] = {0} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "GFDDA_END_H", NC_INT, 1, wrfbdy_d01_GFDDA_END_H_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_GRID_SFDDA_att[1] = {0} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "GRID_SFDDA", NC_INT, 1, wrfbdy_d01_GRID_SFDDA_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_SGFDDA_INTERVAL_M_att[1] = {0} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "SGFDDA_INTERVAL_M", NC_INT, 1, wrfbdy_d01_SGFDDA_INTERVAL_M_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_SGFDDA_END_H_att[1] = {0} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "SGFDDA_END_H", NC_INT, 1, wrfbdy_d01_SGFDDA_END_H_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_HYPSOMETRIC_OPT_att[1] = {2} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "HYPSOMETRIC_OPT", NC_INT, 1, wrfbdy_d01_HYPSOMETRIC_OPT_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_USE_THETA_M_att[1] = {1} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "USE_THETA_M", NC_INT, 1, wrfbdy_d01_USE_THETA_M_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_GWD_OPT_att[1] = {1} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "GWD_OPT", NC_INT, 1, wrfbdy_d01_GWD_OPT_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_SF_URBAN_PHYSICS_att[1] = {0} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "SF_URBAN_PHYSICS", NC_INT, 1, wrfbdy_d01_SF_URBAN_PHYSICS_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_SF_SURFACE_MOSAIC_att[1] = {0} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "SF_SURFACE_MOSAIC", NC_INT, 1, wrfbdy_d01_SF_SURFACE_MOSAIC_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_SF_OCEAN_PHYSICS_att[1] = {0} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "SF_OCEAN_PHYSICS", NC_INT, 1, wrfbdy_d01_SF_OCEAN_PHYSICS_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_WEST_MINUS_EAST_PATCH_START_UNSTAG_att[1] = {1} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "WEST-EAST_PATCH_START_UNSTAG", NC_INT, 1, wrfbdy_d01_WEST_MINUS_EAST_PATCH_START_UNSTAG_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_WEST_MINUS_EAST_PATCH_END_UNSTAG_att[1] = {73} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "WEST-EAST_PATCH_END_UNSTAG", NC_INT, 1, wrfbdy_d01_WEST_MINUS_EAST_PATCH_END_UNSTAG_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_WEST_MINUS_EAST_PATCH_START_STAG_att[1] = {1} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "WEST-EAST_PATCH_START_STAG", NC_INT, 1, wrfbdy_d01_WEST_MINUS_EAST_PATCH_START_STAG_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_WEST_MINUS_EAST_PATCH_END_STAG_att[1] = {74} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "WEST-EAST_PATCH_END_STAG", NC_INT, 1, wrfbdy_d01_WEST_MINUS_EAST_PATCH_END_STAG_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_SOUTH_MINUS_NORTH_PATCH_START_UNSTAG_att[1] = {1} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "SOUTH-NORTH_PATCH_START_UNSTAG", NC_INT, 1, wrfbdy_d01_SOUTH_MINUS_NORTH_PATCH_START_UNSTAG_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_SOUTH_MINUS_NORTH_PATCH_END_UNSTAG_att[1] = {60} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "SOUTH-NORTH_PATCH_END_UNSTAG", NC_INT, 1, wrfbdy_d01_SOUTH_MINUS_NORTH_PATCH_END_UNSTAG_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_SOUTH_MINUS_NORTH_PATCH_START_STAG_att[1] = {1} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "SOUTH-NORTH_PATCH_START_STAG", NC_INT, 1, wrfbdy_d01_SOUTH_MINUS_NORTH_PATCH_START_STAG_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_SOUTH_MINUS_NORTH_PATCH_END_STAG_att[1] = {61} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "SOUTH-NORTH_PATCH_END_STAG", NC_INT, 1, wrfbdy_d01_SOUTH_MINUS_NORTH_PATCH_END_STAG_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_BOTTOM_MINUS_TOP_PATCH_START_UNSTAG_att[1] = {1} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "BOTTOM-TOP_PATCH_START_UNSTAG", NC_INT, 1, wrfbdy_d01_BOTTOM_MINUS_TOP_PATCH_START_UNSTAG_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_BOTTOM_MINUS_TOP_PATCH_END_UNSTAG_att[1] = {32} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "BOTTOM-TOP_PATCH_END_UNSTAG", NC_INT, 1, wrfbdy_d01_BOTTOM_MINUS_TOP_PATCH_END_UNSTAG_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_BOTTOM_MINUS_TOP_PATCH_START_STAG_att[1] = {1} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "BOTTOM-TOP_PATCH_START_STAG", NC_INT, 1, wrfbdy_d01_BOTTOM_MINUS_TOP_PATCH_START_STAG_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_BOTTOM_MINUS_TOP_PATCH_END_STAG_att[1] = {33} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "BOTTOM-TOP_PATCH_END_STAG", NC_INT, 1, wrfbdy_d01_BOTTOM_MINUS_TOP_PATCH_END_STAG_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_GRID_ID_att[1] = {1} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "GRID_ID", NC_INT, 1, wrfbdy_d01_GRID_ID_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_PARENT_ID_att[1] = {0} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "PARENT_ID", NC_INT, 1, wrfbdy_d01_PARENT_ID_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_I_PARENT_START_att[1] = {1} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "I_PARENT_START", NC_INT, 1, wrfbdy_d01_I_PARENT_START_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_J_PARENT_START_att[1] = {1} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "J_PARENT_START", NC_INT, 1, wrfbdy_d01_J_PARENT_START_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_PARENT_GRID_RATIO_att[1] = {1} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "PARENT_GRID_RATIO", NC_INT, 1, wrfbdy_d01_PARENT_GRID_RATIO_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const float wrfbdy_d01_DT_att[1] = {((float)180)} ;
      stat = nc_put_att_float(ncid, NC_GLOBAL, "DT", NC_FLOAT, 1, wrfbdy_d01_DT_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const float wrfbdy_d01_CEN_LAT_att[1] = {((float)34.830021)} ;
      stat = nc_put_att_float(ncid, NC_GLOBAL, "CEN_LAT", NC_FLOAT, 1, wrfbdy_d01_CEN_LAT_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const float wrfbdy_d01_CEN_LON_att[1] = {((float)-81.029999)} ;
      stat = nc_put_att_float(ncid, NC_GLOBAL, "CEN_LON", NC_FLOAT, 1, wrfbdy_d01_CEN_LON_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const float wrfbdy_d01_TRUELAT1_att[1] = {((float)30)} ;
      stat = nc_put_att_float(ncid, NC_GLOBAL, "TRUELAT1", NC_FLOAT, 1, wrfbdy_d01_TRUELAT1_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const float wrfbdy_d01_TRUELAT2_att[1] = {((float)60)} ;
      stat = nc_put_att_float(ncid, NC_GLOBAL, "TRUELAT2", NC_FLOAT, 1, wrfbdy_d01_TRUELAT2_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const float wrfbdy_d01_MOAD_CEN_LAT_att[1] = {((float)34.830021)} ;
      stat = nc_put_att_float(ncid, NC_GLOBAL, "MOAD_CEN_LAT", NC_FLOAT, 1, wrfbdy_d01_MOAD_CEN_LAT_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const float wrfbdy_d01_STAND_LON_att[1] = {((float)-98)} ;
      stat = nc_put_att_float(ncid, NC_GLOBAL, "STAND_LON", NC_FLOAT, 1, wrfbdy_d01_STAND_LON_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const float wrfbdy_d01_POLE_LAT_att[1] = {((float)90)} ;
      stat = nc_put_att_float(ncid, NC_GLOBAL, "POLE_LAT", NC_FLOAT, 1, wrfbdy_d01_POLE_LAT_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const float wrfbdy_d01_POLE_LON_att[1] = {((float)0)} ;
      stat = nc_put_att_float(ncid, NC_GLOBAL, "POLE_LON", NC_FLOAT, 1, wrfbdy_d01_POLE_LON_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_MAP_PROJ_att[1] = {1} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "MAP_PROJ", NC_INT, 1, wrfbdy_d01_MAP_PROJ_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, NC_GLOBAL, "MAP_PROJ_CHAR", 17, "Lambert Conformal");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, NC_GLOBAL, "MMINLU", 24, "MODIFIED_IGBP_MODIS_NOAH");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_NUM_LAND_CAT_att[1] = {21} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "NUM_LAND_CAT", NC_INT, 1, wrfbdy_d01_NUM_LAND_CAT_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_ISWATER_att[1] = {17} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "ISWATER", NC_INT, 1, wrfbdy_d01_ISWATER_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_ISLAKE_att[1] = {21} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "ISLAKE", NC_INT, 1, wrfbdy_d01_ISLAKE_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_ISICE_att[1] = {15} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "ISICE", NC_INT, 1, wrfbdy_d01_ISICE_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_ISURBAN_att[1] = {13} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "ISURBAN", NC_INT, 1, wrfbdy_d01_ISURBAN_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_ISOILWATER_att[1] = {14} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "ISOILWATER", NC_INT, 1, wrfbdy_d01_ISOILWATER_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_HYBRID_OPT_att[1] = {2} ;
      stat = nc_put_att_int(ncid, NC_GLOBAL, "HYBRID_OPT", NC_INT, 1, wrfbdy_d01_HYBRID_OPT_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const float wrfbdy_d01_ETAC_att[1] = {((float)0.2)} ;
      stat = nc_put_att_float(ncid, NC_GLOBAL, "ETAC", NC_FLOAT, 1, wrfbdy_d01_ETAC_att);
      check_err(stat,__LINE__,__FILE__);
   }


   /* assign per-variable attributes */

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, U_BXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BXS_id, "description", 20, "bdy x-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BXS_id, "units", 5, "m s-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BXS_id, "stagger", 1, "X");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, U_BXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BXE_id, "description", 20, "bdy x-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BXE_id, "units", 5, "m s-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BXE_id, "stagger", 1, "X");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, U_BYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BYS_id, "description", 20, "bdy x-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BYS_id, "units", 5, "m s-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BYS_id, "stagger", 1, "X");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, U_BYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BYE_id, "description", 20, "bdy x-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BYE_id, "units", 5, "m s-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BYE_id, "stagger", 1, "X");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, U_BTXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BTXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BTXS_id, "description", 25, "bdy tend x-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BTXS_id, "units", 10, "(m s-1)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BTXS_id, "stagger", 1, "X");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, U_BTXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BTXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BTXE_id, "description", 25, "bdy tend x-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BTXE_id, "units", 10, "(m s-1)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BTXE_id, "stagger", 1, "X");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, U_BTYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BTYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BTYS_id, "description", 25, "bdy tend x-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BTYS_id, "units", 10, "(m s-1)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BTYS_id, "stagger", 1, "X");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, U_BTYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BTYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BTYE_id, "description", 25, "bdy tend x-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BTYE_id, "units", 10, "(m s-1)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, U_BTYE_id, "stagger", 1, "X");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, V_BXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BXS_id, "description", 20, "bdy y-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BXS_id, "units", 5, "m s-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BXS_id, "stagger", 1, "Y");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, V_BXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BXE_id, "description", 20, "bdy y-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BXE_id, "units", 5, "m s-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BXE_id, "stagger", 1, "Y");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, V_BYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BYS_id, "description", 20, "bdy y-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BYS_id, "units", 5, "m s-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BYS_id, "stagger", 1, "Y");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, V_BYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BYE_id, "description", 20, "bdy y-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BYE_id, "units", 5, "m s-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BYE_id, "stagger", 1, "Y");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, V_BTXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BTXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BTXS_id, "description", 25, "bdy tend y-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BTXS_id, "units", 10, "(m s-1)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BTXS_id, "stagger", 1, "Y");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, V_BTXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BTXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BTXE_id, "description", 25, "bdy tend y-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BTXE_id, "units", 10, "(m s-1)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BTXE_id, "stagger", 1, "Y");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, V_BTYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BTYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BTYS_id, "description", 25, "bdy tend y-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BTYS_id, "units", 10, "(m s-1)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BTYS_id, "stagger", 1, "Y");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, V_BTYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BTYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BTYE_id, "description", 25, "bdy tend y-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BTYE_id, "units", 10, "(m s-1)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, V_BTYE_id, "stagger", 1, "Y");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, W_BXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BXS_id, "description", 20, "bdy z-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BXS_id, "units", 5, "m s-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BXS_id, "stagger", 1, "Z");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, W_BXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BXE_id, "description", 20, "bdy z-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BXE_id, "units", 5, "m s-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BXE_id, "stagger", 1, "Z");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, W_BYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BYS_id, "description", 20, "bdy z-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BYS_id, "units", 5, "m s-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BYS_id, "stagger", 1, "Z");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, W_BYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BYE_id, "description", 20, "bdy z-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BYE_id, "units", 5, "m s-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BYE_id, "stagger", 1, "Z");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, W_BTXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BTXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BTXS_id, "description", 25, "bdy tend z-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BTXS_id, "units", 10, "(m s-1)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BTXS_id, "stagger", 1, "Z");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, W_BTXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BTXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BTXE_id, "description", 25, "bdy tend z-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BTXE_id, "units", 10, "(m s-1)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BTXE_id, "stagger", 1, "Z");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, W_BTYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BTYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BTYS_id, "description", 25, "bdy tend z-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BTYS_id, "units", 10, "(m s-1)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BTYS_id, "stagger", 1, "Z");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, W_BTYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BTYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BTYE_id, "description", 25, "bdy tend z-wind component");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BTYE_id, "units", 10, "(m s-1)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, W_BTYE_id, "stagger", 1, "Z");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, PH_BXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BXS_id, "description", 29, "bdy perturbation geopotential");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BXS_id, "units", 6, "m2 s-2");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BXS_id, "stagger", 1, "Z");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, PH_BXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BXE_id, "description", 29, "bdy perturbation geopotential");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BXE_id, "units", 6, "m2 s-2");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BXE_id, "stagger", 1, "Z");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, PH_BYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BYS_id, "description", 29, "bdy perturbation geopotential");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BYS_id, "units", 6, "m2 s-2");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BYS_id, "stagger", 1, "Z");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, PH_BYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BYE_id, "description", 29, "bdy perturbation geopotential");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BYE_id, "units", 6, "m2 s-2");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BYE_id, "stagger", 1, "Z");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, PH_BTXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BTXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BTXS_id, "description", 34, "bdy tend perturbation geopotential");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BTXS_id, "units", 11, "(m2 s-2)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BTXS_id, "stagger", 1, "Z");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, PH_BTXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BTXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BTXE_id, "description", 34, "bdy tend perturbation geopotential");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BTXE_id, "units", 11, "(m2 s-2)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BTXE_id, "stagger", 1, "Z");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, PH_BTYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BTYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BTYS_id, "description", 34, "bdy tend perturbation geopotential");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BTYS_id, "units", 11, "(m2 s-2)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BTYS_id, "stagger", 1, "Z");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, PH_BTYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BTYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BTYE_id, "description", 34, "bdy tend perturbation geopotential");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BTYE_id, "units", 11, "(m2 s-2)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PH_BTYE_id, "stagger", 1, "Z");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, T_BXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BXS_id, "description", 121, "bdy either 1) pert moist pot temp=(1+Rv/Rd Qv)*(theta)-T0, or 2) pert dry pot temp=theta-T0; based on use_theta_m setting");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BXS_id, "units", 1, "K");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, T_BXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BXE_id, "description", 121, "bdy either 1) pert moist pot temp=(1+Rv/Rd Qv)*(theta)-T0, or 2) pert dry pot temp=theta-T0; based on use_theta_m setting");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BXE_id, "units", 1, "K");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, T_BYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BYS_id, "description", 121, "bdy either 1) pert moist pot temp=(1+Rv/Rd Qv)*(theta)-T0, or 2) pert dry pot temp=theta-T0; based on use_theta_m setting");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BYS_id, "units", 1, "K");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, T_BYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BYE_id, "description", 121, "bdy either 1) pert moist pot temp=(1+Rv/Rd Qv)*(theta)-T0, or 2) pert dry pot temp=theta-T0; based on use_theta_m setting");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BYE_id, "units", 1, "K");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, T_BTXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BTXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BTXS_id, "description", 126, "bdy tend either 1) pert moist pot temp=(1+Rv/Rd Qv)*(theta)-T0, or 2) pert dry pot temp=theta-T0; based on use_theta_m setting");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BTXS_id, "units", 6, "(K)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BTXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, T_BTXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BTXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BTXE_id, "description", 126, "bdy tend either 1) pert moist pot temp=(1+Rv/Rd Qv)*(theta)-T0, or 2) pert dry pot temp=theta-T0; based on use_theta_m setting");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BTXE_id, "units", 6, "(K)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BTXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, T_BTYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BTYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BTYS_id, "description", 126, "bdy tend either 1) pert moist pot temp=(1+Rv/Rd Qv)*(theta)-T0, or 2) pert dry pot temp=theta-T0; based on use_theta_m setting");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BTYS_id, "units", 6, "(K)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BTYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, T_BTYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BTYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BTYE_id, "description", 126, "bdy tend either 1) pert moist pot temp=(1+Rv/Rd Qv)*(theta)-T0, or 2) pert dry pot temp=theta-T0; based on use_theta_m setting");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BTYE_id, "units", 6, "(K)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, T_BTYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, MU_BXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BXS_id, "MemoryOrder", 3, "XS ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BXS_id, "description", 39, "bdy perturbation dry air mass in column");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BXS_id, "units", 2, "Pa");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, MU_BXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BXE_id, "MemoryOrder", 3, "XE ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BXE_id, "description", 39, "bdy perturbation dry air mass in column");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BXE_id, "units", 2, "Pa");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, MU_BYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BYS_id, "MemoryOrder", 3, "YS ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BYS_id, "description", 39, "bdy perturbation dry air mass in column");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BYS_id, "units", 2, "Pa");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, MU_BYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BYE_id, "MemoryOrder", 3, "YE ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BYE_id, "description", 39, "bdy perturbation dry air mass in column");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BYE_id, "units", 2, "Pa");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, MU_BTXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BTXS_id, "MemoryOrder", 3, "XS ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BTXS_id, "description", 44, "bdy tend perturbation dry air mass in column");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BTXS_id, "units", 7, "(Pa)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BTXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, MU_BTXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BTXE_id, "MemoryOrder", 3, "XE ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BTXE_id, "description", 44, "bdy tend perturbation dry air mass in column");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BTXE_id, "units", 7, "(Pa)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BTXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, MU_BTYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BTYS_id, "MemoryOrder", 3, "YS ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BTYS_id, "description", 44, "bdy tend perturbation dry air mass in column");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BTYS_id, "units", 7, "(Pa)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BTYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, MU_BTYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BTYE_id, "MemoryOrder", 3, "YE ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BTYE_id, "description", 44, "bdy tend perturbation dry air mass in column");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BTYE_id, "units", 7, "(Pa)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, MU_BTYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QVAPOR_BXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BXS_id, "description", 24, "Water vapor mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BXS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QVAPOR_BXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BXE_id, "description", 24, "Water vapor mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BXE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QVAPOR_BYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BYS_id, "description", 24, "Water vapor mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BYS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QVAPOR_BYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BYE_id, "description", 24, "Water vapor mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BYE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QCLOUD_BXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BXS_id, "description", 24, "Cloud water mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BXS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QCLOUD_BXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BXE_id, "description", 24, "Cloud water mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BXE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QCLOUD_BYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BYS_id, "description", 24, "Cloud water mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BYS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QCLOUD_BYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BYE_id, "description", 24, "Cloud water mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BYE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QRAIN_BXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BXS_id, "description", 23, "Rain water mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BXS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QRAIN_BXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BXE_id, "description", 23, "Rain water mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BXE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QRAIN_BYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BYS_id, "description", 23, "Rain water mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BYS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QRAIN_BYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BYE_id, "description", 23, "Rain water mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BYE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QICE_BXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BXS_id, "description", 16, "Ice mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BXS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QICE_BXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BXE_id, "description", 16, "Ice mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BXE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QICE_BYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BYS_id, "description", 16, "Ice mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BYS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QICE_BYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BYE_id, "description", 16, "Ice mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BYE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QSNOW_BXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BXS_id, "description", 17, "Snow mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BXS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QSNOW_BXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BXE_id, "description", 17, "Snow mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BXE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QSNOW_BYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BYS_id, "description", 17, "Snow mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BYS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QSNOW_BYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BYE_id, "description", 17, "Snow mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BYE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QGRAUP_BXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BXS_id, "description", 20, "Graupel mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BXS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QGRAUP_BXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BXE_id, "description", 20, "Graupel mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BXE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QGRAUP_BYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BYS_id, "description", 20, "Graupel mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BYS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QGRAUP_BYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BYE_id, "description", 20, "Graupel mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BYE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QVAPOR_BTXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BTXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BTXS_id, "description", 24, "Water vapor mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BTXS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BTXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QVAPOR_BTXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BTXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BTXE_id, "description", 24, "Water vapor mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BTXE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BTXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QVAPOR_BTYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BTYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BTYS_id, "description", 24, "Water vapor mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BTYS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BTYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QVAPOR_BTYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BTYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BTYE_id, "description", 24, "Water vapor mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BTYE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QVAPOR_BTYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QCLOUD_BTXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BTXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BTXS_id, "description", 24, "Cloud water mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BTXS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BTXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QCLOUD_BTXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BTXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BTXE_id, "description", 24, "Cloud water mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BTXE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BTXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QCLOUD_BTYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BTYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BTYS_id, "description", 24, "Cloud water mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BTYS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BTYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QCLOUD_BTYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BTYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BTYE_id, "description", 24, "Cloud water mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BTYE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QCLOUD_BTYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QRAIN_BTXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BTXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BTXS_id, "description", 23, "Rain water mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BTXS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BTXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QRAIN_BTXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BTXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BTXE_id, "description", 23, "Rain water mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BTXE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BTXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QRAIN_BTYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BTYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BTYS_id, "description", 23, "Rain water mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BTYS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BTYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QRAIN_BTYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BTYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BTYE_id, "description", 23, "Rain water mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BTYE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QRAIN_BTYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QICE_BTXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BTXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BTXS_id, "description", 16, "Ice mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BTXS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BTXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QICE_BTXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BTXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BTXE_id, "description", 16, "Ice mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BTXE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BTXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QICE_BTYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BTYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BTYS_id, "description", 16, "Ice mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BTYS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BTYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QICE_BTYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BTYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BTYE_id, "description", 16, "Ice mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BTYE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QICE_BTYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QSNOW_BTXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BTXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BTXS_id, "description", 17, "Snow mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BTXS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BTXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QSNOW_BTXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BTXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BTXE_id, "description", 17, "Snow mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BTXE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BTXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QSNOW_BTYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BTYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BTYS_id, "description", 17, "Snow mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BTYS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BTYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QSNOW_BTYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BTYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BTYE_id, "description", 17, "Snow mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BTYE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QSNOW_BTYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QGRAUP_BTXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BTXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BTXS_id, "description", 20, "Graupel mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BTXS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BTXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QGRAUP_BTXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BTXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BTXE_id, "description", 20, "Graupel mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BTXE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BTXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QGRAUP_BTYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BTYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BTYS_id, "description", 20, "Graupel mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BTYS_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BTYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QGRAUP_BTYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BTYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BTYE_id, "description", 20, "Graupel mixing ratio");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BTYE_id, "units", 7, "kg kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QGRAUP_BTYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QNICE_BXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BXS_id, "description", 24, "Ice Number concentration");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BXS_id, "units", 6, "  kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QNICE_BXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BXE_id, "description", 24, "Ice Number concentration");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BXE_id, "units", 6, "  kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QNICE_BYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BYS_id, "description", 24, "Ice Number concentration");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BYS_id, "units", 6, "  kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QNICE_BYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BYE_id, "description", 24, "Ice Number concentration");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BYE_id, "units", 6, "  kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QNRAIN_BXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BXS_id, "description", 25, "Rain Number concentration");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BXS_id, "units", 8, "  kg(-1)");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QNRAIN_BXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BXE_id, "description", 25, "Rain Number concentration");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BXE_id, "units", 8, "  kg(-1)");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QNRAIN_BYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BYS_id, "description", 25, "Rain Number concentration");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BYS_id, "units", 8, "  kg(-1)");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QNRAIN_BYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BYE_id, "description", 25, "Rain Number concentration");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BYE_id, "units", 8, "  kg(-1)");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QNICE_BTXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BTXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BTXS_id, "description", 24, "Ice Number concentration");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BTXS_id, "units", 6, "  kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BTXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QNICE_BTXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BTXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BTXE_id, "description", 24, "Ice Number concentration");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BTXE_id, "units", 6, "  kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BTXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QNICE_BTYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BTYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BTYS_id, "description", 24, "Ice Number concentration");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BTYS_id, "units", 6, "  kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BTYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QNICE_BTYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BTYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BTYE_id, "description", 24, "Ice Number concentration");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BTYE_id, "units", 6, "  kg-1");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNICE_BTYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QNRAIN_BTXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BTXS_id, "MemoryOrder", 3, "XSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BTXS_id, "description", 25, "Rain Number concentration");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BTXS_id, "units", 8, "  kg(-1)");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BTXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QNRAIN_BTXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BTXE_id, "MemoryOrder", 3, "XEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BTXE_id, "description", 25, "Rain Number concentration");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BTXE_id, "units", 8, "  kg(-1)");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BTXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QNRAIN_BTYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BTYS_id, "MemoryOrder", 3, "YSZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BTYS_id, "description", 25, "Rain Number concentration");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BTYS_id, "units", 8, "  kg(-1)");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BTYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, QNRAIN_BTYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BTYE_id, "MemoryOrder", 3, "YEZ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BTYE_id, "description", 25, "Rain Number concentration");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BTYE_id, "units", 8, "  kg(-1)");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, QNRAIN_BTYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, HT_SHAD_BXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BXS_id, "MemoryOrder", 3, "XS ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BXS_id, "description", 31, "bdy Height of orographic shadow");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BXS_id, "units", 1, "m");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, HT_SHAD_BXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BXE_id, "MemoryOrder", 3, "XE ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BXE_id, "description", 31, "bdy Height of orographic shadow");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BXE_id, "units", 1, "m");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, HT_SHAD_BYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BYS_id, "MemoryOrder", 3, "YS ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BYS_id, "description", 31, "bdy Height of orographic shadow");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BYS_id, "units", 1, "m");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, HT_SHAD_BYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BYE_id, "MemoryOrder", 3, "YE ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BYE_id, "description", 31, "bdy Height of orographic shadow");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BYE_id, "units", 1, "m");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, HT_SHAD_BTXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BTXS_id, "MemoryOrder", 3, "XS ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BTXS_id, "description", 36, "bdy tend Height of orographic shadow");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BTXS_id, "units", 6, "(m)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BTXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, HT_SHAD_BTXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BTXE_id, "MemoryOrder", 3, "XE ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BTXE_id, "description", 36, "bdy tend Height of orographic shadow");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BTXE_id, "units", 6, "(m)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BTXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, HT_SHAD_BTYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BTYS_id, "MemoryOrder", 3, "YS ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BTYS_id, "description", 36, "bdy tend Height of orographic shadow");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BTYS_id, "units", 6, "(m)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BTYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, HT_SHAD_BTYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BTYE_id, "MemoryOrder", 3, "YE ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BTYE_id, "description", 36, "bdy tend Height of orographic shadow");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BTYE_id, "units", 6, "(m)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, HT_SHAD_BTYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, PC_BXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BXS_id, "MemoryOrder", 3, "XS ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BXS_id, "description", 39, "bdy perturbation dry air mass in column");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BXS_id, "units", 2, "Pa");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, PC_BXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BXE_id, "MemoryOrder", 3, "XE ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BXE_id, "description", 39, "bdy perturbation dry air mass in column");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BXE_id, "units", 2, "Pa");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, PC_BYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BYS_id, "MemoryOrder", 3, "YS ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BYS_id, "description", 39, "bdy perturbation dry air mass in column");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BYS_id, "units", 2, "Pa");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, PC_BYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BYE_id, "MemoryOrder", 3, "YE ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BYE_id, "description", 39, "bdy perturbation dry air mass in column");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BYE_id, "units", 2, "Pa");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, PC_BTXS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BTXS_id, "MemoryOrder", 3, "XS ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BTXS_id, "description", 44, "bdy tend perturbation dry air mass in column");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BTXS_id, "units", 7, "(Pa)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BTXS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, PC_BTXE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BTXE_id, "MemoryOrder", 3, "XE ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BTXE_id, "description", 44, "bdy tend perturbation dry air mass in column");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BTXE_id, "units", 7, "(Pa)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BTXE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, PC_BTYS_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BTYS_id, "MemoryOrder", 3, "YS ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BTYS_id, "description", 44, "bdy tend perturbation dry air mass in column");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BTYS_id, "units", 7, "(Pa)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BTYS_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      static const int wrfbdy_d01_FieldType_att[1] = {104} ;
      stat = nc_put_att_int(ncid, PC_BTYE_id, "FieldType", NC_INT, 1, wrfbdy_d01_FieldType_att);
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BTYE_id, "MemoryOrder", 3, "YE ");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BTYE_id, "description", 44, "bdy tend perturbation dry air mass in column");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BTYE_id, "units", 7, "(Pa)/dt");
      check_err(stat,__LINE__,__FILE__);
   }

   {
      stat = nc_put_att_text(ncid, PC_BTYE_id, "stagger", 1, "");
      check_err(stat,__LINE__,__FILE__);
   }


   /* leave define mode */
   stat = nc_enddef (ncid);
   check_err(stat,__LINE__,__FILE__);

   /* assign variable data */

   stat = nc_close(ncid);
   check_err(stat,__LINE__,__FILE__);

   return 0;
}

/* static size_t BASEFLOW_chunksizes[3] = {1, 91, 144} ; */
/* static size_t ECHANGE_chunksizes[3] = {1, 91, 144} ; */
/* static size_t EVLAND_chunksizes[3] = {1, 91, 144} ; */
/* static size_t EVPINTR_chunksizes[3] = {1, 91, 144} ; */
/* static size_t EVPSBLN_chunksizes[3] = {1, 91, 144} ; */
/* static size_t EVPSOIL_chunksizes[3] = {1, 91, 144} ; */
/* static size_t EVPTRNS_chunksizes[3] = {1, 91, 144} ; */
/* static size_t FRSAT_chunksizes[3] = {1, 91, 144} ; */
/* static size_t FRSNO_chunksizes[3] = {1, 91, 144} ; */
/* static size_t FRUNST_chunksizes[3] = {1, 91, 144} ; */
/* static size_t FRWLT_chunksizes[3] = {1, 91, 144} ; */
/* static size_t GHLAND_chunksizes[3] = {1, 91, 144} ; */
/* static size_t GRN_chunksizes[3] = {1, 91, 144} ; */
/* static size_t GWETPROF_chunksizes[3] = {1, 91, 144} ; */
/* static size_t GWETROOT_chunksizes[3] = {1, 91, 144} ; */
/* static size_t GWETTOP_chunksizes[3] = {1, 91, 144} ; */
/* static size_t LAI_chunksizes[3] = {1, 91, 144} ; */
/* static size_t LHLAND_chunksizes[3] = {1, 91, 144} ; */
/* static size_t LWLAND_chunksizes[3] = {1, 91, 144} ; */
/* static size_t PARDFLAND_chunksizes[3] = {1, 91, 144} ; */
/* static size_t PARDRLAND_chunksizes[3] = {1, 91, 144} ; */
/* static size_t PRECSNOLAND_chunksizes[3] = {1, 91, 144} ; */
/* static size_t PRECTOTLAND_chunksizes[3] = {1, 91, 144} ; */
/* static size_t PRMC_chunksizes[3] = {1, 91, 144} ; */
/* static size_t QINFIL_chunksizes[3] = {1, 91, 144} ; */
/* static size_t RUNOFF_chunksizes[3] = {1, 91, 144} ; */
/* static size_t RZMC_chunksizes[3] = {1, 91, 144} ; */
/* static size_t SFMC_chunksizes[3] = {1, 91, 144} ; */
/* static size_t SHLAND_chunksizes[3] = {1, 91, 144} ; */
/* static size_t SMLAND_chunksizes[3] = {1, 91, 144} ; */
/* static size_t SNODP_chunksizes[3] = {1, 91, 144} ; */
/* static size_t SNOMAS_chunksizes[3] = {1, 91, 144} ; */
/* static size_t SPLAND_chunksizes[3] = {1, 91, 144} ; */
/* static size_t SPSNOW_chunksizes[3] = {1, 91, 144} ; */
/* static size_t SPWATR_chunksizes[3] = {1, 91, 144} ; */
/* static size_t SWLAND_chunksizes[3] = {1, 91, 144} ; */
/* static size_t TELAND_chunksizes[3] = {1, 91, 144} ; */
/* static size_t TPSNOW_chunksizes[3] = {1, 91, 144} ; */
/* static size_t TSAT_chunksizes[3] = {1, 91, 144} ; */
/* static size_t TSOIL1_chunksizes[3] = {1, 91, 144} ; */
/* static size_t TSOIL2_chunksizes[3] = {1, 91, 144} ; */
/* static size_t TSOIL3_chunksizes[3] = {1, 91, 144} ; */
/* static size_t TSOIL4_chunksizes[3] = {1, 91, 144} ; */
/* static size_t TSOIL5_chunksizes[3] = {1, 91, 144} ; */
/* static size_t TSOIL6_chunksizes[3] = {1, 91, 144} ; */
/* static size_t TSURF_chunksizes[3] = {1, 91, 144} ; */
/* static size_t TUNST_chunksizes[3] = {1, 91, 144} ; */
/* static size_t TWLAND_chunksizes[3] = {1, 91, 144} ; */
/* static size_t TWLT_chunksizes[3] = {1, 91, 144} ; */
/* static size_t WCHANGE_chunksizes[3] = {1, 91, 144} ; */
/* static size_t time_chunksizes[1] = {1} ; */

int
create_merr_file(char *file_name, int cmode) {/* create MERR.nc4.ncdumphs.nc */

    int  stat;  /* return status */
    int  ncid;  /* netCDF id */

    /* group ids */
    int MERR_grp;

    /* dimension ids */
    int time_dim;
    int lat_dim;
    int lon_dim;

    /* dimension lengths */
    size_t time_len = NC_UNLIMITED;
    size_t lat_len = 361;
    size_t lon_len = 576;

    /* variable ids */
    int BASEFLOW_id;
    int ECHANGE_id;
    int EVLAND_id;
    int EVPINTR_id;
    int EVPSBLN_id;
    int EVPSOIL_id;
    int EVPTRNS_id;
    int FRSAT_id;
    int FRSNO_id;
    int FRUNST_id;
    int FRWLT_id;
    int GHLAND_id;
    int GRN_id;
    int GWETPROF_id;
    int GWETROOT_id;
    int GWETTOP_id;
    int LAI_id;
    int LHLAND_id;
    int LWLAND_id;
    int PARDFLAND_id;
    int PARDRLAND_id;
    int PRECSNOLAND_id;
    int PRECTOTLAND_id;
    int PRMC_id;
    int QINFIL_id;
    int RUNOFF_id;
    int RZMC_id;
    int SFMC_id;
    int SHLAND_id;
    int SMLAND_id;
    int SNODP_id;
    int SNOMAS_id;
    int SPLAND_id;
    int SPSNOW_id;
    int SPWATR_id;
    int SWLAND_id;
    int TELAND_id;
    int TPSNOW_id;
    int TSAT_id;
    int TSOIL1_id;
    int TSOIL2_id;
    int TSOIL3_id;
    int TSOIL4_id;
    int TSOIL5_id;
    int TSOIL6_id;
    int TSURF_id;
    int TUNST_id;
    int TWLAND_id;
    int TWLT_id;
    int WCHANGE_id;
    int lat_id;
    int lon_id;
    int time_id;

    /* rank (number of dimensions) for each variable */
#   define RANK_BASEFLOW 3
#   define RANK_ECHANGE 3
#   define RANK_EVLAND 3
#   define RANK_EVPINTR 3
#   define RANK_EVPSBLN 3
#   define RANK_EVPSOIL 3
#   define RANK_EVPTRNS 3
#   define RANK_FRSAT 3
#   define RANK_FRSNO 3
#   define RANK_FRUNST 3
#   define RANK_FRWLT 3
#   define RANK_GHLAND 3
#   define RANK_GRN 3
#   define RANK_GWETPROF 3
#   define RANK_GWETROOT 3
#   define RANK_GWETTOP 3
#   define RANK_LAI 3
#   define RANK_LHLAND 3
#   define RANK_LWLAND 3
#   define RANK_PARDFLAND 3
#   define RANK_PARDRLAND 3
#   define RANK_PRECSNOLAND 3
#   define RANK_PRECTOTLAND 3
#   define RANK_PRMC 3
#   define RANK_QINFIL 3
#   define RANK_RUNOFF 3
#   define RANK_RZMC 3
#   define RANK_SFMC 3
#   define RANK_SHLAND 3
#   define RANK_SMLAND 3
#   define RANK_SNODP 3
#   define RANK_SNOMAS 3
#   define RANK_SPLAND 3
#   define RANK_SPSNOW 3
#   define RANK_SPWATR 3
#   define RANK_SWLAND 3
#   define RANK_TELAND 3
#   define RANK_TPSNOW 3
#   define RANK_TSAT 3
#   define RANK_TSOIL1 3
#   define RANK_TSOIL2 3
#   define RANK_TSOIL3 3
#   define RANK_TSOIL4 3
#   define RANK_TSOIL5 3
#   define RANK_TSOIL6 3
#   define RANK_TSURF 3
#   define RANK_TUNST 3
#   define RANK_TWLAND 3
#   define RANK_TWLT 3
#   define RANK_WCHANGE 3
#   define RANK_lat 1
#   define RANK_lon 1
#   define RANK_time 1

    /* variable shapes */
    int BASEFLOW_dims[RANK_BASEFLOW];
    int ECHANGE_dims[RANK_ECHANGE];
    int EVLAND_dims[RANK_EVLAND];
    int EVPINTR_dims[RANK_EVPINTR];
    int EVPSBLN_dims[RANK_EVPSBLN];
    int EVPSOIL_dims[RANK_EVPSOIL];
    int EVPTRNS_dims[RANK_EVPTRNS];
    int FRSAT_dims[RANK_FRSAT];
    int FRSNO_dims[RANK_FRSNO];
    int FRUNST_dims[RANK_FRUNST];
    int FRWLT_dims[RANK_FRWLT];
    int GHLAND_dims[RANK_GHLAND];
    int GRN_dims[RANK_GRN];
    int GWETPROF_dims[RANK_GWETPROF];
    int GWETROOT_dims[RANK_GWETROOT];
    int GWETTOP_dims[RANK_GWETTOP];
    int LAI_dims[RANK_LAI];
    int LHLAND_dims[RANK_LHLAND];
    int LWLAND_dims[RANK_LWLAND];
    int PARDFLAND_dims[RANK_PARDFLAND];
    int PARDRLAND_dims[RANK_PARDRLAND];
    int PRECSNOLAND_dims[RANK_PRECSNOLAND];
    int PRECTOTLAND_dims[RANK_PRECTOTLAND];
    int PRMC_dims[RANK_PRMC];
    int QINFIL_dims[RANK_QINFIL];
    int RUNOFF_dims[RANK_RUNOFF];
    int RZMC_dims[RANK_RZMC];
    int SFMC_dims[RANK_SFMC];
    int SHLAND_dims[RANK_SHLAND];
    int SMLAND_dims[RANK_SMLAND];
    int SNODP_dims[RANK_SNODP];
    int SNOMAS_dims[RANK_SNOMAS];
    int SPLAND_dims[RANK_SPLAND];
    int SPSNOW_dims[RANK_SPSNOW];
    int SPWATR_dims[RANK_SPWATR];
    int SWLAND_dims[RANK_SWLAND];
    int TELAND_dims[RANK_TELAND];
    int TPSNOW_dims[RANK_TPSNOW];
    int TSAT_dims[RANK_TSAT];
    int TSOIL1_dims[RANK_TSOIL1];
    int TSOIL2_dims[RANK_TSOIL2];
    int TSOIL3_dims[RANK_TSOIL3];
    int TSOIL4_dims[RANK_TSOIL4];
    int TSOIL5_dims[RANK_TSOIL5];
    int TSOIL6_dims[RANK_TSOIL6];
    int TSURF_dims[RANK_TSURF];
    int TUNST_dims[RANK_TUNST];
    int TWLAND_dims[RANK_TWLAND];
    int TWLT_dims[RANK_TWLT];
    int WCHANGE_dims[RANK_WCHANGE];
    int lat_dims[RANK_lat];
    int lon_dims[RANK_lon];
    int time_dims[RANK_time];

    /* enter define mode */
    stat = nc_create(file_name, NC_CLOBBER|cmode, &ncid);
    check_err(stat,__LINE__,__FILE__);
    /* stat = nc_put_att_text(ncid, NC_GLOBAL, "_Format", 1, "netCDF-4"); */
    /* check_err(stat,__LINE__,__FILE__); */
    MERR_grp = ncid;

    /* define dimensions */
    stat = nc_def_dim(MERR_grp, "time", time_len, &time_dim);
    check_err(stat,__LINE__,__FILE__);
    stat = nc_def_dim(MERR_grp, "lat", lat_len, &lat_dim);
    check_err(stat,__LINE__,__FILE__);
    stat = nc_def_dim(MERR_grp, "lon", lon_len, &lon_dim);
    check_err(stat,__LINE__,__FILE__);

    /* define variables */

    BASEFLOW_dims[0] = time_dim;
    BASEFLOW_dims[1] = lat_dim;
    BASEFLOW_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "BASEFLOW", NC_FLOAT, RANK_BASEFLOW, BASEFLOW_dims, &BASEFLOW_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, BASEFLOW_id, NC_CHUNKED, BASEFLOW_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, BASEFLOW_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, BASEFLOW_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    ECHANGE_dims[0] = time_dim;
    ECHANGE_dims[1] = lat_dim;
    ECHANGE_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "ECHANGE", NC_FLOAT, RANK_ECHANGE, ECHANGE_dims, &ECHANGE_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, ECHANGE_id, NC_CHUNKED, ECHANGE_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, ECHANGE_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, ECHANGE_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    EVLAND_dims[0] = time_dim;
    EVLAND_dims[1] = lat_dim;
    EVLAND_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "EVLAND", NC_FLOAT, RANK_EVLAND, EVLAND_dims, &EVLAND_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, EVLAND_id, NC_CHUNKED, EVLAND_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, EVLAND_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, EVLAND_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    EVPINTR_dims[0] = time_dim;
    EVPINTR_dims[1] = lat_dim;
    EVPINTR_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "EVPINTR", NC_FLOAT, RANK_EVPINTR, EVPINTR_dims, &EVPINTR_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, EVPINTR_id, NC_CHUNKED, EVPINTR_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, EVPINTR_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, EVPINTR_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    EVPSBLN_dims[0] = time_dim;
    EVPSBLN_dims[1] = lat_dim;
    EVPSBLN_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "EVPSBLN", NC_FLOAT, RANK_EVPSBLN, EVPSBLN_dims, &EVPSBLN_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, EVPSBLN_id, NC_CHUNKED, EVPSBLN_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, EVPSBLN_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, EVPSBLN_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    EVPSOIL_dims[0] = time_dim;
    EVPSOIL_dims[1] = lat_dim;
    EVPSOIL_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "EVPSOIL", NC_FLOAT, RANK_EVPSOIL, EVPSOIL_dims, &EVPSOIL_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, EVPSOIL_id, NC_CHUNKED, EVPSOIL_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, EVPSOIL_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, EVPSOIL_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    EVPTRNS_dims[0] = time_dim;
    EVPTRNS_dims[1] = lat_dim;
    EVPTRNS_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "EVPTRNS", NC_FLOAT, RANK_EVPTRNS, EVPTRNS_dims, &EVPTRNS_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, EVPTRNS_id, NC_CHUNKED, EVPTRNS_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, EVPTRNS_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, EVPTRNS_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    FRSAT_dims[0] = time_dim;
    FRSAT_dims[1] = lat_dim;
    FRSAT_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "FRSAT", NC_FLOAT, RANK_FRSAT, FRSAT_dims, &FRSAT_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, FRSAT_id, NC_CHUNKED, FRSAT_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, FRSAT_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, FRSAT_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    FRSNO_dims[0] = time_dim;
    FRSNO_dims[1] = lat_dim;
    FRSNO_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "FRSNO", NC_FLOAT, RANK_FRSNO, FRSNO_dims, &FRSNO_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, FRSNO_id, NC_CHUNKED, FRSNO_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, FRSNO_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, FRSNO_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    FRUNST_dims[0] = time_dim;
    FRUNST_dims[1] = lat_dim;
    FRUNST_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "FRUNST", NC_FLOAT, RANK_FRUNST, FRUNST_dims, &FRUNST_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, FRUNST_id, NC_CHUNKED, FRUNST_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, FRUNST_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, FRUNST_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    FRWLT_dims[0] = time_dim;
    FRWLT_dims[1] = lat_dim;
    FRWLT_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "FRWLT", NC_FLOAT, RANK_FRWLT, FRWLT_dims, &FRWLT_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, FRWLT_id, NC_CHUNKED, FRWLT_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, FRWLT_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, FRWLT_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    GHLAND_dims[0] = time_dim;
    GHLAND_dims[1] = lat_dim;
    GHLAND_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "GHLAND", NC_FLOAT, RANK_GHLAND, GHLAND_dims, &GHLAND_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, GHLAND_id, NC_CHUNKED, GHLAND_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, GHLAND_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, GHLAND_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    GRN_dims[0] = time_dim;
    GRN_dims[1] = lat_dim;
    GRN_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "GRN", NC_FLOAT, RANK_GRN, GRN_dims, &GRN_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, GRN_id, NC_CHUNKED, GRN_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, GRN_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, GRN_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    GWETPROF_dims[0] = time_dim;
    GWETPROF_dims[1] = lat_dim;
    GWETPROF_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "GWETPROF", NC_FLOAT, RANK_GWETPROF, GWETPROF_dims, &GWETPROF_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, GWETPROF_id, NC_CHUNKED, GWETPROF_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, GWETPROF_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, GWETPROF_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    GWETROOT_dims[0] = time_dim;
    GWETROOT_dims[1] = lat_dim;
    GWETROOT_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "GWETROOT", NC_FLOAT, RANK_GWETROOT, GWETROOT_dims, &GWETROOT_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, GWETROOT_id, NC_CHUNKED, GWETROOT_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, GWETROOT_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, GWETROOT_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    GWETTOP_dims[0] = time_dim;
    GWETTOP_dims[1] = lat_dim;
    GWETTOP_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "GWETTOP", NC_FLOAT, RANK_GWETTOP, GWETTOP_dims, &GWETTOP_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, GWETTOP_id, NC_CHUNKED, GWETTOP_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, GWETTOP_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, GWETTOP_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    LAI_dims[0] = time_dim;
    LAI_dims[1] = lat_dim;
    LAI_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "LAI", NC_FLOAT, RANK_LAI, LAI_dims, &LAI_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, LAI_id, NC_CHUNKED, LAI_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, LAI_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, LAI_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    LHLAND_dims[0] = time_dim;
    LHLAND_dims[1] = lat_dim;
    LHLAND_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "LHLAND", NC_FLOAT, RANK_LHLAND, LHLAND_dims, &LHLAND_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, LHLAND_id, NC_CHUNKED, LHLAND_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, LHLAND_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, LHLAND_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    LWLAND_dims[0] = time_dim;
    LWLAND_dims[1] = lat_dim;
    LWLAND_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "LWLAND", NC_FLOAT, RANK_LWLAND, LWLAND_dims, &LWLAND_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, LWLAND_id, NC_CHUNKED, LWLAND_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, LWLAND_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, LWLAND_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    PARDFLAND_dims[0] = time_dim;
    PARDFLAND_dims[1] = lat_dim;
    PARDFLAND_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "PARDFLAND", NC_FLOAT, RANK_PARDFLAND, PARDFLAND_dims, &PARDFLAND_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, PARDFLAND_id, NC_CHUNKED, PARDFLAND_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, PARDFLAND_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, PARDFLAND_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    PARDRLAND_dims[0] = time_dim;
    PARDRLAND_dims[1] = lat_dim;
    PARDRLAND_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "PARDRLAND", NC_FLOAT, RANK_PARDRLAND, PARDRLAND_dims, &PARDRLAND_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, PARDRLAND_id, NC_CHUNKED, PARDRLAND_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, PARDRLAND_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, PARDRLAND_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    PRECSNOLAND_dims[0] = time_dim;
    PRECSNOLAND_dims[1] = lat_dim;
    PRECSNOLAND_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "PRECSNOLAND", NC_FLOAT, RANK_PRECSNOLAND, PRECSNOLAND_dims, &PRECSNOLAND_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, PRECSNOLAND_id, NC_CHUNKED, PRECSNOLAND_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, PRECSNOLAND_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, PRECSNOLAND_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    PRECTOTLAND_dims[0] = time_dim;
    PRECTOTLAND_dims[1] = lat_dim;
    PRECTOTLAND_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "PRECTOTLAND", NC_FLOAT, RANK_PRECTOTLAND, PRECTOTLAND_dims, &PRECTOTLAND_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, PRECTOTLAND_id, NC_CHUNKED, PRECTOTLAND_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, PRECTOTLAND_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, PRECTOTLAND_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    PRMC_dims[0] = time_dim;
    PRMC_dims[1] = lat_dim;
    PRMC_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "PRMC", NC_FLOAT, RANK_PRMC, PRMC_dims, &PRMC_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, PRMC_id, NC_CHUNKED, PRMC_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, PRMC_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, PRMC_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    QINFIL_dims[0] = time_dim;
    QINFIL_dims[1] = lat_dim;
    QINFIL_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "QINFIL", NC_FLOAT, RANK_QINFIL, QINFIL_dims, &QINFIL_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, QINFIL_id, NC_CHUNKED, QINFIL_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, QINFIL_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, QINFIL_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    RUNOFF_dims[0] = time_dim;
    RUNOFF_dims[1] = lat_dim;
    RUNOFF_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "RUNOFF", NC_FLOAT, RANK_RUNOFF, RUNOFF_dims, &RUNOFF_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, RUNOFF_id, NC_CHUNKED, RUNOFF_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, RUNOFF_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, RUNOFF_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    RZMC_dims[0] = time_dim;
    RZMC_dims[1] = lat_dim;
    RZMC_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "RZMC", NC_FLOAT, RANK_RZMC, RZMC_dims, &RZMC_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, RZMC_id, NC_CHUNKED, RZMC_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, RZMC_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, RZMC_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    SFMC_dims[0] = time_dim;
    SFMC_dims[1] = lat_dim;
    SFMC_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "SFMC", NC_FLOAT, RANK_SFMC, SFMC_dims, &SFMC_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, SFMC_id, NC_CHUNKED, SFMC_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, SFMC_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, SFMC_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    SHLAND_dims[0] = time_dim;
    SHLAND_dims[1] = lat_dim;
    SHLAND_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "SHLAND", NC_FLOAT, RANK_SHLAND, SHLAND_dims, &SHLAND_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, SHLAND_id, NC_CHUNKED, SHLAND_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, SHLAND_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, SHLAND_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    SMLAND_dims[0] = time_dim;
    SMLAND_dims[1] = lat_dim;
    SMLAND_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "SMLAND", NC_FLOAT, RANK_SMLAND, SMLAND_dims, &SMLAND_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, SMLAND_id, NC_CHUNKED, SMLAND_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, SMLAND_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, SMLAND_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    SNODP_dims[0] = time_dim;
    SNODP_dims[1] = lat_dim;
    SNODP_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "SNODP", NC_FLOAT, RANK_SNODP, SNODP_dims, &SNODP_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, SNODP_id, NC_CHUNKED, SNODP_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, SNODP_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, SNODP_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    SNOMAS_dims[0] = time_dim;
    SNOMAS_dims[1] = lat_dim;
    SNOMAS_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "SNOMAS", NC_FLOAT, RANK_SNOMAS, SNOMAS_dims, &SNOMAS_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, SNOMAS_id, NC_CHUNKED, SNOMAS_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, SNOMAS_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, SNOMAS_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    SPLAND_dims[0] = time_dim;
    SPLAND_dims[1] = lat_dim;
    SPLAND_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "SPLAND", NC_FLOAT, RANK_SPLAND, SPLAND_dims, &SPLAND_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, SPLAND_id, NC_CHUNKED, SPLAND_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, SPLAND_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, SPLAND_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    SPSNOW_dims[0] = time_dim;
    SPSNOW_dims[1] = lat_dim;
    SPSNOW_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "SPSNOW", NC_FLOAT, RANK_SPSNOW, SPSNOW_dims, &SPSNOW_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, SPSNOW_id, NC_CHUNKED, SPSNOW_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, SPSNOW_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, SPSNOW_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    SPWATR_dims[0] = time_dim;
    SPWATR_dims[1] = lat_dim;
    SPWATR_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "SPWATR", NC_FLOAT, RANK_SPWATR, SPWATR_dims, &SPWATR_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, SPWATR_id, NC_CHUNKED, SPWATR_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, SPWATR_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, SPWATR_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    SWLAND_dims[0] = time_dim;
    SWLAND_dims[1] = lat_dim;
    SWLAND_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "SWLAND", NC_FLOAT, RANK_SWLAND, SWLAND_dims, &SWLAND_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, SWLAND_id, NC_CHUNKED, SWLAND_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, SWLAND_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, SWLAND_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    TELAND_dims[0] = time_dim;
    TELAND_dims[1] = lat_dim;
    TELAND_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "TELAND", NC_FLOAT, RANK_TELAND, TELAND_dims, &TELAND_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, TELAND_id, NC_CHUNKED, TELAND_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, TELAND_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, TELAND_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    TPSNOW_dims[0] = time_dim;
    TPSNOW_dims[1] = lat_dim;
    TPSNOW_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "TPSNOW", NC_FLOAT, RANK_TPSNOW, TPSNOW_dims, &TPSNOW_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, TPSNOW_id, NC_CHUNKED, TPSNOW_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, TPSNOW_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, TPSNOW_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    TSAT_dims[0] = time_dim;
    TSAT_dims[1] = lat_dim;
    TSAT_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "TSAT", NC_FLOAT, RANK_TSAT, TSAT_dims, &TSAT_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, TSAT_id, NC_CHUNKED, TSAT_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, TSAT_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, TSAT_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    TSOIL1_dims[0] = time_dim;
    TSOIL1_dims[1] = lat_dim;
    TSOIL1_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "TSOIL1", NC_FLOAT, RANK_TSOIL1, TSOIL1_dims, &TSOIL1_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, TSOIL1_id, NC_CHUNKED, TSOIL1_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, TSOIL1_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, TSOIL1_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    TSOIL2_dims[0] = time_dim;
    TSOIL2_dims[1] = lat_dim;
    TSOIL2_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "TSOIL2", NC_FLOAT, RANK_TSOIL2, TSOIL2_dims, &TSOIL2_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, TSOIL2_id, NC_CHUNKED, TSOIL2_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, TSOIL2_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, TSOIL2_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    TSOIL3_dims[0] = time_dim;
    TSOIL3_dims[1] = lat_dim;
    TSOIL3_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "TSOIL3", NC_FLOAT, RANK_TSOIL3, TSOIL3_dims, &TSOIL3_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, TSOIL3_id, NC_CHUNKED, TSOIL3_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, TSOIL3_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, TSOIL3_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    TSOIL4_dims[0] = time_dim;
    TSOIL4_dims[1] = lat_dim;
    TSOIL4_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "TSOIL4", NC_FLOAT, RANK_TSOIL4, TSOIL4_dims, &TSOIL4_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, TSOIL4_id, NC_CHUNKED, TSOIL4_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, TSOIL4_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, TSOIL4_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    TSOIL5_dims[0] = time_dim;
    TSOIL5_dims[1] = lat_dim;
    TSOIL5_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "TSOIL5", NC_FLOAT, RANK_TSOIL5, TSOIL5_dims, &TSOIL5_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, TSOIL5_id, NC_CHUNKED, TSOIL5_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, TSOIL5_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, TSOIL5_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    TSOIL6_dims[0] = time_dim;
    TSOIL6_dims[1] = lat_dim;
    TSOIL6_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "TSOIL6", NC_FLOAT, RANK_TSOIL6, TSOIL6_dims, &TSOIL6_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, TSOIL6_id, NC_CHUNKED, TSOIL6_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, TSOIL6_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, TSOIL6_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    TSURF_dims[0] = time_dim;
    TSURF_dims[1] = lat_dim;
    TSURF_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "TSURF", NC_FLOAT, RANK_TSURF, TSURF_dims, &TSURF_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, TSURF_id, NC_CHUNKED, TSURF_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, TSURF_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, TSURF_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    TUNST_dims[0] = time_dim;
    TUNST_dims[1] = lat_dim;
    TUNST_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "TUNST", NC_FLOAT, RANK_TUNST, TUNST_dims, &TUNST_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, TUNST_id, NC_CHUNKED, TUNST_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, TUNST_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, TUNST_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    TWLAND_dims[0] = time_dim;
    TWLAND_dims[1] = lat_dim;
    TWLAND_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "TWLAND", NC_FLOAT, RANK_TWLAND, TWLAND_dims, &TWLAND_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, TWLAND_id, NC_CHUNKED, TWLAND_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, TWLAND_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, TWLAND_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    TWLT_dims[0] = time_dim;
    TWLT_dims[1] = lat_dim;
    TWLT_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "TWLT", NC_FLOAT, RANK_TWLT, TWLT_dims, &TWLT_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, TWLT_id, NC_CHUNKED, TWLT_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, TWLT_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, TWLT_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    WCHANGE_dims[0] = time_dim;
    WCHANGE_dims[1] = lat_dim;
    WCHANGE_dims[2] = lon_dim;
    stat = nc_def_var(MERR_grp, "WCHANGE", NC_FLOAT, RANK_WCHANGE, WCHANGE_dims, &WCHANGE_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, WCHANGE_id, NC_CHUNKED, WCHANGE_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, WCHANGE_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, WCHANGE_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    lat_dims[0] = lat_dim;
    stat = nc_def_var(MERR_grp, "lat", NC_DOUBLE, RANK_lat, lat_dims, &lat_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, lat_id, NC_CONTIGUOUS, NULL); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, lat_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }
    lon_dims[0] = lon_dim;
    stat = nc_def_var(MERR_grp, "lon", NC_DOUBLE, RANK_lon, lon_dims, &lon_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, lon_id, NC_CONTIGUOUS, NULL); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, lon_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }
    time_dims[0] = time_dim;
    stat = nc_def_var(MERR_grp, "time", NC_INT, RANK_time, time_dims, &time_id);
    check_err(stat,__LINE__,__FILE__);
    if (cmode & NC_NETCDF4)
    {
       /* stat = nc_def_var_chunking(MERR_grp, time_id, NC_CHUNKED, time_chunksizes); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_deflate(MERR_grp, time_id, NC_SHUFFLE, 1, 0); */
       /* check_err(stat,__LINE__,__FILE__); */
       /* stat = nc_def_var_endian(MERR_grp, time_id, NC_ENDIAN_LITTLE); */
       /* check_err(stat,__LINE__,__FILE__); */
    }

    /* assign global attributes */

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "History", 120, "Wed Sep 20 09:06:02 2017: ncks -L 0 MERR.nc4 MERR.uncompressed.nc4\nOriginal file generated: Mon Mar 23 09:27:34 2015 GMT");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "Comment", 58, "GMAO filename: d5124_m2_jan00.tavg1_2d_lnd_Nx.20100105.nc4");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "Filename", 39, "MERRA2_300.tavg1_2d_lnd_Nx.20100105.nc4");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "Conventions", 4, "CF-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "Institution", 44, "NASA Global Modeling and Assimilation Office");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "References", 25, "http://gmao.gsfc.nasa.gov");
    check_err(stat,__LINE__,__FILE__);
    }

    /* { */
    /* stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "Format", 14, "NetCDF-4/HDF-5"); */
    /* check_err(stat,__LINE__,__FILE__); */
    /* } */

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "SpatialCoverage", 6, "global");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "VersionID", 6, "5.12.4");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "TemporalRange", 24, "1980-01-01 -> 2016-12-31");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "identifier_product_doi_authority", 18, "http://dx.doi.org/");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "ShortName", 9, "M2T1NXLND");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "RangeBeginningDate", 10, "2010-01-04");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "RangeBeginningTime", 15, "23:30:00.000000");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "RangeEndingDate", 10, "2010-01-05");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "RangeEndingTime", 15, "00:30:00.000000");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "GranuleID", 39, "MERRA2_300.tavg1_2d_lnd_Nx.20100105.nc4");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "ProductionDateTime", 53, "Original file generated: Mon Mar 23 09:27:34 2015 GMT");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "LongName", 100, "MERRA2 tavg1_2d_lnd_Nx: 2d,1-Hourly,Time-Averaged,Single-Level,Assimilation,Land Surface Diagnostics");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "Title", 100, "MERRA2 tavg1_2d_lnd_Nx: 2d,1-Hourly,Time-Averaged,Single-Level,Assimilation,Land Surface Diagnostics");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "SouthernmostLatitude", 5, "-90.0");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "NorthernmostLatitude", 4, "90.0");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "WesternmostLongitude", 6, "-180.0");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "EasternmostLongitude", 7, "179.375");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "LatitudeResolution", 3, "0.5");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "LongitudeResolution", 5, "0.625");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "DataResolution", 11, "0.5 x 0.625");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "identifier_product_doi", 3, "TBD");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "Source", 24, "CVS tag: GEOSadas-5_12_4");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "Contact", 25, "http://gmao.gsfc.nasa.gov");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, NC_GLOBAL, "NCO", 5, "4.6.7");
    check_err(stat,__LINE__,__FILE__);
    }


    /* assign per-variable attributes */

    {
    stat = nc_put_att_text(MERR_grp, BASEFLOW_id, "long_name", 13, "baseflow_flux");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, BASEFLOW_id, "units", 10, "kg m-2 s-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float _FillValue_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, BASEFLOW_id, "_FillValue", NC_FLOAT, 1, _FillValue_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float missing_value_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, BASEFLOW_id, "missing_value", NC_FLOAT, 1, missing_value_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float fmissing_value_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, BASEFLOW_id, "fmissing_value", NC_FLOAT, 1, fmissing_value_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float scale_factor_att[1] = {((float)1)} ;
    stat = nc_put_att_float(MERR_grp, BASEFLOW_id, "scale_factor", NC_FLOAT, 1, scale_factor_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float add_offset_att[1] = {((float)0)} ;
    stat = nc_put_att_float(MERR_grp, BASEFLOW_id, "add_offset", NC_FLOAT, 1, add_offset_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, BASEFLOW_id, "standard_name", 13, "baseflow_flux");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float vmax_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, BASEFLOW_id, "vmax", NC_FLOAT, 1, vmax_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float vmin_att[1] = {((float)-9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, BASEFLOW_id, "vmin", NC_FLOAT, 1, vmin_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float valid_range_att[2] = {((float)-9.9999999e+14), ((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, BASEFLOW_id, "valid_range", NC_FLOAT, 2, valid_range_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, ECHANGE_id, "long_name", 35, "rate_of_change_of_total_land_energy");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, ECHANGE_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float _FillValue_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, ECHANGE_id, "_FillValue", NC_FLOAT, 1, _FillValue_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float missing_value_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, ECHANGE_id, "missing_value", NC_FLOAT, 1, missing_value_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float fmissing_value_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, ECHANGE_id, "fmissing_value", NC_FLOAT, 1, fmissing_value_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float scale_factor_att[1] = {((float)1)} ;
    stat = nc_put_att_float(MERR_grp, ECHANGE_id, "scale_factor", NC_FLOAT, 1, scale_factor_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float add_offset_att[1] = {((float)0)} ;
    stat = nc_put_att_float(MERR_grp, ECHANGE_id, "add_offset", NC_FLOAT, 1, add_offset_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, ECHANGE_id, "standard_name", 35, "rate_of_change_of_total_land_energy");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float vmax_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, ECHANGE_id, "vmax", NC_FLOAT, 1, vmax_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float vmin_att[1] = {((float)-9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, ECHANGE_id, "vmin", NC_FLOAT, 1, vmin_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float valid_range_att[2] = {((float)-9.9999999e+14), ((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, ECHANGE_id, "valid_range", NC_FLOAT, 2, valid_range_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, EVLAND_id, "long_name", 16, "Evaporation_land");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, EVLAND_id, "units", 10, "kg m-2 s-1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float _FillValue_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVLAND_id, "_FillValue", NC_FLOAT, 1, _FillValue_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float missing_value_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVLAND_id, "missing_value", NC_FLOAT, 1, missing_value_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float fmissing_value_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVLAND_id, "fmissing_value", NC_FLOAT, 1, fmissing_value_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float scale_factor_att[1] = {((float)1)} ;
    stat = nc_put_att_float(MERR_grp, EVLAND_id, "scale_factor", NC_FLOAT, 1, scale_factor_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float add_offset_att[1] = {((float)0)} ;
    stat = nc_put_att_float(MERR_grp, EVLAND_id, "add_offset", NC_FLOAT, 1, add_offset_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, EVLAND_id, "standard_name", 16, "Evaporation_land");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float vmax_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVLAND_id, "vmax", NC_FLOAT, 1, vmax_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float vmin_att[1] = {((float)-9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVLAND_id, "vmin", NC_FLOAT, 1, vmin_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float valid_range_att[2] = {((float)-9.9999999e+14), ((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVLAND_id, "valid_range", NC_FLOAT, 2, valid_range_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, EVPINTR_id, "long_name", 29, "interception_loss_energy_flux");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, EVPINTR_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float _FillValue_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPINTR_id, "_FillValue", NC_FLOAT, 1, _FillValue_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float missing_value_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPINTR_id, "missing_value", NC_FLOAT, 1, missing_value_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float fmissing_value_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPINTR_id, "fmissing_value", NC_FLOAT, 1, fmissing_value_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float scale_factor_att[1] = {((float)1)} ;
    stat = nc_put_att_float(MERR_grp, EVPINTR_id, "scale_factor", NC_FLOAT, 1, scale_factor_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float add_offset_att[1] = {((float)0)} ;
    stat = nc_put_att_float(MERR_grp, EVPINTR_id, "add_offset", NC_FLOAT, 1, add_offset_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, EVPINTR_id, "standard_name", 29, "interception_loss_energy_flux");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float vmax_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPINTR_id, "vmax", NC_FLOAT, 1, vmax_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float vmin_att[1] = {((float)-9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPINTR_id, "vmin", NC_FLOAT, 1, vmin_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float valid_range_att[2] = {((float)-9.9999999e+14), ((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPINTR_id, "valid_range", NC_FLOAT, 2, valid_range_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, EVPSBLN_id, "long_name", 32, "snow_ice_evaporation_energy_flux");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, EVPSBLN_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float _FillValue_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPSBLN_id, "_FillValue", NC_FLOAT, 1, _FillValue_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float missing_value_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPSBLN_id, "missing_value", NC_FLOAT, 1, missing_value_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float fmissing_value_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPSBLN_id, "fmissing_value", NC_FLOAT, 1, fmissing_value_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float scale_factor_att[1] = {((float)1)} ;
    stat = nc_put_att_float(MERR_grp, EVPSBLN_id, "scale_factor", NC_FLOAT, 1, scale_factor_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float add_offset_att[1] = {((float)0)} ;
    stat = nc_put_att_float(MERR_grp, EVPSBLN_id, "add_offset", NC_FLOAT, 1, add_offset_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, EVPSBLN_id, "standard_name", 32, "snow_ice_evaporation_energy_flux");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float vmax_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPSBLN_id, "vmax", NC_FLOAT, 1, vmax_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float vmin_att[1] = {((float)-9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPSBLN_id, "vmin", NC_FLOAT, 1, vmin_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float valid_range_att[2] = {((float)-9.9999999e+14), ((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPSBLN_id, "valid_range", NC_FLOAT, 2, valid_range_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, EVPSOIL_id, "long_name", 25, "baresoil_evap_energy_flux");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, EVPSOIL_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float _FillValue_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPSOIL_id, "_FillValue", NC_FLOAT, 1, _FillValue_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float missing_value_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPSOIL_id, "missing_value", NC_FLOAT, 1, missing_value_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float fmissing_value_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPSOIL_id, "fmissing_value", NC_FLOAT, 1, fmissing_value_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float scale_factor_att[1] = {((float)1)} ;
    stat = nc_put_att_float(MERR_grp, EVPSOIL_id, "scale_factor", NC_FLOAT, 1, scale_factor_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float add_offset_att[1] = {((float)0)} ;
    stat = nc_put_att_float(MERR_grp, EVPSOIL_id, "add_offset", NC_FLOAT, 1, add_offset_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, EVPSOIL_id, "standard_name", 25, "baresoil_evap_energy_flux");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float vmax_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPSOIL_id, "vmax", NC_FLOAT, 1, vmax_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float vmin_att[1] = {((float)-9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPSOIL_id, "vmin", NC_FLOAT, 1, vmin_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float valid_range_att[2] = {((float)-9.9999999e+14), ((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPSOIL_id, "valid_range", NC_FLOAT, 2, valid_range_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, EVPTRNS_id, "long_name", 25, "transpiration_energy_flux");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, EVPTRNS_id, "units", 5, "W m-2");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float _FillValue_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPTRNS_id, "_FillValue", NC_FLOAT, 1, _FillValue_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float missing_value_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPTRNS_id, "missing_value", NC_FLOAT, 1, missing_value_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float fmissing_value_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPTRNS_id, "fmissing_value", NC_FLOAT, 1, fmissing_value_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float scale_factor_att[1] = {((float)1)} ;
    stat = nc_put_att_float(MERR_grp, EVPTRNS_id, "scale_factor", NC_FLOAT, 1, scale_factor_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float add_offset_att[1] = {((float)0)} ;
    stat = nc_put_att_float(MERR_grp, EVPTRNS_id, "add_offset", NC_FLOAT, 1, add_offset_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, EVPTRNS_id, "standard_name", 25, "transpiration_energy_flux");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float vmax_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPTRNS_id, "vmax", NC_FLOAT, 1, vmax_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float vmin_att[1] = {((float)-9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPTRNS_id, "vmin", NC_FLOAT, 1, vmin_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float valid_range_att[2] = {((float)-9.9999999e+14), ((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, EVPTRNS_id, "valid_range", NC_FLOAT, 2, valid_range_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, FRSAT_id, "long_name", 33, "fractional_area_of_saturated_zone");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, FRSAT_id, "units", 1, "1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float _FillValue_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, FRSAT_id, "_FillValue", NC_FLOAT, 1, _FillValue_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float missing_value_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, FRSAT_id, "missing_value", NC_FLOAT, 1, missing_value_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float fmissing_value_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, FRSAT_id, "fmissing_value", NC_FLOAT, 1, fmissing_value_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float scale_factor_att[1] = {((float)1)} ;
    stat = nc_put_att_float(MERR_grp, FRSAT_id, "scale_factor", NC_FLOAT, 1, scale_factor_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float add_offset_att[1] = {((float)0)} ;
    stat = nc_put_att_float(MERR_grp, FRSAT_id, "add_offset", NC_FLOAT, 1, add_offset_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, FRSAT_id, "standard_name", 33, "fractional_area_of_saturated_zone");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float vmax_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, FRSAT_id, "vmax", NC_FLOAT, 1, vmax_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float vmin_att[1] = {((float)-9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, FRSAT_id, "vmin", NC_FLOAT, 1, vmin_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float valid_range_att[2] = {((float)-9.9999999e+14), ((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, FRSAT_id, "valid_range", NC_FLOAT, 2, valid_range_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, FRSNO_id, "long_name", 33, "fractional_area_of_land_snowcover");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, FRSNO_id, "units", 1, "1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float _FillValue_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, FRSNO_id, "_FillValue", NC_FLOAT, 1, _FillValue_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float missing_value_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, FRSNO_id, "missing_value", NC_FLOAT, 1, missing_value_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float fmissing_value_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, FRSNO_id, "fmissing_value", NC_FLOAT, 1, fmissing_value_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float scale_factor_att[1] = {((float)1)} ;
    stat = nc_put_att_float(MERR_grp, FRSNO_id, "scale_factor", NC_FLOAT, 1, scale_factor_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float add_offset_att[1] = {((float)0)} ;
    stat = nc_put_att_float(MERR_grp, FRSNO_id, "add_offset", NC_FLOAT, 1, add_offset_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, FRSNO_id, "standard_name", 33, "fractional_area_of_land_snowcover");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float vmax_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, FRSNO_id, "vmax", NC_FLOAT, 1, vmax_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float vmin_att[1] = {((float)-9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, FRSNO_id, "vmin", NC_FLOAT, 1, vmin_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float valid_range_att[2] = {((float)-9.9999999e+14), ((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, FRSNO_id, "valid_range", NC_FLOAT, 2, valid_range_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, FRUNST_id, "long_name", 35, "fractional_area_of_unsaturated_zone");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, FRUNST_id, "units", 1, "1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float _FillValue_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, FRUNST_id, "_FillValue", NC_FLOAT, 1, _FillValue_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float missing_value_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, FRUNST_id, "missing_value", NC_FLOAT, 1, missing_value_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float fmissing_value_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, FRUNST_id, "fmissing_value", NC_FLOAT, 1, fmissing_value_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float scale_factor_att[1] = {((float)1)} ;
    stat = nc_put_att_float(MERR_grp, FRUNST_id, "scale_factor", NC_FLOAT, 1, scale_factor_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float add_offset_att[1] = {((float)0)} ;
    stat = nc_put_att_float(MERR_grp, FRUNST_id, "add_offset", NC_FLOAT, 1, add_offset_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, FRUNST_id, "standard_name", 35, "fractional_area_of_unsaturated_zone");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float vmax_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, FRUNST_id, "vmax", NC_FLOAT, 1, vmax_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float vmin_att[1] = {((float)-9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, FRUNST_id, "vmin", NC_FLOAT, 1, vmin_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float valid_range_att[2] = {((float)-9.9999999e+14), ((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, FRUNST_id, "valid_range", NC_FLOAT, 2, valid_range_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, FRWLT_id, "long_name", 31, "fractional_area_of_wilting_zone");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    stat = nc_put_att_text(MERR_grp, FRWLT_id, "units", 1, "1");
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float _FillValue_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, FRWLT_id, "_FillValue", NC_FLOAT, 1, _FillValue_att);
    check_err(stat,__LINE__,__FILE__);
    }

    {
    static const float missing_value_att[1] = {((float)9.9999999e+14)} ;
    stat = nc_put_att_float(MERR_grp, FRWLT_id, "missing_value", NC_FLOAT, 1, missing_value_att);