
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file PageIDAttributes.h
    \\brief Definition of PageID Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MagRequest.h" 
#include "PageIDWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


PageIDWrapper::PageIDWrapper(): pageid_(new PageID())

{

	
	
	NoPageIDWrapper::object(pageid_);
	
	
} 
PageIDWrapper::PageIDWrapper(PageID* pageid): pageid_(pageid)
{
	
	
	NoPageIDWrapper::object(pageid_);
	
} 

PageIDWrapper::~PageIDWrapper()
{
	
}

void PageIDWrapper::set(const MagRequest& request)
{
	
	
	
	NoPageIDWrapper::set(request);
	

	if  (request.countValues("PAGE_ID_LINE_HEIGHT") ) {
		double height_value = request("PAGE_ID_LINE_HEIGHT");
		pageid_->height_ = height_value;
		}
	if  (request.countValues("PAGE_ID_LINE_MAGICS") ) {
		string magics_value = request("PAGE_ID_LINE_MAGICS");
		pageid_->magics_ = MagTranslator<string, bool>()(magics_value);
		}
	if  (request.countValues("PAGE_ID_LINE_USER_TEXT") ) {
		string user_text_value = request("PAGE_ID_LINE_USER_TEXT");
		pageid_->user_text_ = user_text_value;
		}
	if  (request.countValues("PAGE_ID_LINE_SYSTEM_PLOT") ) {
		string system_value = request("PAGE_ID_LINE_SYSTEM_PLOT");
		pageid_->system_ = MagTranslator<string, bool>()(system_value);
		}
	if  (request.countValues("PAGE_ID_LINE_DATE_PLOT") ) {
		string date_value = request("PAGE_ID_LINE_DATE_PLOT");
		pageid_->date_ = MagTranslator<string, bool>()(date_value);
		}
	if  (request.countValues("PAGE_ID_LINE_ERRORS_PLOT") ) {
		string errors_value = request("PAGE_ID_LINE_ERRORS_PLOT");
		pageid_->errors_ = MagTranslator<string, bool>()(errors_value);
		}
	if  (request.countValues("PAGE_ID_LINE_USER_TEXT_PLOT") ) {
		string text_value = request("PAGE_ID_LINE_USER_TEXT_PLOT");
		pageid_->text_ = MagTranslator<string, bool>()(text_value);
		}
	if  (request.countValues("PAGE_ID_LINE_FONT") ) {
		string font_value = request("PAGE_ID_LINE_FONT");
		pageid_->font_ = font_value;
		}
	if  (request.countValues("PAGE_ID_LINE_FONT_STYLE") ) {
		string font_style_value = request("PAGE_ID_LINE_FONT_STYLE");
		pageid_->font_style_ = font_style_value;
		}
	
	if  (request.countValues("PAGE_ID_LINE_COLOUR") ) {
		string colour_value = request("PAGE_ID_LINE_COLOUR");
		pageid_->colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(colour_value));
	}
		
	
		string logo_value = request.countValues("PAGE_ID_LINE_LOGO_PLOT") ?  (string) request("PAGE_ID_LINE_LOGO_PLOT") : "on";
	MagLog::debug() << " PAGE_ID_LINE_LOGO_PLOT set to " << logo_value << endl;
	NoLogoPlottingWrapper* logo_wrapper = 0;
	try
	{
		logo_wrapper = SimpleFactory<NoLogoPlottingWrapper>::create(logo_value);
	}
	 catch (NoFactoryException) {
		MagLog::warning() << "[" << logo_value << "] is not a valid value for logo: reset to default -> [on]" << endl;
		logo_wrapper = SimpleFactory<NoLogoPlottingWrapper>::create("on");
	}
	logo_wrapper->set(request);
	pageid_->logo_ =  unique_ptr<NoLogoPlotting>(logo_wrapper->object());
	delete logo_wrapper;
	
}

void PageIDWrapper::print(ostream& out)  const
{
	out << "PageIDWrapper[]";
}


    




#include "LogoPlottingWrapper.h"
static SimpleObjectMaker<LogoPlotting, NoLogoPlotting> PageID_page_id_line_logo_plot_logo ("logo");
static SimpleObjectMaker<LogoPlottingWrapper, NoLogoPlottingWrapper> PageID_page_id_line_logo_plot_logo_wrapper ("logo");


#include "LogoPlottingWrapper.h"
static SimpleObjectMaker<LogoPlotting, NoLogoPlotting> PageID_page_id_line_logo_plot_on ("on");
static SimpleObjectMaker<LogoPlottingWrapper, NoLogoPlottingWrapper> PageID_page_id_line_logo_plot_on_wrapper ("on");


#include "NoLogoPlottingWrapper.h"

static SimpleObjectMaker<NoLogoPlottingWrapper> PageID_page_id_line_logo_plot_nologo_Wrapper("nologo");


#include "NoLogoPlottingWrapper.h"

static SimpleObjectMaker<NoLogoPlottingWrapper> PageID_page_id_line_logo_plot_off_Wrapper("off");



