/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// Stdlib includes
#include <vector>
#include <utility>
#include <algorithm>


/////////////////////// Qt includes
#include <QString>


/////////////////////// pappsomspp includes


/////////////////////// Local includes
#include "MsXpS/libXpertMassCore/jsclassregistrar.h"
#include "MsXpS/export-import-config.h"

namespace MsXpS
{
namespace libXpertMassCore
{

/*  BEGIN CLASS JS REFERENCE
 *  namespace: MsXpS::libXpertMassCore
 *  class name: IndexRange
 */

class DECLSPEC IndexRange: public QObject
{
  Q_OBJECT

  Q_PROPERTY(qsizetype start MEMBER m_start)
  Q_PROPERTY(qsizetype stop MEMBER m_stop)

  friend class IndexRangeCollection;

  public:
  qsizetype m_start = std::numeric_limits<std::size_t>::max();
  qsizetype m_stop  = std::numeric_limits<std::size_t>::max();

  Q_INVOKABLE explicit IndexRange(QObject *parent = nullptr);

  Q_INVOKABLE explicit IndexRange(qsizetype index_start,
             qsizetype index_stop,
             QObject *parent = nullptr);
  // Pseudo copy constructor
  Q_INVOKABLE explicit IndexRange(const IndexRange &other, QObject *parent = nullptr);

  virtual ~IndexRange();

  Q_INVOKABLE void initialize(const IndexRange &other);
  Q_INVOKABLE IndexRange *clone(QObject *parent = nullptr);
  Q_INVOKABLE static IndexRange *clone(const IndexRange &other,
                                       QObject *parent = nullptr);

  bool operator=(const IndexRange &other) = delete;
  Q_INVOKABLE bool operator==(const IndexRange &other) const;
  Q_INVOKABLE bool operator!=(const IndexRange &other) const;

  Q_INVOKABLE void sortAscending();
  Q_INVOKABLE void sortDescending();

  Q_INVOKABLE bool isValid() const;

  Q_INVOKABLE void reset();

  QString indicesAsText() const;
  QString positionsAsText() const;

  static void registerJsConstructor(QJSEngine *engine);
};

typedef QSharedPointer<IndexRange> IndexRangeQSPtr;

/*  END CLASS JS REFERENCE
 *  namespace: MsXpS::libXpertMassCore
 *  class name: IndexRange
 */
} // namespace libXpertMassCore
MSXPS_REGISTER_JS_CLASS(MsXpS::libXpertMassCore, IndexRange)

} // namespace MsXpS
