# Need to check things per compiler brand since they're different
if(CMAKE_C_COMPILER_ID STREQUAL "Intel")
  option_with_flags(ENABLE_XHOST "Enable processor-specific optimization" OFF  "-xHost")
elseif(CMAKE_C_COMPILER_ID STREQUAL "IntelLLVM")
  option_with_flags(ENABLE_XHOST "Enable processor-specific optimization" OFF  "-xHost")
elseif(CMAKE_C_COMPILER_ID STREQUAL "GNU")
  option_with_flags(ENABLE_XHOST "Enable processor-specific optimization" OFF  "-march=native")
elseif(CMAKE_C_COMPILER_ID STREQUAL "Clang")
    if (CMAKE_C_COMPILER_FRONTEND_VARIANT STREQUAL "MSVC")
        # clang-cl
        option_with_flags(ENABLE_XHOST "Enable processor-specific optimization" OFF  "/arch:AVX2")
    elseif (CMAKE_C_COMPILER_FRONTEND_VARIANT STREQUAL "GNU")
        if (NOT CMAKE_HOST_SYSTEM_PROCESSOR STREQUAL "arm64")
            option_with_flags(ENABLE_XHOST "Enable processor-specific optimization" OFF  "-march=native")
        endif()
    endif()
elseif(CMAKE_C_COMPILER_ID STREQUAL "AppleClang")
  option_with_flags(ENABLE_XHOST "Enable processor-specific optimization" OFF  "-march=native")
elseif(CMAKE_C_COMPILER_ID STREQUAL "PGI")
  option_with_flags(ENABLE_XHOST "Enable processor-specific optimization" OFF  "-tp=host")
  if (NOT ENABLE_XHOST)
    # This generates code for all x86-compatible processors
      set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -tp=px")
  endif()
elseif(CMAKE_C_COMPILER_ID STREQUAL "MSVC")
  option_with_flags(ENABLE_XHOST "Enable processor-specific optimization" OFF  "/arch:AVX2")
endif()
